/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.GenomeSequence;
import net.maizegenetics.dna.map.GenomeSequenceBuilder;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.Utils;

public class AddReferenceToGenotypePlugin
extends AbstractPlugin {
    private PluginParameter<String> myReference = new PluginParameter.Builder<String>("reference", null, String.class).description("Input Reference Fasta").required(true).inFile().build();

    public AddReferenceToGenotypePlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        List<Datum> temp = input.getDataOfType(GenotypeTable.class);
        if (temp.size() != 1) {
            throw new IllegalArgumentException("AddReferenceToGenotypePlugin: processData: must select one genotype table");
        }
        GenotypeTable orig = (GenotypeTable)temp.get(0).getData();
        GenomeSequence reference = GenomeSequenceBuilder.instance(this.reference());
        PositionList origPositions = orig.positions();
        PositionListBuilder builder = new PositionListBuilder();
        builder.genomeVersion(Utils.getFilename(this.reference()));
        origPositions.forEach(position -> {
            GeneralPosition.Builder newPosBuilder = new GeneralPosition.Builder((Position)position);
            byte ref = 15;
            try {
                ref = reference.genotype(position.getChromosome(), position.getPosition());
            }
            catch (Exception exception) {
                // empty catch block
            }
            newPosBuilder.allele(WHICH_ALLELE.Reference, ref);
            GeneralPosition newPos = newPosBuilder.build();
            builder.add(newPos);
        });
        GenotypeTable result = GenotypeTableBuilder.getInstance(orig.genotypeMatrix(), builder.build(), orig.taxa(), orig.depth(), orig.alleleProbability(), orig.referenceProbability(), orig.dosage(), orig.annotations());
        return new DataSet(new Datum(temp.get(0).getName() + "_withReference", result, null), (Plugin)this);
    }

    public String reference() {
        return this.myReference.value();
    }

    public AddReferenceToGenotypePlugin reference(String value) {
        this.myReference = new PluginParameter<String>(this.myReference, value);
        return this;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Add Reference to Genotype";
    }

    @Override
    public String getToolTipText() {
        return "Add Reference to Genotype";
    }
}

