/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.ImageIcon;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class AdjustPhasingPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(AdjustPhasingPlugin.class);
    private static final int NUM_VCF_HEADER_COLUMNS = 9;
    private PluginParameter<String> myInputVCFFile = new PluginParameter.Builder<String>("inputVCFFile", null, String.class).description("Input VCF file").inFile().guiName("Input VCF File").required(true).build();
    private PluginParameter<String> myHapcutDir = new PluginParameter.Builder<String>("hapcutDir", null, String.class).description("Directory containing Hapcut output files.").inDir().required(true).build();
    private PluginParameter<String> myOutputVCFFile = new PluginParameter.Builder<String>("outputVCFFile", null, String.class).description("Output VCF file").outFile().guiName("Output VCF File").required(true).build();
    private int myNumTaxa = 0;
    private String[] myTaxaNames = null;
    private int myNumSites = 0;
    private final Switch FALSE_SWITCH = new Switch();
    private static final int NUM_LINES_PER_BLOCK = 100;

    public AdjustPhasingPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        this.myNumSites = Utils.getNumberLinesNotHashOrBlank(this.inputVCFFile());
        try {
            ExecutorService pool = Executors.newWorkStealingPool();
            ArrayList<Future<ProcessHapcut>> futures = new ArrayList<Future<ProcessHapcut>>();
            File temp = new File(this.hapcutDir());
            for (File file : temp.listFiles()) {
                String name = file.getCanonicalPath();
                if (!name.endsWith("_haplotypes")) continue;
                ProcessHapcut process = new ProcessHapcut(name, this.myNumSites);
                futures.add(pool.submit(process));
            }
            String[] positionsFromHapcut = new String[this.myNumSites];
            HashMap<String, ProcessHapcut> processedHapcutFiles = new HashMap<String, ProcessHapcut>();
            for (Future future : futures) {
                ProcessHapcut processed = (ProcessHapcut)future.get();
                for (int s = 0; s < this.myNumSites; ++s) {
                    if (positionsFromHapcut[s] == null) {
                        positionsFromHapcut[s] = processed.myPositions[s];
                        continue;
                    }
                    if (processed.myPositions[s] == null || positionsFromHapcut[s].equals(processed.myPositions[s])) continue;
                    throw new IllegalStateException("AdjustPhasingPlugin: position at site: " + s + " in: " + processed.myFilename + ": " + processed.myPositions[s] + " doesn't match other Hapcut files: " + positionsFromHapcut[s]);
                }
                processedHapcutFiles.put(processed.taxaName(), processed);
                myLogger.info((Object)("finished processing: " + processed.filename() + " taxa: " + processed.taxaName()));
            }
            try {
                Throwable throwable = null;
                try (BufferedReader reader = Utils.getBufferedReader(this.inputVCFFile());
                     BufferedWriter writer = Utils.getBufferedWriter(this.outputVCFFile());){
                    String line = reader.readLine();
                    while (line != null && line.startsWith("##")) {
                        writer.write(line);
                        line = reader.readLine();
                    }
                    if (line == null || !line.startsWith("#CHROM")) {
                        throw new IllegalArgumentException("AdjustPhasingPlugin: processData: First line after ## lines should be header #CHROM...");
                    }
                    writer.write(line);
                    writer.write(10);
                    String[] tokens = line.split("\t");
                    this.myNumTaxa = tokens.length - 9;
                    myLogger.info((Object)("Number of Taxa: " + this.myNumTaxa));
                    myLogger.info((Object)("Number of Sites: " + this.myNumSites));
                    this.myTaxaNames = new String[this.myNumTaxa];
                    Switch[] switches = new Switch[this.myNumTaxa];
                    int numIntersectingTaxa = 0;
                    int numTaxaWithOutHapcut = 0;
                    for (int i = 9; i < tokens.length; ++i) {
                        this.myTaxaNames[i - 9] = tokens[i];
                        ProcessHapcut current = (ProcessHapcut)processedHapcutFiles.remove(tokens[i]);
                        if (current == null) {
                            switches[i - 9] = this.FALSE_SWITCH;
                            ++numTaxaWithOutHapcut;
                            continue;
                        }
                        switches[i - 9] = current.result();
                        ++numIntersectingTaxa;
                    }
                    int numHapcutNotInVCF = processedHapcutFiles.size();
                    myLogger.info((Object)("Number intersecting taxa between Hapcut files and VCF: " + numIntersectingTaxa));
                    myLogger.info((Object)("Number Taxa in VCF without Hapcut files: " + numTaxaWithOutHapcut));
                    myLogger.info((Object)("Number Hapcut files without taxa in VCF: " + numHapcutNotInVCF));
                    LinkedBlockingQueue<Future<ProcessLines>> queue = new LinkedBlockingQueue<Future<ProcessLines>>();
                    Future<?> readFuture = pool.submit(new ReadLines(reader, queue, switches, pool));
                    Future<?> writeFuture = pool.submit(new WriteLines(writer, queue));
                    readFuture.get();
                    writeFuture.get();
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
            }
            catch (Exception ex) {
                myLogger.debug((Object)ex.getMessage(), (Throwable)ex);
                throw new IllegalStateException("AdjustPhasingPlugin: processData: problem converting file: " + this.inputVCFFile() + " to file: " + this.outputVCFFile() + " error: " + ex.getMessage());
            }
            pool.shutdown();
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public String inputVCFFile() {
        return this.myInputVCFFile.value();
    }

    public AdjustPhasingPlugin inputVCFFile(String value) {
        this.myInputVCFFile = new PluginParameter<String>(this.myInputVCFFile, value);
        return this;
    }

    public String hapcutDir() {
        return this.myHapcutDir.value();
    }

    public AdjustPhasingPlugin hapcutDir(String value) {
        this.myHapcutDir = new PluginParameter<String>(this.myHapcutDir, value);
        return this;
    }

    public String outputVCFFile() {
        return this.myOutputVCFFile.value();
    }

    public AdjustPhasingPlugin outputVCFFile(String value) {
        this.myOutputVCFFile = new PluginParameter<String>(this.myOutputVCFFile, value);
        return this;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Adjust Phasing";
    }

    @Override
    public String getToolTipText() {
        return "Adjust Phasing";
    }

    private class WriteLines
    implements Runnable {
        private final BufferedWriter myWriter;
        private final BlockingQueue<Future<ProcessLines>> myQueue;

        public WriteLines(BufferedWriter writer, BlockingQueue<Future<ProcessLines>> queue) {
            this.myWriter = writer;
            this.myQueue = queue;
        }

        @Override
        public void run() {
            int[] numSwitchesTaxa = new int[AdjustPhasingPlugin.this.myNumTaxa];
            int[] numSwitchesSites = new int[AdjustPhasingPlugin.this.myNumSites];
            try {
                Future<ProcessLines> future = this.myQueue.take();
                ProcessLines processed = future.get();
                while (!processed.myIsFinalProcessLines) {
                    this.myWriter.write(processed.myBuilder.toString());
                    int percent = Math.min(Math.abs((int)((double)processed.myStartSite / (double)AdjustPhasingPlugin.this.myNumSites * 100.0)), 100);
                    AdjustPhasingPlugin.this.progress(percent, this);
                    for (int t = 0; t < AdjustPhasingPlugin.this.myNumTaxa; ++t) {
                        int n = t;
                        numSwitchesTaxa[n] = numSwitchesTaxa[n] + processed.myNumSwitchesTaxa[t];
                    }
                    System.arraycopy(processed.myNumSwitchesSites, 0, numSwitchesSites, processed.myStartSite, processed.myLines.length);
                    future = this.myQueue.take();
                    processed = future.get();
                }
            }
            catch (Exception e) {
                myLogger.debug((Object)e.getMessage(), (Throwable)e);
                throw new IllegalStateException("AdjustPhasingPlugin: WriteLines: problem writing file: " + AdjustPhasingPlugin.this.outputVCFFile());
            }
            for (int t = 0; t < AdjustPhasingPlugin.this.myNumTaxa; ++t) {
                System.out.println(t + ": " + AdjustPhasingPlugin.this.myTaxaNames[t] + ": alleles switched: " + numSwitchesTaxa[t]);
            }
        }
    }

    private class ReadLines
    implements Runnable {
        private final BufferedReader myReader;
        private final BlockingQueue<Future<ProcessLines>> myQueue;
        private final Switch[] mySwitches;
        private final ExecutorService myPool;

        public ReadLines(BufferedReader reader, BlockingQueue<Future<ProcessLines>> queue, Switch[] switches, ExecutorService pool) {
            this.myReader = reader;
            this.myQueue = queue;
            this.mySwitches = switches;
            this.myPool = pool;
        }

        @Override
        public void run() {
            try {
                String[] lines;
                ArrayList<String> temp = new ArrayList<String>();
                String line = this.myReader.readLine();
                int count = 0;
                int startSite = 0;
                while (line != null) {
                    temp.add(line);
                    if (++count == 100) {
                        lines = new String[100];
                        this.myQueue.add(this.myPool.submit(new ProcessLines(startSite, temp.toArray(lines), this.mySwitches)));
                        temp.clear();
                        count = 0;
                        startSite += 100;
                    }
                    line = this.myReader.readLine();
                }
                if (!temp.isEmpty()) {
                    lines = new String[temp.size()];
                    this.myQueue.add(this.myPool.submit(new ProcessLines(startSite, temp.toArray(lines), this.mySwitches)));
                }
                this.myQueue.add(this.myPool.submit(new ProcessLines()));
            }
            catch (Exception e) {
                myLogger.debug((Object)e.getMessage(), (Throwable)e);
                throw new IllegalStateException("AdjustPhasingPlugin: ReadLines: problem reading file: " + AdjustPhasingPlugin.this.inputVCFFile());
            }
        }
    }

    private class ProcessLines
    implements Callable<ProcessLines> {
        private final int myStartSite;
        private final String[] myLines;
        private final Switch[] mySwitches;
        private final StringBuilder myBuilder = new StringBuilder();
        private final boolean myIsFinalProcessLines;
        private final int[] myNumSwitchesTaxa;
        private final int[] myNumSwitchesSites;

        public ProcessLines(int startSite, String[] lines, Switch[] switches) {
            this.myStartSite = startSite;
            this.myLines = lines;
            this.mySwitches = switches;
            this.myIsFinalProcessLines = false;
            this.myNumSwitchesTaxa = new int[AdjustPhasingPlugin.this.myNumTaxa];
            this.myNumSwitchesSites = new int[this.myLines.length];
        }

        public ProcessLines() {
            this.myStartSite = 0;
            this.myLines = new String[0];
            this.mySwitches = null;
            this.myIsFinalProcessLines = true;
            this.myNumSwitchesTaxa = new int[0];
            this.myNumSwitchesSites = new int[0];
        }

        @Override
        public ProcessLines call() throws Exception {
            int currentSite = this.myStartSite;
            for (String current : this.myLines) {
                char[] temp = current.toCharArray();
                int numChars = temp.length;
                int copyToNthTab = 9;
                int numTabsFound = 0;
                int startIndex = 0;
                int charIndex = 0;
                for (int t = 0; t < AdjustPhasingPlugin.this.myNumTaxa; ++t) {
                    if (this.mySwitches[t].alleles(currentSite)) {
                        int n = t;
                        this.myNumSwitchesTaxa[n] = this.myNumSwitchesTaxa[n] + 1;
                        int n2 = currentSite - this.myStartSite;
                        this.myNumSwitchesSites[n2] = this.myNumSwitchesSites[n2] + 1;
                        while (true) {
                            if (temp[charIndex] == '\t' && ++numTabsFound == copyToNthTab) {
                                this.myBuilder.append(temp, startIndex, charIndex - startIndex + 1);
                                char first = temp[++charIndex];
                                if (temp[++charIndex] != '|') {
                                    throw new IllegalStateException("AdjustPhasingPlugin: ProcessLines: | char expected.");
                                }
                                this.myBuilder.append(temp[++charIndex]);
                                this.myBuilder.append('|');
                                this.myBuilder.append(first);
                                ++charIndex;
                                while (charIndex < numChars && temp[charIndex] != '\t') {
                                    this.myBuilder.append(temp[charIndex]);
                                    ++charIndex;
                                }
                                if (charIndex < numChars) {
                                    this.myBuilder.append('\t');
                                    break;
                                }
                                this.myBuilder.append('\n');
                                break;
                            }
                            ++charIndex;
                        }
                        startIndex = charIndex + 1;
                        ++copyToNthTab;
                        continue;
                    }
                    ++copyToNthTab;
                }
                if (startIndex < numChars) {
                    this.myBuilder.append(temp, startIndex, numChars - startIndex);
                    this.myBuilder.append('\n');
                }
                ++currentSite;
            }
            return this;
        }
    }

    private class SwitchBitSet
    extends Switch {
        private final BitSet myBitSet;

        public SwitchBitSet(BitSet bitSet) {
            this.myBitSet = bitSet;
        }

        @Override
        public boolean alleles(int site) {
            return this.myBitSet.fastGet(site);
        }
    }

    private class Switch {
        private Switch() {
        }

        public boolean alleles(int site) {
            return false;
        }
    }

    private class ProcessHapcut
    implements Callable<ProcessHapcut> {
        private final String myFilename;
        private final String myLogfile;
        private final String myTaxaName;
        private final BitSet myResult;
        private final String[] myPositions;
        private final List<String> myChromosomes = new ArrayList<String>();
        private final List<Integer> myOffsets = new ArrayList<Integer>();

        public ProcessHapcut(String filename, int numSites) {
            this.myFilename = filename;
            this.myLogfile = filename + ".log";
            this.myTaxaName = Utils.getFilename(filename).split("_")[0];
            this.myResult = new OpenBitSet(numSites);
            this.myPositions = new String[numSites];
        }

        @Override
        public ProcessHapcut call() throws Exception {
            try (BufferedReader reader = Utils.getBufferedReader(this.myFilename);
                 BufferedWriter log = Utils.getBufferedWriter(this.myLogfile);){
                String line = reader.readLine();
                if (line == null) {
                    myLogger.warn((Object)("Hapcut file: " + this.myFilename + " is empty."));
                }
                int blockNum = 0;
                while (line != null) {
                    if (!line.startsWith("BLOCK")) {
                        throw new IllegalStateException("AdjustPhasingPlugin: expected BLOCK statement: " + line);
                    }
                    this.processBlock(reader, line, ++blockNum, log);
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                myLogger.debug((Object)e.getMessage(), (Throwable)e);
                throw new IllegalStateException("AdjustPhasingPlugin: ProcessHapcut: problem reading file: " + this.myFilename + ": " + e.getMessage());
            }
            return this;
        }

        private void processBlock(BufferedReader reader, String blockLine, int blockNum, BufferedWriter log) {
            String currentChr = null;
            int highestChrIndex = -1;
            List[] phased = new List[]{new ArrayList(), new ArrayList()};
            HashMap<Integer, String> blockLines = new HashMap<Integer, String>();
            try {
                String line = reader.readLine();
                while (line != null && !line.startsWith("********")) {
                    String[] tokens = line.split("\t");
                    if (currentChr == null) {
                        currentChr = tokens[3];
                    } else if (!currentChr.equals(tokens[3])) {
                        throw new IllegalStateException("AdjustPhasingPlugin: ProcessHapcut: Different chr: " + tokens[3] + " within block that started with chr: " + currentChr);
                    }
                    int tempIndex = Integer.parseInt(tokens[0]) - 1;
                    blockLines.put(tempIndex, line);
                    if (highestChrIndex >= tempIndex) {
                        throw new IllegalStateException("AdjustPhasingPlugin: ProcessHapcut: index out of order: " + tempIndex);
                    }
                    highestChrIndex = tempIndex;
                    this.myPositions[tempIndex] = tokens[4];
                    String[] fromVCF = tokens[7].split(":")[0].split("\\|");
                    if (tokens[1].equals(fromVCF[0]) || tokens[2].equals(fromVCF[1])) {
                        phased[0].add(tempIndex);
                    } else {
                        phased[1].add(tempIndex);
                    }
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                myLogger.debug((Object)e.getMessage(), (Throwable)e);
                throw new IllegalStateException("AdjustPhasingPlugin: ProcessHapcut: problem reading file: " + this.myFilename + ": " + e.getMessage());
            }
            int chrIndex = this.myChromosomes.indexOf(currentChr);
            if (chrIndex == -1) {
                this.myChromosomes.add(currentChr);
                this.myOffsets.add(highestChrIndex);
            } else if (this.myOffsets.get(chrIndex) < highestChrIndex) {
                this.myOffsets.add(chrIndex, highestChrIndex);
            }
            if (!phased[0].isEmpty() || !phased[1].isEmpty()) {
                List smallest = null;
                smallest = phased[0].size() < phased[1].size() ? phased[0] : phased[1];
                for (Integer index : smallest) {
                    this.myResult.fastSet(index);
                    try {
                        log.write(String.valueOf(blockNum));
                        log.write("\t");
                        log.write((String)blockLines.get(index));
                        log.write("\n");
                    }
                    catch (Exception e) {
                        myLogger.debug((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }

        public String filename() {
            return this.myFilename;
        }

        public String taxaName() {
            return this.myTaxaName;
        }

        public Switch result() {
            if (this.myResult.cardinality() == 0L) {
                return AdjustPhasingPlugin.this.FALSE_SWITCH;
            }
            return new SwitchBitSet(this.myResult);
        }

        public String[] positions() {
            return this.myPositions;
        }

        public List<String> chromosomes() {
            return this.myChromosomes;
        }

        public List<Integer> offsets() {
            return this.myOffsets;
        }
    }
}

