/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.io.BufferedReader;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.Tuple;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class ConvertAlignmentCoordinatesPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(ConvertAlignmentCoordinatesPlugin.class);
    private PluginParameter<String> myMapFilename = new PluginParameter.Builder<String>("mapFile", null, String.class).description("").inFile().required(true).build();
    private PluginParameter<String> myGenomeVersion = new PluginParameter.Builder<String>("genomeVersion", "AGPv3", String.class).description("").build();
    private final HashMap<String, Chromosome> myLociMap = new HashMap();
    private final HashMap<String, Chromosome> myAlignmentLociMap = new HashMap();

    public ConvertAlignmentCoordinatesPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DataSet processData(DataSet input) {
        List<Datum> alignInList = input.getDataOfType(GenotypeTable.class);
        if (alignInList.size() != 1) {
            throw new IllegalArgumentException("Invalid selection.  Please select one genotype table.");
        }
        Datum datum = alignInList.get(0);
        GenotypeTable alignment = (GenotypeTable)datum.getData();
        Chromosome[] loci = alignment.chromosomes();
        this.myLociMap.clear();
        for (int i = 0; i < loci.length; ++i) {
            this.myLociMap.put(loci[i].getName(), loci[i]);
            this.myAlignmentLociMap.put(loci[i].getName(), loci[i]);
        }
        int numSites = alignment.numberOfSites();
        String[] snpIDs = new String[numSites];
        for (int i = 0; i < numSites; ++i) {
            snpIDs[i] = alignment.siteName(i);
        }
        int count = 1;
        PositionListBuilder posBuilder = new PositionListBuilder().addAll(alignment.positions()).genomeVersion(this.genomeVersion());
        try (BufferedReader br = Utils.getBufferedReader(this.mapFilename());){
            Pattern sep = Pattern.compile("\\s+");
            String inputline = br.readLine();
            inputline = br.readLine();
            int numChanges = 0;
            while (inputline != null) {
                int site;
                ++count;
                inputline = inputline.trim();
                String[] parsedline = sep.split(inputline);
                inputline = br.readLine();
                String locus1 = this.getLocusName(parsedline[1]);
                if (this.myAlignmentLociMap.get(locus1) == null) continue;
                String snpID = parsedline[0];
                int pos1 = Integer.valueOf(parsedline[2]);
                String locus2 = this.getLocusName(parsedline[3]);
                int pos2 = Integer.valueOf(parsedline[4]);
                if (locus1.equals(locus2) && pos1 == pos2 || (site = this.getSiteOfSNPID(snpID, snpIDs)) < 0) continue;
                if (pos1 != alignment.chromosomalPosition(site) || !locus1.equals(alignment.chromosome(site).getName())) {
                    myLogger.warn((Object)("map file line: " + count + "  SNP ID: " + snpID + "  position: " + pos1 + "  locus: " + locus1 + " position and locus do not match alignment."));
                    myLogger.warn((Object)("Alignment SNP ID: " + alignment.siteName(site) + "  position: " + alignment.chromosomalPosition(site) + "  locus: " + alignment.chromosomeName(site)));
                    continue;
                }
                ++numChanges;
                GeneralPosition.Builder newPos = new GeneralPosition.Builder((Position)alignment.positions().get(site));
                newPos.chromosome(this.getLocusObj(locus2)).position(pos2).snpName(snpID);
                posBuilder.set(site, newPos.build());
            }
            myLogger.info((Object)("Number Changes: " + numChanges));
            Tuple<PositionList, int[]> temp = posBuilder.buildWithSiteRedirect();
            GenotypeTable newGenotypeTable = FilterGenotypeTable.getInstance(alignment, (PositionList)temp.x, (int[])temp.y);
            String comment = alignment.positions().genomeVersion() + " converted to " + this.genomeVersion();
            Datum result = new Datum(datum.getName() + "_NewCoordinates", newGenotypeTable, comment);
            DataSet dataSet = new DataSet(result, (Plugin)this);
            return dataSet;
        }
        catch (Exception e) {
            throw new IllegalStateException("ConvertAlignmentCoordinatesPlugin: processDatum: problem converting alignment: line: " + count + "  message: " + e.getMessage());
        }
    }

    private Chromosome getLocusObj(String locus) {
        Chromosome locusObj = this.myLociMap.get(locus);
        if (locusObj == null) {
            locusObj = new Chromosome(locus);
            this.myLociMap.put(locus, locusObj);
        }
        return locusObj;
    }

    private String getLocusName(String input) {
        if (input.startsWith("chr")) {
            return input.substring(3);
        }
        return input;
    }

    private int getSiteOfSNPID(String id, String[] snpIDs) {
        int n = snpIDs.length;
        for (int i = 0; i < n; ++i) {
            if (!id.equals(snpIDs[i])) continue;
            return i;
        }
        return -1;
    }

    public String mapFilename() {
        return this.myMapFilename.value();
    }

    public ConvertAlignmentCoordinatesPlugin mapFilename(String value) {
        this.myMapFilename = new PluginParameter<String>(this.myMapFilename, value);
        return this;
    }

    public String genomeVersion() {
        return this.myGenomeVersion.value();
    }

    public ConvertAlignmentCoordinatesPlugin genomeVersion(String value) {
        this.myGenomeVersion = new PluginParameter<String>(this.myGenomeVersion, value);
        return this;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Convert Genotype Table Coordinates";
    }

    @Override
    public String getToolTipText() {
        return "Convert Genotype Table Coordinates";
    }
}

