/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.swing.ImageIcon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\tH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\u0006\u0010\u0007\u001a\u00020\tJ\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\tJ\u0006\u0010\u000b\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\tJ\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\t0\u00152\u0006\u0010\u000b\u001a\u00020\tJ\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\tJ\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0016R2\u0010\u0007\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u000b\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \n*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000e\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lnet/maizegenetics/analysis/data/CountAssociationsPlugin;", "Lnet/maizegenetics/plugindef/AbstractPlugin;", "parentFrame", "Ljava/awt/Frame;", "isInteractive", "", "(Ljava/awt/Frame;Z)V", "gwasResults", "Lnet/maizegenetics/plugindef/PluginParameter;", "", "kotlin.jvm.PlatformType", "intervalFile", "myLogger", "Lorg/apache/log4j/Logger;", "outputFile", "getButtonName", "getIcon", "Ljavax/swing/ImageIcon;", "getToolTipText", "value", "loadInIntervalFile", "Lcom/google/common/collect/RangeMap;", "Lnet/maizegenetics/dna/map/Position;", "processData", "Lnet/maizegenetics/plugindef/DataSet;", "input", "tassel"})
public final class CountAssociationsPlugin
extends AbstractPlugin {
    private final Logger myLogger;
    private PluginParameter<String> intervalFile;
    private PluginParameter<String> gwasResults;
    private PluginParameter<String> outputFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public DataSet processData(@Nullable DataSet input) {
        String it;
        boolean bl;
        void $this$mapTo$iv$iv;
        RangeMap<Position, String> intervalMap = this.loadInIntervalFile(this.intervalFile());
        boolean bl2 = false;
        Map outputMap = new LinkedHashMap();
        boolean bl3 = false;
        Set traitSet = new LinkedHashSet();
        Map map = intervalMap.asMapOfRanges();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"intervalMap.asMapOfRanges()");
        Map $this$map$iv = map;
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var11_25 = $this$mapTo$iv$iv;
        boolean bl4 = false;
        Iterator iterator = var11_25.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            bl = false;
            String string = (String)it.getValue();
            collection.add(string);
        }
        SortedSet intervalSet = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
        boolean traitCount = false;
        Closeable closeable = Utils.getBufferedReader(this.gwasResults());
        boolean bl5 = false;
        boolean bl6 = false;
        Throwable throwable = null;
        try {
            BufferedReader reader = (BufferedReader)closeable;
            boolean bl7 = false;
            String currLine = reader.readLine();
            while (currLine != null) {
                if (StringsKt.startsWith$default((String)currLine, (String)"trait", (boolean)false, (int)2, null)) {
                    currLine = reader.readLine();
                    continue;
                }
                List currLineSplit = StringsKt.split$default((CharSequence)currLine, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
                String traitName = (String)currLineSplit.get(0);
                traitSet.add(traitName);
                it = (String)currLineSplit.get(2);
                bl = false;
                Position pos = Position.of((String)currLineSplit.get(1), Integer.parseInt(it));
                String intervalHit = (String)intervalMap.get((Comparable)pos);
                if (intervalHit == null) {
                    currLine = reader.readLine();
                    continue;
                }
                if (!outputMap.containsKey(intervalHit)) {
                    bl = false;
                    outputMap.put(intervalHit, (Map)new LinkedHashMap());
                }
                Object v = outputMap.get(intervalHit);
                Intrinsics.checkNotNull(v);
                if (!((Map)v).containsKey(traitName)) {
                    Map map3 = (Map)outputMap.get(intervalHit);
                    if (map3 != null) {
                        map3.put(traitName, 1);
                    }
                } else {
                    Object object = (Map)outputMap.get(intervalHit);
                    int currentCount = object != null && (object = (Integer)object.get(traitName)) != null ? (Integer)object : 0;
                    Map map4 = (Map)outputMap.get(intervalHit);
                    if (map4 != null) {
                        map4.put(traitName, currentCount + 1);
                    }
                }
                currLine = reader.readLine();
            }
            reader = Unit.INSTANCE;
        }
        catch (Throwable reader) {
            throwable = reader;
            throw reader;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        closeable = Utils.getBufferedWriter(this.outputFile());
        bl5 = false;
        boolean bl8 = false;
        Throwable throwable2 = null;
        try {
            BufferedWriter output = (BufferedWriter)closeable;
            boolean bl9 = false;
            List sortedTraits = CollectionsKt.sorted((Iterable)traitSet);
            output.write("Interval\t" + CollectionsKt.joinToString$default((Iterable)sortedTraits, (CharSequence)"\t", null, null, (int)0, null, null, (int)62, null) + '\n');
            for (String interval : intervalSet) {
                Map countMap2 = (Map)outputMap.get(interval);
                boolean currentCount = false;
                List countList = new ArrayList();
                for (String trait : sortedTraits) {
                    if (countMap2 == null) {
                        countList.add(0);
                        continue;
                    }
                    Integer n = (Integer)countMap2.get(trait);
                    int count = n != null ? n : 0;
                    countList.add(count);
                }
                output.write(interval + '\t' + CollectionsKt.joinToString$default((Iterable)countList, (CharSequence)"\t", null, null, (int)0, null, null, (int)62, null) + '\n');
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable2 = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
        }
        return null;
    }

    @NotNull
    public final RangeMap<Position, String> loadInIntervalFile(@NotNull String intervalFile) {
        List list;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)intervalFile, (String)"intervalFile");
        ImmutableRangeMap.Builder intervalMapBuilder = new ImmutableRangeMap.Builder();
        BufferedReader bufferedReader = Utils.getBufferedReader(intervalFile);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"Utils.getBufferedReader(intervalFile)");
        Iterable $this$filter$iv = TextStreamsKt.readLines((Reader)bufferedReader);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!StringsKt.startsWith$default((String)it, (String)"seqnames", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            list = StringsKt.split$default((CharSequence)((CharSequence)it), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
            collection.add(list);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (List)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = (String)it.get(1);
            boolean bl2 = false;
            Comparable comparable = Position.of((String)it.get(0), Integer.parseInt(string));
            string = (String)it.get(2);
            bl2 = false;
            list = new Pair((Object)Range.closed((Comparable)comparable, (Comparable)Position.of((String)it.get(0), Integer.parseInt(string))), it.get(3));
            collection.add(list);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it2 = (Pair)element$iv;
            boolean bl = false;
            intervalMapBuilder.put((Range)it2.getFirst(), it2.getSecond());
        }
        ImmutableRangeMap immutableRangeMap = intervalMapBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableRangeMap, (String)"intervalMapBuilder.build()");
        return (RangeMap)immutableRangeMap;
    }

    @Override
    @Nullable
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    @NotNull
    public String getButtonName() {
        return "Count Associations";
    }

    @Override
    @NotNull
    public String getToolTipText() {
        return "Create a count file For Associations";
    }

    @NotNull
    public final String intervalFile() {
        String string = this.intervalFile.value();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"intervalFile.value()");
        return string;
    }

    @NotNull
    public final CountAssociationsPlugin intervalFile(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.intervalFile = new PluginParameter<String>(this.intervalFile, value);
        return this;
    }

    @NotNull
    public final String gwasResults() {
        String string = this.gwasResults.value();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gwasResults.value()");
        return string;
    }

    @NotNull
    public final CountAssociationsPlugin gwasResults(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.gwasResults = new PluginParameter<String>(this.gwasResults, value);
        return this;
    }

    @NotNull
    public final String outputFile() {
        String string = this.outputFile.value();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"outputFile.value()");
        return string;
    }

    @NotNull
    public final CountAssociationsPlugin outputFile(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.outputFile = new PluginParameter<String>(this.outputFile, value);
        return this;
    }

    public CountAssociationsPlugin(@Nullable Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
        this.myLogger = Logger.getLogger(CountAssociationsPlugin.class);
        this.intervalFile = new PluginParameter.Builder<String>("intervals", null, String.class).description("Interval File.").inFile().required(true).build();
        this.gwasResults = new PluginParameter.Builder<String>("gwasResults", null, String.class).description("GWAS Result File.").inFile().required(true).build();
        this.outputFile = new PluginParameter.Builder<String>("outputCountFile", null, String.class).description("Output Count File.").outFile().required(true).build();
    }

    public /* synthetic */ CountAssociationsPlugin(Frame frame, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            frame = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        this(frame, bl);
    }

    public CountAssociationsPlugin() {
        this(null, false, 3, null);
    }
}

