/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.data.GenomeAnnosDBQueryToPositionListPlugin;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class FeatureListToPositionsPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(FeatureListToPositionsPlugin.class);
    private PluginParameter<String> myConnConfigFile = new PluginParameter.Builder<String>("cf", null, String.class).required(true).inFile().guiName("DB Config File").description("DB connection config file").build();
    private PluginParameter<String> myFeatureType = new PluginParameter.Builder<String>("featureType", "gene", String.class).description("Feature Type.  Examples: three_prime_utr, gene, exon, five_prime_utr, transcript, cds").build();
    private PluginParameter<String> myFeatureListFilename = new PluginParameter.Builder<String>("featureListFilename", null, String.class).description("File with list of features.  If this is not specified, all features of specified type are retrieved.").inFile().build();
    private PluginParameter<String> myOutputFile = new PluginParameter.Builder<String>("outputFile", null, String.class).description("Output filename").required(true).outFile().build();
    private PluginParameter<Integer> myNumberBasesPlusOrMinus = new PluginParameter.Builder<Integer>("numberBasesPlusOrMinus", 0, Integer.class).description("Number of bases plus or minus the range of each feature").build();

    public FeatureListToPositionsPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        StringBuilder builder = new StringBuilder();
        builder.append("select feature_name, chr_number, feature_range from feature where feature_type = '");
        builder.append(this.featureType());
        builder.append("'");
        if (this.featureListFilename() != null && !this.featureListFilename().isEmpty()) {
            builder.append(" AND feature_name in (");
            try (BufferedReader reader = Utils.getBufferedReader(this.featureListFilename());){
                boolean first = true;
                String line = reader.readLine();
                while (line != null) {
                    if (!(line = line.trim()).isEmpty()) {
                        if (!first) {
                            builder.append(", ");
                        }
                        builder.append("'");
                        builder.append(line);
                        builder.append("'");
                        first = false;
                    }
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                myLogger.debug((Object)e.getMessage(), (Throwable)e);
                throw new IllegalStateException("processData: Problem reading gene list file: " + this.featureListFilename());
            }
            builder.append(")");
        }
        builder.append(" order by chr_number, feature_range;");
        String query = builder.toString();
        myLogger.info((Object)("processData: query statement: " + query));
        Connection dbConnection = GenomeAnnosDBQueryToPositionListPlugin.connectToDB(this.connConfigFile());
        if (dbConnection == null) {
            throw new IllegalStateException("processData: Problem connecting to database.");
        }
        try (ResultSet rs = dbConnection.createStatement().executeQuery(query);
             BufferedWriter writer = Utils.getBufferedWriter(Utils.addSuffixIfNeeded(this.outputFile(), ".bed"));){
            while (rs.next()) {
                String featureName = rs.getString("feature_name");
                String range = rs.getString("feature_range");
                writer.write(rs.getString("chr_number").trim());
                writer.write("\t");
                String[] tokens = range.split(",");
                String startPosStr = tokens[0].trim().substring(1);
                String endPosStr = tokens[1].trim().substring(0, tokens[1].length() - 1);
                int startPos = Math.max(0, Integer.parseInt(startPosStr) - this.numberBasesPlusOrMinus() - 1);
                writer.write(String.valueOf(startPos));
                writer.write("\t");
                int endPos = Integer.parseInt(endPosStr) + this.numberBasesPlusOrMinus() - 1;
                writer.write(String.valueOf(endPos));
                writer.write("\t");
                writer.write(featureName);
                writer.write("\t");
                writer.write("0");
                writer.write("\t");
                writer.write("+");
                writer.write("\t");
                writer.write(startPosStr);
                writer.write("\t");
                writer.write(endPosStr);
                writer.write("\n");
            }
        }
        catch (Exception se) {
            myLogger.debug((Object)se.getMessage(), (Throwable)se);
            throw new IllegalStateException("processData: Problem querying the database: " + se.getMessage());
        }
        return null;
    }

    public String connConfigFile() {
        return this.myConnConfigFile.value();
    }

    public FeatureListToPositionsPlugin connConfigFile(String value) {
        this.myConnConfigFile = new PluginParameter<String>(this.myConnConfigFile, value);
        return this;
    }

    public String featureType() {
        return this.myFeatureType.value();
    }

    public FeatureListToPositionsPlugin featureType(String value) {
        this.myFeatureType = new PluginParameter<String>(this.myFeatureType, value);
        return this;
    }

    public String featureListFilename() {
        return this.myFeatureListFilename.value();
    }

    public FeatureListToPositionsPlugin featureListFilename(String value) {
        this.myFeatureListFilename = new PluginParameter<String>(this.myFeatureListFilename, value);
        return this;
    }

    public String outputFile() {
        return this.myOutputFile.value();
    }

    public FeatureListToPositionsPlugin outputFile(String value) {
        this.myOutputFile = new PluginParameter<String>(this.myOutputFile, value);
        return this;
    }

    public Integer numberBasesPlusOrMinus() {
        return this.myNumberBasesPlusOrMinus.value();
    }

    public FeatureListToPositionsPlugin numberBasesPlusOrMinus(Integer value) {
        this.myNumberBasesPlusOrMinus = new PluginParameter<Integer>(this.myNumberBasesPlusOrMinus, value);
        return this;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Feature List to Positions";
    }

    @Override
    public String getToolTipText() {
        return "Feature List to Positions";
    }
}

