/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.util.List;
import javax.swing.ImageIcon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.genotypecall.AlleleFreqCache;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.util.ColumnMatrix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Lnet/maizegenetics/analysis/data/GenotypeToAdditiveValuesPlugin;", "Lnet/maizegenetics/plugindef/AbstractPlugin;", "parentFrame", "Ljava/awt/Frame;", "isInteractive", "", "(Ljava/awt/Frame;Z)V", "getButtonName", "", "getIcon", "Ljavax/swing/ImageIcon;", "getToolTipText", "processData", "Lnet/maizegenetics/plugindef/DataSet;", "input", "runPlugin", "Lnet/maizegenetics/util/ColumnMatrix;", "genotype", "Lnet/maizegenetics/dna/snp/GenotypeTable;", "tassel"})
public final class GenotypeToAdditiveValuesPlugin
extends AbstractPlugin {
    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DataSet processData(@Nullable DataSet input) {
        List<Datum> temp;
        DataSet dataSet = input;
        List<Datum> list = temp = dataSet != null ? dataSet.getDataOfType(GenotypeTable.class) : null;
        if (list == null || list.size() != 1) {
            throw (Throwable)new IllegalArgumentException("GenotypeToAdditiveValuesPlugin: processData: must input a genotype");
        }
        Datum datum = temp.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"temp[0]");
        Object object = datum.getData();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type net.maizegenetics.dna.snp.GenotypeTable");
        }
        GenotypeTable genotype = (GenotypeTable)object;
        ColumnMatrix.Builder result = new ColumnMatrix.Builder(genotype.numberOfTaxa(), genotype.numberOfSites());
        int n = 0;
        int n2 = genotype.numberOfSites();
        while (n < n2) {
            void site;
            byte[] siteGenotypes = genotype.genotypeAllTaxa((int)site);
            int[][] alleleCounts = AlleleFreqCache.allelesSortedByFrequencyNucleotide(siteGenotypes);
            byte majorAllele = AlleleFreqCache.majorAllele(alleleCounts);
            int n3 = 0;
            int n4 = genotype.numberOfTaxa();
            while (n3 < n4) {
                byte by;
                void taxon;
                byte value = 0;
                byte[] alleles = GenotypeTableUtils.getDiploidValues(siteGenotypes[taxon]);
                if (alleles[0] != majorAllele) {
                    by = value;
                    value = (byte)(by + 1);
                }
                if (alleles[1] != majorAllele) {
                    by = value;
                    value = (byte)(by + 1);
                }
                result.set((int)taxon, (int)site, value);
                ++taxon;
            }
            ++site;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Datum datum2 = temp.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)datum2, (String)"temp[0]");
        return new DataSet(new Datum(stringBuilder.append(datum2.getName()).append(" Additive Values").toString(), result.build(), null), (Plugin)this);
    }

    @NotNull
    public final ColumnMatrix runPlugin(@NotNull GenotypeTable genotype) {
        Intrinsics.checkNotNullParameter((Object)genotype, (String)"genotype");
        Datum datum = this.performFunction(DataSet.getDataSet(genotype)).getDataOfType(ColumnMatrix.class).get(0);
        Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"performFunction(DataSet.\u2026umnMatrix::class.java)[0]");
        Object object = datum.getData();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type net.maizegenetics.util.ColumnMatrix");
        }
        return (ColumnMatrix)object;
    }

    @Override
    @Nullable
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    @NotNull
    public String getButtonName() {
        return "Convert Genotype to Additive Values";
    }

    @Override
    @NotNull
    public String getToolTipText() {
        return "Convert Genotype to Additive Values";
    }

    public GenotypeToAdditiveValuesPlugin(@Nullable Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }
}

