/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import org.apache.log4j.Logger;

public class GetTaxaListPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(GetTaxaListPlugin.class);

    public GetTaxaListPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        String name;
        ArrayList<Datum> result = new ArrayList<Datum>();
        List<Datum> datumList = input.getDataOfType(GenotypeTable.class);
        for (Datum current : datumList) {
            name = current.getName();
            GenotypeTable genotypeTable = (GenotypeTable)current.getData();
            result.add(new Datum(name + "_TaxaList", genotypeTable.taxa(), "Taxa List from " + name));
        }
        datumList = input.getDataOfType(DistanceMatrix.class);
        for (Datum current : datumList) {
            name = current.getName();
            DistanceMatrix matrix = (DistanceMatrix)current.getData();
            result.add(new Datum(name + "_TaxaList", matrix.getTaxaList(), "Taxa List from " + name));
        }
        datumList = input.getDataOfType(Phenotype.class);
        for (Datum current : datumList) {
            name = current.getName();
            Phenotype phenotype = (Phenotype)current.getData();
            result.add(new Datum(name + "_TaxaList", phenotype.taxa(), "Taxa List from " + name));
        }
        if (result.isEmpty()) {
            throw new IllegalArgumentException("GetTaxaListPlugin: processData: nothing is selected that has a taxa list.");
        }
        return new DataSet(result, (Plugin)this);
    }

    @Override
    public String getToolTipText() {
        return "Get Taxa List";
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = GetTaxaListPlugin.class.getResource("/net/maizegenetics/analysis/images/lists.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Get Taxa List";
    }
}

