/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.HDF5LinkInformation;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import java.util.List;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.HDF5Utils;

public class LowLevelCopyOfHDF5 {
    public static void subsetGenotypesToNewFile(String t5File, String subT5File, TaxaList subsetTaxa) {
        IHDF5Reader reader = HDF5Factory.openForReading((String)t5File);
        IHDF5Writer writer = HDF5Factory.open((String)subT5File);
        writer.object().createGroup("Genotypes");
        HDF5Utils.unlockHDF5GenotypeModule(writer);
        writer.object().createGroup("Taxa");
        HDF5Utils.unlockHDF5TaxaModule(writer);
        int numTaxa = 0;
        HDF5Utils.writeHDF5GenotypesAlleleStates(writer, NucleotideAlignmentConstants.NUCLEOTIDE_ALLELES);
        HDF5Utils.writeHDF5GenotypesMaxNumAlleles(writer, 6);
        HDF5Utils.writeHDF5GenotypesRetainRareAlleles(writer, false);
        List fields = reader.object().getAllGroupMemberInformation("Genotypes", true);
        for (HDF5LinkInformation is : fields) {
            String taxonName;
            if (!is.isGroup() || subsetTaxa.indexOf(taxonName = is.getName()) < 0) continue;
            reader.object().copy("Genotypes/" + taxonName, writer, "Genotypes/" + taxonName);
            HDF5Utils.addTaxon(writer, new Taxon(taxonName));
            ++numTaxa;
        }
        HDF5Utils.writeHDF5GenotypesNumTaxa(writer, numTaxa);
        HDF5Utils.writeHDF5TaxaNumTaxa(writer, numTaxa);
        reader.object().copy("Positions", writer, "Positions");
        GenotypeTableBuilder.annotateHDF5File(writer);
        HDF5Utils.lockHDF5GenotypeModule(writer);
        HDF5Utils.lockHDF5TaxaModule(writer);
        reader.close();
        writer.close();
    }
}

