/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import java.awt.Frame;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.data.SeparatePlugin;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.genotypecall.BasicGenotypeMergeRule;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.ArgsEngine;
import net.maizegenetics.util.DirectoryCrawler;
import net.maizegenetics.util.HDF5Utils;
import org.apache.log4j.Logger;

public class MergeHDF5GenotypesSameSitesPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(MergeHDF5GenotypesSameSitesPlugin.class);
    private ArgsEngine myArgsEngine = null;
    private String[] inHD5F5GenoFileNames = null;
    private String mergedHDF5GenoFileName;
    private boolean ignoreDepth = false;

    public MergeHDF5GenotypesSameSitesPlugin() {
        super(null, false);
    }

    public MergeHDF5GenotypesSameSitesPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    private void printUsage() {
        myLogger.info((Object)"\n\nThe options for the TASSEL5 MergeHDF5GenotypesSameSitesPlugin are as follows:\n  -i   Input folder containing HDF5 genotype (*.h5) files to be merged. These\n       must all contain exactly the same sites.\n\n  -o   Output, merged HDF5 genotype file name (*.h5). Must in a different\n       folder than the input folder, that lies outside of the input folder.\n\n  -iD  Ignore depth. If genotypic depth information is present in any of the\n       input files, ignore it. If none of the files contain depth, then this\n       option is not strictly necessary, but it will likely improve speed.\n       Default: use depth (under the assumption that it is present in all\n       input files).\n\n");
    }

    @Override
    public void setParameters(String[] args) {
        if (args == null || args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.myArgsEngine == null) {
            this.myArgsEngine = new ArgsEngine();
            this.myArgsEngine.add("-i", "--input-folder", true);
            this.myArgsEngine.add("-o", "--output-file", true);
            this.myArgsEngine.add("-iD", "--ignore-depth", false);
        }
        this.myArgsEngine.parse(args);
        String inDirName = this.myArgsEngine.getString("-i");
        File inDirectory = null;
        if (inDirName != null) {
            inDirectory = new File(inDirName);
            if (!inDirectory.isDirectory()) {
                this.printUsage();
                String string = "\nThe input folder name you supplied is not a directory:\n" + inDirName + "\n\n";
                myLogger.error((Object)string);
                throw new IllegalArgumentException(string);
            }
            this.inHD5F5GenoFileNames = DirectoryCrawler.listFileNames(".*\\.h5$", inDirectory.getAbsolutePath());
            if (this.inHD5F5GenoFileNames.length == 0 || this.inHD5F5GenoFileNames == null) {
                this.printUsage();
                String string = "\nNo files with the extension .h5 (HDF5 genotype files) were found in the input folder:\n  " + inDirName + "\nor in any of its sub-folders\n\n";
                myLogger.error((Object)string);
                throw new IllegalArgumentException(string);
            }
            if (this.inHD5F5GenoFileNames.length < 2) {
                this.printUsage();
                String string = "\nThere must be at least 2 files with the extension .h5 (HDF5 genotype files) in the input folder:\n  " + inDirName + "\nor its sub-folders\n\n";
                myLogger.error((Object)string);
                throw new IllegalArgumentException(string);
            }
            Arrays.sort(this.inHD5F5GenoFileNames);
            myLogger.info((Object)"\n\nMergeHDF5GenotypesSameSitesPlugin:\n\nThe following HDF5 genotype files were found in the input folder (and sub-folders):");
            for (String filename : this.inHD5F5GenoFileNames) {
                System.out.println("   " + filename);
            }
        } else {
            this.printUsage();
            String string = "\nPlease specify an input directory containing HDF5 genotype files to be merged (option -i)\n\n";
            myLogger.error((Object)string);
            throw new IllegalArgumentException(string);
        }
        System.out.println("\n");
        if (this.myArgsEngine.getBoolean("-o")) {
            this.mergedHDF5GenoFileName = this.myArgsEngine.getString("-o");
            File file = new File(this.mergedHDF5GenoFileName);
            if (file.exists()) {
                this.printUsage();
                String errMessage = "\nThe output file (option -o) must not already exist.\n\n";
                myLogger.error((Object)errMessage);
                throw new IllegalArgumentException(errMessage);
            }
            if (file.getAbsolutePath().startsWith(inDirectory.getAbsolutePath())) {
                this.printUsage();
                String errMessage = "\nThe output file (option -o) must not lie within the input folder.\n\n";
                myLogger.error((Object)errMessage);
                throw new IllegalArgumentException(errMessage);
            }
            if (!this.mergedHDF5GenoFileName.endsWith(".h5")) {
                this.printUsage();
                String errMessage = "\nThe output file name (option -o) must end with the extension \".h5\"\n\n";
                myLogger.error((Object)errMessage);
                throw new IllegalArgumentException(errMessage);
            }
        } else {
            this.printUsage();
            String string = "\nPlease specify the output file name (option -o), using the extension \".h5\"\n\n";
            myLogger.error((Object)string);
            throw new IllegalArgumentException(string);
        }
        if (this.myArgsEngine.getBoolean("-iD")) {
            this.ignoreDepth = true;
        }
    }

    @Override
    public DataSet performFunction(DataSet input) {
        String message = this.mergeHDF5GenoTables();
        if (message != null) {
            this.printUsage();
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            myLogger.error((Object)message);
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new UnsupportedOperationException(message);
        }
        this.fireProgress(100);
        return null;
    }

    public String mergeHDF5GenoTables() {
        IHDF5Reader reader = HDF5Factory.openForReading((String)this.inHD5F5GenoFileNames[0]);
        PositionList firstPosList = PositionListBuilder.getInstance(reader);
        GenotypeTableBuilder mrgGenos = GenotypeTableBuilder.getTaxaIncrementalWithMerging(this.mergedHDF5GenoFileName, firstPosList, new BasicGenotypeMergeRule(0.01));
        for (int i = 0; i < this.inHD5F5GenoFileNames.length; ++i) {
            if (i > 0 && !this.samePositions(firstPosList, PositionListBuilder.getInstance(reader = HDF5Factory.openForReading((String)this.inHD5F5GenoFileNames[i])))) {
                return "Error: " + this.inHD5F5GenoFileNames[i] + " does not contain the same positions as " + this.inHD5F5GenoFileNames[0];
            }
            List<String> taxaNames = HDF5Utils.getAllTaxaNames(reader);
            for (String taxonName : taxaNames) {
                Taxon taxon = HDF5Utils.getTaxon(reader, taxonName);
                byte[] genos = HDF5Utils.getHDF5GenotypesCalls(reader, taxonName);
                byte[][] depth = null;
                if (!this.ignoreDepth) {
                    depth = HDF5Utils.getHDF5GenotypesDepth(reader, taxonName);
                }
                try {
                    mrgGenos.addTaxon(taxon, genos, depth);
                }
                catch (Exception e) {
                    return "Error: " + e;
                }
            }
            System.out.println("...finished adding " + this.inHD5F5GenoFileNames[i] + " to the output file");
        }
        mrgGenos.build();
        System.out.println("\n\nFinished merging genotypes to output file:");
        System.out.println("  " + this.mergedHDF5GenoFileName + "\n\n");
        return null;
    }

    private boolean samePositions(PositionList PosListA, PositionList PosListB) {
        if (PosListA.size() != PosListB.size()) {
            return false;
        }
        for (int j = 0; j < PosListA.size(); ++j) {
            GeneralPosition genPos2;
            GeneralPosition genPos1 = new GeneralPosition.Builder((Position)PosListA.get(j)).build();
            if (((Object)genPos1).equals(genPos2 = new GeneralPosition.Builder((Position)PosListB.get(j)).build())) continue;
            return false;
        }
        return true;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = SeparatePlugin.class.getResource("/net/maizegenetics/analysis/images/Merge.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Merge GenotypeTables";
    }

    @Override
    public String getToolTipText() {
        return "Merge GenotypeTables";
    }
}

