/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.genotypecall.BasicGenotypeMergeRule;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.GeneralAnnotation;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class MergeRenameDeleteTaxaPlugin
extends AbstractPlugin {
    private PluginParameter<String> taxaRenameKey = new PluginParameter.Builder<String>("renameKey", null, String.class).required(true).inFile().guiName("Taxa Rename Key").description("Tab-delimited file with original and new taxa names. Taxa with the same new name will be merged. Taxa with the new name \"delete\" will be removed. Any other columns (and the header line) are ignored.").build();
    private PluginParameter<String> outputHDF5Genotypes = new PluginParameter.Builder<String>("o", null, String.class).guiName("Output HDF Genotypes").required(true).outFile().description("Output HDF5 genotypes file").build();
    private PluginParameter<Double> avgSeqErrorRate = new PluginParameter.Builder<Double>("eR", 0.01, Double.class).guiName("Avg Seq Error Rate").description("Average sequencing error rate per base (used to decide between heterozygous and homozygous calls when merging taxa)").build();
    private PluginParameter<Boolean> noDepthOutput = new PluginParameter.Builder<Boolean>("ndo", false, Boolean.class).guiName("No Depth Output").description("No depth output: do not write depths to the output HDF5 genotypes file").build();
    private PluginParameter<String> dataSetName = new PluginParameter.Builder<String>("name", null, String.class).guiName("Data set name").required(false).description("(Optional) Short data set name to be added as an root level annotation under \"dataSetName\"").build();
    private PluginParameter<String> dataSetDescription = new PluginParameter.Builder<String>("desc", null, String.class).guiName("Data set description").required(false).description("(Optional) Short data set description to be added as an root level annotation under \"dataSetDescription\"").build();
    private static final Logger myLogger = Logger.getLogger(MergeRenameDeleteTaxaPlugin.class);
    String dataSetDescrip;
    String date;
    String errorMessage;
    private GenotypeTable inputGenotypes = null;
    private String inputGenosName = null;
    private TreeMap<String, TreeSet<String>> newNameToOldNames = new TreeMap();
    private BasicGenotypeMergeRule genoMergeRule = null;
    private GenotypeTableBuilder genos = null;
    private TaxaList taxaList = null;

    @Override
    public String pluginDescription() {
        return "Rename taxa, merging those with the same new name in the taxa rename key file. Taxa with the new name \"delete\" will be removed.";
    }

    public MergeRenameDeleteTaxaPlugin() {
        super(null, false);
    }

    public MergeRenameDeleteTaxaPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        if (input == null) {
            throw new IllegalArgumentException("MergeRenameDeleteTaxaPlugin: preProcessParameters: Please select one Genotype Table.");
        }
        List<Datum> genotypeTables = input.getDataOfType(GenotypeTable.class);
        this.inputGenosName = genotypeTables.get(0).getName();
        myLogger.info((Object)("\n" + this.pluginDescription() + "\n"));
        myLogger.info((Object)("Input genotype name: " + this.inputGenosName));
        if (genotypeTables.size() != 1) {
            throw new IllegalArgumentException("MergeRenameDeleteTaxaPlugin: preProcessParameters: Please select one Genotype Table.");
        }
        this.inputGenotypes = (GenotypeTable)genotypeTables.get(0).getData();
        this.taxaList = this.inputGenotypes.taxa();
        this.date = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String outfile = this.outputHDF5Genotypes();
        this.outputHDF5Genotypes(outfile.replace("__DATE__", "_" + this.date));
    }

    @Override
    public DataSet processData(DataSet input) {
        this.readTaxaRenameKey();
        this.setUpHDF5GenotypeTableBuilder();
        int nTaxaAdded = this.addRenamedMergedTaxa();
        if (this.dataSetName() != null) {
            this.genos.dataSetName(this.parseDataSetName(this.dataSetName()));
        }
        if (this.dataSetDescription() != null) {
            this.genos.dataSetDescription(this.parseDataSetDescription(this.dataSetDescription(), nTaxaAdded));
        }
        this.genos.build();
        myLogger.info((Object)"\n\nFinished creating new HDF5 genotpye file with merged and renamed taxa.\n\n");
        return null;
    }

    private void readTaxaRenameKey() {
        myLogger.info((Object)("\nReading the taxaRenameKey file:\n   " + this.taxaRenameKey() + "\n"));
        BufferedReader taxaRenameKeyReader = Utils.getBufferedReader(this.taxaRenameKey());
        int nLinesRead = 0;
        try {
            String line;
            while ((line = taxaRenameKeyReader.readLine()) != null) {
                if (++nLinesRead == 1) continue;
                String[] values = line.split("\t", -1);
                String oldName = values[0];
                String newName = values[1];
                if (!this.newNameToOldNames.containsKey(newName)) {
                    this.newNameToOldNames.put(newName, new TreeSet());
                }
                this.newNameToOldNames.get(newName).add(oldName);
            }
        }
        catch (IOException e) {
            System.err.println("\n\nProblem reading the taxaRenameKey file (" + this.taxaRenameKey() + "):\n\t" + e);
            System.exit(1);
        }
        myLogger.info((Object)("\nFinished reading the taxaRenameKey file (nTaxa=" + (nLinesRead - 1) + ")\n"));
    }

    private void setUpHDF5GenotypeTableBuilder() {
        this.genoMergeRule = new BasicGenotypeMergeRule(this.avgSeqErrorRate());
        File hdf5File = new File(this.outputHDF5Genotypes());
        if (hdf5File.exists()) {
            this.errorMessage = "\nERROR: the output HDF5 genotypes file:\n   " + this.outputHDF5Genotypes() + "\n already exists\n\n";
            myLogger.error((Object)this.errorMessage);
            throw new IllegalStateException(this.errorMessage);
        }
        myLogger.info((Object)("\nInitializing the output HDF5 file:\n   " + this.outputHDF5Genotypes() + "\n\n"));
        this.genos = GenotypeTableBuilder.getTaxaIncrementalWithMerging(this.outputHDF5Genotypes(), this.inputGenotypes.positions(), this.genoMergeRule);
    }

    private int addRenamedMergedTaxa() {
        int nTaxaAdded = 0;
        int nTaxaDeleted = 0;
        for (Map.Entry<String, TreeSet<String>> newNameAndOldNames : this.newNameToOldNames.entrySet()) {
            String newName = newNameAndOldNames.getKey();
            int nTaxaToMergeOrDelete = newNameAndOldNames.getValue().size();
            if (newName.equals("delete") || newName.equals("remove")) {
                nTaxaDeleted += nTaxaToMergeOrDelete;
                continue;
            }
            StringBuilder oldNames = new StringBuilder();
            Taxon.Builder TaxonBuilder = null;
            int[][] alleleDepths = new int[6][this.inputGenotypes.positions().numberOfSites()];
            byte[] taxonGenos = null;
            for (String oldName : newNameAndOldNames.getValue()) {
                oldNames.append(oldName + ",");
                Taxon oldTaxon = (Taxon)this.taxaList.get(this.taxaList.indexOf(oldName));
                if (TaxonBuilder == null) {
                    TaxonBuilder = new Taxon.Builder(oldTaxon);
                    TaxonBuilder = TaxonBuilder.name(newName);
                } else {
                    GeneralAnnotation oldAnnos = oldTaxon.getAnnotation();
                    for (Map.Entry<String, String> oldAnno : oldAnnos.getAllAnnotationEntries()) {
                        TaxonBuilder = TaxonBuilder.addAnno(oldAnno.getKey(), oldAnno.getValue());
                    }
                }
                TaxonBuilder = TaxonBuilder.addAnno("OldName", oldName);
                if (this.inputGenotypes.hasDepth()) {
                    for (int site = 0; site < this.inputGenotypes.positions().numberOfSites(); ++site) {
                        int[] alleleDepthsAtSite = this.inputGenotypes.depthForAlleles(this.taxaList.indexOf(oldName), site);
                        for (int allele = 0; allele < 6; ++allele) {
                            int[] nArray = alleleDepths[allele];
                            int n = site;
                            nArray[n] = nArray[n] + alleleDepthsAtSite[allele];
                        }
                    }
                }
                if (nTaxaToMergeOrDelete != 1) continue;
                taxonGenos = this.inputGenotypes.genotypeAllSites(this.taxaList.indexOf(oldName));
            }
            if (nTaxaToMergeOrDelete > 1) {
                if (this.inputGenotypes.hasDepth()) {
                    taxonGenos = this.resolveGenosForTaxon(alleleDepths);
                } else {
                    throw new IllegalStateException("\n\nERROR: Merging genotypes across replicate taxa is not allowed when there is no depth\n\n");
                }
            }
            if (this.noDepthOutput().booleanValue()) {
                this.genos.addTaxon(TaxonBuilder.build(), taxonGenos, (byte[][])null);
            } else {
                this.genos.addTaxon(TaxonBuilder.build(), alleleDepths, taxonGenos);
            }
            myLogger.info((Object)("  ...finished calling/adding genotypes for " + newName + "   OldName(s):" + oldNames.deleteCharAt(oldNames.length() - 1).toString()));
            ++nTaxaAdded;
        }
        myLogger.info((Object)("\nFinished adding genotypes for " + nTaxaAdded + " taxa.  nTaxaDeleted=" + nTaxaDeleted));
        return nTaxaAdded;
    }

    private byte[] resolveGenosForTaxon(int[][] depthsForTaxon) {
        int nAlleles = depthsForTaxon.length;
        int[] depthsAtSite = new int[nAlleles];
        int nSites = depthsForTaxon[0].length;
        byte[] genos = new byte[nSites];
        for (int site = 0; site < nSites; ++site) {
            for (int allele = 0; allele < nAlleles; ++allele) {
                depthsAtSite[allele] = depthsForTaxon[allele][site];
            }
            genos[site] = this.genoMergeRule.callBasedOnDepth(depthsAtSite);
        }
        return genos;
    }

    private String parseDataSetName(String dataSetName) {
        return dataSetName.replace("__DATE__", "_" + this.date);
    }

    private String parseDataSetDescription(String dataSetDescrip, int nTaxa) {
        int nSNPs = this.inputGenotypes.numberOfSites();
        return dataSetDescrip.replace("__SNPS__", "" + nSNPs).replace("__TAXA__", "" + nTaxa).replace("__DATE__", this.date);
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = MergeRenameDeleteTaxaPlugin.class.getResource("/net/maizegenetics/analysis/images/lowDepthToMissing.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "MergeRenameTaxa";
    }

    @Override
    public String getToolTipText() {
        return "Rename taxa, merging those with the same new name";
    }

    public void runPlugin(GenotypeTable inputGenos) {
        DataSet input = new DataSet(new Datum("inputGenotypes", inputGenos, null), null);
        this.runPlugin(input);
    }

    public void runPlugin(DataSet input) {
        this.performFunction(input);
    }

    public String taxaRenameKey() {
        return this.taxaRenameKey.value();
    }

    public MergeRenameDeleteTaxaPlugin taxaRenameKey(String value) {
        this.taxaRenameKey = new PluginParameter<String>(this.taxaRenameKey, value);
        return this;
    }

    public String outputHDF5Genotypes() {
        return this.outputHDF5Genotypes.value();
    }

    public MergeRenameDeleteTaxaPlugin outputHDF5Genotypes(String value) {
        this.outputHDF5Genotypes = new PluginParameter<String>(this.outputHDF5Genotypes, value);
        return this;
    }

    public Double avgSeqErrorRate() {
        return this.avgSeqErrorRate.value();
    }

    public MergeRenameDeleteTaxaPlugin avgSeqErrorRate(Double value) {
        this.avgSeqErrorRate = new PluginParameter<Double>(this.avgSeqErrorRate, value);
        return this;
    }

    public Boolean noDepthOutput() {
        return this.noDepthOutput.value();
    }

    public MergeRenameDeleteTaxaPlugin noDepthOutput(Boolean value) {
        this.noDepthOutput = new PluginParameter<Boolean>(this.noDepthOutput, value);
        return this;
    }

    public String dataSetName() {
        return this.dataSetName.value();
    }

    public MergeRenameDeleteTaxaPlugin dataSetName(String value) {
        this.dataSetName = new PluginParameter<String>(this.dataSetName, value);
        return this;
    }

    public String dataSetDescription() {
        return this.dataSetDescription.value();
    }

    public MergeRenameDeleteTaxaPlugin dataSetDescription(String value) {
        this.dataSetDescription = new PluginParameter<String>(this.dataSetDescription, value);
        return this;
    }
}

