/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.ImportUtils;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class PlinkLoadPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(PlinkLoadPlugin.class);
    private PluginParameter<String> myPedFile = new PluginParameter.Builder<String>("pedFile", null, String.class).required(true).inFile().description("Ped File").build();
    private PluginParameter<String> myMapFile = new PluginParameter.Builder<String>("mapFile", null, String.class).required(true).inFile().description("Map File").build();
    private PluginParameter<Boolean> mySortPositions = new PluginParameter.Builder<Boolean>("sortPositions", false, Boolean.class).description("Whether to sort genotype positions.").build();

    public PlinkLoadPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        return this.loadFile(this.pedFile(), this.mapFile(), this.sortPositions());
    }

    public GenotypeTable runPlugin(DataSet input) {
        return (GenotypeTable)this.performFunction(input).getData(0).getData();
    }

    public String pedFile() {
        return this.myPedFile.value();
    }

    public PlinkLoadPlugin pedFile(String value) {
        this.myPedFile = new PluginParameter<String>(this.myPedFile, value);
        return this;
    }

    public String mapFile() {
        return this.myMapFile.value();
    }

    public PlinkLoadPlugin mapFile(String value) {
        this.myMapFile = new PluginParameter<String>(this.myMapFile, value);
        return this;
    }

    public Boolean sortPositions() {
        return this.mySortPositions.value();
    }

    public PlinkLoadPlugin sortPositions(Boolean value) {
        this.mySortPositions = new PluginParameter<Boolean>(this.mySortPositions, value);
        return this;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Load Plink";
    }

    @Override
    public String getToolTipText() {
        return "Load Plink Files";
    }

    private DataSet loadFile(String thePedFile, String theMapFile, boolean sortPositions) {
        GenotypeTable result = ImportUtils.readFromPLink(thePedFile, theMapFile, this, sortPositions);
        Datum td = new Datum(Utils.getFilename(thePedFile, ".plk.ped"), result, null);
        DataSet tds = new DataSet(td, (Plugin)this);
        this.fireDataSetReturned(new PluginEvent(tds, PlinkLoadPlugin.class));
        return tds;
    }
}

