/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.association.AssociationUtils;
import net.maizegenetics.analysis.numericaltransform.ImputationPlugin;
import net.maizegenetics.analysis.numericaltransform.NumericalGenotypePlugin;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.genotypecall.ProjectionGenotypeCallTable;
import net.maizegenetics.dna.snp.io.ProjectionGenotypeIO;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.phenotype.NumericAttribute;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.phenotype.PhenotypeBuilder;
import net.maizegenetics.phenotype.TaxaAttribute;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.stats.PCA.PrinComp;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.util.OpenBitSet;
import org.apache.log4j.Logger;

public class ProjectPcsAndRunModelSelectionPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(ProjectPcsAndRunModelSelectionPlugin.class);
    private PluginParameter<String> myRecombinationBreakpoints = new PluginParameter.Builder<String>("recombinationBreakpoints", null, String.class).required(true).inFile().description("").build();
    private GenotypeTable myHighDensityMarkersGenotypeTable = null;
    private GenotypeTable myCharacterAlignment;
    private double minRequiredData = 0.0;

    public ProjectPcsAndRunModelSelectionPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        if (input == null) {
            throw new IllegalArgumentException("ProjectPcsAndRunModelSelectionPlugin: preProcessParameters: Please select one Genotype Table.");
        }
        List<Datum> genotypeTables = input.getDataOfType(GenotypeTable.class);
        if (genotypeTables.size() != 1) {
            throw new IllegalArgumentException("ProjectPcsAndRunModelSelectionPlugin: preProcessParameters: Please select one Genotype Table.");
        }
        this.myHighDensityMarkersGenotypeTable = (GenotypeTable)genotypeTables.get(0).getData();
    }

    @Override
    public DataSet processData(DataSet input) {
        try {
            DataSet dataSet = this.loadFile(this.myRecombinationBreakpoints.value(), this.myHighDensityMarkersGenotypeTable);
            return dataSet;
        }
        catch (Exception e) {
            throw new IllegalStateException("ProjectPcsAndRunModelSelectionPlugin: processData: Problem loading: " + this.myRecombinationBreakpoints.value() + "\n" + e.getMessage());
        }
        finally {
            this.fireProgress(100);
        }
    }

    public GenotypeTable runPlugin(DataSet input) {
        return (GenotypeTable)this.performFunction(input).getData(0).getData();
    }

    public String recombinationBreakpoints() {
        return this.myRecombinationBreakpoints.value();
    }

    public ProjectPcsAndRunModelSelectionPlugin recombinationBreakpoints(String value) {
        this.myRecombinationBreakpoints = new PluginParameter<String>(this.myRecombinationBreakpoints, value);
        return this;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Load Projection Alignment";
    }

    @Override
    public String getToolTipText() {
        return "Load Projection Alignments";
    }

    public DataSet loadFile(String theRecombinationBreakpoints, GenotypeTable theHighDensityMarkers) {
        Datum test = new Datum("Full", theHighDensityMarkers, null);
        DataSet tests = new DataSet(test, (Plugin)this);
        this.fireDataSetReturned(new PluginEvent(tests, ProjectPcsAndRunModelSelectionPlugin.class));
        System.out.println("------------------------Calculating the PCs among the NAM founders--------------");
        Chromosome[] chr = theHighDensityMarkers.chromosomes();
        ArrayList<String> chrVector = new ArrayList<String>();
        ArrayList<Double> posVector = new ArrayList<Double>();
        ArrayList<Double> startPosVector = new ArrayList<Double>();
        ArrayList<Double> endPosVector = new ArrayList<Double>();
        int increment = 10000;
        int[] selectedColumns = new int[]{0, 1, 2, 3, 4};
        DoubleMatrix PCResults = this.calculatePCsAcrossNAMFounders(chr, theHighDensityMarkers, chrVector, posVector, startPosVector, endPosVector, increment, selectedColumns);
        DataSet tdr = this.displayNamPCsOnTASSELGUI(PCResults, chrVector, posVector, startPosVector, endPosVector, theHighDensityMarkers);
        System.out.println("------------------------Done:- Calculating the PCs among the NAM founders--------------");
        System.out.println("------------------------Creating the projection alignment--------------");
        GenotypeTable theAlignmentForGenotype = null;
        try {
            theAlignmentForGenotype = ProjectionGenotypeIO.getInstance(theRecombinationBreakpoints, theHighDensityMarkers);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        System.out.println("------------------------Done:- Creating the projection alignment--------------");
        System.out.println("------------------------Projecting PCs onto the NAM popluation--------------");
        DoubleMatrix ProjectedPCs = this.projectPCsOntoNAMFounders(theAlignmentForGenotype, PCResults, chrVector, posVector, theHighDensityMarkers, chr);
        System.out.println("------------------------Done:- Projecting PCs onto the NAM popluation--------------");
        System.out.println("------------------------Displaying Results on TASSEL GUI--------------");
        DataSet tds = this.displayProjectedPCsOnTASSELGUI(ProjectedPCs, chrVector, posVector, startPosVector, endPosVector, theAlignmentForGenotype);
        System.out.println("------------------------Done: Displaying Results on TASSEL GUI--------------");
        return tds;
    }

    public DoubleMatrix calculatePCsAcrossNAMFounders(Chromosome[] chr, GenotypeTable theGenotypesForCalculatingPCs, ArrayList<String> chrVector, ArrayList<Double> posVector, ArrayList<Double> startPosVector, ArrayList<Double> endPosVector, int increment, int[] selectedColumns) {
        GenotypeTable theGenotypesForCalculatingPCsOneChr = theGenotypesForCalculatingPCs;
        DoubleMatrix PCResults = null;
        int[] chrStartAndStop = new int[2];
        for (int i = 0; i < chr.length; ++i) {
            chrStartAndStop = theGenotypesForCalculatingPCs.firstLastSiteOfChromosome(chr[i]);
            theGenotypesForCalculatingPCsOneChr = FilterGenotypeTable.getInstance(theGenotypesForCalculatingPCs, chrStartAndStop[0], chrStartAndStop[1]);
            int[] positions = theGenotypesForCalculatingPCsOneChr.physicalPositions();
            for (int j = 0; j < positions.length; j += increment) {
                int diffBetweenIncrementAndIndexj = positions.length - j;
                int startPos = positions[j];
                int endPos = diffBetweenIncrementAndIndexj >= increment ? positions[j + increment] : positions[positions.length - 1];
                int myStart = theGenotypesForCalculatingPCsOneChr.siteOfPhysicalPosition(startPos, chr[i]);
                int myEnd = theGenotypesForCalculatingPCsOneChr.siteOfPhysicalPosition(endPos, chr[i]);
                GenotypeTable theGenotypesForCalculatingPCsReduced = theGenotypesForCalculatingPCs;
                theGenotypesForCalculatingPCsReduced = FilterGenotypeTable.getInstance(theGenotypesForCalculatingPCsReduced, myStart, myEnd);
                Datum test1 = new Datum("Reduced", theGenotypesForCalculatingPCsReduced, null);
                DataSet test1s = new DataSet(test1, (Plugin)this);
                NumericalGenotypePlugin NGPConverter = new NumericalGenotypePlugin();
                GenotypeTable theGenotypesForCalculatingPCsReducedPartTwo = NumericalGenotypePlugin.setAlternateMinorAllelesToMinor(theGenotypesForCalculatingPCsReduced);
                ImputationPlugin imputor = new ImputationPlugin(null, false);
                imputor.by_mean(true);
                DataSet genoData = new DataSet(new Datum("name", theGenotypesForCalculatingPCsReducedPartTwo, "no comment"), null);
                DataSet numericalData = imputor.processData(genoData);
                this.myCharacterAlignment = (GenotypeTable)numericalData.getData(0).getData();
                int ntaxa = this.myCharacterAlignment.numberOfTaxa();
                int nsites = this.myCharacterAlignment.numberOfSites();
                DoubleMatrix dataMatrix = DoubleMatrixFactory.DEFAULT.make(ntaxa, nsites);
                for (int t = 0; t < ntaxa; ++t) {
                    for (int s = 0; s < nsites; ++s) {
                        dataMatrix.set(t, s, this.myCharacterAlignment.referenceProbability(t, s));
                    }
                }
                PrinComp myPrinComp = new PrinComp(dataMatrix, PrinComp.PC_TYPE.cov);
                DoubleMatrix myPCs = myPrinComp.getPrincipalComponents();
                PCResults = i == 0 & j == 0 ? myPCs.getSelection(null, selectedColumns) : PCResults.concatenate(myPCs.getSelection(null, selectedColumns), false);
                int posMidPoint = (startPos + endPos) / 2;
                for (int k = 0; k < selectedColumns.length; ++k) {
                    chrVector.add(chr[i].toString());
                    posVector.add(Double.valueOf(posMidPoint));
                    startPosVector.add(Double.valueOf(startPos));
                    endPosVector.add(Double.valueOf(endPos));
                }
            }
        }
        return PCResults;
    }

    public DoubleMatrix projectPCsOntoNAMFounders(GenotypeTable theAlignmentForGenotype, DoubleMatrix PCResults, ArrayList<String> chrVector, ArrayList<Double> posVector, GenotypeTable theGenotypesForCalculatingPCs, Chromosome[] chr) {
        ProjectionGenotypeCallTable pg = (ProjectionGenotypeCallTable)theAlignmentForGenotype.genotypeMatrix();
        DoubleMatrix ProjectedPCs = null;
        for (int midpointPCSite = 0; midpointPCSite < chrVector.size(); ++midpointPCSite) {
            double[] ProjectedPCColumn = new double[pg.numberOfTaxa()];
            DoubleMatrix ProjectedPCColumnAsDoubleMatrix = null;
            int[] leftAndRightFlankingMarkerSite = this.identifySitesOfFlankingMarkers(midpointPCSite, chrVector, posVector, theGenotypesForCalculatingPCs, pg, chr);
            for (int individual = 0; individual < pg.numberOfTaxa(); ++individual) {
                double projectedPCElement;
                int leftFlankingMarkerSite = leftAndRightFlankingMarkerSite[0];
                int rightFlankingMarkerSite = leftAndRightFlankingMarkerSite[1];
                try {
                    int[] theDonorsOnLeftFlank = pg.taxonDonors(individual, leftFlankingMarkerSite);
                    int[] theDonorsOnRightFlank = pg.taxonDonors(individual, rightFlankingMarkerSite);
                    DoubleMatrix SpecificPCColumn = PCResults.column(midpointPCSite);
                    projectedPCElement = 0.25 * SpecificPCColumn.get(theDonorsOnLeftFlank[0], 0) + 0.25 * SpecificPCColumn.get(theDonorsOnLeftFlank[1], 0) + 0.25 * SpecificPCColumn.get(theDonorsOnRightFlank[0], 0) + 0.25 * SpecificPCColumn.get(theDonorsOnRightFlank[1], 0);
                }
                catch (Exception e) {
                    projectedPCElement = Double.NaN;
                }
                ProjectedPCColumn[individual] = projectedPCElement;
            }
            ProjectedPCColumnAsDoubleMatrix = DoubleMatrixFactory.DEFAULT.make(ProjectedPCColumn.length, 1, ProjectedPCColumn);
            ProjectedPCs = midpointPCSite == 0 ? ProjectedPCColumnAsDoubleMatrix : ProjectedPCs.concatenate(ProjectedPCColumnAsDoubleMatrix, false);
        }
        return ProjectedPCs;
    }

    public DataSet displayProjectedPCsOnTASSELGUI(DoubleMatrix ProjectedPCs, ArrayList<String> chrVector, ArrayList<Double> posVector, ArrayList<Double> startPosVector, ArrayList<Double> endPosVector, GenotypeTable theAlignmentForGenotype) {
        TaxaList theTaxa = theAlignmentForGenotype.taxa();
        ArrayList<PhenotypeAttribute> myAttributes = new ArrayList<PhenotypeAttribute>();
        ArrayList<Phenotype.ATTRIBUTE_TYPE> types = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();
        myAttributes.add(new TaxaAttribute(theTaxa));
        types.add(Phenotype.ATTRIBUTE_TYPE.taxa);
        Integer counter = 0;
        int ntaxa = theTaxa.numberOfTaxa();
        for (int i = 0; i < chrVector.size(); ++i) {
            counter = counter + 1;
            if (i > 0 && !posVector.get(i).equals(posVector.get(i - 1))) {
                counter = 1;
            }
            String name = "Chr_" + chrVector.get(i).toString() + "_Start_BP_" + startPosVector.get(i).toString() + "_End_BP_" + endPosVector.get(i).toString() + "_End_BP__PC_" + counter.toString();
            float[] data = AssociationUtils.convertDoubleArrayToFloat(ProjectedPCs.column(i).to1DArray());
            myAttributes.add(new NumericAttribute(name, data, new OpenBitSet(ntaxa)));
            types.add(Phenotype.ATTRIBUTE_TYPE.covariate);
        }
        double[][] ProjectedPCsAsDouble = new double[ProjectedPCs.numberOfRows()][ProjectedPCs.numberOfColumns()];
        for (int i = 0; i < ProjectedPCs.numberOfRows(); ++i) {
            for (int j = 0; j < ProjectedPCs.numberOfColumns(); ++j) {
                ProjectedPCsAsDouble[i][j] = ProjectedPCs.get(i, j);
            }
        }
        String ProjectedPCsReportName = "Projected PCs";
        String ProjectedPCsReportComments = "These are the projected PCs";
        Phenotype ProjectedPCsAsPhenotype = new PhenotypeBuilder().fromAttributeList(myAttributes, types).build().get(0);
        Datum ProjectedPCsDatum = new Datum(ProjectedPCsReportName, ProjectedPCsAsPhenotype, ProjectedPCsReportComments);
        DataSet ProjectedPCsDataSet = new DataSet(ProjectedPCsDatum, (Plugin)this);
        this.fireDataSetReturned(new PluginEvent(ProjectedPCsDataSet, ProjectPcsAndRunModelSelectionPlugin.class));
        return ProjectedPCsDataSet;
    }

    public DataSet displayNamPCsOnTASSELGUI(DoubleMatrix PCResults, ArrayList<String> chrVector, ArrayList<Double> posVector, ArrayList<Double> startPosVector, ArrayList<Double> endPosVector, GenotypeTable theGenotypesForCalculatingPCs) {
        TaxaList theTaxa = theGenotypesForCalculatingPCs.taxa();
        ArrayList<PhenotypeAttribute> myAttributes = new ArrayList<PhenotypeAttribute>();
        ArrayList<Phenotype.ATTRIBUTE_TYPE> types = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();
        myAttributes.add(new TaxaAttribute(theTaxa));
        types.add(Phenotype.ATTRIBUTE_TYPE.taxa);
        Integer counter = 0;
        int ntaxa = theTaxa.numberOfTaxa();
        for (int i = 0; i < chrVector.size(); ++i) {
            counter = counter + 1;
            if (i > 0 && !posVector.get(i).equals(posVector.get(i - 1))) {
                counter = 1;
            }
            String name = "Chr_" + chrVector.get(i).toString() + "_Start_BP_" + startPosVector.get(i).toString() + "_End_BP_" + endPosVector.get(i).toString() + "_PC_" + counter.toString();
            float[] data = AssociationUtils.convertDoubleArrayToFloat(PCResults.column(i).to1DArray());
            myAttributes.add(new NumericAttribute(name, data, new OpenBitSet(ntaxa)));
            types.add(Phenotype.ATTRIBUTE_TYPE.covariate);
        }
        String ProjectedPCsReportName = "PCs among NAM Founders";
        String ProjectedPCsReportComments = "PCs among NAM Founders";
        Phenotype ProjectedPCsAsPhenotype = new PhenotypeBuilder().fromAttributeList(myAttributes, types).build().get(0);
        Datum ProjectedPCsDatum = new Datum(ProjectedPCsReportName, ProjectedPCsAsPhenotype, ProjectedPCsReportComments);
        DataSet ProjectedPCsDataSet = new DataSet(ProjectedPCsDatum, (Plugin)this);
        this.fireDataSetReturned(new PluginEvent(ProjectedPCsDataSet, ProjectPcsAndRunModelSelectionPlugin.class));
        return ProjectedPCsDataSet;
    }

    public int[] identifySitesOfFlankingMarkers(int site, ArrayList<String> chrVector, ArrayList<Double> posVector, GenotypeTable theGenotypesForCalculatingPCs, ProjectionGenotypeCallTable pg, Chromosome[] chr) {
        Chromosome testedChromosome = new Chromosome(chrVector.get(site));
        int[] chrStartAndStop = theGenotypesForCalculatingPCs.firstLastSiteOfChromosome(testedChromosome);
        GenotypeTable theGenotypesForCalculatingPCsOneChr = theGenotypesForCalculatingPCs;
        theGenotypesForCalculatingPCsOneChr = FilterGenotypeTable.getInstance(theGenotypesForCalculatingPCsOneChr, chrStartAndStop[0], chrStartAndStop[1]);
        int leftFlankingMarkerSite = 0;
        int rightFlankingMarkerSite = 0;
        ArrayList<Double> distanceFromMidpointOfInterval = new ArrayList<Double>();
        ArrayList<Double> positiveDistanceFromMidpointOfInterval = new ArrayList<Double>();
        ArrayList<Double> negativeDistanceFromMidpointOfInterval = new ArrayList<Double>();
        for (int j = 0; j < theGenotypesForCalculatingPCsOneChr.numberOfSites(); ++j) {
            Double testPosition = posVector.get(site);
            double distance = (double)theGenotypesForCalculatingPCsOneChr.chromosomalPosition(j) - testPosition;
            distanceFromMidpointOfInterval.add(distance);
            if (distance > 0.0) {
                positiveDistanceFromMidpointOfInterval.add(distance);
            }
            if (!(distance < 0.0)) continue;
            negativeDistanceFromMidpointOfInterval.add(distance);
        }
        double distanceToRightMarker = Double.MAX_VALUE;
        if (positiveDistanceFromMidpointOfInterval.size() > 0) {
            for (int j = 0; j < positiveDistanceFromMidpointOfInterval.size(); ++j) {
                double positiveDistanceArrayElement = (Double)positiveDistanceFromMidpointOfInterval.get(j);
                if (!(positiveDistanceArrayElement < distanceToRightMarker)) continue;
                distanceToRightMarker = positiveDistanceArrayElement;
            }
        } else {
            distanceToRightMarker = 0.0;
        }
        double distanceToLeftMarker = Double.MAX_VALUE;
        if (negativeDistanceFromMidpointOfInterval.size() > 0) {
            for (int j = 0; j < negativeDistanceFromMidpointOfInterval.size(); ++j) {
                double negativeDistanceArrayElement = (Double)negativeDistanceFromMidpointOfInterval.get(j);
                if (!((negativeDistanceArrayElement = -1.0 * negativeDistanceArrayElement) < distanceToLeftMarker)) continue;
                distanceToLeftMarker = negativeDistanceArrayElement;
            }
            distanceToLeftMarker = -1.0 * distanceToLeftMarker;
        } else {
            distanceToLeftMarker = 0.0;
        }
        if (distanceToRightMarker != 0.0) {
            rightFlankingMarkerSite = distanceFromMidpointOfInterval.indexOf(distanceToRightMarker);
        }
        if (distanceToLeftMarker != 0.0) {
            leftFlankingMarkerSite = distanceFromMidpointOfInterval.indexOf(distanceToLeftMarker);
        }
        int[] leftAndRightFlankingMarkerSiteAndChrStartAndStop = new int[]{leftFlankingMarkerSite + chrStartAndStop[0], rightFlankingMarkerSite + chrStartAndStop[0]};
        return leftAndRightFlankingMarkerSiteAndChrStartAndStop;
    }
}

