/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.data.GenosToABHPlugin;
import net.maizegenetics.analysis.data.HetsToUnknownPlugin;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.snp.ExportUtils;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.PluginParameter;
import org.apache.log4j.Logger;

public class ThinSitesByPositionPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(GenosToABHPlugin.class);
    private PluginParameter<String> outfile = new PluginParameter.Builder<String>("o", null, String.class).required(true).outFile().guiName("Output file").description("Output genotype file").build();
    private PluginParameter<Integer> minDist = new PluginParameter.Builder<Integer>("minDist", null, Integer.class).required(true).guiName("Minimum distance").description("Minimum distance in bp between adjacent sites").build();
    private GenotypeTable myInput = null;

    public ThinSitesByPositionPlugin() {
        super(null, false);
    }

    public ThinSitesByPositionPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        if (input == null) {
            throw new IllegalArgumentException("GenosToABHPlugin: preProcessParameters: Please select one Genotype Table.");
        }
        List<Datum> genotypeTables = input.getDataOfType(GenotypeTable.class);
        if (genotypeTables.size() != 1) {
            throw new IllegalArgumentException("GenosToABHPlugin: preProcessParameters: Please select one Genotype Table.");
        }
        this.myInput = (GenotypeTable)genotypeTables.get(0).getData();
    }

    @Override
    public DataSet processData(DataSet input) {
        String[] sitesToKeep = this.findSiteNamesToKeep(this.myInput);
        GenotypeTable filteredGenos = null;
        if (sitesToKeep != null && sitesToKeep.length != 0) {
            filteredGenos = FilterGenotypeTable.getInstance(this.myInput, sitesToKeep);
            this.writeOutputGenos(filteredGenos);
        } else {
            myLogger.warn((Object)"WARNING - no sites kept, no output file written !!");
        }
        return null;
    }

    private String[] findSiteNamesToKeep(GenotypeTable genos) {
        ArrayList<String> sitesToKeep = new ArrayList<String>();
        PositionList positions = genos.positions();
        Chromosome chrom = new Chromosome("-1");
        int prevPos = -1;
        for (Position currPos : positions) {
            if (!currPos.getChromosome().equals(chrom)) {
                sitesToKeep.add(currPos.getSNPID());
                chrom = currPos.getChromosome();
                prevPos = currPos.getPosition();
                continue;
            }
            if (currPos.getPosition() - prevPos < this.minDist()) continue;
            sitesToKeep.add(currPos.getSNPID());
            prevPos = currPos.getPosition();
        }
        myLogger.info((Object)("ThinSitesByPosition: original number of sites: " + positions.size() + " number of sites kept: " + sitesToKeep.size()));
        String[] stringArray = sitesToKeep.toArray(new String[sitesToKeep.size()]);
        return stringArray;
    }

    private void writeOutputGenos(GenotypeTable genos) {
        String fileName = this.outFile();
        if (fileName.endsWith(".h5")) {
            ExportUtils.writeGenotypeHDF5(genos, fileName, true);
        } else if (fileName.endsWith("hmp.txt.gz") || fileName.endsWith("hmp.txt")) {
            ExportUtils.writeToHapmap(genos, fileName);
        } else if (fileName.endsWith(".vcf") || fileName.endsWith(".vcf.gz")) {
            ExportUtils.writeToVCF(genos, fileName, true);
        } else {
            fileName = fileName + ".hmp.txt";
            myLogger.warn((Object)("File extension not recognized, writing to hapmap file:\n    " + fileName));
            ExportUtils.writeToHapmap(genos, fileName);
        }
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = HetsToUnknownPlugin.class.getResource("/net/maizegenetics/analysis/images/homozygous.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Thin Sites by Position";
    }

    @Override
    public String getToolTipText() {
        return "This sites based on their physical position on the chromosome";
    }

    public String outFile() {
        return this.outfile.value();
    }

    public ThinSitesByPositionPlugin outfile(String value) {
        this.outfile = new PluginParameter<String>(this.outfile, value);
        return this;
    }

    public Integer minDist() {
        return this.minDist.value();
    }

    public ThinSitesByPositionPlugin minDist(Integer value) {
        this.minDist = new PluginParameter<Integer>(this.minDist, value);
        return this;
    }

    @Override
    public String getCitation() {
        return "Stefan Reuscher, Jeff Glaubitz, Lynn Johnson (2015) First Annual TASSEL Hackathon";
    }

    public GenotypeTable runPlugin(DataSet input) {
        return (GenotypeTable)this.performFunction(input).getData(0).getData();
    }
}

