/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.distance;

import java.awt.Frame;
import java.io.BufferedReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.util.Utils;

public class AMatrixPlugin
extends AbstractPlugin {
    private PluginParameter<String> myPedFilename = new PluginParameter.Builder<String>("pedigreeFilename", null, String.class).description("Pedigree Filename").required(true).inFile().build();
    private double[][] myAMatrix;
    private HashMap<Integer, Progeny> myProgeny;
    protected List<String> myProgenyIDs;

    public AMatrixPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public String pluginDescription() {
        return "Create Pedigree Matrix";
    }

    @Override
    public DataSet processData(DataSet input) {
        double[][] result = this.pedMatrix(AMatrixPlugin.plinkToPed(this.pedFilename()));
        TaxaListBuilder builder = new TaxaListBuilder();
        for (String current : this.myProgenyIDs) {
            builder.add(new Taxon(current));
        }
        DistanceMatrix matrix = new DistanceMatrix(result, builder.build());
        return new DataSet(new Datum("Pedigree Matrix for " + Utils.getFilename(this.pedFilename()), matrix, null), (Plugin)this);
    }

    public static String[][] plinkToPed(String ped) {
        try {
            ArrayList<String[]> rows = new ArrayList<String[]>();
            BufferedReader br = Utils.getBufferedReader(ped);
            while (br.ready()) {
                String line = br.readLine();
                String[] fields = line.split("\\s+");
                if (fields.length <= 3) continue;
                String progenyID = fields[1];
                String parent1ID = fields[2];
                String parent2ID = fields[3];
                String[] resultRow = new String[]{progenyID, parent1ID, parent2ID};
                rows.add(resultRow);
            }
            String[][] result = new String[rows.size()][3];
            for (int i = 0; i < rows.size(); ++i) {
                result[i] = (String[])rows.get(i);
            }
            return result;
        }
        catch (Exception e) {
            throw new IllegalStateException("plinkToPed: problem reading file: " + ped);
        }
    }

    public double[][] pedMatrix(String[][] pedigree) {
        int i;
        this.myProgenyIDs = this.getNameList(pedigree);
        this.myProgeny = new HashMap();
        for (String[] p : pedigree) {
            int progenyID = this.myProgenyIDs.indexOf(p[0]);
            this.myProgeny.put(progenyID, new Progeny(progenyID, this.myProgenyIDs.indexOf(p[1]), this.myProgenyIDs.indexOf(p[2])));
        }
        for (int i2 = 0; i2 < this.myProgenyIDs.size(); ++i2) {
            if (this.myProgeny.containsKey(i2)) continue;
            this.myProgeny.put(i2, new Progeny(i2, -1, -1));
        }
        int size = this.myProgenyIDs.size();
        this.myAMatrix = new double[size][size];
        for (i = 0; i < size; ++i) {
            Arrays.fill(this.myAMatrix[i], Double.NaN);
        }
        for (i = 0; i < size; ++i) {
            for (int j = i; j < size; ++j) {
                this.calcMatrix(i, j);
            }
        }
        return this.myAMatrix;
    }

    public List<String> getNameList(String[][] pedigree) {
        HashSet<String> progenySet = new HashSet<String>();
        for (String[] p : pedigree) {
            progenySet.add(p[0]);
            progenySet.add(p[1]);
            progenySet.add(p[2]);
        }
        progenySet.remove("0");
        return new ArrayList<String>(progenySet);
    }

    private double calcMatrix(int x, int y) {
        double result;
        if (x == -1 || y == -1) {
            return 0.0;
        }
        if (!Double.isNaN(this.myAMatrix[x][y])) {
            return this.myAMatrix[x][y];
        }
        Progeny X = this.myProgeny.get(x);
        Progeny Y = this.myProgeny.get(y);
        if (x == y) {
            result = 1.0 + this.calcMatrix(X.parent1, X.parent2) / 2.0;
        } else {
            double result2;
            double result1;
            int F1 = X.parent1;
            int F2 = Y.parent1;
            int M1 = X.parent2;
            int M2 = Y.parent2;
            result = F1 == -1 || M1 == -1 ? (this.calcMatrix(x, M2) + this.calcMatrix(F2, x)) / 2.0 : (F2 == -1 || M2 == -1 ? (this.calcMatrix(F1, y) + this.calcMatrix(M1, y)) / 2.0 : ((result1 = (this.calcMatrix(x, M2) + this.calcMatrix(F2, x)) / 2.0) > (result2 = (this.calcMatrix(F1, y) + this.calcMatrix(M1, y)) / 2.0) ? result1 : result2));
        }
        this.myAMatrix[x][y] = result;
        this.myAMatrix[y][x] = result;
        return result;
    }

    public String pedFilename() {
        return this.myPedFilename.value();
    }

    public AMatrixPlugin pedFilename(String value) {
        this.myPedFilename = new PluginParameter<String>(this.myPedFilename, value);
        return this;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = AMatrixPlugin.class.getResource("/net/maizegenetics/analysis/images/amatrix.png");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Pedigree Relationship Matrix";
    }

    @Override
    public String getToolTipText() {
        return "Create Pedigree Relationship Matrix";
    }

    @Override
    public String getCitation() {
        return "Lamos-Sweeney J, Nti-Addae Y, Robbins K, Casstevens T. (Oct. 2015) Second Tassel Hackathon.";
    }

    private class Progeny {
        public int progeny;
        public int parent1;
        public int parent2;

        public Progeny(int progeny, int parent1, int parent2) {
            this.progeny = progeny;
            this.parent1 = parent1;
            this.parent2 = parent2;
        }
    }
}

