/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.distance;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.distance.IBSDistanceMatrix3Alleles;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.util.ProgressListener;
import org.apache.log4j.Logger;

public class DistanceMatrixPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(DistanceMatrixPlugin.class);

    public DistanceMatrixPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        List<Datum> alignInList = input.getDataOfType(GenotypeTable.class);
        if (alignInList.size() < 1) {
            throw new IllegalArgumentException("DistanceMatrixPlugin: performFunction: Please select a genotype table.");
        }
        ArrayList<DataSet> result = new ArrayList<DataSet>();
        for (Datum current : alignInList) {
            GenotypeTable aa = (GenotypeTable)current.getData();
            DistanceMatrix adm = DistanceMatrixPlugin.getDistanceMatrix(aa, this);
            DataSet tds = new DataSet(new Datum("Matrix:" + current.getName(), adm, "Distance Matrix"), (Plugin)this);
            result.add(tds);
        }
        return DataSet.getDataSet(result, this);
    }

    public static DistanceMatrix getDistanceMatrix(GenotypeTable alignment) {
        return IBSDistanceMatrix3Alleles.getInstance(alignment);
    }

    public static DistanceMatrix getDistanceMatrix(GenotypeTable alignment, ProgressListener listener) {
        return IBSDistanceMatrix3Alleles.getInstance(alignment, listener);
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = DistanceMatrixPlugin.class.getResource("/net/maizegenetics/analysis/images/DistanceMatrix.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Distance Matrix";
    }

    @Override
    public String getToolTipText() {
        return "Create a distance matrix";
    }
}

