/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.distance;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.analysis.distance.IBSDistanceMatrix;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.util.SimpleTableReport;
import org.apache.log4j.Logger;

public class DistanceMatrixRangesPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(DistanceMatrixRangesPlugin.class);
    private int[] myPhysicalPositions = null;
    private String myLocus = null;
    private String myTaxon = null;

    public DistanceMatrixRangesPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            List<Datum> alignInList = input.getDataOfType(GenotypeTable.class);
            if (alignInList.size() < 1) {
                String message = "Invalid selection.  Please select sequence alignment.";
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), message);
                } else {
                    myLogger.error((Object)message);
                }
                DataSet dataSet = null;
                return dataSet;
            }
            ArrayList<DataSet> result = new ArrayList<DataSet>();
            for (Datum current : alignInList) {
                DataSet tds = this.processDatum(current);
                result.add(tds);
                if (tds == null) continue;
                this.fireDataSetReturned(new PluginEvent(tds, DistanceMatrixRangesPlugin.class));
            }
            DataSet dataSet = DataSet.getDataSet(result, this);
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    public DataSet processDatum(Datum input) {
        GenotypeTable aa = (GenotypeTable)input.getData();
        int numTaxa = aa.numberOfTaxa();
        int interestedTaxa = aa.taxa().indexOf(this.myTaxon);
        Object[][] theData = new Object[numTaxa][this.myPhysicalPositions.length];
        for (int t = 0; t < numTaxa; ++t) {
            theData[t][0] = aa.taxaName(t);
        }
        Object[] columnNames = new String[this.myPhysicalPositions.length];
        columnNames[0] = "Taxa";
        int n = this.myPhysicalPositions.length;
        for (int i = 1; i < n; ++i) {
            int t;
            GenotypeTable alignment = FilterGenotypeTable.getInstance(aa, this.myLocus, this.myPhysicalPositions[i - 1], this.myPhysicalPositions[i]);
            columnNames[i] = String.valueOf(this.myPhysicalPositions[i - 1] + "-" + String.valueOf(this.myPhysicalPositions[i]));
            if (alignment == null) {
                for (t = 0; t < numTaxa; ++t) {
                    theData[t][i] = Double.NaN;
                }
                continue;
            }
            for (t = 0; t < numTaxa; ++t) {
                theData[t][i] = IBSDistanceMatrix.computeHetBitDistances(alignment, interestedTaxa, t)[0];
            }
        }
        SimpleTableReport result = new SimpleTableReport("Distance Matrix Ranges", columnNames, theData);
        return new DataSet(new Datum("MatrixRanges:" + input.getName(), result, "Distance Matrix Ranges"), (Plugin)this);
    }

    public void setPhysicalPositions(String[] positions) {
        int[] result = new int[positions.length];
        for (int i = 0; i < positions.length; ++i) {
            result[i] = Integer.valueOf(positions[i]);
        }
        this.setPhysicalPositions(result);
    }

    public void setPhysicalPositions(int[] positions) {
        this.myPhysicalPositions = positions;
    }

    public int[] getPhysicalPositions() {
        return this.myPhysicalPositions;
    }

    public void setLocus(String locus) {
        this.myLocus = locus;
    }

    public String getLocus() {
        return this.myLocus;
    }

    public void setTaxon(String taxon) {
        this.myTaxon = taxon;
    }

    public String getTaxon() {
        return this.myTaxon;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Distance Matrix";
    }

    @Override
    public String getToolTipText() {
        return "Create a distance matrix";
    }
}

