/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.distance;

import java.util.Arrays;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.maizegenetics.analysis.distance.KinshipPlugin;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.genotypecall.AlleleFreqCache;
import net.maizegenetics.prefs.TasselPrefs;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.taxa.distance.DistanceMatrixBuilder;
import net.maizegenetics.util.GeneralAnnotationStorage;
import net.maizegenetics.util.ProgressListener;
import net.maizegenetics.util.Tuple;
import org.apache.log4j.Logger;

public class DominanceNormalizedIBSMatrix {
    private static final Logger myLogger;
    private static final byte[] PRECALCULATED_COUNTS;
    private static final byte[] INCREMENT;
    private static final int NUM_CORES_TO_USE;
    private static int myNumSitesProcessed;

    private DominanceNormalizedIBSMatrix() {
    }

    public static DistanceMatrix getInstance(GenotypeTable genotype) {
        return DominanceNormalizedIBSMatrix.getInstance(genotype, null);
    }

    public static DistanceMatrix getInstance(GenotypeTable genotype, ProgressListener listener) {
        return DominanceNormalizedIBSMatrix.computeDominanceNormalizedIBSMatrix(genotype, listener);
    }

    private static DistanceMatrix computeDominanceNormalizedIBSMatrix(GenotypeTable genotype, ProgressListener listener) {
        int numTaxa = genotype.numberOfTaxa();
        long time = System.currentTimeMillis();
        Optional<CountersDistances> optional = DominanceNormalizedIBSMatrix.stream(genotype, listener).reduce((t, u) -> {
            t.addAll((CountersDistances)u);
            return t;
        });
        if (!optional.isPresent()) {
            return null;
        }
        CountersDistances counters = optional.get();
        int[] counts = counters.myCounters;
        float[] distances = counters.myDistances;
        GeneralAnnotationStorage.Builder annotations = GeneralAnnotationStorage.getBuilder();
        annotations.addAnnotation("Matrix_Type", KinshipPlugin.KINSHIP_METHOD.Dominance_Normalized_IBS.toString());
        DistanceMatrixBuilder builder = DistanceMatrixBuilder.getInstance(genotype.taxa());
        builder.annotation(annotations.build());
        int index = 0;
        for (int t2 = 0; t2 < numTaxa; ++t2) {
            int n = numTaxa - t2;
            for (int i = 0; i < n; ++i) {
                builder.set(t2, t2 + i, (double)distances[index] / (double)counts[index]);
                builder.setCount(t2, i, counts[index]);
                ++index;
            }
        }
        myLogger.info((Object)("DominanceNormalizedIBSMatrix: computeDominanceNormalizedIBSMatrix time: " + (System.currentTimeMillis() - time) / 1000L + " seconds"));
        return builder.build();
    }

    protected static void fireProgress(int percent, ProgressListener listener) {
        if (listener != null) {
            if (percent > 100) {
                percent = 100;
            }
            listener.progress(percent, null);
        }
    }

    private static Stream<CountersDistances> stream(GenotypeTable genotypes, ProgressListener listener) {
        myNumSitesProcessed = 0;
        return StreamSupport.stream(new DominanceNormalizedIBSSiteSpliterator(genotypes, 0, genotypes.numberOfSites(), listener), true);
    }

    static {
        int b;
        myLogger = Logger.getLogger(DominanceNormalizedIBSMatrix.class);
        PRECALCULATED_COUNTS = new byte[512];
        for (int major = 0; major < 8; ++major) {
            for (int a = 0; a < 8; ++a) {
                for (b = 0; b < 8; ++b) {
                    int temp = major << 6 | a << 3 | b;
                    if (major == 7 || a == 7 && b == 7) {
                        DominanceNormalizedIBSMatrix.PRECALCULATED_COUNTS[temp] = 7;
                        continue;
                    }
                    if (a == major) {
                        if (b == major) {
                            DominanceNormalizedIBSMatrix.PRECALCULATED_COUNTS[temp] = 4;
                            continue;
                        }
                        DominanceNormalizedIBSMatrix.PRECALCULATED_COUNTS[temp] = 2;
                        continue;
                    }
                    DominanceNormalizedIBSMatrix.PRECALCULATED_COUNTS[temp] = b == major ? 2 : 4;
                }
            }
        }
        INCREMENT = new byte[32768];
        for (int a = 1; a < 8; ++a) {
            int temp = a << 12;
            for (b = 1; b < 8; ++b) {
                int temp2 = b << 9;
                for (int c = 1; c < 8; ++c) {
                    int temp3 = c << 6;
                    for (int d = 1; d < 8; ++d) {
                        int temp4 = d << 3;
                        for (int e = 1; e < 8; ++e) {
                            int incrementIndex = temp | temp2 | temp3 | temp4 | e;
                            if (a != 7) {
                                int n = incrementIndex;
                                INCREMENT[n] = (byte)(INCREMENT[n] + 1);
                            }
                            if (b != 7) {
                                int n = incrementIndex;
                                INCREMENT[n] = (byte)(INCREMENT[n] + 1);
                            }
                            if (c != 7) {
                                int n = incrementIndex;
                                INCREMENT[n] = (byte)(INCREMENT[n] + 1);
                            }
                            if (d != 7) {
                                int n = incrementIndex;
                                INCREMENT[n] = (byte)(INCREMENT[n] + 1);
                            }
                            if (e == 7) continue;
                            int n = incrementIndex;
                            INCREMENT[n] = (byte)(INCREMENT[n] + 1);
                        }
                    }
                }
            }
        }
        NUM_CORES_TO_USE = TasselPrefs.getMaxThreads();
        myNumSitesProcessed = 0;
    }

    static class DominanceNormalizedIBSSiteSpliterator
    implements Spliterator<CountersDistances> {
        private int myCurrentSite;
        private final int myFence;
        private final GenotypeTable myGenotypes;
        private final int myNumTaxa;
        private final int myNumSites;
        private final ProgressListener myProgressListener;
        private final int myMinSitesToProcess;
        private final int myNumSitesPerBlockForProgressReporting;
        private static final int NUM_SITES_PER_BLOCK = 5;

        DominanceNormalizedIBSSiteSpliterator(GenotypeTable genotypes, int currentIndex, int fence, ProgressListener listener) {
            this.myGenotypes = genotypes;
            this.myNumTaxa = this.myGenotypes.numberOfTaxa();
            this.myNumSites = this.myGenotypes.numberOfSites();
            this.myCurrentSite = currentIndex;
            this.myFence = fence;
            this.myProgressListener = listener;
            this.myMinSitesToProcess = Math.max(this.myNumSites / NUM_CORES_TO_USE, 1000);
            this.myNumSitesPerBlockForProgressReporting = (this.myFence - this.myCurrentSite) / 10;
        }

        @Override
        public void forEachRemaining(Consumer<? super CountersDistances> action) {
            CountersDistances result = new CountersDistances(this.myNumTaxa);
            int[] counts = result.myCounters;
            float[] distances = result.myDistances;
            float[] answer1 = new float[32768];
            float[] answer2 = new float[32768];
            float[] answer3 = new float[32768];
            while (this.myCurrentSite < this.myFence) {
                int currentBlockFence = Math.min(this.myCurrentSite + this.myNumSitesPerBlockForProgressReporting, this.myFence);
                int numSitesProcessed = currentBlockFence - this.myCurrentSite;
                while (this.myCurrentSite < currentBlockFence) {
                    int[] numSites = new int[1];
                    Tuple<short[], float[]> firstBlock = this.getBlockOfSites(this.myCurrentSite, numSites);
                    float[] possibleTerms = (float[])firstBlock.y;
                    short[] genotypeClass1 = (short[])firstBlock.x;
                    Tuple<short[], float[]> secondBlock = this.getBlockOfSites(this.myCurrentSite + numSites[0], numSites);
                    float[] possibleTerms2 = (float[])secondBlock.y;
                    short[] genotypeClass2 = (short[])secondBlock.x;
                    Tuple<short[], float[]> thirdBlock = this.getBlockOfSites(this.myCurrentSite + numSites[0], numSites);
                    float[] possibleTerms3 = (float[])thirdBlock.y;
                    short[] genotypeClass3 = (short[])thirdBlock.x;
                    this.myCurrentSite += numSites[0];
                    for (int i = 0; i < 32768; ++i) {
                        answer1[i] = possibleTerms[(i & 0x7000) >>> 12] + possibleTerms[(i & 0xE00) >>> 9 | 8] + possibleTerms[(i & 0x1C0) >>> 6 | 0x10] + possibleTerms[(i & 0x38) >>> 3 | 0x18] + possibleTerms[i & 7 | 0x20];
                        answer2[i] = possibleTerms2[(i & 0x7000) >>> 12] + possibleTerms2[(i & 0xE00) >>> 9 | 8] + possibleTerms2[(i & 0x1C0) >>> 6 | 0x10] + possibleTerms2[(i & 0x38) >>> 3 | 0x18] + possibleTerms2[i & 7 | 0x20];
                        answer3[i] = possibleTerms3[(i & 0x7000) >>> 12] + possibleTerms3[(i & 0xE00) >>> 9 | 8] + possibleTerms3[(i & 0x1C0) >>> 6 | 0x10] + possibleTerms3[(i & 0x38) >>> 3 | 0x18] + possibleTerms3[i & 7 | 0x20];
                    }
                    int index = 0;
                    for (int firstTaxa = 0; firstTaxa < this.myNumTaxa; ++firstTaxa) {
                        if (genotypeClass1[firstTaxa] != Short.MAX_VALUE || genotypeClass2[firstTaxa] != Short.MAX_VALUE || genotypeClass3[firstTaxa] != Short.MAX_VALUE) {
                            for (int secondTaxa = firstTaxa; secondTaxa < this.myNumTaxa; ++secondTaxa) {
                                int n = index;
                                distances[n] = distances[n] + (answer1[genotypeClass1[firstTaxa] | genotypeClass1[secondTaxa]] + answer2[genotypeClass2[firstTaxa] | genotypeClass2[secondTaxa]] + answer3[genotypeClass3[firstTaxa] | genotypeClass3[secondTaxa]]);
                                int n2 = index++;
                                counts[n2] = counts[n2] + (INCREMENT[genotypeClass1[firstTaxa] | genotypeClass1[secondTaxa]] + INCREMENT[genotypeClass2[firstTaxa] | genotypeClass2[secondTaxa]] + INCREMENT[genotypeClass3[firstTaxa] | genotypeClass3[secondTaxa]]);
                            }
                            continue;
                        }
                        index += this.myNumTaxa - firstTaxa;
                    }
                }
                myNumSitesProcessed = myNumSitesProcessed + numSitesProcessed;
                DominanceNormalizedIBSMatrix.fireProgress((int)((double)myNumSitesProcessed / (double)this.myNumSites * 100.0), this.myProgressListener);
            }
            action.accept(result);
        }

        private Tuple<short[], float[]> getBlockOfSites(int currentSite, int[] numSites) {
            int currentSiteNum = 0;
            float[] possibleTerms = new float[40];
            short[] genotypeClasses = new short[this.myNumTaxa];
            Arrays.fill(genotypeClasses, (short)Short.MAX_VALUE);
            while (currentSiteNum < 5 && currentSite < this.myFence) {
                byte[] genotypes = this.myGenotypes.genotypeAllTaxa(currentSite);
                int[][] alleleCounts = AlleleFreqCache.allelesSortedByFrequencyNucleotide(genotypes);
                byte major = AlleleFreqCache.majorAllele(alleleCounts);
                float minorFreq = 1.0f - (float)AlleleFreqCache.majorAlleleFrequency(alleleCounts);
                float majorFreqSqrTimes2 = minorFreq * minorFreq * 2.0f;
                float denominatorTerm = minorFreq * minorFreq * 4.0f * (1.0f - minorFreq) * (1.0f - minorFreq);
                if (major != 15 && (double)denominatorTerm != 0.0) {
                    float hetTerm = 1.0f - majorFreqSqrTimes2;
                    float homoTerm = 0.0f - majorFreqSqrTimes2;
                    int siteNumIncrement = currentSiteNum * 8;
                    possibleTerms[siteNumIncrement + 2] = hetTerm * hetTerm / denominatorTerm;
                    possibleTerms[siteNumIncrement + 4] = homoTerm * homoTerm / denominatorTerm;
                    possibleTerms[siteNumIncrement + 6] = hetTerm * homoTerm / denominatorTerm;
                    int temp = (major & 7) << 6;
                    int shift = (5 - currentSiteNum - 1) * 3;
                    int mask = ~(7 << shift) & Short.MAX_VALUE;
                    for (int i = 0; i < this.myNumTaxa; ++i) {
                        genotypeClasses[i] = (short)(genotypeClasses[i] & (mask | PRECALCULATED_COUNTS[temp | (genotypes[i] & 0x70) >>> 1 | genotypes[i] & 7] << shift));
                    }
                    ++currentSiteNum;
                }
                ++currentSite;
                numSites[0] = numSites[0] + 1;
            }
            return new Tuple<short[], float[]>(genotypeClasses, possibleTerms);
        }

        @Override
        public boolean tryAdvance(Consumer<? super CountersDistances> action) {
            if (this.myCurrentSite < this.myFence) {
                this.forEachRemaining(action);
                return true;
            }
            return false;
        }

        @Override
        public Spliterator<CountersDistances> trySplit() {
            int lo = this.myCurrentSite;
            int mid = lo + this.myMinSitesToProcess;
            if (mid < this.myFence) {
                this.myCurrentSite = mid;
                return new DominanceNormalizedIBSSiteSpliterator(this.myGenotypes, lo, mid, this.myProgressListener);
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return this.myFence - this.myCurrentSite;
        }

        @Override
        public int characteristics() {
            return 1024;
        }
    }

    private static class CountersDistances {
        private final int[] myCounters;
        private final float[] myDistances;
        private final int myNumTaxa;

        public CountersDistances(int numTaxa) {
            this.myNumTaxa = numTaxa;
            this.myCounters = new int[this.myNumTaxa * (this.myNumTaxa + 1) / 2];
            this.myDistances = new float[this.myNumTaxa * (this.myNumTaxa + 1) / 2];
        }

        public void addAll(CountersDistances counters) {
            float[] otherDistances = counters.myDistances;
            int n = this.myCounters.length;
            for (int t = 0; t < n; ++t) {
                int n2 = t;
                this.myDistances[n2] = this.myDistances[n2] + otherDistances[t];
            }
            otherDistances = null;
            int[] otherCounters = counters.myCounters;
            int n3 = this.myCounters.length;
            for (int t = 0; t < n3; ++t) {
                int n4 = t;
                this.myCounters[n4] = this.myCounters[n4] + otherCounters[t];
            }
        }
    }
}

