/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.distance;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.matrixalgebra.decomposition.EigenvalueDecomposition;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.taxa.distance.DistanceMatrix;

public class HMatrixPlugin
extends AbstractPlugin {
    private PluginParameter<DistanceMatrix> myAMatrix = new PluginParameter.Builder<DistanceMatrix>("pedigreeMatrix", null, DistanceMatrix.class).description("Pedigree Matrix (A Matrix)").required(true).distanceMatrix().build();
    private PluginParameter<DistanceMatrix> myGMatrix = new PluginParameter.Builder<DistanceMatrix>("kinshipMatrix", null, DistanceMatrix.class).description("Kinship Matrix (G Matrix)").required(true).distanceMatrix().build();
    private PluginParameter<Double> myWeight = new PluginParameter.Builder<Double>("weight", 1.0, Double.class).description("Weight").build();

    public HMatrixPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        ArrayList<Datum> result = new ArrayList<Datum>();
        DoubleMatrix aDoubleMatrix = DoubleMatrixFactory.DEFAULT.make(this.aMatrix());
        aDoubleMatrix.invert();
        DistanceMatrix aInverse = new DistanceMatrix(aDoubleMatrix.toArray(), this.aMatrix().getTaxaList());
        DistanceMatrix gStarMatrix = HMatrixPlugin.generateGStarMatrix(this.aMatrix(), this.gMatrix(), this.weight());
        DoubleMatrix gStarDoubleMatrix = DoubleMatrixFactory.DEFAULT.make(gStarMatrix);
        gStarDoubleMatrix.invert();
        DistanceMatrix gStarInverse = new DistanceMatrix(gStarDoubleMatrix.toArray(), this.gMatrix().getTaxaList());
        DistanceMatrix matrix = HMatrixPlugin.generateCombinedMatrix(aInverse, gStarInverse);
        result.add(new Datum("Combined A and G Matrix", matrix, null));
        result.add(new Datum("A Matrix Inverse", aInverse, null));
        result.add(new Datum("G* Matrix Inverse", gStarInverse, null));
        return new DataSet(result, (Plugin)this);
    }

    public DistanceMatrix aMatrix() {
        return this.myAMatrix.value();
    }

    public HMatrixPlugin aMatrix(DistanceMatrix value) {
        this.myAMatrix = new PluginParameter<DistanceMatrix>(this.myAMatrix, value);
        return this;
    }

    public DistanceMatrix gMatrix() {
        return this.myGMatrix.value();
    }

    public HMatrixPlugin gMatrix(DistanceMatrix value) {
        this.myGMatrix = new PluginParameter<DistanceMatrix>(this.myGMatrix, value);
        return this;
    }

    public Double weight() {
        return this.myWeight.value();
    }

    public HMatrixPlugin weight(Double value) {
        this.myWeight = new PluginParameter<Double>(this.myWeight, value);
        return this;
    }

    private static DistanceMatrix generateGStarMatrix(DistanceMatrix aMatrix, DistanceMatrix gMatrix, double weight) {
        double[][] doubleA = aMatrix.getDistances();
        double[][] doubleG = gMatrix.getDistances();
        TaxaList aTaxa = aMatrix.getTaxaList();
        TaxaList gTaxa = gMatrix.getTaxaList();
        int size = gTaxa.size();
        double[][] doubleGStar = new double[size][size];
        for (int i = 0; i < size; ++i) {
            int aLocI = aTaxa.indexOf(gTaxa.get(i));
            if (aLocI == -1) {
                doubleGStar[i] = doubleG[i];
                continue;
            }
            for (int j = 0; j < size; ++j) {
                int aLocJ = aTaxa.indexOf(gTaxa.get(j));
                doubleGStar[i][j] = aLocJ == -1 ? doubleG[i][j] : weight * doubleG[i][j] + (1.0 - weight) * doubleA[aLocI][aLocJ];
            }
        }
        return new DistanceMatrix(doubleGStar, gMatrix.getTaxaList());
    }

    public static DistanceMatrix generateCombinedMatrix(DistanceMatrix aInverse, DistanceMatrix gStarInverse) {
        int newJ;
        int j;
        TaxaList aTaxa = aInverse.getTaxaList();
        TaxaList gTaxa = gStarInverse.getTaxaList();
        LinkedList<Taxon> aOnlyTaxa = new LinkedList<Taxon>(aTaxa);
        aOnlyTaxa.removeAll(gTaxa);
        LinkedList<Taxon> gOnlyTaxa = new LinkedList<Taxon>(gTaxa);
        gOnlyTaxa.removeAll(aTaxa);
        LinkedList<Taxon> unionTaxa = new LinkedList<Taxon>(aTaxa);
        unionTaxa.removeAll(aOnlyTaxa);
        ArrayList<Taxon> matrixOrder = new ArrayList<Taxon>(aOnlyTaxa);
        matrixOrder.addAll(gOnlyTaxa);
        matrixOrder.addAll(unionTaxa);
        double[][] aPrime = aInverse.getDistances();
        double[][] gStarPrime = gStarInverse.getDistances();
        int outputSize = aTaxa.size() + gOnlyTaxa.size();
        double[][] hPrime = new double[outputSize][outputSize];
        for (int i = 0; i < aPrime.length; ++i) {
            int newI = matrixOrder.indexOf(aTaxa.get(i));
            for (j = 0; j < aPrime.length; ++j) {
                newJ = matrixOrder.indexOf(aTaxa.get(j));
                hPrime[newI][newJ] = aPrime[i][j];
            }
        }
        for (Taxon gOnly : gOnlyTaxa) {
            int newI = matrixOrder.indexOf(gOnly);
            hPrime[newI][newI] = 1.0;
        }
        for (int i = 0; i < gTaxa.size(); ++i) {
            int newI = matrixOrder.indexOf(gTaxa.get(i));
            for (j = 0; j < gTaxa.size(); ++j) {
                newJ = matrixOrder.indexOf(gTaxa.get(j));
                hPrime[newI][newJ] = gStarPrime[i][j];
            }
        }
        TaxaListBuilder builder = new TaxaListBuilder();
        for (Taxon current : matrixOrder) {
            builder.add(current);
        }
        DistanceMatrix hInverse = new DistanceMatrix(hPrime, builder.build());
        return hInverse;
    }

    private static EigenvalueDecomposition decompose(DistanceMatrix input) {
        return DoubleMatrixFactory.DEFAULT.make(input.getDistances()).getEigenvalueDecomposition();
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = HMatrixPlugin.class.getResource("/net/maizegenetics/analysis/images/hmatrix.png");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Combined A and G Relationship Matrix";
    }

    @Override
    public String getToolTipText() {
        return "Create Combined A and G Relationship Matrix (H Matrix)";
    }

    @Override
    public String getCitation() {
        return "Lamos-Sweeney J, Nti-Addae Y, Robbins K, Casstevens T. (Oct. 2015) Second Tassel Hackathon.";
    }
}

