/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.distance;

import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.genotypecall.AlleleFreqCache;
import net.maizegenetics.util.ProgressListener;
import org.apache.log4j.Logger;

public class IBSDistanceMatrixOneByAll {
    private static final Logger myLogger = Logger.getLogger(IBSDistanceMatrixOneByAll.class);
    private static final long TRUE_TRUE_LONG = 4398048608257L;
    private static final long TRUE_FALSE_LONG = 1L;
    private static final long FALSE_TRUE_LONG = 0x200000L;
    private static final long FALSE_FALSE_LONG = 0L;
    private static long[] PRECALCULATED_COUNTS = null;
    private static final byte[] PRECALCULATED_ENCODINGS;
    private static final int NUM_CORES_TO_USE;
    private static int myNumSitesProcessed;
    private static final int MAX_NUMBER_20_BITS = 1048575;

    private IBSDistanceMatrixOneByAll() {
    }

    public static double[] getInstance(GenotypeTable genotype, int taxonIndex) {
        return IBSDistanceMatrixOneByAll.getInstance(genotype, taxonIndex, 0, null);
    }

    public static double[] getInstance(GenotypeTable genotype, int taxonIndex, ProgressListener listener) {
        return IBSDistanceMatrixOneByAll.getInstance(genotype, taxonIndex, 0, listener);
    }

    public static double[] getInstance(GenotypeTable genotype, int taxonIndex, int minSiteComp, ProgressListener listener) {
        return IBSDistanceMatrixOneByAll.computeHetBitDistances(genotype, taxonIndex, listener, minSiteComp);
    }

    private static double[] computeHetBitDistances(GenotypeTable genotype, int taxonIndex, ProgressListener listener, int minSitesComp) {
        int numSeqs = genotype.numberOfTaxa();
        long time = System.currentTimeMillis();
        Counters temp = new Counters(numSeqs);
        IBSDistanceMatrixOneByAll.stream(genotype, taxonIndex, listener).forEach(t -> temp.add((long[])t));
        int[] counters = temp.myCounters;
        double[] result = new double[numSeqs];
        int index = 0;
        for (int i = 0; i < numSeqs; ++i) {
            int sameCount = counters[index++];
            int diffCount = counters[index++];
            int hetCount = counters[index++];
            long sites = sameCount + diffCount - hetCount;
            double identity = ((double)sameCount - 0.5 * (double)hetCount) / (double)sites;
            double dist = 1.0 - identity;
            if (sites < (long)minSitesComp) {
                dist = Double.NaN;
            }
            result[i] = dist;
        }
        myLogger.info((Object)("IBSDistanceMatrixOneByAll: computeHetBitDistances time = " + (System.currentTimeMillis() - time) / 1000L + " seconds"));
        return result;
    }

    protected static void fireProgress(int percent, ProgressListener listener) {
        if (listener != null) {
            listener.progress(percent, null);
        }
    }

    private static Stream<long[]> stream(GenotypeTable genotypes, int taxonIndex, ProgressListener listener) {
        myNumSitesProcessed = 0;
        return StreamSupport.stream(new IBSSiteSpliterator(genotypes, taxonIndex, 0, genotypes.numberOfSites(), listener), true);
    }

    static {
        long[] possibleTerms = new long[32];
        possibleTerms[22] = 1L;
        possibleTerms[20] = 4398048608257L;
        possibleTerms[18] = 4398048608257L;
        possibleTerms[6] = 0x200000L;
        possibleTerms[2] = 0x200000L;
        possibleTerms[0] = 0L;
        possibleTerms[21] = 4398048608257L;
        possibleTerms[17] = 4398048608257L;
        possibleTerms[4] = 4398048608257L;
        possibleTerms[1] = 4398048608257L;
        possibleTerms[5] = 0x200000L;
        possibleTerms[19] = 4398048608257L;
        possibleTerms[3] = 4398048608257L;
        possibleTerms[14] = 1L;
        possibleTerms[10] = 4398048608257L;
        possibleTerms[11] = 4398048608257L;
        possibleTerms[7] = 1L;
        PRECALCULATED_COUNTS = new long[23255];
        for (int i = 0; i < 23255; ++i) {
            int firstCode = i & 0x1F;
            int secondCode = i >>> 5 & 0x1F;
            int thirdCode = i >>> 10 & 0x1F;
            IBSDistanceMatrixOneByAll.PRECALCULATED_COUNTS[i] = possibleTerms[firstCode] + possibleTerms[secondCode] + possibleTerms[thirdCode];
        }
        PRECALCULATED_ENCODINGS = new byte[8];
        IBSDistanceMatrixOneByAll.PRECALCULATED_ENCODINGS[1] = 22;
        IBSDistanceMatrixOneByAll.PRECALCULATED_ENCODINGS[3] = 21;
        IBSDistanceMatrixOneByAll.PRECALCULATED_ENCODINGS[5] = 19;
        IBSDistanceMatrixOneByAll.PRECALCULATED_ENCODINGS[2] = 14;
        IBSDistanceMatrixOneByAll.PRECALCULATED_ENCODINGS[6] = 11;
        IBSDistanceMatrixOneByAll.PRECALCULATED_ENCODINGS[4] = 7;
        IBSDistanceMatrixOneByAll.PRECALCULATED_ENCODINGS[0] = 0;
        NUM_CORES_TO_USE = Runtime.getRuntime().availableProcessors() - 1;
        myNumSitesProcessed = 0;
    }

    static class IBSSiteSpliterator
    implements Spliterator<long[]> {
        private int myCurrentSite;
        private final int myFence;
        private final GenotypeTable myGenotypes;
        private final int myNumTaxa;
        private final int myNumSites;
        private final ProgressListener myProgressListener;
        private int myMinSitesToProcess;
        private final int myTaxonIndex;
        private static final int NUM_SITES_PER_BLOCK = 3;

        IBSSiteSpliterator(GenotypeTable genotypes, int taxonIndex, int currentIndex, int fence, ProgressListener listener) {
            this.myGenotypes = genotypes;
            this.myNumTaxa = this.myGenotypes.numberOfTaxa();
            this.myNumSites = this.myGenotypes.numberOfSites();
            this.myCurrentSite = currentIndex;
            this.myFence = fence;
            this.myProgressListener = listener;
            this.myMinSitesToProcess = this.myNumSites / NUM_CORES_TO_USE;
            if (this.myMinSitesToProcess == 0) {
                this.myMinSitesToProcess = this.myNumSites;
            }
            this.myTaxonIndex = taxonIndex;
        }

        @Override
        public void forEachRemaining(Consumer<? super long[]> action) {
            int numSitesProcessed = this.myFence - this.myCurrentSite;
            while (this.myCurrentSite < this.myFence) {
                int currentBlockFence = Math.min(this.myCurrentSite + 1048575, this.myFence);
                long[] counts = new long[this.myNumTaxa];
                while (this.myCurrentSite < currentBlockFence) {
                    int[] numSites = new int[1];
                    short[] encodings1 = this.getBlockOfSites(this.myCurrentSite, numSites, currentBlockFence);
                    short[] encodings2 = this.getBlockOfSites(this.myCurrentSite + numSites[0], numSites, currentBlockFence);
                    short[] encodings3 = this.getBlockOfSites(this.myCurrentSite + numSites[0], numSites, currentBlockFence);
                    short[] encodings4 = this.getBlockOfSites(this.myCurrentSite + numSites[0], numSites, currentBlockFence);
                    short[] encodings5 = this.getBlockOfSites(this.myCurrentSite + numSites[0], numSites, currentBlockFence);
                    short[] encodings6 = this.getBlockOfSites(this.myCurrentSite + numSites[0], numSites, currentBlockFence);
                    this.myCurrentSite += numSites[0];
                    for (int firstTaxa = 0; firstTaxa < this.myNumTaxa; ++firstTaxa) {
                        int n = firstTaxa;
                        counts[n] = counts[n] + (PRECALCULATED_COUNTS[encodings1[firstTaxa] & encodings1[this.myTaxonIndex]] + PRECALCULATED_COUNTS[encodings2[firstTaxa] & encodings2[this.myTaxonIndex]] + PRECALCULATED_COUNTS[encodings3[firstTaxa] & encodings3[this.myTaxonIndex]] + PRECALCULATED_COUNTS[encodings4[firstTaxa] & encodings4[this.myTaxonIndex]] + PRECALCULATED_COUNTS[encodings5[firstTaxa] & encodings5[this.myTaxonIndex]] + PRECALCULATED_COUNTS[encodings6[firstTaxa] & encodings6[this.myTaxonIndex]]);
                    }
                }
                action.accept((long[])counts);
            }
            myNumSitesProcessed = myNumSitesProcessed + numSitesProcessed;
            IBSDistanceMatrixOneByAll.fireProgress((int)((double)myNumSitesProcessed / (double)this.myNumSites * 100.0), this.myProgressListener);
        }

        private short[] getBlockOfSites(int currentSite, int[] numSites, int currentBlockFence) {
            int currentSiteNum = 0;
            short[] encodings = new short[this.myNumTaxa];
            while (currentSiteNum < 3 && currentSite < currentBlockFence) {
                byte[] genotype = this.myGenotypes.genotypeAllTaxa(currentSite);
                int[][] alleles = AlleleFreqCache.allelesSortedByFrequencyNucleotide(genotype);
                int numAlleles = alleles[0].length;
                if (numAlleles != 0) {
                    for (int i = 0; i < this.myNumTaxa; ++i) {
                        byte first = (byte)(genotype[i] & 0xF);
                        byte second = (byte)(genotype[i] >>> 4 & 0xF);
                        int allelePresent = 0;
                        if (alleles[0][0] == first || alleles[0][0] == second) {
                            allelePresent = 1;
                        }
                        if (numAlleles >= 2) {
                            if (alleles[0][1] == first || alleles[0][1] == second) {
                                allelePresent |= 2;
                            }
                            if (numAlleles >= 3 && (alleles[0][2] == first || alleles[0][2] == second)) {
                                allelePresent |= 4;
                            }
                        }
                        encodings[i] = (short)(encodings[i] << 5 | PRECALCULATED_ENCODINGS[allelePresent]);
                    }
                    ++currentSiteNum;
                }
                ++currentSite;
                numSites[0] = numSites[0] + 1;
            }
            return encodings;
        }

        @Override
        public boolean tryAdvance(Consumer<? super long[]> action) {
            if (this.myCurrentSite < this.myFence) {
                this.forEachRemaining(action);
                return true;
            }
            return false;
        }

        @Override
        public Spliterator<long[]> trySplit() {
            int lo = this.myCurrentSite;
            int mid = lo + this.myMinSitesToProcess;
            if (mid < this.myFence) {
                this.myCurrentSite = mid;
                return new IBSSiteSpliterator(this.myGenotypes, this.myTaxonIndex, lo, mid, this.myProgressListener);
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return this.myFence - this.myCurrentSite;
        }

        @Override
        public int characteristics() {
            return 1024;
        }
    }

    private static class Counters {
        private final int[] myCounters;
        private final int myNumTaxa;

        public Counters(int numTaxa) {
            this.myNumTaxa = numTaxa;
            this.myCounters = new int[this.myNumTaxa * 3];
        }

        public synchronized void add(long[] values) {
            int index = 0;
            for (int i = 0; i < this.myNumTaxa; ++i) {
                int n = index++;
                this.myCounters[n] = this.myCounters[n] + (int)(values[i] & 0x1FFFFFL);
                int n2 = index++;
                this.myCounters[n2] = this.myCounters[n2] + (int)(values[i] >>> 21 & 0x1FFFFFL);
                int n3 = index++;
                this.myCounters[n3] = this.myCounters[n3] + (int)(values[i] >>> 42 & 0x1FFFFFL);
            }
        }

        public void addAll(Counters counters) {
            int[] other = counters.myCounters;
            for (int t = 0; t < this.myNumTaxa; ++t) {
                int n = t;
                this.myCounters[n] = this.myCounters[n] + other[t];
            }
        }
    }
}

