/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.distance;

import com.google.common.collect.Range;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.data.ExportPlugin;
import net.maizegenetics.analysis.data.FileLoadPlugin;
import net.maizegenetics.analysis.distance.KinshipPlugin;
import net.maizegenetics.analysis.distance.SubtractDistanceMatrixPlugin;
import net.maizegenetics.analysis.filter.FilterSiteBuilderPlugin;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.snp.FilterSite;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.io.JSONUtils;
import net.maizegenetics.dna.snp.io.ReadBedfile;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.DefaultPluginListener;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.plugindef.ThreadedPluginListener;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class VCAPScanPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(VCAPScanPlugin.class);
    private PluginParameter<SCAN_METHOD> myMethod = new PluginParameter.Builder<SCAN_METHOD>("method", SCAN_METHOD.Chromosome, SCAN_METHOD.class).guiName("Scan method").range((Comparable<T>[])SCAN_METHOD.values()).description("").build();
    private PluginParameter<Integer> myBlockingWindowSize = new PluginParameter.Builder<Integer>("blockingWindowSize", 0, Integer.class).description("Blocking window size. Number of sites (Site_Blocks) or physical positions (Bed_File) on each side of regions.").range((Range<Comparable<Integer>>)Range.atLeast((Comparable)Integer.valueOf(0))).build();
    private PluginParameter<Integer> myNumSitesPerBlock = new PluginParameter.Builder<Integer>("numSitesPerBlock", 10000, Integer.class).description("For Site_Blocks method, this sets number of sites per block. Blocks do not span chromosomes.").range((Range<Comparable<Integer>>)Range.atLeast((Comparable)Integer.valueOf(1))).build();
    private PluginParameter<Integer> myStepSize = new PluginParameter.Builder<Integer>("stepSize", 0, Integer.class).description("Step Size. If step size set to default 0, the step size will equal number sites per block.").range((Range<Comparable<Integer>>)Range.atLeast((Comparable)Integer.valueOf(0))).build();
    private PluginParameter<String> myDirOfFiles = new PluginParameter.Builder<String>("dirOfFiles", null, String.class).description("Directory contains files for sub-matrices. Can be text (.txt) containing chromosome / positions, Bed (.bed), or Position List (.json or .json.gz)").inDir().build();
    private PluginParameter<String> myBedFile = new PluginParameter.Builder<String>("bedFile", null, String.class).description("For Bed_File method, this specifies bed file to use.  Each line / range in the bed file will be a block in the scan.").inFile().build();
    private PluginParameter<String> myBlockingBedFile = new PluginParameter.Builder<String>("blockingBedFile", null, String.class).description("For Bed_File method, this specifies optional bed file to define blocking window for each block in the main bed file.").inFile().build();
    private PluginParameter<String> myPhenotypeFile = new PluginParameter.Builder<String>("phenotypeFile", null, String.class).description("The phenotype file to use with LDAK.  Must have only one phenotype.").inFile().required(true).build();
    private PluginParameter<String> myLDAKCommand = new PluginParameter.Builder<String>("ldakCommand", "ldak.4.9.fast", String.class).description("Command to call LDAK.  If not on PATH, full pathname needed.").build();
    private PluginParameter<String> myOutputDir = new PluginParameter.Builder<String>("outputDir", ".", String.class).description("Directory to output kinship matrices and LDAK reml results.").outDir().build();
    private PluginParameter<String> myWholeMatrix = new PluginParameter.Builder<String>("wholeMatrix", null, String.class).description("Kinship matrix of whole genotype dataset.  This will be created if not specified.  Must have been exported from Tassel with export type SqrMatrixBin.").inFile().build();

    public VCAPScanPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        List<Datum> alignInList = input.getDataOfType(GenotypeTable.class);
        if (alignInList == null || alignInList.size() != 1) {
            throw new IllegalArgumentException("VCAPScanPlugin: Must input exactly one genotype table.");
        }
    }

    @Override
    protected void postProcessParameters() {
        if (this.outputDir().charAt(this.outputDir().length() - 1) != '/') {
            this.outputDir(this.outputDir() + "/");
        }
    }

    @Override
    public DataSet processData(DataSet input) {
        GenotypeTable genotype = (GenotypeTable)input.getDataOfType(GenotypeTable.class).get(0).getData();
        ArrayList<String> matrixFiles = new ArrayList<String>();
        if (this.method() == SCAN_METHOD.Chromosome) {
            ForkJoinPool threadPool = new ForkJoinPool();
            KinshipPlugin kinshipPlugin = new KinshipPlugin(null, false).kinshipMethod(KinshipPlugin.KINSHIP_METHOD.Centered_IBS);
            kinshipPlugin.addListener(DefaultPluginListener.getInstance());
            SubtractDistanceMatrixPlugin subtractPlugin = new SubtractDistanceMatrixPlugin(null, false).wholeMatrix(this.createWholeMatrixIfNeeded(input));
            for (Chromosome currentChr : genotype.chromosomes()) {
                String chrStr = currentChr.getName();
                FilterSiteBuilderPlugin filterChr = new FilterSiteBuilderPlugin(null, false).startChr(currentChr).endChr(currentChr);
                DataSet genotypeDataSet = filterChr.performFunction(input);
                GenotypeTable genotypeChr = (GenotypeTable)genotypeDataSet.getData(0).getData();
                int numSites = genotypeChr.numberOfSites();
                DataSet part = kinshipPlugin.performFunction(genotypeDataSet);
                DataSet rest = subtractPlugin.performFunction(part);
                ExportPlugin exportPlugin = new ExportPlugin(null, false);
                exportPlugin.fileType(FileLoadPlugin.TasselFileType.SqrMatrixBin);
                String startPosStr = String.format("%012d", genotypeChr.chromosomalPosition(0));
                String endPosStr = String.format("%012d", genotypeChr.chromosomalPosition(numSites - 1));
                String saveFilename = this.outputDir() + "Kinship_" + chrStr + "_" + startPosStr + "_" + endPosStr;
                matrixFiles.add(saveFilename);
                exportPlugin.saveFile(saveFilename);
                threadPool.submit(new ThreadedPluginListener(exportPlugin, new PluginEvent(new DataSet(part.getData(0), part.getCreator()))));
                ExportPlugin exportPlugin1 = new ExportPlugin(null, false);
                exportPlugin1.fileType(FileLoadPlugin.TasselFileType.SqrMatrixBin);
                exportPlugin1.saveFile(saveFilename + "Rest");
                threadPool.submit(new ThreadedPluginListener(exportPlugin1, new PluginEvent(new DataSet(rest.getData(0), rest.getCreator()))));
            }
            threadPool.shutdown();
            try {
                threadPool.awaitTermination(20L, TimeUnit.MINUTES);
            }
            catch (Exception e) {
                myLogger.debug((Object)e.getMessage(), (Throwable)e);
                throw new IllegalStateException("VCAPScanPlugin: processData: problem: " + e.getMessage());
            }
        }
        if (this.method() == SCAN_METHOD.Site_Blocks) {
            Chromosome[] chromosomes;
            ForkJoinPool threadPool = new ForkJoinPool();
            int numSitesPerBlock = this.numSitesPerBlock();
            KinshipPlugin kinshipPlugin = new KinshipPlugin(null, false).kinshipMethod(KinshipPlugin.KINSHIP_METHOD.Centered_IBS);
            kinshipPlugin.addListener(DefaultPluginListener.getInstance());
            SubtractDistanceMatrixPlugin subtractPlugin = new SubtractDistanceMatrixPlugin(null, false).wholeMatrix(this.createWholeMatrixIfNeeded(input));
            for (Chromosome c : chromosomes = genotype.chromosomes()) {
                String chrStr = c.getName();
                FilterSiteBuilderPlugin filterChr = new FilterSiteBuilderPlugin(null, false).startChr(c).endChr(c);
                DataSet genotypeDataSet = filterChr.performFunction(input);
                GenotypeTable genotypeChr = (GenotypeTable)genotypeDataSet.getData(0).getData();
                int numSites = genotypeChr.numberOfSites();
                int winBufferSize = this.blockingWindowSize();
                int stepSize = this.stepSize();
                if (stepSize < 1) {
                    stepSize = numSitesPerBlock;
                }
                for (int startSite = 0; startSite < numSites; startSite += stepSize) {
                    DataSet blocking;
                    int endSite = Math.min(startSite + numSitesPerBlock - 1, numSites - 1);
                    int startSiteBlocking = Math.max(startSite - winBufferSize, 0);
                    int endSiteBlocking = Math.min(endSite + winBufferSize, numSites - 1);
                    String startPosStr = String.format("%012d", genotypeChr.chromosomalPosition(startSite));
                    String endPosStr = String.format("%012d", genotypeChr.chromosomalPosition(endSite));
                    String saveFilename = this.outputDir() + "Kinship_" + chrStr + "_" + startPosStr + "_" + endPosStr;
                    matrixFiles.add(saveFilename);
                    if (new File(saveFilename + "Rest.grm.bin").isFile() && new File(saveFilename + ".grm.bin").isFile()) {
                        myLogger.info((Object)(saveFilename + " already exists"));
                        continue;
                    }
                    FilterSiteBuilderPlugin filter = new FilterSiteBuilderPlugin(null, false).startSite(startSite).endSite(endSite);
                    DataSet filteredGenotype = filter.performFunction(genotypeDataSet);
                    DataSet part = kinshipPlugin.performFunction(filteredGenotype);
                    if (startSite != startSiteBlocking || endSite != endSiteBlocking) {
                        FilterSiteBuilderPlugin filterBlocking = new FilterSiteBuilderPlugin(null, false).startSite(startSiteBlocking).endSite(endSiteBlocking);
                        DataSet filteredBlocking = filterBlocking.performFunction(genotypeDataSet);
                        blocking = kinshipPlugin.performFunction(filteredBlocking);
                    } else {
                        blocking = part;
                    }
                    DataSet rest = subtractPlugin.performFunction(blocking);
                    ExportPlugin exportPlugin = new ExportPlugin(null, false);
                    exportPlugin.fileType(FileLoadPlugin.TasselFileType.SqrMatrixBin);
                    exportPlugin.saveFile(saveFilename);
                    threadPool.submit(new ThreadedPluginListener(exportPlugin, new PluginEvent(new DataSet(part.getData(0), part.getCreator()))));
                    ExportPlugin exportPlugin1 = new ExportPlugin(null, false);
                    exportPlugin1.fileType(FileLoadPlugin.TasselFileType.SqrMatrixBin);
                    exportPlugin1.saveFile(saveFilename + "Rest");
                    threadPool.submit(new ThreadedPluginListener(exportPlugin1, new PluginEvent(new DataSet(rest.getData(0), rest.getCreator()))));
                }
            }
            threadPool.shutdown();
            try {
                threadPool.awaitTermination(20L, TimeUnit.MINUTES);
            }
            catch (Exception e) {
                myLogger.debug((Object)e.getMessage(), (Throwable)e);
                throw new IllegalStateException("VCAPScanPlugin: processData: problem: " + e.getMessage());
            }
        }
        if (this.method() == SCAN_METHOD.Directory_Of_Files) {
            String[] files;
            ForkJoinPool threadPool = new ForkJoinPool();
            KinshipPlugin kinshipPlugin = new KinshipPlugin(null, false).kinshipMethod(KinshipPlugin.KINSHIP_METHOD.Centered_IBS);
            kinshipPlugin.addListener(DefaultPluginListener.getInstance());
            SubtractDistanceMatrixPlugin subtractPlugin = new SubtractDistanceMatrixPlugin(null, false).wholeMatrix(this.createWholeMatrixIfNeeded(input));
            for (String current : files = new File(this.dirOfFiles()).list()) {
                FilterSiteBuilderPlugin filterChr;
                String file = this.dirOfFiles() + "/" + current;
                DataSet genotypeDataSet = null;
                if (file.endsWith(".txt")) {
                    filterChr = new FilterSiteBuilderPlugin(null, false).chrPosFile(file);
                    genotypeDataSet = filterChr.performFunction(input);
                } else if (file.endsWith(".bed")) {
                    filterChr = new FilterSiteBuilderPlugin(null, false).bedFile(file);
                    genotypeDataSet = filterChr.performFunction(input);
                } else {
                    if (!file.endsWith(".json") && !file.endsWith(".json.gz")) continue;
                    filterChr = new FilterSiteBuilderPlugin(null, false).positionList(JSONUtils.importPositionListFromJSON(file));
                    genotypeDataSet = filterChr.performFunction(input);
                }
                DataSet part = kinshipPlugin.performFunction(genotypeDataSet);
                DataSet rest = subtractPlugin.performFunction(part);
                GenotypeTable genotypeChr = (GenotypeTable)genotypeDataSet.getData(0).getData();
                int numSites = genotypeChr.numberOfSites();
                ExportPlugin exportPlugin = new ExportPlugin(null, false);
                exportPlugin.fileType(FileLoadPlugin.TasselFileType.SqrMatrixBin);
                String startPosStr = String.format("%012d", genotypeChr.chromosomalPosition(0));
                String endPosStr = String.format("%012d", genotypeChr.chromosomalPosition(numSites - 1));
                String saveFilename = this.outputDir() + "Kinship_0_" + startPosStr + "_" + endPosStr + "_" + Utils.getFilename(file);
                matrixFiles.add(saveFilename);
                exportPlugin.saveFile(saveFilename);
                threadPool.submit(new ThreadedPluginListener(exportPlugin, new PluginEvent(new DataSet(part.getData(0), part.getCreator()))));
                ExportPlugin exportPlugin1 = new ExportPlugin(null, false);
                exportPlugin1.fileType(FileLoadPlugin.TasselFileType.SqrMatrixBin);
                exportPlugin1.saveFile(saveFilename + "Rest");
                threadPool.submit(new ThreadedPluginListener(exportPlugin1, new PluginEvent(new DataSet(rest.getData(0), rest.getCreator()))));
            }
            threadPool.shutdown();
            try {
                threadPool.awaitTermination(20L, TimeUnit.MINUTES);
            }
            catch (Exception e) {
                myLogger.debug((Object)e.getMessage(), (Throwable)e);
                throw new IllegalStateException("VCAPScanPlugin: processData: problem: " + e.getMessage());
            }
        }
        if (this.method() == SCAN_METHOD.Bed_File) {
            ReadBedfile.BedFileRange range;
            int i;
            if (this.bedFile() == null || this.bedFile().isEmpty()) {
                throw new IllegalArgumentException("VCAPScanPlugin: processData: bed file must be specified for method Bed_File.");
            }
            if (!new File(this.bedFile()).isFile()) {
                throw new IllegalArgumentException("VCAPScanPlugin: processData: bed file doesn't exist: " + this.bedFile());
            }
            ForkJoinPool threadPool = new ForkJoinPool();
            KinshipPlugin kinshipPlugin = new KinshipPlugin(null, false).kinshipMethod(KinshipPlugin.KINSHIP_METHOD.Centered_IBS);
            kinshipPlugin.addListener(DefaultPluginListener.getInstance());
            SubtractDistanceMatrixPlugin subtractPlugin = new SubtractDistanceMatrixPlugin(null, false).wholeMatrix(this.createWholeMatrixIfNeeded(input));
            List<ReadBedfile.BedFileRange> ranges = ReadBedfile.getRanges(this.bedFile());
            int numRanges = ranges.size();
            List<ReadBedfile.BedFileRange> blockingRanges = null;
            if (this.blockingBedFile() == null || this.blockingBedFile().isEmpty()) {
                myLogger.info((Object)("processData: no blocking windows used with bed file: " + this.bedFile()));
            } else {
                if (!new File(this.blockingBedFile()).isFile()) {
                    throw new IllegalArgumentException("VCAPScanPlugin: processData: blocking bed file doesn't exist: " + this.blockingBedFile());
                }
                blockingRanges = ReadBedfile.getRanges(this.blockingBedFile());
                if (ranges.size() != blockingRanges.size()) {
                    throw new IllegalArgumentException("VCAPScanPlugin: processData: must be same number of ranges in bed file and blocking bed file.");
                }
                for (i = 0; i < numRanges; ++i) {
                    range = ranges.get(i);
                    ReadBedfile.BedFileRange blockingRange = blockingRanges.get(i);
                    if (!blockingRange.chr().equals(range.chr())) {
                        throw new IllegalArgumentException("VCAPScanPlugin: processData: block range chr: " + blockingRange.chr() + " should equal range chr: " + range.chr());
                    }
                    if (blockingRange.start() > range.start()) {
                        throw new IllegalArgumentException("VCAPScanPlugin: processData: blocking range start: " + blockingRange.start() + " should be less than or equal to range start: " + range.start());
                    }
                    if (blockingRange.end() >= range.end()) continue;
                    throw new IllegalArgumentException("VCAPScanPlugin: processData: blocking range end: " + blockingRange.end() + " should be greater than or equal to range end: " + range.end());
                }
            }
            for (i = 0; i < numRanges; ++i) {
                DataSet blocking;
                int endSite;
                range = ranges.get(i);
                int startSite = genotype.siteOfPhysicalPosition(range.start(), new Chromosome(range.chr()));
                if (startSite < 0) {
                    startSite = -startSite - 1;
                }
                endSite = (endSite = genotype.siteOfPhysicalPosition(range.end(), new Chromosome(range.chr()))) < 0 ? -endSite - 2 : --endSite;
                if (endSite <= startSite) {
                    myLogger.warn((Object)("No sites in region chr: " + range.chr() + " start: " + range.start() + " end: " + range.end()));
                    continue;
                }
                int startSiteBlocking = startSite;
                int endSiteBlocking = endSite;
                if (blockingRanges != null) {
                    ReadBedfile.BedFileRange blockingRange = blockingRanges.get(i);
                    startSiteBlocking = genotype.siteOfPhysicalPosition(blockingRange.start(), new Chromosome(blockingRange.chr()));
                    if (startSiteBlocking < 0) {
                        startSiteBlocking = -startSiteBlocking - 1;
                    }
                    endSiteBlocking = (endSiteBlocking = genotype.siteOfPhysicalPosition(blockingRange.end(), new Chromosome(blockingRange.chr()))) < 0 ? -endSiteBlocking - 2 : --endSiteBlocking;
                } else if (this.blockingWindowSize() != 0) {
                    startSiteBlocking = genotype.siteOfPhysicalPosition(Math.max(0, range.start() - this.blockingWindowSize()), new Chromosome(range.chr()));
                    if (startSiteBlocking < 0) {
                        startSiteBlocking = -startSiteBlocking - 1;
                    }
                    endSiteBlocking = (endSiteBlocking = genotype.siteOfPhysicalPosition(range.end() + this.blockingWindowSize(), new Chromosome(range.chr()))) < 0 ? -endSiteBlocking - 2 : --endSiteBlocking;
                }
                String startPosStr = String.format("%012d", genotype.chromosomalPosition(startSite));
                String endPosStr = String.format("%012d", genotype.chromosomalPosition(endSite));
                String saveFilename = this.outputDir() + "Kinship_" + range.chr() + "_" + startPosStr + "_" + endPosStr;
                if (range.name() != null) {
                    saveFilename = saveFilename + "_" + range.name();
                }
                matrixFiles.add(saveFilename);
                if (new File(saveFilename + "Rest.grm.bin").isFile() && new File(saveFilename + ".grm.bin").isFile()) {
                    myLogger.info((Object)(saveFilename + " already exists"));
                    continue;
                }
                FilterSiteBuilderPlugin filter = new FilterSiteBuilderPlugin(null, false).siteFilter(FilterSite.SITE_RANGE_FILTER_TYPES.SITES).startSite(startSite).endSite(endSite);
                DataSet filteredGenotype = filter.performFunction(input);
                DataSet part = kinshipPlugin.performFunction(filteredGenotype);
                if (startSite != startSiteBlocking || endSite != endSiteBlocking) {
                    FilterSiteBuilderPlugin filterBlocking = new FilterSiteBuilderPlugin(null, false).startSite(startSiteBlocking).endSite(endSiteBlocking);
                    DataSet filteredBlocking = filterBlocking.performFunction(input);
                    blocking = kinshipPlugin.performFunction(filteredBlocking);
                } else {
                    blocking = part;
                }
                DataSet rest = subtractPlugin.performFunction(blocking);
                ExportPlugin exportPlugin = new ExportPlugin(null, false);
                exportPlugin.fileType(FileLoadPlugin.TasselFileType.SqrMatrixBin);
                exportPlugin.saveFile(saveFilename);
                threadPool.submit(new ThreadedPluginListener(exportPlugin, new PluginEvent(new DataSet(part.getData(0), part.getCreator()))));
                ExportPlugin exportPlugin1 = new ExportPlugin(null, false);
                exportPlugin1.fileType(FileLoadPlugin.TasselFileType.SqrMatrixBin);
                exportPlugin1.saveFile(saveFilename + "Rest");
                threadPool.submit(new ThreadedPluginListener(exportPlugin1, new PluginEvent(new DataSet(rest.getData(0), rest.getCreator()))));
            }
            threadPool.shutdown();
            try {
                threadPool.awaitTermination(20L, TimeUnit.MINUTES);
            }
            catch (Exception e) {
                myLogger.debug((Object)e.getMessage(), (Throwable)e);
                throw new IllegalStateException("VCAPScanPlugin: processData: problem: " + e.getMessage());
            }
        }
        this.runLDAK(matrixFiles);
        this.getResults();
        return null;
    }

    private String createWholeMatrixIfNeeded(DataSet input) {
        if (this.wholeMatrix() == null || this.wholeMatrix().isEmpty()) {
            String saveFilename = this.outputDir() + "kinship_whole.txt";
            if (!this.isFileEmpty(saveFilename)) {
                myLogger.info((Object)("Whole Kinship already exists: " + saveFilename));
                return saveFilename;
            }
            KinshipPlugin kinshipPlugin = new KinshipPlugin(null, false).kinshipMethod(KinshipPlugin.KINSHIP_METHOD.Centered_IBS);
            kinshipPlugin.addListener(DefaultPluginListener.getInstance());
            DataSet whole = kinshipPlugin.performFunction(input);
            ExportPlugin exportPlugin = new ExportPlugin(null, false);
            exportPlugin.fileType(FileLoadPlugin.TasselFileType.SqrMatrix);
            exportPlugin.saveFile(saveFilename);
            exportPlugin.performFunction(whole);
            return saveFilename;
        }
        return this.wholeMatrix();
    }

    private void runLDAK(List<String> matrixFiles) {
        int numProcesses = 0;
        Process[] runningProcesses = new Process[3];
        BufferedReader[] readers = new BufferedReader[3];
        String[] commands = new String[3];
        for (String filename : matrixFiles) {
            String resultFilename = this.outputDir() + "Results" + Utils.getFilename(filename);
            if (!this.isFileEmpty(resultFilename + ".reml")) continue;
            String listFilename = "kinship_list" + numProcesses + ".txt";
            try (BufferedWriter writer = Utils.getBufferedWriter(listFilename);){
                writer.write(filename);
                writer.write("\n");
                writer.write(filename + "Rest");
                writer.write("\n");
            }
            catch (Exception e) {
                myLogger.debug((Object)e.getMessage(), (Throwable)e);
            }
            commands[numProcesses] = this.ldakCommand() + " --reml " + resultFilename + " --mgrm " + listFilename + " --pheno " + this.phenotypeFile() + " --kinship-details NO";
            try {
                runningProcesses[numProcesses] = Runtime.getRuntime().exec(commands[numProcesses]);
                readers[numProcesses] = new BufferedReader(new InputStreamReader(runningProcesses[numProcesses].getInputStream()));
            }
            catch (Exception e) {
                myLogger.error((Object)e.getMessage(), (Throwable)e);
            }
            if (++numProcesses != 3) continue;
            for (int i = 0; i < numProcesses; ++i) {
                try {
                    runningProcesses[i].waitFor();
                    myLogger.info((Object)("command: " + commands[i]));
                    String line = null;
                    while ((line = readers[i].readLine()) != null) {
                        System.out.println(line);
                    }
                    readers[i].close();
                    continue;
                }
                catch (Exception e) {
                    myLogger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            numProcesses = 0;
        }
        for (int i = 0; i < numProcesses; ++i) {
            try {
                runningProcesses[i].waitFor();
                myLogger.info((Object)("command: " + commands[i]));
                String line = null;
                while ((line = readers[i].readLine()) != null) {
                    System.out.println(line);
                }
                readers[i].close();
                continue;
            }
            catch (Exception e) {
                myLogger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void getResults() {
        String[] files;
        TreeMap<ChrPos, String[]> rows = new TreeMap<ChrPos, String[]>();
        String output = this.outputDir() + Utils.getFilename(this.phenotypeFile()) + "Results.txt";
        for (String file : files = new File(this.outputDir()).list()) {
            if (!file.endsWith(".reml")) continue;
            String[] result = new String[6];
            String[] tokens = file.substring(0, file.indexOf(".reml")).split("_");
            result[0] = tokens[1];
            result[1] = tokens[2];
            result[2] = tokens[3];
            result[3] = tokens.length > 4 ? tokens[4] : "";
            String file3 = this.outputDir() + file;
            try (BufferedReader reader = Utils.getBufferedReader(file3);){
                String line = reader.readLine();
                while (line != null) {
                    String[] temp;
                    if (line.startsWith("Her_K1")) {
                        temp = line.split(" ");
                        result[4] = temp[1];
                    } else if (line.startsWith("Her_K2")) {
                        temp = line.split(" ");
                        result[5] = temp[1];
                    }
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            rows.put(new ChrPos(Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2])), result);
        }
        myLogger.info((Object)("Writing Results file: " + output));
        try (BufferedWriter writer = Utils.getBufferedWriter(output);){
            writer.write("Chromosome\tStart Position\tEnd Position\tComment\tHeritably Subset\tHeritably Rest\n");
            for (Map.Entry current : rows.entrySet()) {
                boolean first = true;
                for (int i = 0; i < ((String[])current.getValue()).length; ++i) {
                    if (!first) {
                        writer.write("\t");
                    }
                    first = false;
                    writer.write(((String[])current.getValue())[i]);
                }
                writer.write("\n");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isFileEmpty(String filename) {
        if (!new File(filename).isFile()) return true;
        try (BufferedReader reader = Utils.getBufferedReader(filename);){
            boolean bl = reader.readLine() == null;
            return bl;
        }
        catch (Exception e) {
            return true;
        }
    }

    public SCAN_METHOD method() {
        return this.myMethod.value();
    }

    public VCAPScanPlugin method(SCAN_METHOD value) {
        this.myMethod = new PluginParameter<SCAN_METHOD>(this.myMethod, value);
        return this;
    }

    public Integer blockingWindowSize() {
        return this.myBlockingWindowSize.value();
    }

    public VCAPScanPlugin blockingWindowSize(Integer value) {
        this.myBlockingWindowSize = new PluginParameter<Integer>(this.myBlockingWindowSize, value);
        return this;
    }

    public Integer numSitesPerBlock() {
        return this.myNumSitesPerBlock.value();
    }

    public VCAPScanPlugin numSitesPerBlock(Integer value) {
        this.myNumSitesPerBlock = new PluginParameter<Integer>(this.myNumSitesPerBlock, value);
        return this;
    }

    public Integer stepSize() {
        return this.myStepSize.value();
    }

    public VCAPScanPlugin stepSize(Integer value) {
        this.myStepSize = new PluginParameter<Integer>(this.myStepSize, value);
        return this;
    }

    public String dirOfFiles() {
        return this.myDirOfFiles.value();
    }

    public VCAPScanPlugin dirOfFiles(String value) {
        this.myDirOfFiles = new PluginParameter<String>(this.myDirOfFiles, value);
        return this;
    }

    public String bedFile() {
        return this.myBedFile.value();
    }

    public VCAPScanPlugin bedFile(String value) {
        this.myBedFile = new PluginParameter<String>(this.myBedFile, value);
        return this;
    }

    public String blockingBedFile() {
        return this.myBlockingBedFile.value();
    }

    public VCAPScanPlugin blockingBedFile(String value) {
        this.myBlockingBedFile = new PluginParameter<String>(this.myBlockingBedFile, value);
        return this;
    }

    public String phenotypeFile() {
        return this.myPhenotypeFile.value();
    }

    public VCAPScanPlugin phenotypeFile(String value) {
        this.myPhenotypeFile = new PluginParameter<String>(this.myPhenotypeFile, value);
        return this;
    }

    public String ldakCommand() {
        return this.myLDAKCommand.value();
    }

    public VCAPScanPlugin ldakCommand(String value) {
        this.myLDAKCommand = new PluginParameter<String>(this.myLDAKCommand, value);
        return this;
    }

    public String outputDir() {
        return this.myOutputDir.value();
    }

    public VCAPScanPlugin outputDir(String value) {
        this.myOutputDir = new PluginParameter<String>(this.myOutputDir, value);
        return this;
    }

    public String wholeMatrix() {
        return this.myWholeMatrix.value();
    }

    public VCAPScanPlugin wholeMatrix(String value) {
        this.myWholeMatrix = new PluginParameter<String>(this.myWholeMatrix, value);
        return this;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = VCAPScanPlugin.class.getResource("/net/maizegenetics/analysis/images/VCAP.png");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "VCAP Scan";
    }

    @Override
    public String getToolTipText() {
        return "Variance Component Annotation Pipeline Scan";
    }

    @Override
    public String pluginUserManualURL() {
        return "https://bitbucket.org/tasseladmin/tassel-5-source/wiki/UserManual/VCAPScan/VCAPScan";
    }

    private class ChrPos
    implements Comparable<ChrPos> {
        private final int myChr;
        private final int myPos;

        public ChrPos(int chr, int pos) {
            this.myChr = chr;
            this.myPos = pos;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ChrPos)) {
                return false;
            }
            ChrPos other = (ChrPos)obj;
            return this.myChr == other.myChr && this.myPos == other.myPos;
        }

        public int hashCode() {
            int hash = 5;
            hash = 37 * hash + this.myChr;
            hash = 37 * hash + this.myPos;
            return hash;
        }

        @Override
        public int compareTo(ChrPos o) {
            if (this.myChr < o.myChr) {
                return -1;
            }
            if (this.myChr > o.myChr) {
                return 1;
            }
            if (this.myPos < o.myPos) {
                return -1;
            }
            if (this.myPos > o.myPos) {
                return 1;
            }
            return 0;
        }
    }

    public static enum SCAN_METHOD {
        Chromosome,
        Site_Blocks,
        Directory_Of_Files,
        Bed_File;

    }
}

