/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.filter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.maizegenetics.analysis.data.SeparatePlugin;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.snp.CombineGenotypeTable;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.prefs.TasselPrefs;
import org.apache.log4j.Logger;

public class FilterAlignmentPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(FilterAlignmentPlugin.class);
    private int myStart = 0;
    private int myEnd = -1;
    private int myStartPos = -1;
    private int myEndPos = -1;
    private Chromosome myLocus = null;
    private String myLocusStr = null;
    private int myMinCount = 1;
    private double myMinFreq = TasselPrefs.getFilterAlignPluginMinFreq();
    private double myMaxFreq = 1.0;
    private boolean myExtractIndels = false;
    private boolean myFilterMinorSNPs = false;
    private boolean myIsUseAllSiteTypes = true;
    private boolean myDoSlidingHaps = false;
    private int myWinSize = 3;
    private int myStepSize = 3;

    public FilterAlignmentPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            List<Datum> alignInList = input.getDataOfType(GenotypeTable.class);
            if (alignInList.size() < 1) {
                String gpMessage = "Invalid selection.  Please select genotype alignment.";
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), gpMessage);
                } else {
                    myLogger.error((Object)gpMessage);
                }
                DataSet dataSet = null;
                return dataSet;
            }
            ArrayList<Datum> alignOutList = new ArrayList<Datum>();
            for (Datum current : alignInList) {
                Datum result = this.processDatum(current, this.isInteractive());
                if (result == null) continue;
                alignOutList.add(result);
            }
            if (alignOutList.isEmpty()) {
                Datum current;
                current = null;
                return current;
            }
            DataSet output = new DataSet(alignOutList, (Plugin)this);
            this.fireDataSetReturned(new PluginEvent(output, FilterAlignmentPlugin.class));
            DataSet dataSet = output;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    private Datum processDatum(Datum inDatum, boolean isInteractive) {
        Chromosome theLocus;
        GenotypeTable aa = (GenotypeTable)inDatum.getData();
        if (this.myEnd == -1) {
            this.myEnd = aa.numberOfSites() - 1;
        }
        if ((theLocus = this.myLocus) == null && this.myLocusStr != null) {
            theLocus = aa.chromosome(this.myLocusStr);
            if (theLocus == null) {
                throw new IllegalStateException("FilterAlignmentPlugin: processDatum: Alignment doesn't contain locus: " + this.myLocusStr);
            }
            if (this.myStartPos == -1) {
                int[] startEnd = aa.firstLastSiteOfChromosome(theLocus);
                this.myStart = startEnd[0];
                this.myEnd = startEnd[1];
            }
        }
        if (this.myStartPos != -1) {
            this.myStart = aa.siteOfPhysicalPosition(this.myStartPos, theLocus);
            if (this.myStart < 0) {
                this.myStart = -(this.myStart + 1);
            }
        }
        if (this.myEndPos != -1) {
            this.myEnd = aa.siteOfPhysicalPosition(this.myEndPos, theLocus);
            if (this.myEnd < 0) {
                this.myEnd = -(this.myEnd + 2);
            }
        }
        if (this.myEnd < this.myStart) {
            throw new IllegalStateException("FilterAlignmentPlugin: processDatum: Start Site can't be after End Site.");
        }
        if (isInteractive) {
            DataFilterAlignmentDialog theDialog = new DataFilterAlignmentDialog(aa, this.getParentFrame());
            theDialog.setLocationRelativeTo(this.getParentFrame());
            theDialog.setVisible(true);
            if (theDialog.isCanceled()) {
                return null;
            }
            aa = theDialog.getChromFilteredAlignment();
            this.myStart = theDialog.getStart();
            this.myEnd = theDialog.getEnd();
            this.myMinCount = theDialog.getMinimumCount();
            this.myMinFreq = theDialog.getMinimumFrequency();
            this.myMaxFreq = theDialog.getMaximumFrequency();
            this.myExtractIndels = theDialog.isExtractIndels();
            this.myFilterMinorSNPs = theDialog.isRemoveMinorSNPs();
            this.myIsUseAllSiteTypes = theDialog.isAllSiteIncluded();
            this.myDoSlidingHaps = theDialog.isUseSlidingWindow();
            this.myWinSize = theDialog.getWindowSize();
            this.myStepSize = theDialog.getStepSize();
            theDialog.dispose();
        }
        if (this.myStart >= aa.numberOfSites()) {
            throw new IllegalArgumentException("FilterAlignmentPlugin: starting site can't be past end of alignment.");
        }
        if (this.myEnd < 0 || this.myEnd < this.myStart) {
            throw new IllegalArgumentException("FilterAlignmentPlugin: end site can't be less than zero or less that starting site.");
        }
        if (this.myStart < 0) {
            this.myStart = 0;
        }
        if (this.myEnd >= aa.numberOfSites()) {
            this.myEnd = aa.numberOfSites() - 1;
        }
        GenotypeTable naa = aa;
        if (this.myFilterMinorSNPs) {
            naa = GenotypeTableBuilder.getInstanceOnlyMajorMinor(naa);
        }
        if (this.myStart != 0 || this.myEnd < naa.numberOfSites() - 1) {
            naa = FilterGenotypeTable.getInstance(naa, this.myStart, this.myEnd);
        }
        if (this.myExtractIndels) {
            throw new UnsupportedOperationException();
        }
        naa = GenotypeTableUtils.removeSitesBasedOnFreqIgnoreMissing(naa, this.myMinFreq, this.myMaxFreq, this.myMinCount);
        if (this.myDoSlidingHaps) {
            throw new UnsupportedOperationException();
        }
        StringBuilder builder = new StringBuilder();
        Chromosome[] loci = naa.chromosomes();
        builder.append(inDatum.getName());
        builder.append("_");
        if (loci != null && loci.length != 0) {
            boolean first = true;
            for (int i = 0; i < loci.length; ++i) {
                String name = loci[i].getName();
                if (name == null || name.length() == 0) continue;
                if (first) {
                    builder.append("chr");
                    first = false;
                }
                builder.append(name);
                builder.append("_");
            }
        }
        if (naa.numberOfSites() > 1) {
            builder.append(naa.chromosomalPosition(0));
            builder.append("-");
            builder.append(naa.chromosomalPosition(naa.numberOfSites() - 1));
        }
        String theName = builder.toString();
        String theComment = this.myDoSlidingHaps ? "Sliding Haplotypes.\n" : (this.myExtractIndels ? "Indels Extracted\n" : (this.myFilterMinorSNPs ? "Minor SNPs Removed\n" : ""));
        if (naa.numberOfSites() != 0) {
            myLogger.info((Object)("Resulting Number Sites: " + naa.numberOfSites()));
            return new Datum(theName, naa, theComment);
        }
        if (this.isInteractive()) {
            JOptionPane.showMessageDialog(this.getParentFrame(), "No available SNPs given filter parameters.");
        } else {
            myLogger.warn((Object)"No available SNPs given filter parameters.");
        }
        return null;
    }

    public int getStart() {
        return this.myStart;
    }

    public void setStart(int start) {
        this.myStart = start;
    }

    public int getEnd() {
        return this.myEnd;
    }

    public void setEnd(int end) {
        this.myEnd = end;
    }

    public int getStartPos() {
        return this.myStartPos;
    }

    public void setStartPos(int start) {
        this.myStartPos = start;
    }

    public int getEndPos() {
        return this.myEndPos;
    }

    public void setEndPos(int end) {
        this.myEndPos = end;
    }

    public String getLocusStr() {
        return this.myLocusStr;
    }

    public void setLocusStr(String name) {
        this.myLocus = null;
        this.myLocusStr = name;
    }

    public Chromosome getLocus() {
        return this.myLocus;
    }

    public void setLocus(Chromosome locus) {
        this.myLocusStr = null;
        this.myLocus = locus;
    }

    public int getMinCount() {
        return this.myMinCount;
    }

    public void setMinCount(int minCount) {
        this.myMinCount = minCount;
    }

    public double getMinFreq() {
        return this.myMinFreq;
    }

    public void setMinFreq(double minFreq) {
        this.myMinFreq = minFreq;
    }

    public double getMaxFreq() {
        return this.myMaxFreq;
    }

    public void setMaxFreq(double maxFreq) {
        this.myMaxFreq = maxFreq;
    }

    public boolean isExtractIndels() {
        return this.myExtractIndels;
    }

    public void setExtractIndels(boolean extractIndels) {
        this.myExtractIndels = extractIndels;
    }

    public boolean isFilterMinorSNPs() {
        return this.myFilterMinorSNPs;
    }

    public void setFilterMinorSNPs(boolean filterMinorSNPs) {
        this.myFilterMinorSNPs = filterMinorSNPs;
    }

    public boolean isUseAllSiteTypes() {
        return this.myIsUseAllSiteTypes;
    }

    public void setUseAllSiteTypes(boolean useAllSiteTypes) {
        this.myIsUseAllSiteTypes = useAllSiteTypes;
    }

    public boolean isDoSlidingHaps() {
        return this.myDoSlidingHaps;
    }

    public void setDoSlidingHaps(boolean doSlidingHaps) {
        this.myDoSlidingHaps = doSlidingHaps;
    }

    public int getWinSize() {
        return this.myWinSize;
    }

    public void setWinSize(int winSize) {
        this.myWinSize = winSize;
    }

    public int getStepSize() {
        return this.myStepSize;
    }

    public void setStepSize(int stepSize) {
        this.myStepSize = stepSize;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = FilterAlignmentPlugin.class.getResource("/net/maizegenetics/analysis/images/Filter.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Sites";
    }

    @Override
    public String getToolTipText() {
        return "Filter and Process Alignment";
    }

    class ChromosomeFilterDialog
    extends JDialog {
        private int numChromsSelected;
        private boolean isCanceled;
        private JPanel mainPanel;
        private JPanel checkBoxPanel;
        private JLabel lblChromSelect;
        private JButton okayButton;
        private JButton cancelButton;
        private JCheckBox selectAllCheckBox;
        private JCheckBox[] selectChromsCheckBoxes;
        private GridBagLayout gridBagLayout;

        public ChromosomeFilterDialog(String[] chromNames, Frame f) {
            super(f, "Filter Alignment", true);
            this.isCanceled = true;
            this.mainPanel = new JPanel();
            this.checkBoxPanel = new JPanel();
            this.lblChromSelect = new JLabel();
            this.okayButton = new JButton();
            this.cancelButton = new JButton();
            this.selectAllCheckBox = new JCheckBox();
            this.gridBagLayout = new GridBagLayout();
            this.selectChromsCheckBoxes = new JCheckBox[chromNames.length];
            this.selectAllCheckBox.setText("Select/Deselect All");
            this.selectAllCheckBox.setSelected(true);
            for (int i = 0; i < chromNames.length; ++i) {
                this.selectChromsCheckBoxes[i] = new JCheckBox(chromNames[i]);
                this.selectChromsCheckBoxes[i].setSelected(true);
            }
            this.numChromsSelected = chromNames.length;
            try {
                this.initUI();
                this.pack();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        void initUI() throws Exception {
            int i;
            this.lblChromSelect.setFont(new Font("Dialog", 1, 16));
            this.lblChromSelect.setText("Select Chromosomes to Filter");
            this.mainPanel.setMinimumSize(new Dimension(480, 480));
            this.mainPanel.setPreferredSize(new Dimension(480, 480));
            this.mainPanel.setLayout(this.gridBagLayout);
            this.okayButton.setMaximumSize(new Dimension(63, 27));
            this.okayButton.setMinimumSize(new Dimension(63, 27));
            this.okayButton.setText("Select");
            this.okayButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChromosomeFilterDialog.this.okayButton_actionPerformed(e);
                }
            });
            this.cancelButton.setMaximumSize(new Dimension(63, 27));
            this.cancelButton.setMinimumSize(new Dimension(63, 27));
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChromosomeFilterDialog.this.cancelButton_actionPerformed(e);
                }
            });
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(this.okayButton);
            buttonPanel.add(this.cancelButton);
            this.selectAllCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChromosomeFilterDialog.this.selectAllCheckBox_actionPerformed(e);
                }
            });
            for (i = 0; i < this.selectChromsCheckBoxes.length; ++i) {
                this.selectChromsCheckBoxes[i].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ChromosomeFilterDialog.this.checkBox_actionPerformed(e);
                    }
                });
            }
            this.checkBoxPanel.setLayout(new GridLayout(0, 2));
            for (i = 0; i < this.selectChromsCheckBoxes.length; ++i) {
                this.checkBoxPanel.add(this.selectChromsCheckBoxes[i]);
            }
            this.checkBoxPanel.add(this.selectAllCheckBox);
            this.mainPanel.add((Component)this.lblChromSelect, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
            this.mainPanel.add((Component)this.checkBoxPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(20, 40, 5, 0), 15, 0));
            this.mainPanel.add((Component)buttonPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 20, 0, new Insets(5, 0, 5, 0), 0, 0));
            this.add((Component)this.mainPanel, "Center");
        }

        public String[] getChromsSelected() {
            String[] chroms = new String[this.numChromsSelected];
            int j = 0;
            for (int i = 0; i < this.selectChromsCheckBoxes.length; ++i) {
                if (!this.selectChromsCheckBoxes[i].isSelected()) continue;
                chroms[j] = this.selectChromsCheckBoxes[i].getText();
                ++j;
            }
            return chroms;
        }

        private void okayButton_actionPerformed(ActionEvent e) {
            if (this.numChromsSelected != 0) {
                this.isCanceled = false;
                this.setVisible(false);
            } else {
                JOptionPane.showMessageDialog(this.getParent(), "Please select at least one chromosome.");
            }
        }

        private void cancelButton_actionPerformed(ActionEvent e) {
            this.isCanceled = true;
            this.setVisible(false);
        }

        private void selectAllCheckBox_actionPerformed(ActionEvent e) {
            if (((JCheckBox)e.getSource()).isSelected()) {
                for (int i = 0; i < this.selectChromsCheckBoxes.length; ++i) {
                    this.selectChromsCheckBoxes[i].setSelected(true);
                }
                this.numChromsSelected = this.selectChromsCheckBoxes.length;
            } else {
                for (int i = 0; i < this.selectChromsCheckBoxes.length; ++i) {
                    this.selectChromsCheckBoxes[i].setSelected(false);
                }
                this.numChromsSelected = 0;
            }
        }

        private void checkBox_actionPerformed(ActionEvent e) {
            if (!((JCheckBox)e.getSource()).isSelected()) {
                this.selectAllCheckBox.setSelected(false);
                --this.numChromsSelected;
            } else {
                ++this.numChromsSelected;
                if (this.numChromsSelected == this.selectChromsCheckBoxes.length) {
                    this.selectAllCheckBox.setSelected(true);
                }
            }
        }

        public boolean isCanceled() {
            return this.isCanceled;
        }
    }

    class DataFilterAlignmentDialog
    extends JDialog {
        private final Logger myLogger;
        GenotypeTable theAlignment;
        GenotypeTable chromFilteredAlignment;
        int start;
        int end;
        int startPos;
        int endPos;
        int minCount;
        int totalSeq;
        int siteCount;
        String[] chromsAvailable;
        String[] chromsSelected;
        double minFreq;
        double maxFreq;
        double minPercentage;
        boolean isCanceled;
        private static final int TEXT_FIELD_WIDTH = 8;
        private static final int INVALID_VALUE = -999;
        private JPanel mainPanel;
        private JButton filterButton;
        private JButton cancelButton;
        private JButton chromSelectButton;
        private JLabel lblFilterAlignment;
        private JLabel lblTotalSequences;
        private JLabel lblMinCount;
        private JLabel lblMinFreq;
        private JLabel lblMaxFreq;
        private JLabel lblStartSite;
        private JLabel lblDistanceFromEndSite;
        private JLabel lblEndSite;
        private JLabel lblSeqLength;
        private JLabel lblWinSize;
        private JLabel lblStepSize;
        private JLabel lblPosType;
        private JLabel lblSiteIndex;
        private JLabel lblSitePos;
        private JTextField countTextField;
        private JTextField endTextField;
        private JTextField startTextField;
        private JTextField endPosTextField;
        private JTextField startPosTextField;
        private JTextField freqTextField;
        private JTextField maxFreqTextField;
        private JTextField winSizeTextField;
        private JTextField stepSizeTextField;
        private JPanel checkBoxPanel;
        private JCheckBox removeMinorCheckBox;
        private JCheckBox slidingHapCheckBox;
        private GridBagLayout gridBagLayout2;
        private String lblEndString;
        private boolean doBatchAnalysis;
        private boolean isStartTextFieldNumeric;
        private boolean isEndTextFieldNumeric;
        private boolean isStartPosTextFieldNumeric;
        private boolean isEndPosTextFieldNumeric;
        private boolean isChromSelectionValid;
        private ChromosomeFilterDialog myChromFilter;

        public DataFilterAlignmentDialog(GenotypeTable a, Frame f) {
            super(f, "Filter Alignment", true);
            this.myLogger = Logger.getLogger(DataFilterAlignmentDialog.class);
            this.start = 0;
            this.minCount = 0;
            this.siteCount = 0;
            this.minFreq = 0.01;
            this.maxFreq = 1.0;
            this.minPercentage = 0.5;
            this.isCanceled = true;
            this.mainPanel = new JPanel();
            this.filterButton = new JButton();
            this.cancelButton = new JButton();
            this.chromSelectButton = new JButton();
            this.lblFilterAlignment = new JLabel();
            this.lblTotalSequences = new JLabel();
            this.lblMinCount = new JLabel();
            this.lblMinFreq = new JLabel();
            this.lblMaxFreq = new JLabel();
            this.lblStartSite = new JLabel();
            this.lblDistanceFromEndSite = new JLabel();
            this.lblEndSite = new JLabel();
            this.lblSeqLength = new JLabel();
            this.lblWinSize = new JLabel();
            this.lblStepSize = new JLabel();
            this.lblPosType = new JLabel();
            this.lblSiteIndex = new JLabel();
            this.lblSitePos = new JLabel();
            this.countTextField = new JTextField();
            this.endTextField = new JTextField();
            this.startTextField = new JTextField();
            this.endPosTextField = new JTextField();
            this.startPosTextField = new JTextField();
            this.freqTextField = new JTextField();
            this.maxFreqTextField = new JTextField();
            this.winSizeTextField = new JTextField(8);
            this.stepSizeTextField = new JTextField(8);
            this.checkBoxPanel = new JPanel();
            this.removeMinorCheckBox = new JCheckBox();
            this.slidingHapCheckBox = new JCheckBox();
            this.gridBagLayout2 = new GridBagLayout();
            this.lblEndString = "End Position:";
            this.doBatchAnalysis = false;
            this.isStartTextFieldNumeric = true;
            this.isEndTextFieldNumeric = true;
            this.isStartPosTextFieldNumeric = true;
            this.isEndPosTextFieldNumeric = true;
            this.isChromSelectionValid = true;
            this.chromFilteredAlignment = this.theAlignment = a;
            this.chromsAvailable = new String[this.theAlignment.numChromosomes()];
            for (int i = 0; i < this.chromsAvailable.length; ++i) {
                this.chromsAvailable[i] = this.theAlignment.chromosomes()[i].getName().trim();
            }
            this.totalSeq = this.theAlignment.numberOfTaxa();
            this.siteCount = this.theAlignment.numberOfSites();
            this.lblSeqLength.setText(" of " + (this.siteCount - 1) + " sites");
            this.lblMinCount.setText("Minimum PERCENTAGE:");
            this.start = 0;
            this.end = this.siteCount - 1;
            this.startPos = this.theAlignment.chromosomalPosition(0);
            this.endPos = this.theAlignment.chromosomalPosition(this.siteCount - 1);
            this.minCount = TasselPrefs.getFilterAlignPluginMinCount();
            this.minFreq = FilterAlignmentPlugin.this.myMinFreq;
            this.maxFreq = TasselPrefs.getFilterAlignPluginMaxFreq();
            this.myChromFilter = new ChromosomeFilterDialog(this.chromsAvailable, f);
            try {
                this.initUI();
                this.pack();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        void initUI() throws Exception {
            this.mainPanel.setMinimumSize(new Dimension(640, 480));
            this.mainPanel.setPreferredSize(new Dimension(640, 480));
            this.mainPanel.setLayout(this.gridBagLayout2);
            this.filterButton.setText("Filter");
            this.filterButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataFilterAlignmentDialog.this.filterButton_actionPerformed(e);
                }
            });
            this.cancelButton.setMaximumSize(new Dimension(63, 27));
            this.cancelButton.setMinimumSize(new Dimension(63, 27));
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataFilterAlignmentDialog.this.cancelButton_actionPerformed(e);
                }
            });
            this.chromSelectButton.setText("Select Chromosomes...");
            this.chromSelectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataFilterAlignmentDialog.this.chromSelectButton_actionPerformed(e);
                }
            });
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new GridLayout(1, 3));
            buttonPanel.add(this.filterButton);
            if (this.chromsAvailable.length != 1) {
                buttonPanel.add(this.chromSelectButton);
            }
            buttonPanel.add(this.cancelButton);
            this.lblFilterAlignment.setFont(new Font("Dialog", 1, 16));
            this.lblFilterAlignment.setText("Filter Alignment");
            this.lblMinFreq.setText("Minimum Frequency:");
            this.lblMaxFreq.setText("Maximum Frequency:");
            this.lblStartSite.setText("Start Position:");
            this.lblPosType.setText("Position Type:");
            this.lblSiteIndex.setText(" Position index");
            this.lblSitePos.setText(" Physical Position (AGP)");
            this.lblEndSite.setText(this.lblEndString);
            this.countTextField.setMinimumSize(new Dimension(40, 25));
            this.countTextField.setPreferredSize(new Dimension(63, 25));
            if (this.doBatchAnalysis) {
                this.countTextField.setText(this.minPercentage + "");
            } else {
                this.countTextField.setText(this.minCount + "");
            }
            this.countTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    DataFilterAlignmentDialog.this.countTextField_focusLost(e);
                }
            });
            this.setEndTextField();
            this.endTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    DataFilterAlignmentDialog.this.endTextField_focusLost(e);
                }
            });
            this.endTextField.setPreferredSize(new Dimension(63, 25));
            this.endTextField.setMinimumSize(new Dimension(40, 25));
            this.startTextField.setText(this.start + "");
            this.startTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    DataFilterAlignmentDialog.this.startTextField_focusLost(e);
                }
            });
            this.startTextField.setPreferredSize(new Dimension(63, 25));
            this.startTextField.setMinimumSize(new Dimension(40, 25));
            this.endPosTextField.setText(this.endPos + "");
            this.endPosTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    DataFilterAlignmentDialog.this.endPosTextField_focusLost(e);
                }
            });
            this.endPosTextField.setPreferredSize(new Dimension(63, 25));
            this.endPosTextField.setMinimumSize(new Dimension(40, 25));
            this.startPosTextField.setText(this.startPos + "");
            this.startPosTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    DataFilterAlignmentDialog.this.startPosTextField_focusLost(e);
                }
            });
            this.startPosTextField.setPreferredSize(new Dimension(63, 25));
            this.startPosTextField.setMinimumSize(new Dimension(40, 25));
            this.freqTextField.setText(this.minFreq + "");
            this.freqTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    DataFilterAlignmentDialog.this.freqTextField_focusLost(e);
                }
            });
            this.freqTextField.setPreferredSize(new Dimension(63, 25));
            this.freqTextField.setMinimumSize(new Dimension(40, 25));
            this.maxFreqTextField.setText(this.maxFreq + "");
            this.maxFreqTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    DataFilterAlignmentDialog.this.maxFreqTextField_focusLost(e);
                }
            });
            this.maxFreqTextField.setPreferredSize(new Dimension(63, 25));
            this.maxFreqTextField.setMinimumSize(new Dimension(40, 25));
            if (!this.doBatchAnalysis) {
                this.lblMinCount.setText("Minimum Count:");
                this.lblTotalSequences.setText(" out of " + this.totalSeq + " sequences");
            }
            this.removeMinorCheckBox.setText("Remove minor SNP states");
            this.removeMinorCheckBox.setOpaque(false);
            this.slidingHapCheckBox.setText("Generate haplotypes via sliding window");
            this.slidingHapCheckBox.setOpaque(false);
            this.slidingHapCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean enable = DataFilterAlignmentDialog.this.slidingHapCheckBox.isSelected();
                    if (!enable) {
                        DataFilterAlignmentDialog.this.winSizeTextField.setText("");
                        DataFilterAlignmentDialog.this.stepSizeTextField.setText("");
                    }
                    DataFilterAlignmentDialog.this.winSizeTextField.setEnabled(enable);
                    DataFilterAlignmentDialog.this.stepSizeTextField.setEnabled(enable);
                    DataFilterAlignmentDialog.this.lblWinSize.setEnabled(enable);
                    DataFilterAlignmentDialog.this.lblStepSize.setEnabled(enable);
                }
            });
            this.lblStepSize.setText("Step Length");
            this.lblWinSize.setText("Haplotype Length");
            this.lblStepSize.setLabelFor(this.stepSizeTextField);
            this.lblWinSize.setLabelFor(this.winSizeTextField);
            this.winSizeTextField.setEnabled(false);
            this.stepSizeTextField.setEnabled(false);
            this.lblWinSize.setEnabled(false);
            this.lblStepSize.setEnabled(false);
            JPanel winSizePanel = new JPanel();
            FlowLayout fl = new FlowLayout(2);
            winSizePanel.setLayout(fl);
            winSizePanel.add(this.lblWinSize);
            winSizePanel.add(this.winSizeTextField);
            JPanel stepSizePanel = new JPanel();
            stepSizePanel.setLayout(fl);
            stepSizePanel.add(this.lblStepSize);
            stepSizePanel.add(this.stepSizeTextField);
            this.checkBoxPanel.setLayout(new GridLayout(6, 1));
            this.checkBoxPanel.add(this.removeMinorCheckBox);
            this.checkBoxPanel.add(this.slidingHapCheckBox);
            this.checkBoxPanel.add(winSizePanel);
            this.checkBoxPanel.add(stepSizePanel);
            this.mainPanel.add((Component)this.lblFilterAlignment, new GridBagConstraints(1, 0, 4, 1, 1.0, 1.0, 10, 2, new Insets(5, 0, 0, 5), 0, 12));
            this.mainPanel.add((Component)this.lblMinCount, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 37, 14));
            this.mainPanel.add((Component)this.lblMinFreq, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 37, 14));
            this.mainPanel.add((Component)this.lblMaxFreq, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 37, 14));
            this.mainPanel.add((Component)this.lblPosType, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 37, 14));
            this.mainPanel.add((Component)this.lblStartSite, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 37, 14));
            this.mainPanel.add((Component)this.lblDistanceFromEndSite, new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 37, 14));
            this.mainPanel.add((Component)this.countTextField, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 12, 0));
            this.mainPanel.add((Component)this.lblTotalSequences, new GridBagConstraints(3, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 42, 3));
            this.mainPanel.add((Component)this.freqTextField, new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 12, 0));
            this.mainPanel.add((Component)this.maxFreqTextField, new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 12, 0));
            this.mainPanel.add((Component)this.lblSiteIndex, new GridBagConstraints(2, 4, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 42, 3));
            this.mainPanel.add((Component)this.startTextField, new GridBagConstraints(2, 5, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 12, 0));
            this.mainPanel.add((Component)this.lblSitePos, new GridBagConstraints(3, 4, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 42, 3));
            this.mainPanel.add((Component)this.startPosTextField, new GridBagConstraints(3, 5, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 12, 0));
            this.lblSitePos.setVisible(this.theAlignment.numChromosomes() == 1 && this.startPos >= 0);
            this.startPosTextField.setVisible(this.theAlignment.numChromosomes() == 1 && this.startPos >= 0);
            if (!this.doBatchAnalysis) {
                this.mainPanel.add((Component)this.lblEndSite, new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 37, 14));
                this.mainPanel.add((Component)this.endTextField, new GridBagConstraints(2, 6, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 12, 0));
                this.mainPanel.add((Component)this.endPosTextField, new GridBagConstraints(3, 6, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 12, 0));
                this.endPosTextField.setVisible(this.theAlignment.numChromosomes() == 1 && this.endPos >= 0);
                this.mainPanel.add((Component)this.lblSeqLength, new GridBagConstraints(2, 7, 1, 1, 1.0, 0.6, 17, 0, new Insets(0, 0, 0, 0), 0, 3));
            }
            this.mainPanel.add((Component)this.checkBoxPanel, new GridBagConstraints(0, 8, 2, 1, 1.0, 1.0, 10, 2, new Insets(15, 2, 11, 19), 0, 15));
            this.mainPanel.add((Component)buttonPanel, new GridBagConstraints(0, 12, 4, 1, 1.0, 1.0, 15, 0, new Insets(20, 50, 14, 12), 25, 12));
            this.add((Component)this.mainPanel, "Center");
        }

        private void filterButton_actionPerformed(ActionEvent e) {
            if (this.start < 0) {
                JOptionPane.showMessageDialog(this.getParent(), "Start site must be non negative.");
            } else if (this.start >= this.siteCount) {
                JOptionPane.showMessageDialog(this.getParent(), "Start site must be less than " + this.siteCount + ".");
            } else if (!this.isStartTextFieldNumeric) {
                JOptionPane.showMessageDialog(this.getParent(), "Start site must be a number between 0 and " + (this.siteCount - 1) + " inclusive.");
            } else if (this.end < 0) {
                JOptionPane.showMessageDialog(this.getParent(), "End site must be non negative.");
            } else if (this.end >= this.siteCount) {
                JOptionPane.showMessageDialog(this.getParent(), "End site must be less than " + this.siteCount + ".");
            } else if (!this.isEndTextFieldNumeric) {
                JOptionPane.showMessageDialog(this.getParent(), "End site must be a number between 0 and " + (this.siteCount - 1) + " inclusive.");
            } else if (this.start > this.end) {
                JOptionPane.showMessageDialog(this.getParent(), "Start site must be less than the end site.");
            } else if (this.startPos < 0 && this.endPos >= 0 && this.theAlignment.numChromosomes() == 1) {
                JOptionPane.showMessageDialog(this.getParent(), "Start position must be non negative.");
            } else if (this.startPos > this.theAlignment.chromosomalPosition(this.siteCount - 1) && this.theAlignment.numChromosomes() == 1) {
                JOptionPane.showMessageDialog(this.getParent(), "No available SNPs with positions greater than " + this.theAlignment.chromosomalPosition(this.siteCount - 1) + ".");
            } else if (!this.isStartPosTextFieldNumeric) {
                JOptionPane.showMessageDialog(this.getParent(), "Start position must be a number between 0 and " + this.theAlignment.chromosomalPosition(this.siteCount - 1) + " inclusive.");
            } else if (this.endPos < 0 && this.startPos >= 0 && this.theAlignment.numChromosomes() == 1) {
                JOptionPane.showMessageDialog(this.getParent(), "End Position must be non negative.");
            } else if (this.endPos < this.theAlignment.chromosomalPosition(0) && this.theAlignment.numChromosomes() == 1) {
                JOptionPane.showMessageDialog(this.getParent(), "No available SNPs with positions less than " + this.theAlignment.chromosomalPosition(0) + ".");
            } else if (!this.isEndPosTextFieldNumeric) {
                JOptionPane.showMessageDialog(this.getParent(), "End position must be a number greater than " + this.theAlignment.chromosomalPosition(0) + ".");
            } else if (this.startPos > this.endPos && this.theAlignment.numChromosomes() == 1) {
                JOptionPane.showMessageDialog(this.getParent(), "Start position must be less than the end position.");
            } else if (!this.isChromSelectionValid) {
                JOptionPane.showMessageDialog(this.getParent(), "Invalid chromosome selection");
            } else {
                this.isCanceled = false;
                this.setVisible(false);
            }
        }

        public boolean isAllSiteIncluded() {
            return true;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public double getMinimumFrequency() {
            return this.minFreq;
        }

        public double getMaximumFrequency() {
            return this.maxFreq;
        }

        public int getMinimumCount() {
            if (this.doBatchAnalysis) {
                throw new RuntimeException("This method should not be called when using an Minimum Sequence Percentage");
            }
            return this.minCount;
        }

        public double getMinPercentage() {
            if (!this.doBatchAnalysis) {
                throw new RuntimeException("This method should not be called when using an absolute Minimum Sequence Count");
            }
            return this.minPercentage;
        }

        public boolean isExtractIndels() {
            return false;
        }

        public boolean isRemoveMinorSNPs() {
            return this.removeMinorCheckBox.isSelected();
        }

        public boolean isUseSlidingWindow() {
            return this.slidingHapCheckBox.isSelected();
        }

        public int getWindowSize() {
            int windowSize = -999;
            if (this.slidingHapCheckBox.isSelected()) {
                try {
                    windowSize = Integer.parseInt(this.winSizeTextField.getText().trim());
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(this.getParent(), "Please enter an integer.");
                }
            }
            return windowSize;
        }

        public int getStepSize() {
            int stepSize = -999;
            if (this.slidingHapCheckBox.isSelected()) {
                try {
                    stepSize = Integer.parseInt(this.stepSizeTextField.getText().trim());
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(this.getParent(), "Please enter an integer.");
                }
            }
            return stepSize;
        }

        private void cancelButton_actionPerformed(ActionEvent e) {
            this.isCanceled = true;
            this.setVisible(false);
        }

        private void chromSelectButton_actionPerformed(ActionEvent e) {
            this.myChromFilter.setLocationRelativeTo(this);
            this.myChromFilter.setVisible(true);
            if (!this.myChromFilter.isCanceled()) {
                this.chromsSelected = this.myChromFilter.getChromsSelected();
                GenotypeTable[] selectedAlignments = new GenotypeTable[this.chromsSelected.length];
                List<Datum> availableAlignments = SeparatePlugin.separateAlignmentIntoLoci(this.theAlignment, null);
                for (int i = 0; i < this.chromsSelected.length; ++i) {
                    for (int j = 0; j < availableAlignments.size(); ++j) {
                        GenotypeTable current = (GenotypeTable)availableAlignments.get(j).getData();
                        if (current.chromosomes().length != 1 || !this.chromsSelected[i].equals(current.chromosomeName(0))) continue;
                        selectedAlignments[i] = current;
                    }
                }
                this.chromFilteredAlignment = CombineGenotypeTable.getInstance(selectedAlignments);
                this.lblSitePos.setVisible(this.chromFilteredAlignment.numChromosomes() == 1 && this.startPos >= 0);
                this.startPosTextField.setVisible(this.chromFilteredAlignment.numChromosomes() == 1 && this.startPos >= 0);
                this.endPosTextField.setVisible(this.chromFilteredAlignment.numChromosomes() == 1 && this.endPos >= 0);
                this.totalSeq = this.chromFilteredAlignment.numberOfTaxa();
                this.siteCount = this.chromFilteredAlignment.numberOfSites();
                this.lblSeqLength.setText(" of " + (this.siteCount - 1) + " sites");
                this.lblMinCount.setText("Minimum Count:");
                this.start = 0;
                this.end = this.siteCount - 1;
                this.startPos = this.chromFilteredAlignment.chromosomalPosition(0);
                this.endPos = this.chromFilteredAlignment.chromosomalPosition(this.siteCount - 1);
                if (this.doBatchAnalysis) {
                    this.countTextField.setText(this.minPercentage + "");
                } else {
                    this.countTextField.setText(this.minCount + "");
                }
                this.setEndTextField();
                this.startTextField.setText(this.start + "");
                this.endPosTextField.setText(this.endPos + "");
                this.startPosTextField.setText(this.startPos + "");
            }
        }

        public String[] getChromsSelected() {
            return this.chromsSelected;
        }

        public GenotypeTable getChromFilteredAlignment() {
            return this.chromFilteredAlignment;
        }

        public boolean isCanceled() {
            return this.isCanceled;
        }

        private void setEndTextField() {
            this.endTextField.setText("" + this.end);
        }

        private void endTextField_focusLost(FocusEvent e) {
            try {
                int endFromField = Integer.parseInt(this.endTextField.getText().trim());
                if (endFromField < 0) {
                    throw new IllegalArgumentException("End Site Can't be Negative.");
                }
                if (endFromField >= this.siteCount) {
                    throw new IllegalArgumentException("End Site Can't be Greater Than: " + (this.siteCount - 1));
                }
                this.end = endFromField;
                this.endPos = this.theAlignment.chromosomalPosition(this.end);
                this.endPosTextField.setText(String.valueOf(this.endPos));
            }
            catch (Exception ee) {
                StringBuilder builder = new StringBuilder();
                builder.append("\nProblem with End Site: ");
                builder.append(this.endTextField.getText().trim());
                builder.append("\n");
                builder.append("Number Should be a Positive Integer between:\n0 and ");
                builder.append(this.siteCount - 1);
                builder.append("\n");
                builder.append(ee.getMessage());
                builder.append("\n");
                JOptionPane.showMessageDialog(this.getParent(), builder.toString(), "Error", 0);
                try {
                    this.end = this.theAlignment.siteOfPhysicalPosition(this.endPos, this.theAlignment.chromosomes()[0]);
                    this.endTextField.setText(String.valueOf(this.end));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        private void startTextField_focusLost(FocusEvent e) {
            try {
                int startFromField = Integer.parseInt(this.startTextField.getText().trim());
                if (startFromField < 0) {
                    throw new IllegalArgumentException("Start Site Can't be Negative.");
                }
                if (startFromField >= this.siteCount) {
                    throw new IllegalArgumentException("Start Site Can't be Greater Than: " + (this.siteCount - 1));
                }
                this.start = startFromField;
                this.startPos = this.theAlignment.chromosomalPosition(this.start);
                this.startPosTextField.setText(String.valueOf(this.startPos));
            }
            catch (Exception ee) {
                StringBuilder builder = new StringBuilder();
                builder.append("\nProblem with Start Site: ");
                builder.append(this.startTextField.getText().trim());
                builder.append("\n");
                builder.append("Number Should be a Positive Integer between:\n0 and ");
                builder.append(this.siteCount - 1);
                builder.append("\n");
                builder.append(ee.getMessage());
                builder.append("\n");
                JOptionPane.showMessageDialog(this.getParent(), builder.toString(), "Error", 0);
                try {
                    this.start = this.theAlignment.siteOfPhysicalPosition(this.startPos, this.theAlignment.chromosomes()[0]);
                    this.startTextField.setText(String.valueOf(this.start));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        private void endPosTextField_focusLost(FocusEvent e) {
            try {
                int endPosFromField;
                if (this.endPosTextField.getText().toLowerCase().trim().contains("e")) {
                    int expandedValue = Double.valueOf(this.endPosTextField.getText().trim()).intValue();
                    this.endPosTextField.setText("" + expandedValue);
                }
                if ((endPosFromField = Integer.parseInt(this.endPosTextField.getText().trim())) < 0) {
                    throw new IllegalArgumentException("End Position Can't be Negative.");
                }
                int endSite = this.theAlignment.siteOfPhysicalPosition(endPosFromField, this.theAlignment.chromosomes()[0]);
                if (endSite < 0) {
                    endSite = -(endSite + 1);
                }
                if (endSite >= this.siteCount) {
                    endSite = this.siteCount - 1;
                }
                this.end = endSite;
                this.endPos = this.theAlignment.chromosomalPosition(this.end);
                this.endTextField.setText(String.valueOf(this.end));
            }
            catch (Exception ee) {
                ee.printStackTrace();
                StringBuilder builder = new StringBuilder();
                builder.append("\nProblem with End Physical Position: ");
                builder.append(this.endPosTextField.getText().trim());
                builder.append("\n");
                builder.append("Number Should be a Positive Integer between: \n");
                builder.append(this.theAlignment.chromosomalPosition(0));
                builder.append(" and ");
                builder.append(this.theAlignment.chromosomalPosition(this.siteCount - 1));
                builder.append("\n");
                builder.append(ee.getMessage());
                builder.append("\n");
                JOptionPane.showMessageDialog(this.getParent(), builder.toString(), "Error", 0);
                try {
                    this.endPos = this.theAlignment.chromosomalPosition(this.end);
                    this.endPosTextField.setText(String.valueOf(this.endPos));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        private void startPosTextField_focusLost(FocusEvent e) {
            try {
                int startPosFromField;
                if (this.startPosTextField.getText().toLowerCase().trim().contains("e")) {
                    int expandedValue = Double.valueOf(this.startPosTextField.getText().trim()).intValue();
                    this.startPosTextField.setText("" + expandedValue);
                }
                if ((startPosFromField = Integer.parseInt(this.startPosTextField.getText().trim())) < 0) {
                    throw new IllegalArgumentException("Start Position Can't be Negative.");
                }
                int startSite = this.theAlignment.siteOfPhysicalPosition(startPosFromField, this.theAlignment.chromosomes()[0]);
                if (startSite < 0) {
                    startSite = -(startSite + 1);
                }
                if (startSite >= this.siteCount) {
                    startSite = this.siteCount - 1;
                }
                this.start = startSite;
                this.startPos = this.theAlignment.chromosomalPosition(this.start);
                this.startTextField.setText(String.valueOf(this.start));
            }
            catch (Exception ee) {
                this.myLogger.debug((Object)ee.getMessage(), (Throwable)ee);
                StringBuilder builder = new StringBuilder();
                builder.append("\nProblem with Start Physical Position: ");
                builder.append(this.startPosTextField.getText().trim());
                builder.append("\n");
                builder.append("Number Should be a Positive Integer between: \n");
                builder.append(this.theAlignment.chromosomalPosition(0));
                builder.append(" and ");
                builder.append(this.theAlignment.chromosomalPosition(this.siteCount - 1));
                builder.append("\n");
                builder.append(ee.getMessage());
                builder.append("\n");
                JOptionPane.showMessageDialog(this.getParent(), builder.toString(), "Error", 0);
                try {
                    this.startPos = this.theAlignment.chromosomalPosition(this.start);
                    this.startPosTextField.setText(String.valueOf(this.startPos));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        private void freqTextField_focusLost(FocusEvent e) {
            try {
                String input = this.freqTextField.getText().trim();
                double tmpMinFreq = -0.1;
                if (input != null) {
                    tmpMinFreq = Double.parseDouble(input);
                }
                if (tmpMinFreq > 1.0 || tmpMinFreq < 0.0) {
                    tmpMinFreq = this.minFreq;
                }
                this.minFreq = tmpMinFreq;
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this.getParent(), "Could not parse \"Minimum Frequency\".  Please enter a value between 0.0 and 1.0");
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            this.freqTextField.setText(this.minFreq + "");
            TasselPrefs.putFilterAlignPluginMinFreq(this.minFreq);
        }

        private void maxFreqTextField_focusLost(FocusEvent e) {
            try {
                String input = this.maxFreqTextField.getText().trim();
                double tmpMaxFreq = -0.1;
                if (input != null) {
                    tmpMaxFreq = Double.parseDouble(input);
                }
                if (tmpMaxFreq > 1.0 || tmpMaxFreq < 0.0) {
                    tmpMaxFreq = this.maxFreq;
                }
                this.maxFreq = tmpMaxFreq;
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this.getParent(), "Could not parse \"Maximum Frequency\".  Please enter a value between 0.0 and 1.0");
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            this.maxFreqTextField.setText(this.maxFreq + "");
            TasselPrefs.putFilterAlignPluginMaxFreq(this.maxFreq);
        }

        private void countTextField_focusLost(FocusEvent e) {
            if (this.doBatchAnalysis) {
                double minPercentageOriginal = this.minPercentage;
                try {
                    this.minPercentage = Double.parseDouble(this.countTextField.getText().trim());
                    if (this.minPercentage > 1.0 || this.minPercentage < 0.0) {
                        this.minPercentage = minPercentageOriginal;
                    }
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    this.minPercentage = minPercentageOriginal;
                }
                this.countTextField.setText(this.minPercentage + "");
            } else {
                int minCountOriginal = this.minCount;
                try {
                    this.minCount = Integer.parseInt(this.countTextField.getText().trim());
                    if (this.minCount > this.theAlignment.numberOfTaxa() || this.minCount < 0) {
                        this.minCount = minCountOriginal;
                    }
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    this.minCount = minCountOriginal;
                }
                this.countTextField.setText(this.minCount + "");
                TasselPrefs.putFilterAlignPluginMinCount(this.minCount);
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(600, 600);
        }
    }
}

