/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.filter;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.FilterSite;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.genotypecall.ListStats;
import net.maizegenetics.dna.snp.genotypecall.Stats;

public class FilterBySites {
    private FilterBySites() {
    }

    public static GenotypeTable filter(GenotypeTable orig, FilterSite filter) {
        String chrPosFile;
        String bedFile;
        PositionList positions;
        int end;
        int start;
        GenotypeTable result = orig;
        int numSites = orig.numberOfSites();
        int numTaxa = orig.numberOfTaxa();
        if (filter.siteFilterType() == FilterSite.SITE_RANGE_FILTER_TYPES.SITES) {
            start = filter.startSite();
            end = filter.endSite();
            if (start < 0 || start > end || end >= orig.numberOfSites()) {
                throw new IllegalArgumentException("GenotypeTableUtils: filter: start: " + start + " or end: " + end + " site outside acceptable range.");
            }
            result = FilterGenotypeTable.getInstance(result, start, end);
        } else if (filter.siteFilterType() == FilterSite.SITE_RANGE_FILTER_TYPES.POSITIONS) {
            start = 0;
            if (filter.startPos() == -1) {
                start = orig.firstLastSiteOfChromosome(filter.startChr())[0];
            } else {
                start = orig.siteOfPhysicalPosition(filter.startPos(), filter.startChr());
                if (start < 0 && (start = -(start + 1)) >= numSites) {
                    start = numSites - 1;
                }
            }
            end = 0;
            if (filter.endPos() == -1) {
                end = orig.firstLastSiteOfChromosome(filter.endChr())[1];
            } else {
                end = orig.siteOfPhysicalPosition(filter.endPos(), filter.endChr());
                if (end < 0 && (end = -end - 2) >= numSites) {
                    end = numSites - 1;
                }
            }
            if (start < 0 || start > end || end > numSites) {
                throw new IllegalArgumentException("GenotypeTableUtils: filter: start: " + start + " or end: " + end + " site outside acceptable range.");
            }
            result = FilterGenotypeTable.getInstance(result, start, end);
        } else if (filter.siteFilterType() != FilterSite.SITE_RANGE_FILTER_TYPES.NONE) {
            throw new IllegalStateException("GenotypeTableUtils: filter: unknown SITE_RANGE_FILTER_TYPE: " + (Object)((Object)filter.siteFilterType()));
        }
        List<String> siteNames = filter.siteNames();
        if (siteNames != null) {
            result = filter.includeSites() ? FilterGenotypeTable.getInstance(result, siteNames) : FilterGenotypeTable.getInstanceRemoveSiteNames(result, siteNames);
        }
        if ((positions = filter.positionList()) != null) {
            result = GenotypeTableUtils.filterSitesByChrPos(result, positions, filter.includeSites());
        }
        if ((bedFile = filter.bedFile()) != null && !bedFile.isEmpty()) {
            result = GenotypeTableUtils.filterSitesByBedFile(result, bedFile, filter.includeSites());
        }
        if ((chrPosFile = filter.chrPosFile()) != null && !chrPosFile.isEmpty()) {
            result = GenotypeTableUtils.filterSitesByChrPos(result, chrPosFile, filter.includeSites());
        }
        Stream<Stats> stream = null;
        if (filter.removeSitesWithIndels()) {
            stream = FilterBySites.stream(result, stream);
            stream = stream.filter(stats -> !stats.hasIndel());
        }
        if (filter.siteMinCount() != 0) {
            stream = FilterBySites.stream(result, stream);
            stream = stream.filter(stats -> {
                int totalNonMissing = stats.totalGametesNonMissingForSite();
                return totalNonMissing >= filter.siteMinCount() * 2;
            });
        }
        if (filter.siteMinAlleleFreq() != 0.0 || filter.siteMaxAlleleFreq() != 1.0) {
            stream = FilterBySites.stream(result, stream);
            stream = stream.filter(stats -> {
                double maf = stats.minorAlleleFrequency();
                return filter.siteMinAlleleFreq() <= maf && filter.siteMaxAlleleFreq() >= maf;
            });
        }
        if (filter.minHeterozygous() != 0.0 || filter.maxHeterozygous() != 1.0) {
            stream = FilterBySites.stream(result, stream);
            stream = stream.filter(stats -> {
                double hetFreq = stats.proportionHeterozygous();
                return filter.minHeterozygous() <= hetFreq && filter.maxHeterozygous() >= hetFreq;
            });
        }
        if (stream != null) {
            List sitesToKeep = stream.map(stats -> stats.index()).collect(Collectors.toList());
            int[] sites = new int[sitesToKeep.size()];
            for (int i = 0; i < sitesToKeep.size(); ++i) {
                sites[i] = (Integer)sitesToKeep.get(i);
            }
            result = FilterGenotypeTable.getInstance(result, sites);
        }
        if (filter.removeMinorSNPStates()) {
            result = GenotypeTableBuilder.getInstanceOnlyMajorMinor(result);
        }
        return result;
    }

    private static Stream<Stats> stream(GenotypeTable genotypes, Stream<Stats> stream) {
        if (stream != null) {
            return stream;
        }
        ListStats siteStats = ListStats.getSiteInstance(genotypes.genotypeMatrix());
        IntStream intStream = IntStream.range(0, genotypes.numberOfSites()).parallel();
        return intStream.mapToObj(value -> (Stats)siteStats.get(value));
    }
}

