/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.filter;

import com.google.common.collect.Range;
import java.awt.Frame;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.data.GenotypeSummaryPlugin;
import net.maizegenetics.analysis.filter.FilterByTaxa;
import net.maizegenetics.dna.snp.FilterList;
import net.maizegenetics.dna.snp.FilterTaxa;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.gui.DialogUtils;
import net.maizegenetics.phenotype.GenotypePhenotype;
import net.maizegenetics.phenotype.GenotypePhenotypeBuilder;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.TaxaList;
import org.apache.log4j.Logger;

public class FilterTaxaBuilderPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(FilterTaxaBuilderPlugin.class);
    private PluginParameter<String> myFilterName = new PluginParameter.Builder<String>(FilterTaxa.FILTER_TAXA_ATTRIBUTES.filterName.name(), "Filter", String.class).description("Filter Name").build();
    private PluginParameter<Double> myMinNotMissing = new PluginParameter.Builder<Double>(FilterTaxa.FILTER_TAXA_ATTRIBUTES.minNotMissing.name(), 0.0, Double.class).guiName("Min Proportion of Sites Present").range((Range<Comparable<Double>>)Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0))).build();
    private PluginParameter<Double> myMinHeterozygous = new PluginParameter.Builder<Double>(FilterTaxa.FILTER_TAXA_ATTRIBUTES.minHeterozygous.name(), 0.0, Double.class).guiName("Min Heterozygous Proportion").range((Range<Comparable<Double>>)Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0))).build();
    private PluginParameter<Double> myMaxHeterozygous = new PluginParameter.Builder<Double>(FilterTaxa.FILTER_TAXA_ATTRIBUTES.maxHeterozygous.name(), 1.0, Double.class).guiName("Max Heterozygous Proportion").range((Range<Comparable<Double>>)Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0))).build();
    private PluginParameter<Boolean> myIncludeTaxa = new PluginParameter.Builder<Boolean>(FilterTaxa.FILTER_TAXA_ATTRIBUTES.includeTaxa.name(), true, Boolean.class).description("Include taxa from list of names or taxa list if true. Exclude otherwise.").build();
    private PluginParameter<TaxaList> myTaxaList = new PluginParameter.Builder<TaxaList>(FilterTaxa.FILTER_TAXA_ATTRIBUTES.taxaList.name(), null, TaxaList.class).description("Optional list of taxa to include. This can be a comma separated list of taxa (no spaces unless surrounded by quotes), file (.txt) with list of taxa names to include, or a taxa list file (.json or .json.gz). By default, all taxa will be included.").build();

    public FilterTaxaBuilderPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    public FilterTaxaBuilderPlugin() {
        this(null, false);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        if (input == null) {
            return;
        }
    }

    @Override
    public DataSet processData(DataSet input) {
        List<Datum> phenoGenoTableList;
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        for (Field field : this.getParameterFields()) {
            PluginParameter current = null;
            try {
                current = (PluginParameter)field.get(this);
            }
            catch (Exception e) {
                myLogger.error((Object)e.getMessage(), (Throwable)e);
            }
            if (current == null || (current.value() == null || current.value().equals(current.defaultValue())) && !current.cmdLineName().equals(FilterTaxa.FILTER_TAXA_ATTRIBUTES.filterName.name())) continue;
            values.put(current.cmdLineName(), current.value());
        }
        ArrayList<Datum> result = new ArrayList<Datum>();
        FilterTaxa filter = new FilterTaxa(values);
        List<Datum> genotypeTableList = input.getDataOfType(GenotypeTable.class);
        if (genotypeTableList.size() >= 1) {
            for (Datum datum : genotypeTableList) {
                GenotypeTable current = (GenotypeTable)datum.getData();
                GenotypeTable filteredGenotype = FilterByTaxa.filter(current, filter);
                if (filteredGenotype == null || filteredGenotype.numberOfTaxa() == 0) {
                    DialogUtils.showWarning("No genotype data remained after filtering: " + datum.getName(), this.getParentFrame());
                    continue;
                }
                if (filteredGenotype != current) {
                    Datum temp = new Datum(datum.getName() + "_" + filter.filterName(), filteredGenotype, null);
                    result.add(temp);
                    GenotypeSummaryPlugin.printSimpleSummary(temp);
                    continue;
                }
                result.add(datum);
                DialogUtils.showWarning("Genotype data unchanged after filtering: " + datum.getName(), this.getParentFrame());
            }
        }
        if ((phenoGenoTableList = input.getDataOfType(GenotypePhenotype.class)).size() >= 1) {
            for (Datum datum : phenoGenoTableList) {
                GenotypePhenotype pheno = (GenotypePhenotype)datum.getData();
                GenotypeTable current = pheno.genotypeTable();
                GenotypeTable filteredGenotype = FilterByTaxa.filter(current, filter);
                if (filteredGenotype == null || filteredGenotype.numberOfTaxa() == 0) {
                    DialogUtils.showWarning("No genotype data remained after filtering: " + datum.getName(), this.getParentFrame());
                    continue;
                }
                if (filteredGenotype != current) {
                    GenotypePhenotype resultPheno = new GenotypePhenotypeBuilder().genotype(filteredGenotype).phenotype(pheno.phenotype()).union().build();
                    String name = datum.getName() + "_" + filter.filterName();
                    Datum temp = new Datum(name, resultPheno, null);
                    result.add(temp);
                    GenotypeSummaryPlugin.printSimpleSummary(filteredGenotype, name);
                    continue;
                }
                result.add(datum);
                DialogUtils.showWarning("Genotype data unchanged after filtering: " + datum.getName(), this.getParentFrame());
            }
        }
        result.add(new Datum(filter.filterName(), new FilterList(filter), null));
        return new DataSet(result, (Plugin)this);
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = FilterTaxaBuilderPlugin.class.getResource("/net/maizegenetics/analysis/images/FilterNew.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Filter Genotype Table Taxa";
    }

    @Override
    public String getToolTipText() {
        return "Filter Genotype Table Taxa";
    }

    @Override
    public String pluginUserManualURL() {
        return "https://bitbucket.org/tasseladmin/tassel-5-source/wiki/UserManual/FilterMenu/FilterTaxaBuilderPlugin";
    }

    public FilterTaxa build() {
        return (FilterTaxa)this.performFunction(null).getData(0).getData();
    }

    public FilterTaxaBuilderPlugin useFilterValues(FilterTaxa filter) {
        this.setParametersToDefault();
        filter.attributes().entrySet().stream().forEach(attribute -> this.setParameter(((FilterTaxa.FILTER_TAXA_ATTRIBUTES)((Object)((Object)attribute.getKey()))).name(), attribute.getValue()));
        return this;
    }

    public FilterTaxa runPlugin() {
        return (FilterTaxa)this.performFunction(null).getData(0).getData();
    }

    public GenotypeTable runPlugin(DataSet input) {
        return (GenotypeTable)this.performFunction(input).getDataOfType(GenotypeTable.class).get(0).getData();
    }

    public GenotypeTable runPlugin(GenotypeTable input) {
        return (GenotypeTable)this.performFunction(DataSet.getDataSet(input)).getDataOfType(GenotypeTable.class).get(0).getData();
    }

    public String filterName() {
        return this.myFilterName.value();
    }

    public FilterTaxaBuilderPlugin filterName(String value) {
        this.myFilterName = new PluginParameter<String>(this.myFilterName, value);
        return this;
    }

    public Double minNotMissing() {
        return this.myMinNotMissing.value();
    }

    public FilterTaxaBuilderPlugin minNotMissing(Double value) {
        this.myMinNotMissing = new PluginParameter<Double>(this.myMinNotMissing, value);
        return this;
    }

    public Double minHeterozygous() {
        return this.myMinHeterozygous.value();
    }

    public FilterTaxaBuilderPlugin minHeterozygous(Double value) {
        this.myMinHeterozygous = new PluginParameter<Double>(this.myMinHeterozygous, value);
        return this;
    }

    public Double maxHeterozygous() {
        return this.myMaxHeterozygous.value();
    }

    public FilterTaxaBuilderPlugin maxHeterozygous(Double value) {
        this.myMaxHeterozygous = new PluginParameter<Double>(this.myMaxHeterozygous, value);
        return this;
    }

    public Boolean includeTaxa() {
        return this.myIncludeTaxa.value();
    }

    public FilterTaxaBuilderPlugin includeTaxa(Boolean value) {
        this.myIncludeTaxa = new PluginParameter<Boolean>(this.myIncludeTaxa, value);
        return this;
    }

    public TaxaList taxaList() {
        return this.myTaxaList.value();
    }

    public FilterTaxaBuilderPlugin taxaList(TaxaList value) {
        this.myTaxaList = new PluginParameter<TaxaList>(this.myTaxaList, value);
        return this;
    }

    public FilterTaxaBuilderPlugin taxaList(String value) {
        this.myTaxaList = new PluginParameter<TaxaList>(this.myTaxaList, FilterTaxaBuilderPlugin.convert(value, TaxaList.class));
        return this;
    }
}

