/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.filter;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.analysis.filter.FilterTraitsDialog;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.phenotype.PhenotypeBuilder;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import org.apache.log4j.Logger;

public class FilterTraitsPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(FilterTraitsPlugin.class);
    private ArrayList<int[]> includeList;
    private ArrayList<Map<PhenotypeAttribute, Phenotype.ATTRIBUTE_TYPE>> typeChangeList;
    private boolean excludeLast = false;

    public FilterTraitsPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public String getButtonName() {
        return "Traits";
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = FilterTraitsPlugin.class.getResource("/net/maizegenetics/analysis/images/FilterNew.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getToolTipText() {
        return "Exclude traits or change properties";
    }

    @Override
    public DataSet performFunction(DataSet input) {
        this.includeList = new ArrayList();
        this.typeChangeList = new ArrayList();
        List<Datum> data = input.getDataOfType(Phenotype.class);
        ArrayList<Datum> outputList = new ArrayList<Datum>();
        if (this.isInteractive()) {
            if (data.size() == 0) {
                JOptionPane.showMessageDialog(this.getParentFrame(), "No Phenotype data selected.");
            }
            for (Datum datum : data) {
                FilterTraitsDialog ftd = new FilterTraitsDialog(this.getParentFrame(), (Phenotype)datum.getData());
                ftd.setLocationRelativeTo(this.getParentFrame());
                ftd.setVisible(true);
                if (ftd.getClickedOK()) {
                    this.includeList.add(ftd.getIncludedTraits());
                    this.typeChangeList.add(ftd.getTypeChangeMap());
                }
                ftd.dispose();
            }
            int n = this.includeList.size();
            for (int i2 = 0; i2 < n; ++i2) {
                Map<PhenotypeAttribute, Phenotype.ATTRIBUTE_TYPE> typeChangeMap;
                Datum datum = data.get(i2);
                Phenotype pheno = (Phenotype)datum.getData();
                int[] included = this.includeList.get(i2);
                int numberOfOriginalTraits = pheno.numberOfAttributes();
                boolean buildnew = false;
                PhenotypeBuilder phenoBuilder = new PhenotypeBuilder().fromPhenotype(pheno);
                if (included.length > 0 && included.length < numberOfOriginalTraits) {
                    buildnew = true;
                    phenoBuilder.keepAttributes(included);
                }
                if ((typeChangeMap = this.typeChangeList.get(i2)).size() > 0) {
                    buildnew = true;
                    phenoBuilder.changeAttributeType(typeChangeMap);
                }
                if (!buildnew) continue;
                String name = "Filtered_" + datum.getName();
                phenoBuilder.assignName(name);
                String comment = "";
                outputList.add(new Datum(name, phenoBuilder.build().get(0), comment));
            }
        } else if (this.excludeLast) {
            for (Datum datum : data) {
                Phenotype pheno = (Phenotype)datum.getData();
                int numberOfOriginalTraits = pheno.numberOfAttributes();
                int[] keepAttributeIndex = IntStream.iterate(0, i -> i + 1).limit(numberOfOriginalTraits - 1).toArray();
                String name = "Filtered_" + datum.getName();
                Phenotype filteredPhenotype = new PhenotypeBuilder().fromPhenotype(pheno).assignName(name).keepAttributes(keepAttributeIndex).build().get(0);
                outputList.add(new Datum(name, filteredPhenotype, "no comment"));
            }
        }
        DataSet ds = new DataSet(outputList, (Plugin)this);
        this.fireDataSetReturned(ds);
        return ds;
    }

    public void addIncludedTraits(int[] traitsToInclude) {
        this.includeList.add(traitsToInclude);
    }

    public void setIncludeList(ArrayList<int[]> includeList) {
        this.includeList = includeList;
    }

    public void addTypeChangeMap(Map<PhenotypeAttribute, Phenotype.ATTRIBUTE_TYPE> typeMap) {
        this.typeChangeList.add(typeMap);
    }

    public void setTypeChangeList(ArrayList<Map<PhenotypeAttribute, Phenotype.ATTRIBUTE_TYPE>> typeChangeList) {
        this.typeChangeList = typeChangeList;
    }

    public void excludeLast(boolean exclude) {
        this.excludeLast = exclude;
    }
}

