/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import com.google.common.collect.Range;
import java.awt.Frame;
import java.io.File;
import java.util.Arrays;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.map.TagsOnPhysicalMap;
import net.maizegenetics.dna.tag.TagCounts;
import net.maizegenetics.dna.tag.TagsByTaxa;
import net.maizegenetics.dna.tag.TagsByTaxaByte;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import org.apache.log4j.Logger;

public class BinaryToTextPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(BinaryToTextPlugin.class);
    private PluginParameter<String> myInputFile = new PluginParameter.Builder<String>("i", null, String.class).guiName("Input File").required(true).inFile().build();
    private PluginParameter<String> myOutputFile = new PluginParameter.Builder<String>("o", null, String.class).guiName("Output File").required(true).outFile().build();
    private PluginParameter<FILE_TYPES> myFileType = new PluginParameter.Builder<FILE_TYPES>("t", FILE_TYPES.TOPM, FILE_TYPES.class).guiName("File Type").range((Range<Comparable<FILE_TYPES>>)Range.encloseAll(Arrays.asList(FILE_TYPES.values()))).build();

    public BinaryToTextPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        switch (this.fileType()) {
            case TOPM: {
                TagsOnPhysicalMap topm = new TagsOnPhysicalMap(this.inputFile(), true);
                topm.writeTextFile(new File(this.outputFile()));
                break;
            }
            case TagCounts: {
                TagCounts tc = new TagCounts(this.inputFile(), TagsByTaxa.FilePacking.Byte);
                tc.writeTagCountFile(this.outputFile(), TagsByTaxa.FilePacking.Text, 0);
                break;
            }
            case TBTByte: {
                TagsByTaxaByte tbtbyte = new TagsByTaxaByte(this.inputFile(), TagsByTaxa.FilePacking.Byte);
                tbtbyte.writeDistFile(new File(this.outputFile()), TagsByTaxa.FilePacking.Text, 0);
            }
        }
        return null;
    }

    @Override
    public String pluginDescription() {
        return "Converts Binary GBS Files into Text format.";
    }

    public String inputFile() {
        return this.myInputFile.value();
    }

    public BinaryToTextPlugin inputFile(String value) {
        this.myInputFile = new PluginParameter<String>(this.myInputFile, value);
        return this;
    }

    public String outputFile() {
        return this.myOutputFile.value();
    }

    public BinaryToTextPlugin outputFile(String value) {
        this.myOutputFile = new PluginParameter<String>(this.myOutputFile, value);
        return this;
    }

    public FILE_TYPES fileType() {
        return this.myFileType.value();
    }

    public BinaryToTextPlugin fileType(FILE_TYPES value) {
        this.myFileType = new PluginParameter<FILE_TYPES>(this.myFileType, value);
        return this;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Binary to Text";
    }

    @Override
    public String getToolTipText() {
        return "Binary to Text";
    }

    public static enum FILE_TYPES {
        TOPM,
        TagCounts,
        TBTByte;

    }
}

