/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import net.maizegenetics.dna.map.TagLocus;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;

class CustomSNPLogRecord {
    private int chr;
    private int tagLocusStartPos;
    private byte tagLocusStrand;
    private int snpPosition;
    private byte majAllele;
    private byte minAllele;
    private String alleles;
    private int nTagsAtLocus;
    private int nReads;
    private int nTaxa;
    private int nTaxaCovered;
    private int nInbreds;
    private int nInbredsCovered;
    private int nInbreds1Read;
    private int nInbreds1ReadMaj;
    private int nInbreds1ReadMin;
    private int nInbredsGT1Read;
    private int nInbredsGT1ReadHomoMaj;
    private int nInbredsGT1ReadHomoMin;
    private int nInbredHets;
    private int nOutbreds;
    private int nOutbredsCovered;
    private int nOutbreds1Read;
    private int nOutbreds1ReadMaj;
    private int nOutbreds1ReadMin;
    private int nOutbredsGT1Read;
    private int nOutbredsGT1ReadMajHomo;
    private int nOutbredsGT1ReadMinHomo;
    private int nOutbredHets;
    private double inbredCoverage;
    private double inbredHetScore;
    private boolean pass;
    private static final String DELIM = "\t";

    public CustomSNPLogRecord(int site, TagLocus myTAL, int position, boolean[] isInbred, boolean includeReference) {
        this.chr = myTAL.getChromosome();
        this.tagLocusStartPos = myTAL.getMinStartPosition();
        this.tagLocusStrand = myTAL.getStrand();
        this.snpPosition = position;
        byte[][] byteAlleles = myTAL.getCommonAlleles();
        this.majAllele = this.tagLocusStrand == -1 ? NucleotideAlignmentConstants.getNucleotideComplement(byteAlleles[0][site]) : byteAlleles[0][site];
        this.minAllele = this.tagLocusStrand == -1 ? NucleotideAlignmentConstants.getNucleotideComplement(byteAlleles[1][site]) : byteAlleles[1][site];
        this.alleles = NucleotideAlignmentConstants.NUCLEOTIDE_ALLELES[0][this.majAllele] + "/" + NucleotideAlignmentConstants.NUCLEOTIDE_ALLELES[0][this.minAllele];
        this.nTagsAtLocus = includeReference ? myTAL.getSize() - 1 : myTAL.getSize();
        this.nReads = myTAL.getTotalNReads();
        this.nTaxaCovered = myTAL.getNumberTaxaCovered();
        this.getCounts(site, myTAL.getAlleleDepthsInTaxa(), isInbred);
    }

    private void getCounts(int site, byte[][][] alleleDepthsInTaxa, boolean[] isInbred) {
        this.nTaxa = alleleDepthsInTaxa[0][site].length;
        for (int tx = 0; tx < this.nTaxa; ++tx) {
            byte alleleDepth;
            int a;
            int genoDepth = 0;
            int nAlleles = 0;
            boolean majPresent = false;
            if (isInbred == null || isInbred[tx]) {
                ++this.nInbreds;
                for (a = 0; a < 2; ++a) {
                    alleleDepth = alleleDepthsInTaxa[a][site][tx];
                    if (alleleDepth <= 0) continue;
                    genoDepth += alleleDepth;
                    ++nAlleles;
                    if (a != 0) continue;
                    majPresent = true;
                }
                if (nAlleles <= 0) continue;
                ++this.nInbredsCovered;
                if (genoDepth > 1) {
                    ++this.nInbredsGT1Read;
                    if (nAlleles > 1) {
                        ++this.nInbredHets;
                        continue;
                    }
                    if (majPresent) {
                        ++this.nInbredsGT1ReadHomoMaj;
                        continue;
                    }
                    ++this.nInbredsGT1ReadHomoMin;
                    continue;
                }
                ++this.nInbreds1Read;
                if (majPresent) {
                    ++this.nInbreds1ReadMaj;
                    continue;
                }
                ++this.nInbreds1ReadMin;
                continue;
            }
            ++this.nOutbreds;
            for (a = 0; a < 2; ++a) {
                alleleDepth = alleleDepthsInTaxa[a][site][tx];
                if (alleleDepth <= 0) continue;
                genoDepth += alleleDepth;
                ++nAlleles;
                if (a != 0) continue;
                majPresent = true;
            }
            if (nAlleles <= 0) continue;
            ++this.nOutbredsCovered;
            if (genoDepth > 1) {
                ++this.nOutbredsGT1Read;
                if (nAlleles > 1) {
                    ++this.nOutbredHets;
                    continue;
                }
                if (majPresent) {
                    ++this.nOutbredsGT1ReadMajHomo;
                    continue;
                }
                ++this.nOutbredsGT1ReadMinHomo;
                continue;
            }
            ++this.nOutbreds1Read;
            if (majPresent) {
                ++this.nOutbreds1ReadMaj;
                continue;
            }
            ++this.nOutbreds1ReadMin;
        }
        this.inbredCoverage = (double)this.nInbredsCovered / (double)this.nInbreds;
        this.inbredHetScore = (double)this.nInbredHets / ((double)(this.nInbredsGT1ReadHomoMin + this.nInbredHets) + 0.5);
        if (this.inbredCoverage > 0.15 && this.inbredHetScore < 0.21) {
            this.pass = true;
        }
    }

    public boolean isGoodSNP() {
        return this.pass;
    }

    public double getInbredCoverage() {
        return this.inbredCoverage;
    }

    public double getInbredHetScore() {
        return this.inbredHetScore;
    }

    public String toString() {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(String.valueOf(this.chr));
        sBuilder.append(DELIM);
        sBuilder.append(String.valueOf(this.tagLocusStartPos));
        sBuilder.append(DELIM);
        sBuilder.append(String.valueOf(this.tagLocusStrand));
        sBuilder.append(DELIM);
        sBuilder.append(String.valueOf(this.snpPosition));
        sBuilder.append(DELIM);
        sBuilder.append(this.alleles);
        sBuilder.append(DELIM);
        sBuilder.append(String.valueOf(this.nTagsAtLocus)).append(DELIM);
        sBuilder.append(String.valueOf(this.nReads));
        sBuilder.append(DELIM);
        sBuilder.append(String.valueOf(this.nTaxa));
        sBuilder.append(DELIM);
        sBuilder.append(String.valueOf(this.nTaxaCovered));
        sBuilder.append(DELIM);
        sBuilder.append(String.valueOf(this.nInbreds));
        sBuilder.append(DELIM);
        sBuilder.append(String.valueOf(this.nInbredsCovered));
        sBuilder.append(DELIM);
        sBuilder.append(String.valueOf(this.nInbreds1Read));
        sBuilder.append(DELIM);
        sBuilder.append(String.valueOf(this.nInbreds1ReadMaj));
        sBuilder.append(DELIM);
        sBuilder.append(String.valueOf(this.nInbreds1ReadMin));
        sBuilder.append(DELIM);
        sBuilder.append(String.valueOf(this.nInbredsGT1Read));
        sBuilder.append(DELIM);
        sBuilder.append(String.valueOf(this.nInbredsGT1ReadHomoMaj));
        sBuilder.append(DELIM);
        sBuilder.append(String.valueOf(this.nInbredsGT1ReadHomoMin));
        sBuilder.append(DELIM);
        sBuilder.append(String.valueOf(this.nInbredHets));
        sBuilder.append(DELIM);
        sBuilder.append(String.valueOf(this.inbredCoverage));
        sBuilder.append(DELIM);
        sBuilder.append(String.valueOf(this.inbredHetScore));
        sBuilder.append(DELIM);
        sBuilder.append(String.valueOf(this.nOutbreds));
        sBuilder.append(DELIM);
        sBuilder.append(String.valueOf(this.nOutbredsCovered));
        sBuilder.append(DELIM);
        sBuilder.append(String.valueOf(this.nOutbreds1Read));
        sBuilder.append(DELIM);
        sBuilder.append(String.valueOf(this.nOutbreds1ReadMaj));
        sBuilder.append(DELIM);
        sBuilder.append(String.valueOf(this.nOutbreds1ReadMin));
        sBuilder.append(DELIM);
        sBuilder.append(String.valueOf(this.nOutbredsGT1Read));
        sBuilder.append(DELIM);
        sBuilder.append(String.valueOf(this.nOutbredsGT1ReadMajHomo));
        sBuilder.append(DELIM);
        sBuilder.append(String.valueOf(this.nOutbredsGT1ReadMinHomo));
        sBuilder.append(DELIM);
        sBuilder.append(String.valueOf(this.nOutbredHets));
        sBuilder.append(DELIM);
        if (this.pass) {
            sBuilder.append(String.valueOf(1));
        } else {
            sBuilder.append(String.valueOf(0));
        }
        sBuilder.append("\n");
        return sBuilder.toString();
    }
}

