/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import cern.colt.list.IntArrayList;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.tag.TagsByTaxaByteHDF5TagGroups;
import net.maizegenetics.dna.tag.TagsByTaxaByteHDF5TaxaGroups;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import org.apache.log4j.Logger;

public class ModifyTBTHDF5Plugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(ModifyTBTHDF5Plugin.class);
    private PluginParameter<String> myTargetTBT = new PluginParameter.Builder<String>("o", null, String.class).guiName("Target TBT HDF5 File").required(true).inFile().description("Target TBT HDF5 (*tbt.h5) file to be modified. (Depending on the modification that you wish to make, choose only one of the only three parameters)").build();
    private PluginParameter<String> myAdditionalTaxaFile = new PluginParameter.Builder<String>("i", null, String.class).guiName("Addition Taxa File").inFile().description("TBT HDF5 (*tbt.h5) file containing additional taxa to be added to the target TBT HDF5 file").build();
    private PluginParameter<String> myTransposeFile = new PluginParameter.Builder<String>("p", null, String.class).guiName("Pivot TBT HDF5 File").outFile().description("Pivot (transpose) the target TBT HDF5 file into a tag-optimized orientation").build();
    private PluginParameter<Boolean> myCombineTaxa = new PluginParameter.Builder<Boolean>("c", false, Boolean.class).guiName("Merge Taxa").description("Merge taxa in the target TBT HDF5 file with same LibraryPrepID").build();
    IntArrayList[] taxaReads;
    int[] readsPerSample;
    int[] mappedReadsPerSample;
    int goodBarcodedReads = 0;
    int allReads = 0;
    int goodMatched = 0;
    HashMap<String, Integer> taxaNameToIndices;
    TagsByTaxaByteHDF5TaxaGroups targetTBT = null;

    public ModifyTBTHDF5Plugin() {
        super(null, false);
    }

    public ModifyTBTHDF5Plugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    protected void postProcessParameters() {
        int count = 0;
        if (!this.myAdditionalTaxaFile.isEmpty()) {
            ++count;
        }
        if (!this.myTransposeFile.isEmpty()) {
            ++count;
        }
        if (this.mergeTaxa().booleanValue()) {
            ++count;
        }
        if (count != 1) {
            throw new IllegalArgumentException("ModifyTBTHDF5Plugin: must specify exactly one paramter (Addition Taxa File, Pivot TBT HDF5 File, or Merge Taxa)");
        }
    }

    @Override
    public DataSet processData(DataSet input) {
        this.targetTBT = new TagsByTaxaByteHDF5TaxaGroups(this.targetTBTHDF5File());
        if (this.additionTaxaFile() != null && !this.additionTaxaFile().isEmpty()) {
            this.addAllTaxaToNewHDF5(this.additionTaxaFile());
        }
        if (this.mergeTaxa().booleanValue()) {
            this.combineTaxaHDF5();
        }
        if (this.pivotTBTHDF5File() != null && !this.pivotTBTHDF5File().isEmpty()) {
            TagsByTaxaByteHDF5TagGroups tagsByTaxaByteHDF5TagGroups = new TagsByTaxaByteHDF5TagGroups(this.targetTBT, this.pivotTBTHDF5File());
        }
        this.targetTBT.getFileReadyForClosing();
        this.targetTBT = null;
        System.gc();
        return null;
    }

    private boolean addAllTaxaToNewHDF5(String addTBTName) {
        int i;
        TagsByTaxaByteHDF5TaxaGroups addTBT = new TagsByTaxaByteHDF5TaxaGroups(addTBTName);
        for (i = 0; i < addTBT.getTagCount(); ++i) {
            if (Arrays.equals(this.targetTBT.getTag(i), addTBT.getTag(i))) continue;
            System.err.println("Tags are not the same for the two TBT file.  They cannot be combined.");
            System.exit(0);
        }
        for (i = 0; i < addTBT.getTaxaCount(); ++i) {
            String name = addTBT.getTaxaName(i);
            byte[] states = addTBT.getReadCountDistributionForTaxon(i);
            this.targetTBT.addTaxon(name, states);
        }
        addTBT.getFileReadyForClosing();
        return true;
    }

    private boolean combineTaxaHDF5() {
        TreeMap<String, ArrayList<String>> combineTaxa = new TreeMap<String, ArrayList<String>>();
        for (String tn : this.targetTBT.getTaxaNames()) {
            String ptn = this.parseTaxaName(tn, "#");
            ArrayList<String> taxaList = (ArrayList<String>)combineTaxa.get(ptn);
            if (taxaList == null) {
                taxaList = new ArrayList<String>();
                combineTaxa.put(ptn, taxaList);
            }
            taxaList.add(tn);
        }
        for (ArrayList taxaList : combineTaxa.values()) {
            if (taxaList.size() < 2) continue;
            byte[] di = new byte[this.targetTBT.getTagCount()];
            String ptn = this.parseTaxaName((String)taxaList.get(0), "" + taxaList.size());
            for (int i = 0; i < taxaList.size(); ++i) {
                int j = this.targetTBT.getIndexOfTaxaName((String)taxaList.get(i));
                byte[] dj = this.targetTBT.getReadCountDistributionForTaxon(j);
                for (int k = 0; k < dj.length; ++k) {
                    int ts = di[k] + dj[k];
                    di[k] = ts > 127 ? 127 : (byte)ts;
                }
            }
            this.targetTBT.addTaxon(ptn, di);
            for (String tn : taxaList) {
                this.targetTBT.deleteTaxon(tn);
            }
        }
        return true;
    }

    private String parseTaxaName(String tn, String cnt) {
        String[] s = tn.split(":");
        return s[0] + ":MRG:" + cnt + ":" + s[3];
    }

    public String targetTBTHDF5File() {
        return this.myTargetTBT.value();
    }

    public ModifyTBTHDF5Plugin targetTBTHDF5File(String value) {
        this.myTargetTBT = new PluginParameter<String>(this.myTargetTBT, value);
        return this;
    }

    public String additionTaxaFile() {
        return this.myAdditionalTaxaFile.value();
    }

    public ModifyTBTHDF5Plugin additionTaxaFile(String value) {
        this.myAdditionalTaxaFile = new PluginParameter<String>(this.myAdditionalTaxaFile, value);
        return this;
    }

    public Boolean mergeTaxa() {
        return this.myCombineTaxa.value();
    }

    public ModifyTBTHDF5Plugin mergeTaxa(Boolean value) {
        this.myCombineTaxa = new PluginParameter<Boolean>(this.myCombineTaxa, value);
        return this;
    }

    public String pivotTBTHDF5File() {
        return this.myTransposeFile.value();
    }

    public ModifyTBTHDF5Plugin pivotTBTHDF5File(String value) {
        this.myTransposeFile = new PluginParameter<String>(this.myTransposeFile, value);
        return this;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Modify TBT HDF5";
    }

    @Override
    public String getToolTipText() {
        return "Modify TBT HDF5";
    }
}

