/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import java.util.ArrayList;
import java.util.Arrays;
import net.maizegenetics.dna.tag.ReadsByTaxa;

public class PolymorphismFinder {
    ReadsByTaxa rbt;
    long[] lookup;
    int[] indexOfRbt;
    Swapper swapper = new Swapper(){

        public void swap(int a, int b) {
            long tl = PolymorphismFinder.this.lookup[a];
            PolymorphismFinder.this.lookup[a] = PolymorphismFinder.this.lookup[b];
            PolymorphismFinder.this.lookup[b] = tl;
            int ti = PolymorphismFinder.this.indexOfRbt[a];
            PolymorphismFinder.this.indexOfRbt[a] = PolymorphismFinder.this.indexOfRbt[b];
            PolymorphismFinder.this.indexOfRbt[b] = ti;
        }
    };
    IntComparator comp = new IntComparator(){

        public int compare(int a, int b) {
            if (PolymorphismFinder.this.lookup[a] < PolymorphismFinder.this.lookup[b]) {
                return -1;
            }
            if (PolymorphismFinder.this.lookup[a] > PolymorphismFinder.this.lookup[b]) {
                return 1;
            }
            return 0;
        }
    };

    public PolymorphismFinder(ReadsByTaxa rbt) {
        this.rbt = rbt;
        this.initialize();
    }

    public void initialize() {
        this.lookup = new long[this.rbt.haplotypeNum * 2];
        this.indexOfRbt = new int[this.rbt.haplotypeNum * 2];
        for (int i = 0; i < this.rbt.haplotypeNum; ++i) {
            for (int j = 0; j < 2; ++j) {
                int dex = 2 * i + j;
                this.lookup[dex] = this.rbt.haplotype[j][i];
                this.indexOfRbt[dex] = i;
            }
        }
        GenericSorting.quickSort((int)0, (int)this.lookup.length, (IntComparator)this.comp, (Swapper)this.swapper);
        this.reduceDuplicates();
        System.out.println("Initialization is done");
    }

    public ArrayList<Integer> findOneMismatch(long[] queryLongSeq) {
        ArrayList<Integer> hitIndex = new ArrayList<Integer>();
        for (int i = 0; i < queryLongSeq.length; ++i) {
            int hit = Arrays.binarySearch(this.lookup, queryLongSeq[i]);
            if (hit < 0) continue;
            while (hit > 0 && queryLongSeq[i] == this.lookup[hit - 1]) {
                --hit;
            }
            while (hit < this.lookup.length && this.lookup[hit] == queryLongSeq[i]) {
                int count = this.getMismatchInLong(queryLongSeq[0], this.rbt.haplotype[0][this.indexOfRbt[hit]]) + this.getMismatchInLong(queryLongSeq[1], this.rbt.haplotype[1][this.indexOfRbt[hit]]);
                if (count == 1) {
                    hitIndex.add(this.indexOfRbt[hit]);
                }
                ++hit;
            }
        }
        return hitIndex;
    }

    public byte getMismatchInLong(long longSeq1, long longSeq2) {
        long mask = 3L;
        long diff = longSeq1 ^ longSeq2;
        byte count = 0;
        for (int i = 0; i < 32; ++i) {
            if ((diff & mask) > 0L) {
                count = (byte)(count + 1);
            }
            diff >>= 2;
        }
        return count;
    }

    private void reduceDuplicates() {
        int start = 0;
        int end = -1;
        int duplicated = 0;
        long currHap = this.lookup[0];
        for (int i = 0; i < this.lookup.length; ++i) {
            if (this.lookup[i] == currHap) {
                end = i;
                continue;
            }
            if (end - start > 1000) {
                for (int j = start; j <= end; ++j) {
                    this.lookup[j] = Long.MAX_VALUE;
                    ++duplicated;
                }
            }
            currHap = this.lookup[i];
            start = end = i;
        }
        GenericSorting.quickSort((int)0, (int)this.lookup.length, (IntComparator)this.comp, (Swapper)this.swapper);
        long[] newlookup = new long[this.lookup.length - duplicated];
        int[] newindexOfRbt = new int[this.lookup.length - duplicated];
        System.arraycopy(this.lookup, 0, newlookup, 0, this.lookup.length - duplicated);
        System.arraycopy(this.indexOfRbt, 0, newindexOfRbt, 0, this.indexOfRbt.length - duplicated);
        System.out.println("Old Lookup Size:" + this.lookup.length + "  new size:" + newlookup.length);
        this.lookup = newlookup;
        this.indexOfRbt = newindexOfRbt;
    }
}

