/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import net.maizegenetics.dna.BaseEncoder;

public class ReadBarcodeResult {
    public String unprocessedSequence = null;
    public String processedSequence = null;
    public String paddedSequence = null;
    byte length;
    long[] read;
    private String taxonName;
    private int taxonIndex;

    public ReadBarcodeResult(long[] read2, byte length, String taxon, int taxonIndex) {
        this.read = read2;
        this.length = length;
        this.taxonName = taxon;
        this.taxonIndex = taxonIndex;
    }

    public ReadBarcodeResult(String sequence) {
        this.unprocessedSequence = sequence;
    }

    public String toString() {
        return BaseEncoder.getSequenceFromLong(this.read) + ":" + this.length + ":" + this.taxonName;
    }

    public byte getLength() {
        return this.length;
    }

    public long[] getRead() {
        return this.read;
    }

    public String getTaxonName() {
        return this.taxonName;
    }

    public int getTaxonIndex() {
        return this.taxonIndex;
    }
}

