/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

public class SmithWaterman {
    protected String seq1 = "CGGGTGTGACAGTCGTGCAGTCGACCGTTGGG";
    protected String seq2 = "XXXXXCGGGTGTGACAGTCGTGCAGTCGACCGTTGGGXXXXXXX";
    protected int[][] matrix;
    protected int max_row;
    protected int max_col;
    int rows;
    int cols;
    byte[] bseq1;
    byte[] bseq2;
    int[] array;

    public SmithWaterman() {
        long time = System.currentTimeMillis();
        int maxScore = 0;
        this.rows = this.seq1.length() + 1;
        this.cols = this.seq2.length() + 1;
        this.array = this.rows <= this.cols ? new int[this.rows] : new int[this.cols];
        this.bseq1 = this.seq1.getBytes();
        this.bseq2 = this.seq2.getBytes();
        for (int i = 0; i < 30000; ++i) {
            maxScore = this.computeScore();
        }
    }

    public SmithWaterman(int rows, int cols) {
        this.rows = rows + 1;
        this.cols = cols + 1;
        int max = rows > cols ? rows : cols;
        this.array = new int[max];
    }

    public SmithWaterman(byte[] b1, byte[] b2) {
        this.bseq1 = b1;
        this.bseq2 = b2;
        this.rows = b1.length + 1;
        this.cols = b2.length + 1;
        int max = this.rows > this.cols ? this.rows : this.cols;
        this.array = new int[max];
    }

    int computeScore(byte[] b1, byte[] b2) {
        this.bseq1 = b1;
        this.bseq2 = b2;
        this.rows = b1.length + 1;
        this.cols = b2.length + 1;
        return this.computeScore();
    }

    protected int computeMatrix() {
        int c;
        long time = System.currentTimeMillis();
        for (c = 0; c < this.cols; ++c) {
            this.matrix[0][c] = 0;
        }
        int max_score = 0;
        this.max_col = 0;
        this.max_row = 0;
        for (int r = 1; r < this.rows; ++r) {
            this.matrix[r][0] = 0;
            for (c = 1; c < this.cols; ++c) {
                int ins = this.matrix[r][c - 1] - 1;
                int sub = this.matrix[r - 1][c - 1] + (this.bseq1[r - 1] == this.bseq2[c - 1] ? 2 : 0);
                int del = this.matrix[r - 1][c] - 1;
                this.matrix[r][c] = this.max(ins, sub, del, 0);
                if (this.matrix[r][c] <= max_score) continue;
                max_score = this.matrix[r][c];
                this.max_row = r;
                this.max_col = c;
            }
        }
        System.out.println("MaxScore:" + max_score);
        System.out.println("time:" + (System.currentTimeMillis() - time));
        return max_score;
    }

    public int computeScore() {
        long time = System.currentTimeMillis();
        int max_score = 0;
        if (this.rows <= this.cols) {
            int r;
            for (r = 0; r < this.rows; ++r) {
                this.array[r] = 0;
            }
            for (int c = 1; c < this.cols; ++c) {
                int tmp = 0;
                for (r = 1; r < this.rows; ++r) {
                    int ins = this.array[r] - 1;
                    int sub = this.array[r - 1] + (this.bseq1[r - 1] == this.bseq2[c - 1] ? 2 : 0);
                    int del = tmp - 1;
                    this.array[r - 1] = tmp;
                    tmp = this.max(ins, sub, del, 0);
                    if (tmp <= max_score) continue;
                    max_score = tmp;
                }
                this.array[this.rows - 1] = tmp;
            }
        } else {
            int c;
            for (c = 0; c < this.cols; ++c) {
                this.array[c] = 0;
            }
            for (int r = 1; r < this.rows; ++r) {
                int tmp = 0;
                for (c = 1; c < this.cols; ++c) {
                    int ins = tmp - 1;
                    int sub = this.array[c - 1] + (this.bseq1[r - 1] == this.bseq2[c - 1] ? 2 : 0);
                    int del = this.array[c] - 1;
                    this.array[c - 1] = tmp;
                    tmp = this.max(ins, sub, del, 0);
                    if (tmp <= max_score) continue;
                    max_score = tmp;
                }
                this.array[this.cols - 1] = tmp;
            }
        }
        return max_score;
    }

    protected final int scoreInsertion(char a) {
        return -1;
    }

    protected final int scoreSubstitution(char a, char b) {
        if (a == b) {
            return 2;
        }
        return 0;
    }

    protected final int scoreDeletion(char a) {
        return -1;
    }

    protected final int max(int v1, int v2) {
        return v1 >= v2 ? v1 : v2;
    }

    protected final int max(int v1, int v2, int v3) {
        return v1 >= v2 ? (v1 >= v3 ? v1 : v3) : (v2 >= v3 ? v2 : v3);
    }

    protected final int max(int v1, int v2, int v3, int v4) {
        int m1 = v1 >= v2 ? v1 : v2;
        int m2 = v3 >= v4 ? v3 : v4;
        return m1 >= m2 ? m1 : m2;
    }
}

