/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import cern.jet.random.Binomial;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import net.maizegenetics.analysis.gbs.SimpleGenotypeSBit;
import net.maizegenetics.analysis.gbs.TagBlockPosition;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.tag.TagsByTaxaByte;
import net.maizegenetics.dna.tag.TagsByTaxaByteHDF5TagGroups;
import net.maizegenetics.util.OpenBitSet;

public class TagAgainstAnchor {
    SimpleGenotypeSBit anchor;
    double[] anchorMaf;
    int[] chromosomeNumber;
    int[] chrStartIndex;
    int[] chrEndIndex;
    TagsByTaxaByteHDF5TagGroups tbt;
    int[] tbtRedirect;
    double pThresh = 1.0E-6;
    int minCount = 20;
    int[] blockChr;
    int[] blockPos;
    int tagBlockSize = 64;
    int minTagAlleleIntersection = 4;
    Task[] jobs;
    static int threadNumPerCore = 4;
    int acutualUseCoreNum;
    int threadNum;
    int chunkSize;
    int chunkNum;
    int chunkStartIndex;
    int chunkEndIndex;

    public TagAgainstAnchor(String hapMapHDF5, String tbtHDF5, String blockFileS, String outfileS, double pThresh, int minCount, int coreNum, int chunkSize) {
        this.pThresh = pThresh;
        this.minCount = minCount;
        this.loadAnchorMap(hapMapHDF5);
        this.loadTBT(tbtHDF5);
        this.loadBlockChrPosition(blockFileS);
        this.redirect();
        this.chunkSize = chunkSize;
        this.chunkNum = this.getChunkNum(chunkSize);
        this.calculateThreadNum(coreNum);
        this.chunkStartIndex = 0;
        this.chunkEndIndex = this.chunkNum;
        this.MTMapping(outfileS);
    }

    public TagAgainstAnchor(String hapMapHDF5, String tbtHDF5, String blockFileS, String outfileS, double pThresh, int minCount, int coreNum, int chunkSize, int chunkStartIndex, int chunkEndIndex) {
        this.pThresh = pThresh;
        this.minCount = minCount;
        this.loadAnchorMap(hapMapHDF5);
        this.loadTBT(tbtHDF5);
        this.loadBlockChrPosition(blockFileS);
        this.redirect();
        this.chunkSize = chunkSize;
        this.chunkNum = this.getChunkNum(chunkSize);
        this.calculateThreadNum(coreNum);
        this.chunkStartIndex = chunkStartIndex;
        this.chunkEndIndex = chunkEndIndex;
        this.MTMapping(outfileS);
    }

    public int getChunkNum(int chunkSize) {
        int tagNum = this.tbt.getTagCount();
        int chunkNum = 0;
        int left = tagNum % chunkSize;
        chunkNum = left == 0 ? tagNum / chunkSize : tagNum / chunkSize + 1;
        System.out.println("Number of tags in each chunk was set to " + chunkSize);
        System.out.println("There are " + chunkNum + " TBT chunks");
        if (left != 0) {
            System.out.println("The last chunk has " + left + " tags");
        }
        return chunkNum;
    }

    public static int getChunkNum(String tbtHDF5, int chunkSize) {
        TagsByTaxaByteHDF5TagGroups tbt = new TagsByTaxaByteHDF5TagGroups(tbtHDF5);
        int tagNum = tbt.getTagCount();
        int chunkNum = 0;
        int left = tagNum % chunkSize;
        chunkNum = left == 0 ? tagNum / chunkSize : tagNum / chunkSize + 1;
        System.out.println("TBT has " + tagNum + " tags");
        System.out.println("TBT will be devided into " + chunkNum + " chunks, " + chunkSize + " tags each");
        if (left != 0) {
            System.out.println("The last chunk has " + left + " tags");
        }
        System.out.println("The index of chunk are used submit parallel computation to different node");
        System.out.println("Tags in each chunk will be multi-threaded in one node");
        return chunkNum;
    }

    public void MTMapping(String outfileS) {
        if (this.chunkStartIndex > this.chunkNum - 1 || this.chunkEndIndex > this.chunkNum || this.chunkStartIndex == this.chunkEndIndex) {
            System.out.println("Error in setting chunk index. Please reset");
            System.exit(0);
        }
        int tagNum = this.tbt.getTagCount();
        System.out.println("TBT has " + this.chunkNum + " chunks, mapping will start at chunk " + this.chunkStartIndex + ", end at chunk " + this.chunkEndIndex + "\n");
        System.out.println("Creat output file at " + outfileS);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(outfileS), 65536);
            bw.write("TestTag\tTestTagNum\tBlastChr\tBlastPos\trefDiv\tLDChr\tLDSite\tLDPos\tBinomP\tSigTests\tTagTaxaCnt\tChrSig\tLRatioB:2\tLRatioB:M\tSiteOnBestChrThanNextChr\tMinSigPos\tMaxSigPos");
            bw.newLine();
            for (int i = this.chunkStartIndex; i < this.chunkEndIndex; ++i) {
                int j;
                int j2;
                int[] threadEndTagIndex;
                int[] threadStartTagIndex;
                int chunkStartTagIndex = i * this.chunkSize;
                int chunkEndTagIndex = chunkStartTagIndex + this.chunkSize;
                if (chunkEndTagIndex > tagNum) {
                    chunkEndTagIndex = tagNum;
                }
                System.out.println("Start mapping tag chunk " + i + "(Index), tag index from " + chunkStartTagIndex + " to " + chunkEndTagIndex);
                int actualChunkSize = chunkEndTagIndex - chunkStartTagIndex;
                int left = actualChunkSize % this.threadNum;
                int baseSize = actualChunkSize / this.threadNum;
                if (baseSize == 0) {
                    threadStartTagIndex = new int[left];
                    threadEndTagIndex = new int[left];
                    for (j2 = 0; j2 < threadStartTagIndex.length; ++j2) {
                        threadStartTagIndex[j2] = chunkStartTagIndex + j2;
                        threadEndTagIndex[j2] = threadStartTagIndex[j2] + 1;
                    }
                } else {
                    int[] threadSize = new int[this.threadNum];
                    threadStartTagIndex = new int[this.threadNum];
                    threadEndTagIndex = new int[this.threadNum];
                    for (j2 = 0; j2 < left; ++j2) {
                        threadSize[j2] = baseSize + 1;
                    }
                    for (j2 = left; j2 < this.threadNum; ++j2) {
                        threadSize[j2] = baseSize;
                    }
                    threadStartTagIndex[0] = chunkStartTagIndex;
                    threadEndTagIndex[0] = threadStartTagIndex[0] + threadSize[0];
                    for (j2 = 1; j2 < this.threadNum; ++j2) {
                        threadStartTagIndex[j2] = threadEndTagIndex[j2 - 1];
                        threadEndTagIndex[j2] = threadStartTagIndex[j2] + threadSize[j2];
                    }
                }
                int actualThreadNum = threadStartTagIndex.length;
                this.jobs = new Task[actualThreadNum];
                Thread[] mts = new Thread[actualThreadNum];
                long lastTimePoint = this.getCurrentTimeNano();
                for (j = 0; j < actualThreadNum; ++j) {
                    this.jobs[j] = new Task(threadStartTagIndex[j], threadEndTagIndex[j]);
                }
                System.out.println("Loading this chunk to multiple threads took " + this.getTimeSpanSecond(lastTimePoint) + " seconds");
                System.out.println("Multiple threading mapping in progress...");
                lastTimePoint = this.getCurrentTimeNano();
                for (j = 0; j < actualThreadNum; ++j) {
                    mts[j] = new Thread(this.jobs[j]);
                    mts[j].start();
                }
                for (j = 0; j < actualThreadNum; ++j) {
                    try {
                        mts[j].join();
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println(e.toString());
                    }
                }
                System.out.println("Each LD compirison took " + (double)this.getTimeSpanNano(lastTimePoint) / (double)actualChunkSize / (double)this.anchor.getSiteNum() * (double)this.acutualUseCoreNum + " nano seconds/core");
                System.out.println("Multiple threading mapping took " + this.getTimeSpanSecond(lastTimePoint) + " seconds");
                for (j = 0; j < this.jobs.length; ++j) {
                    String[] result = this.jobs[j].getResult();
                    if (result == null) continue;
                    for (int k = 0; k < result.length; ++k) {
                        bw.write(result[k]);
                    }
                }
                bw.flush();
                System.out.println("Mapping result from chunk " + i + " was written to " + outfileS + "\n");
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void calculateThreadNum(int coreNum) {
        int numOfProcessors = Runtime.getRuntime().availableProcessors();
        if (coreNum < 0) {
            this.threadNum = numOfProcessors * threadNumPerCore;
        } else {
            if (coreNum == 0) {
                System.out.println("Core number = 0, This runs at least on 1 thread. Quit.");
                System.exit(0);
            }
            threadNumPerCore = 1;
            this.threadNum = coreNum * threadNumPerCore;
            System.out.println("TBT will be mapped by " + this.threadNum + " tasks");
            System.out.println("Each core runs 1 tasks, or 1 threads");
        }
        this.acutualUseCoreNum = numOfProcessors;
        if (this.acutualUseCoreNum > this.threadNum) {
            this.acutualUseCoreNum = this.threadNum;
        }
        System.out.println("This node has " + numOfProcessors + " processors. Will use " + this.acutualUseCoreNum + " processors");
        System.out.println("TBT will be mapped by " + this.threadNum + " threads");
        System.out.println("Each core runs " + threadNumPerCore + " threads");
        System.out.println("Each TBT chunk was set to " + this.chunkSize + " tags, which will be split and mapped by the " + this.threadNum + " threads");
        System.out.println("Each thread will map " + this.chunkSize / this.threadNum + " tags");
        int left = this.tbt.getTagCount() % this.chunkSize;
        if (left != 0) {
            System.out.println("The last TBT chunk has " + left + " tags");
        }
        System.out.println("");
    }

    public double fastTestSites(OpenBitSet obsTdist, OpenBitSet obsMajor, OpenBitSet obsMinor, double maf, Binomial binomFunc) {
        int cdfCount;
        double minorProb;
        double result = 1.0;
        int tagMinorCount = 0;
        int tagMajorCount = 0;
        tagMinorCount = (int)OpenBitSet.intersectionCount(obsTdist, obsMinor);
        int sumTagAllele = tagMinorCount + (tagMajorCount = (int)OpenBitSet.intersectionCount(obsTdist, obsMajor));
        if (sumTagAllele < 4) {
            return result;
        }
        double ratio = (double)tagMinorCount / (double)sumTagAllele;
        if (tagMinorCount < tagMajorCount) {
            minorProb = maf;
            cdfCount = tagMinorCount;
        } else {
            minorProb = 1.0 - maf;
            cdfCount = tagMajorCount;
        }
        if (ratio - minorProb < -0.003) {
            return result;
        }
        binomFunc.setNandP(sumTagAllele, minorProb);
        try {
            result = binomFunc.cdf(cdfCount);
        }
        catch (Exception e) {
            System.err.println("Error in the BinomialDistributionImpl");
        }
        return result;
    }

    public double testSites(OpenBitSet obsTdist, OpenBitSet obsMajor, OpenBitSet obsMinor, double maf, Binomial binomFunc) {
        double result = 1.0;
        int tagMinorCount = 0;
        int tagMajorCount = 0;
        tagMinorCount = (int)OpenBitSet.intersectionCount(obsTdist, obsMinor);
        int sumTagAllele = tagMinorCount + (tagMajorCount = (int)OpenBitSet.intersectionCount(obsTdist, obsMajor));
        if (sumTagAllele < 4) {
            return result;
        }
        double minorProb = tagMinorCount < tagMajorCount ? maf : 1.0 - maf;
        binomFunc.setNandP(sumTagAllele, minorProb);
        try {
            result = tagMinorCount < tagMajorCount ? binomFunc.cdf(tagMinorCount) : binomFunc.cdf(tagMajorCount);
        }
        catch (Exception e) {
            System.err.println("Error in the BinomialDistributionImpl");
        }
        return result;
    }

    public static double testSites(OpenBitSet obsTdist, OpenBitSet obsMajor, OpenBitSet obsMinor, Binomial binomFunc) {
        double result = 1.0;
        int minorCount = 0;
        int tagMinorCount = 0;
        int majorCount = 0;
        int tagMajorCount = 0;
        tagMinorCount = (int)OpenBitSet.intersectionCount(obsTdist, obsMinor);
        tagMajorCount = (int)OpenBitSet.intersectionCount(obsTdist, obsMajor);
        minorCount = (int)obsMinor.cardinality();
        majorCount = (int)obsMajor.cardinality();
        int sumAllele = minorCount + majorCount;
        int sumTagAllele = tagMinorCount + tagMajorCount;
        if (sumTagAllele < 4) {
            return result;
        }
        double minorProb = tagMinorCount < tagMajorCount ? (double)minorCount / (double)sumAllele : (double)majorCount / (double)sumAllele;
        binomFunc.setNandP(sumTagAllele, minorProb);
        try {
            result = tagMinorCount < tagMajorCount ? binomFunc.cdf(tagMinorCount) : binomFunc.cdf(tagMajorCount);
        }
        catch (Exception e) {
            System.err.println("Error in the BinomialDistributionImpl");
        }
        return result;
    }

    private long[] getTagsInBits(TagsByTaxaByte aTBT, int tagIndex, int[] reDirect, int anchorTaxa) {
        int lgPerSite = anchorTaxa / 64 + 1;
        long[] seq = new long[lgPerSite];
        for (int j = 0; j < aTBT.getTaxaCount(); ++j) {
            if (reDirect[j] < 0) continue;
            int index = reDirect[j] / 64;
            int offset = reDirect[j] % 64;
            if (aTBT.getReadCountForTagTaxon(tagIndex, j) <= 0) continue;
            seq[index] = seq[index] | 1L << offset;
        }
        return seq;
    }

    private void redirect() {
        long lastTimePoint = this.getCurrentTimeNano();
        this.tbtRedirect = new int[this.tbt.getTaxaCount()];
        for (int i = 0; i < this.tbtRedirect.length; ++i) {
            this.tbtRedirect[i] = this.anchor.getTaxonIndex(this.tbt.getTaxaName(i));
        }
        System.out.println("Taxa redirection between TBT and anchor map took " + String.valueOf(this.getTimeSpanSecond(lastTimePoint)) + " seconds");
    }

    private void loadBlockChrPosition(String blockFileS) {
        if (blockFileS == null) {
            this.blockChr = new int[this.tbt.getTagCount()];
            this.blockPos = new int[this.tbt.getTagCount()];
            for (int i = 0; i < this.blockChr.length; ++i) {
                this.blockChr[i] = Integer.MIN_VALUE;
                this.blockPos[i] = Integer.MIN_VALUE;
            }
            System.out.println("There is no marker need to be blocked for mapping tags");
            return;
        }
        System.out.println("Start loading TBP from " + blockFileS);
        long lastTimePoint = System.nanoTime();
        TagBlockPosition tbp = new TagBlockPosition(blockFileS);
        if (tbp.getBlockPos().length != this.tbt.getTagCount()) {
            System.out.println("counts of TBT and TBP don't match. Program stops");
            System.exit(1);
        }
        this.blockChr = tbp.getBlockChr();
        this.blockPos = tbp.getBlockPos();
        System.out.println("Loading blocking mapping information took " + String.valueOf(this.getTimeSpanSecond(lastTimePoint)) + " seconds\n");
    }

    private void loadTBT(String tbtHDF5) {
        System.out.println("Start loading TBT from " + tbtHDF5);
        long lastTimePoint = this.getCurrentTimeNano();
        this.tbt = new TagsByTaxaByteHDF5TagGroups(tbtHDF5);
        System.out.println("Loading TBT HDF5 took " + String.valueOf(this.getTimeSpanSecond(lastTimePoint)) + " seconds");
        System.out.println("TBT has " + this.tbt.getTagCount() + " tags and " + this.tbt.getTaxaCount() + " taxa");
        this.screenPrintGbMemoryCurrentUse();
        this.screenPrintGbMemoryAvailable();
        System.out.println();
    }

    private void loadAnchorMap(String hapMapHDF5) {
        System.out.println("Start loading anchor map from " + hapMapHDF5);
        long lastTimePoint = this.getCurrentTimeNano();
        this.anchor = new SimpleGenotypeSBit(hapMapHDF5);
        System.out.println("Loading anchor map (SimpleGenotypeSBit) HDF5 took " + String.valueOf(this.getTimeSpanSecond(lastTimePoint)) + " seconds");
        System.out.println("The anchor map has " + this.anchor.getSiteNum() + " sites and " + this.anchor.getTaxaNum() + " taxa");
        this.chromosomeNumber = this.anchor.chromosomeNumber;
        this.chrStartIndex = this.anchor.chrStartIndex;
        this.chrEndIndex = this.anchor.chrEndIndex;
        this.anchorMaf = this.anchor.maf;
        System.gc();
        this.screenPrintGbMemoryCurrentUse();
        this.screenPrintGbMemoryAvailable();
        System.out.println();
    }

    private double getTimeSpanSecond(long lastTimePoint) {
        return (double)this.getTimeSpanNano(lastTimePoint) / 1.0E9;
    }

    private long getTimeSpanNano(long lastTimePoint) {
        return this.getCurrentTimeNano() - lastTimePoint;
    }

    private long getCurrentTimeNano() {
        return System.nanoTime();
    }

    private String getCurrentTimeHR() {
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        String str = sd.format(date);
        return str;
    }

    private double getGbMemoryAvailable() {
        return (double)(Runtime.getRuntime().maxMemory() - (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())) / 1024.0 / 1024.0 / 1024.0;
    }

    private double getGbMemoryCurrentUse() {
        return (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0 / 1024.0;
    }

    private void screenPrintTimeSpanSecond(long lastTimePoint) {
        System.out.println("Time span is " + String.valueOf(this.getTimeSpanSecond(lastTimePoint)) + " seconds");
    }

    private void screenPrintTimeSpanNano(long lastTimePoint) {
        System.out.println("Time span is " + String.valueOf(this.getTimeSpanNano(lastTimePoint)) + " ns");
    }

    private void screenPrintCurrentTimeHR() {
        System.out.println("Current time is " + this.getCurrentTimeHR());
    }

    private void screenPrintGbMemoryAvailable() {
        System.out.println("Available memory is " + String.valueOf(this.getGbMemoryAvailable()) + " GB");
    }

    private void screenPrintGbMemoryCurrentUse() {
        System.out.println("Current memory in use is " + String.valueOf(this.getGbMemoryCurrentUse()) + " GB");
    }

    private class ScanChromosome {
        int chrIndex;
        int chrStartIndex;
        int chrEndIndex;
        OpenBitSet[] obsTdist;
        Binomial binomFunc = new Binomial(5, 0.5, (RandomEngine)new MersenneTwister());
        double[][][] resultReport;
        double sigThreshold;
        int[] minSigPos;
        int[] maxSigPos;
        int step = 1;
        double bionomialThreshold = 0.2;
        int[] blockPosition;
        int blockWindow;

        public ScanChromosome(long[][] tdist, double[][][] resultReport, int chrIndex, int chrStartIndex, int chrEndIndex, double sigThreshold, int step, int[] blockPosition) {
            this.blockWindow = TagAgainstAnchor.this.tbt.getTagSizeInLong() * 32;
            this.obsTdist = new OpenBitSet[tdist.length];
            this.minSigPos = new int[tdist.length];
            this.maxSigPos = new int[tdist.length];
            for (int i = 0; i < tdist.length; ++i) {
                this.obsTdist[i] = new OpenBitSet(tdist[i], tdist[i].length);
                this.minSigPos[i] = Integer.MIN_VALUE;
                this.maxSigPos[i] = Integer.MIN_VALUE;
            }
            this.resultReport = resultReport;
            this.chrIndex = chrIndex;
            this.chrStartIndex = chrStartIndex;
            this.chrEndIndex = chrEndIndex;
            this.sigThreshold = sigThreshold;
            this.blockPosition = blockPosition;
            this.step = step;
        }

        public void scan() {
            int i;
            int[] bestSite = new int[this.obsTdist.length];
            int[] countSig = new int[this.obsTdist.length];
            double[] bestP = new double[this.obsTdist.length];
            for (i = 0; i < bestSite.length; ++i) {
                bestSite[i] = -1;
                countSig[i] = 0;
                bestP[i] = 2.0;
            }
            for (i = this.chrStartIndex; i < this.chrEndIndex; i += this.step) {
                OpenBitSet obsMajor = TagAgainstAnchor.this.anchor.obsMajor[i];
                OpenBitSet obsMinor = TagAgainstAnchor.this.anchor.obsMinor[i];
                if (obsMinor.cardinality() <= 4L) continue;
                for (int j = 0; j < this.obsTdist.length; ++j) {
                    if (Math.abs(TagAgainstAnchor.this.anchor.getPosition(i) - this.blockPosition[j]) < this.blockWindow) continue;
                    double p = TagAgainstAnchor.this.fastTestSites(this.obsTdist[j], obsMajor, obsMinor, TagAgainstAnchor.this.anchorMaf[i], this.binomFunc);
                    if (p < bestP[j]) {
                        bestP[j] = p;
                        bestSite[j] = i;
                    }
                    if (!(p < this.sigThreshold)) continue;
                    int n = j;
                    countSig[n] = countSig[n] + 1;
                    if (this.minSigPos[j] == Integer.MIN_VALUE) {
                        this.minSigPos[j] = TagAgainstAnchor.this.anchor.getPosition(i);
                    }
                    this.maxSigPos[j] = TagAgainstAnchor.this.anchor.getPosition(i);
                }
            }
            for (i = 0; i < this.obsTdist.length; ++i) {
                int chr = TagAgainstAnchor.this.anchor.getChromosomeNumber(bestSite[i]);
                double[] result = new double[]{chr, bestSite[i], TagAgainstAnchor.this.anchor.getPosition(bestSite[i]), bestP[i], countSig[i]};
                this.resultReport[i][this.chrIndex] = result;
            }
        }
    }

    class Task
    implements Runnable {
        int tagStartIndex;
        int tagEndIndex;
        TagsByTaxaByte subTBT;
        String[] result = null;
        int blockNum;
        int[] blockStartIndex;
        int[] blockEndIndex;
        int[] blockTagIndex;
        int[] blockChromosome = null;
        int[] blockPosition = null;
        int[] refDiv = null;
        long[][] testTag = null;
        long[][] testTagDist = null;
        double[][][] theResults = null;

        Task(int tagStartIndex, int tagEndIndex) {
            this.buildSubTBT(tagStartIndex, tagEndIndex);
            this.buildTagBlock();
        }

        private void buildTagBlock() {
            int left = this.subTBT.getTagCount() % TagAgainstAnchor.this.tagBlockSize;
            if (left == 0) {
                this.blockNum = this.subTBT.getTagCount() / TagAgainstAnchor.this.tagBlockSize;
                this.blockStartIndex = new int[this.blockNum];
                this.blockEndIndex = new int[this.blockNum];
                for (int i = 0; i < this.blockNum; ++i) {
                    this.blockStartIndex[i] = i * TagAgainstAnchor.this.tagBlockSize;
                    this.blockEndIndex[i] = this.blockStartIndex[i] + TagAgainstAnchor.this.tagBlockSize;
                }
            } else {
                this.blockNum = this.subTBT.getTagCount() / TagAgainstAnchor.this.tagBlockSize + 1;
                this.blockStartIndex = new int[this.blockNum];
                this.blockEndIndex = new int[this.blockNum];
                for (int i = 0; i < this.blockNum - 1; ++i) {
                    this.blockStartIndex[i] = i * TagAgainstAnchor.this.tagBlockSize;
                    this.blockEndIndex[i] = this.blockStartIndex[i] + TagAgainstAnchor.this.tagBlockSize;
                }
                this.blockStartIndex[this.blockNum - 1] = TagAgainstAnchor.this.tagBlockSize * (this.blockNum - 1);
                this.blockEndIndex[this.blockNum - 1] = this.subTBT.getTagCount();
            }
        }

        private void buildSubTBT(int tagStartIndex, int tagEndIndex) {
            this.tagStartIndex = tagStartIndex;
            this.tagEndIndex = tagEndIndex;
            int tagCount = tagEndIndex - tagStartIndex;
            long[][] tags = new long[TagAgainstAnchor.this.tbt.getTagSizeInLong()][tagCount];
            byte[] tagLength = new byte[tagCount];
            byte[][] tagDist = new byte[TagAgainstAnchor.this.tbt.getTaxaCount()][tagCount];
            String[] namesForTaxa = TagAgainstAnchor.this.tbt.getTaxaNames();
            for (int i = 0; i < tagCount; ++i) {
                int j;
                int tagIndex = i + tagStartIndex;
                long[] t = TagAgainstAnchor.this.tbt.getTag(tagIndex);
                for (j = 0; j < tags.length; ++j) {
                    tags[j][i] = t[j];
                }
                tagLength[i] = (byte)TagAgainstAnchor.this.tbt.getTagLength(tagIndex);
                for (j = 0; j < TagAgainstAnchor.this.tbt.getTaxaCount(); ++j) {
                    tagDist[j][i] = (byte)TagAgainstAnchor.this.tbt.getReadCountForTagTaxon(tagIndex, j);
                }
            }
            this.subTBT = new TagsByTaxaByte(tags, tagLength, tagDist, namesForTaxa);
        }

        public String[] getResult() {
            return this.result;
        }

        private void initialize(int blockSize) {
            this.blockChromosome = new int[blockSize];
            this.blockPosition = new int[blockSize];
            this.refDiv = new int[blockSize];
            this.testTag = new long[blockSize][];
            this.testTagDist = new long[blockSize][];
            this.theResults = new double[blockSize][][];
            this.populate(blockSize);
        }

        private void populate(int blockSize) {
            for (int i = 0; i < blockSize; ++i) {
                this.blockChromosome[i] = Integer.MIN_VALUE;
                this.blockPosition[i] = Integer.MIN_VALUE;
                this.refDiv[i] = Integer.MIN_VALUE;
                this.theResults[i] = new double[TagAgainstAnchor.this.chromosomeNumber.length][];
            }
        }

        @Override
        public void run() {
            long lastTimePoint = TagAgainstAnchor.this.getCurrentTimeNano();
            ArrayList<String> resultList = new ArrayList<String>();
            ScanChromosome[] scanOnChr = null;
            for (int i = 0; i < this.blockNum; ++i) {
                int j;
                int blockSize = this.blockEndIndex[i] - this.blockStartIndex[i];
                ArrayList<Integer> blockTagIndexList = new ArrayList<Integer>();
                for (j = 0; j < blockSize; ++j) {
                    if (this.subTBT.getNumberOfTaxaWithTag(this.blockStartIndex[i] + j) < TagAgainstAnchor.this.minCount) continue;
                    blockTagIndexList.add(this.blockStartIndex[i] + j);
                }
                if (blockTagIndexList.size() == 0) continue;
                this.blockTagIndex = new int[blockTagIndexList.size()];
                for (j = 0; j < blockTagIndexList.size(); ++j) {
                    this.blockTagIndex[j] = (Integer)blockTagIndexList.get(j);
                }
                blockSize = this.blockTagIndex.length;
                this.initialize(blockSize);
                for (j = 0; j < blockSize; ++j) {
                    this.testTag[j] = this.subTBT.getTag(this.blockTagIndex[j]);
                    this.testTagDist[j] = TagAgainstAnchor.this.getTagsInBits(this.subTBT, this.blockTagIndex[j], TagAgainstAnchor.this.tbtRedirect, TagAgainstAnchor.this.anchor.getTaxaNum());
                }
                scanOnChr = new ScanChromosome[TagAgainstAnchor.this.chromosomeNumber.length];
                for (j = 0; j < TagAgainstAnchor.this.chromosomeNumber.length; ++j) {
                    this.blockChromosome = new int[blockSize];
                    this.blockPosition = new int[blockSize];
                    for (int k = 0; k < blockSize; ++k) {
                        if (TagAgainstAnchor.this.blockChr[this.tagStartIndex + this.blockTagIndex[k]] != TagAgainstAnchor.this.chromosomeNumber[j]) {
                            this.blockChromosome[k] = Integer.MIN_VALUE;
                            this.blockPosition[k] = Integer.MIN_VALUE;
                            continue;
                        }
                        this.blockChromosome[k] = TagAgainstAnchor.this.blockChr[this.tagStartIndex + this.blockTagIndex[k]];
                        this.blockPosition[k] = TagAgainstAnchor.this.blockPos[this.tagStartIndex + this.blockTagIndex[k]];
                    }
                    scanOnChr[j] = new ScanChromosome(this.testTagDist, this.theResults, j, TagAgainstAnchor.this.chrStartIndex[j], TagAgainstAnchor.this.chrEndIndex[j], TagAgainstAnchor.this.pThresh, 1, this.blockPosition);
                    scanOnChr[j].scan();
                }
                double[] pRank = null;
                int bestAlignment = Integer.MIN_VALUE;
                for (int j2 = 0; j2 < blockSize; ++j2) {
                    pRank = new double[TagAgainstAnchor.this.chromosomeNumber.length];
                    double[] bestR = new double[]{-1.0, -1.0, -1.0, 1.0, -1.0};
                    int countRealSig = 0;
                    for (int k = 0; k < TagAgainstAnchor.this.chromosomeNumber.length; ++k) {
                        double[] r = this.theResults[j2][k];
                        pRank[k] = r[3];
                        if (r[3] < bestR[3]) {
                            bestR = (double[])r.clone();
                            bestAlignment = k;
                        }
                        if (!(r[3] < TagAgainstAnchor.this.pThresh)) continue;
                        ++countRealSig;
                    }
                    if (bestR[3] == 1.0) continue;
                    Arrays.sort(pRank);
                    long[][] singleTagDist = new long[][]{this.testTagDist[j2]};
                    double[][][] bestResWithNewThreshold = new double[1][1][];
                    this.blockChromosome = new int[1];
                    this.blockPosition = new int[1];
                    int blastChr = TagAgainstAnchor.this.blockChr[this.tagStartIndex + this.blockTagIndex[j2]];
                    int blastPos = TagAgainstAnchor.this.blockPos[this.tagStartIndex + this.blockTagIndex[j2]];
                    if (blastChr != TagAgainstAnchor.this.chromosomeNumber[bestAlignment]) {
                        this.blockChromosome[0] = Integer.MIN_VALUE;
                        this.blockPosition[0] = Integer.MIN_VALUE;
                    } else {
                        this.blockChromosome[0] = blastChr;
                        this.blockPosition[0] = blastPos;
                    }
                    ScanChromosome bestChrNewThres = new ScanChromosome(singleTagDist, bestResWithNewThreshold, 0, TagAgainstAnchor.this.chrStartIndex[bestAlignment], TagAgainstAnchor.this.chrEndIndex[bestAlignment], pRank[1], 1, this.blockPosition);
                    bestChrNewThres.scan();
                    int countOfSitesBetterThanNextBestChr = (int)bestResWithNewThreshold[0][0][4];
                    if (pRank[0] == 0.0) {
                        pRank[0] = Double.MIN_VALUE;
                    }
                    String s = String.format("%s\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%g\t%d\t%d\t%d\t%g\t%g\t%d\t%d\t%d\t%n", BaseEncoder.getSequenceFromLong(this.testTag[j2]), this.subTBT.getReadCount(this.blockTagIndex[j2]), blastChr, blastPos, this.refDiv[j2], (int)bestR[0], (int)bestR[1], (int)bestR[2], bestR[3], (int)bestR[4], this.subTBT.getNumberOfTaxaWithTag(this.blockTagIndex[j2]), countRealSig, Math.log10(pRank[1] / pRank[0]), Math.log10(pRank[TagAgainstAnchor.this.chromosomeNumber.length / 2] / pRank[0]), countOfSitesBetterThanNextBestChr, bestChrNewThres.minSigPos[0], bestChrNewThres.maxSigPos[0]);
                    resultList.add(s);
                }
            }
            this.result = resultList.toArray(new String[resultList.size()]);
        }
    }
}

