/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.io.BufferedWriter;
import java.io.DataOutputStream;

class cluster
implements Comparable<cluster> {
    int queryIndex;
    int hitIndex;
    int cSize;
    boolean ifSnp;

    public cluster(int queryIndex, int hitIndex, int cSize, boolean ifSnp) {
        this.queryIndex = queryIndex;
        this.hitIndex = hitIndex;
        this.cSize = cSize;
        this.ifSnp = ifSnp;
    }

    public void setIfSnp(boolean ifSnp) {
        this.ifSnp = ifSnp;
    }

    public void writeBinary(DataOutputStream dos) {
        try {
            if (this.ifSnp) {
                dos.writeInt(this.queryIndex);
                dos.writeInt(this.hitIndex);
                dos.writeInt(this.cSize);
                dos.writeBoolean(this.ifSnp);
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public void writeTxt(BufferedWriter bw) {
        try {
            if (this.ifSnp) {
                bw.write(this.queryIndex + "\t" + this.hitIndex + "\t" + this.cSize + "\t" + String.valueOf(this.ifSnp));
                bw.newLine();
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public void screenPri() {
        System.out.println(this.queryIndex + "\t" + this.hitIndex + "\t" + this.cSize);
    }

    public void switchQueryAndHit() {
        if (this.queryIndex > this.hitIndex) {
            int mid = this.queryIndex;
            this.queryIndex = this.hitIndex;
            this.hitIndex = mid;
        }
    }

    @Override
    public int compareTo(cluster o) {
        if (this.queryIndex < o.queryIndex) {
            return -1;
        }
        if (this.queryIndex > o.queryIndex) {
            return 1;
        }
        if (this.hitIndex < o.hitIndex) {
            return -1;
        }
        if (this.hitIndex > o.hitIndex) {
            return 1;
        }
        if (this.cSize < o.cSize) {
            return -1;
        }
        if (this.cSize > o.cSize) {
            return 1;
        }
        return 0;
    }
}

