/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.neobio;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import net.maizegenetics.analysis.gbs.neobio.InvalidSequenceException;

public class CharSequence {
    protected static final char COMMENT_CHAR = '>';
    protected char[] sequence;

    public CharSequence(Reader reader) throws IOException, InvalidSequenceException {
        int ch;
        BufferedReader input = new BufferedReader(reader);
        StringBuffer buf = new StringBuffer();
        while ((ch = input.read()) != -1) {
            char c = (char)ch;
            if (c == '>') {
                input.readLine();
                continue;
            }
            if (Character.isLetter(c)) {
                buf.append(c);
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            throw new InvalidSequenceException("Sequences can contain letters only.");
        }
        if (buf.length() <= 0) {
            throw new InvalidSequenceException("Empty sequence.");
        }
        this.sequence = new char[buf.length()];
        buf.getChars(0, buf.length(), this.sequence, 0);
    }

    public int length() {
        return this.sequence.length;
    }

    public char charAt(int pos) {
        return this.sequence[pos - 1];
    }

    public String toString() {
        return new String(this.sequence);
    }
}

