/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.neobio;

import net.maizegenetics.analysis.gbs.neobio.AlignmentBlock;
import net.maizegenetics.analysis.gbs.neobio.CrochemoreLandauZivUkelson;
import net.maizegenetics.analysis.gbs.neobio.Factor;
import net.maizegenetics.analysis.gbs.neobio.IncompatibleScoringSchemeException;
import net.maizegenetics.analysis.gbs.neobio.PairwiseAlignment;

public class CrochemoreLandauZivUkelsonGlobalAlignment
extends CrochemoreLandauZivUkelson {
    @Override
    protected AlignmentBlock createBlock(Factor factor1, Factor factor2, int row, int col) throws IncompatibleScoringSchemeException {
        int lr = factor1.length();
        int lc = factor2.length();
        int size = lr + lc + 1;
        AlignmentBlock block = new AlignmentBlock(factor1, factor2, size);
        AlignmentBlock left_prefix = this.getLeftPrefix(block);
        AlignmentBlock diag_prefix = this.getDiagonalPrefix(block);
        AlignmentBlock top_prefix = this.getTopPrefix(block);
        int score_ins = this.scoreInsertion(factor2.getNewChar());
        int score_sub = this.scoreSubstitution(factor1.getNewChar(), factor2.getNewChar());
        int score_del = this.scoreDeletion(factor1.getNewChar());
        for (int i = 0; i < size; ++i) {
            int max;
            int del = Integer.MIN_VALUE;
            int sub = Integer.MIN_VALUE;
            int ins = Integer.MIN_VALUE;
            if (i < size - 1) {
                ins = left_prefix.dist_column[i] + score_ins;
            }
            if (i > 0 && i < size - 1) {
                sub = diag_prefix.dist_column[i - 1] + score_sub;
            }
            if (i > 0) {
                del = top_prefix.dist_column[i - 1] + score_del;
            }
            block.dist_column[i] = max = this.max(ins, sub, del);
            block.direction[i] = max == ins ? 1 : (max == sub ? 2 : 3);
        }
        this.computeOutputBorder(block, row, col, size, lc, lr);
        return block;
    }

    @Override
    protected AlignmentBlock createRootBlock(Factor factor1, Factor factor2) {
        return new AlignmentBlock(factor1, factor2);
    }

    @Override
    protected AlignmentBlock createFirstRowBlock(Factor factor1, Factor factor2, int col) throws IncompatibleScoringSchemeException {
        int lr = 0;
        int lc = factor2.length();
        int size = lr + lc + 1;
        AlignmentBlock block = new AlignmentBlock(factor1, factor2, size);
        AlignmentBlock left_prefix = this.getLeftPrefix(block);
        int score_ins = this.scoreInsertion(factor2.getNewChar());
        for (int i = 0; i < lc; ++i) {
            block.dist_column[i] = left_prefix.dist_column[i] + score_ins;
            block.direction[i] = 1;
        }
        block.dist_column[lc] = 0;
        block.direction[lc] = 0;
        this.computeOutputBorder(block, 0, col, size, lc, lr);
        return block;
    }

    @Override
    protected AlignmentBlock createFirstColumnBlock(Factor factor1, Factor factor2, int row) throws IncompatibleScoringSchemeException {
        int lr = factor1.length();
        int lc = 0;
        int size = lr + lc + 1;
        AlignmentBlock block = new AlignmentBlock(factor1, factor2, size);
        AlignmentBlock top_prefix = this.getTopPrefix(block);
        int score_del = this.scoreDeletion(factor1.getNewChar());
        block.dist_column[0] = 0;
        block.direction[0] = 0;
        for (int i = 1; i < size; ++i) {
            block.dist_column[i] = top_prefix.dist_column[i - 1] + score_del;
            block.direction[i] = 3;
        }
        this.computeOutputBorder(block, row, 0, size, lc, lr);
        return block;
    }

    protected void computeOutputBorder(AlignmentBlock block, int row, int col, int dim, int lc, int lr) {
        int[] input = this.assembleInputBorder(dim, row, col, lr);
        int[][] dist = this.assembleDistMatrix(block, dim, row, col, lc);
        this.out_matrix.setData(dist, input, dim, lc);
        this.smawk.computeColumnMaxima(this.out_matrix, block.source_path);
        for (int i = 0; i < dim; ++i) {
            block.output_border[i] = this.out_matrix.valueAt(block.source_path[i], i);
        }
    }

    @Override
    protected PairwiseAlignment buildOptimalAlignment() throws IncompatibleScoringSchemeException {
        StringBuffer gapped_seq1 = new StringBuffer();
        StringBuffer tag_line = new StringBuffer();
        StringBuffer gapped_seq2 = new StringBuffer();
        int row = this.num_rows - 1;
        int col = this.num_cols - 1;
        AlignmentBlock block = this.block_table[row][col];
        int dest = block.factor2.length();
        while (row > 0 || col > 0) {
            block = this.block_table[row][col];
            int source = block.source_path[dest];
            AlignmentBlock ancestor = block.ancestor[dest];
            int ancestor_source = source;
            if (dest > block.factor2.length()) {
                ancestor_source -= block.factor1.length() - ancestor.factor1.length();
            }
            this.traverseBlock(ancestor, ancestor_source, gapped_seq1, tag_line, gapped_seq2);
            if (row == 0) {
                dest = this.block_table[row][--col].factor2.length();
                continue;
            }
            if (col == 0) {
                --row;
                dest = 0;
                continue;
            }
            if (source < block.factor1.length()) {
                dest = this.block_table[row][--col].factor2.length() + source;
                continue;
            }
            if (source == block.factor1.length()) {
                dest = this.block_table[--row][--col].factor2.length();
                continue;
            }
            --row;
            dest = source - block.factor1.length();
        }
        return new PairwiseAlignment(gapped_seq1.toString(), tag_line.toString(), gapped_seq2.toString(), this.locateScore());
    }

    @Override
    protected int locateScore() {
        AlignmentBlock last_block = this.block_table[this.num_rows - 1][this.num_cols - 1];
        return last_block.output_border[last_block.factor2.length()];
    }
}

