/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.neobio;

import net.maizegenetics.analysis.gbs.neobio.AlignmentBlock;
import net.maizegenetics.analysis.gbs.neobio.CrochemoreLandauZivUkelson;
import net.maizegenetics.analysis.gbs.neobio.Factor;
import net.maizegenetics.analysis.gbs.neobio.IncompatibleScoringSchemeException;
import net.maizegenetics.analysis.gbs.neobio.LocalAlignmentBlock;
import net.maizegenetics.analysis.gbs.neobio.PairwiseAlignment;

public class CrochemoreLandauZivUkelsonLocalAlignment
extends CrochemoreLandauZivUkelson {
    protected static final byte TYPE_CROSSING_PATH = 0;
    protected static final byte TYPE_S_PATH = 1;
    protected static final byte TYPE_C_PATH = 2;
    protected static final byte TYPE_E_PATH = 3;
    protected int max_score;
    protected int max_row;
    protected int max_col;
    protected byte max_path_type;
    protected int max_source_index;

    @Override
    protected AlignmentBlock createBlock(Factor factor1, Factor factor2, int row, int col) throws IncompatibleScoringSchemeException {
        int max;
        int ins;
        int del;
        int lr = factor1.length();
        int lc = factor2.length();
        int size = lr + lc + 1;
        LocalAlignmentBlock block = new LocalAlignmentBlock(factor1, factor2, size);
        LocalAlignmentBlock left_prefix = (LocalAlignmentBlock)this.getLeftPrefix(block);
        LocalAlignmentBlock diag_prefix = (LocalAlignmentBlock)this.getDiagonalPrefix(block);
        LocalAlignmentBlock top_prefix = (LocalAlignmentBlock)this.getTopPrefix(block);
        int score_ins = this.scoreInsertion(factor2.getNewChar());
        int score_sub = this.scoreSubstitution(factor1.getNewChar(), factor2.getNewChar());
        int score_del = this.scoreDeletion(factor1.getNewChar());
        for (int i = 0; i < size; ++i) {
            int del_E = Integer.MIN_VALUE;
            int ins_E = Integer.MIN_VALUE;
            del = Integer.MIN_VALUE;
            int sub = Integer.MIN_VALUE;
            ins = Integer.MIN_VALUE;
            if (i < size - 1) {
                ins = left_prefix.dist_column[i] + score_ins;
                ins_E = left_prefix.E_path_score[i];
            }
            if (i > 0 && i < size - 1) {
                sub = diag_prefix.dist_column[i - 1] + score_sub;
            }
            if (i > 0) {
                del = top_prefix.dist_column[i - 1] + score_del;
                del_E = top_prefix.E_path_score[i - 1];
            }
            block.dist_column[i] = max = this.max(ins, sub, del);
            block.direction[i] = max == ins ? 1 : (max == sub ? 2 : 3);
            block.E_path_score[i] = max = this.max(ins_E, block.dist_column[i], del_E);
            if (max == ins_E) {
                block.E_path_ancestor[i] = left_prefix.E_path_ancestor[i];
                block.E_path_ancestor_index[i] = left_prefix.E_path_ancestor_index[i];
            } else if (max == block.dist_column[i]) {
                block.E_path_ancestor[i] = block;
                block.E_path_ancestor_index[i] = i;
            } else {
                block.E_path_ancestor[i] = top_prefix.E_path_ancestor[i - 1];
                block.E_path_ancestor_index[i] = top_prefix.E_path_ancestor_index[i - 1];
            }
            if (i < lc) {
                block.S_path_score[i] = left_prefix.S_path_score[i];
                continue;
            }
            if (i == lc) {
                ins = left_prefix.S_path_score[i - 1] + score_ins;
                sub = diag_prefix.S_path_score[i - 1] + score_sub;
                del = top_prefix.S_path_score[i] + score_del;
                block.S_path_score[i] = max = this.max(0, ins, sub, del);
                if (max == ins) {
                    block.S_direction = 1;
                    continue;
                }
                if (max == sub) {
                    block.S_direction = (byte)2;
                    continue;
                }
                if (max == del) {
                    block.S_direction = (byte)3;
                    continue;
                }
                block.S_direction = 0;
                continue;
            }
            block.S_path_score[i] = top_prefix.S_path_score[i - 1];
        }
        this.computeOutputBorder(block, row, col, size, lc, lr);
        ins = left_prefix.C;
        del = top_prefix.C;
        block.C = max = this.max(ins, block.S_path_score[lc], del);
        if (block.C > this.max_score) {
            this.max_score = block.C;
            this.max_row = row;
            this.max_col = col;
            this.max_path_type = (byte)2;
        }
        return block;
    }

    @Override
    protected AlignmentBlock createRootBlock(Factor factor1, Factor factor2) {
        this.max_score = 0;
        this.max_col = 0;
        this.max_row = 0;
        this.max_path_type = (byte)2;
        return new LocalAlignmentBlock(factor1, factor2);
    }

    @Override
    protected AlignmentBlock createFirstRowBlock(Factor factor1, Factor factor2, int col) throws IncompatibleScoringSchemeException {
        int lr = 0;
        int lc = factor2.length();
        int size = lr + lc + 1;
        LocalAlignmentBlock block = new LocalAlignmentBlock(factor1, factor2, size);
        LocalAlignmentBlock left_prefix = (LocalAlignmentBlock)this.getLeftPrefix(block);
        int score_ins = this.scoreInsertion(factor2.getNewChar());
        for (int i = 0; i < lc; ++i) {
            block.dist_column[i] = left_prefix.dist_column[i] + score_ins;
            block.direction[i] = 1;
            block.S_path_score[i] = left_prefix.S_path_score[i];
            block.E_path_score[i] = left_prefix.E_path_score[i];
            block.E_path_ancestor[i] = left_prefix.E_path_ancestor[i];
            block.E_path_ancestor_index[i] = left_prefix.E_path_ancestor_index[i];
            if (block.dist_column[i] <= block.E_path_score[i]) continue;
            block.E_path_score[i] = block.dist_column[i];
            block.E_path_ancestor[i] = block;
            block.E_path_ancestor_index[i] = i;
        }
        block.dist_column[lc] = 0;
        block.E_path_score[lc] = 0;
        block.direction[lc] = 0;
        block.E_path_ancestor[lc] = block;
        block.E_path_ancestor_index[lc] = lc;
        block.S_direction = 1;
        block.S_path_score[lc] = left_prefix.S_path_score[lc - 1] + score_ins;
        if (block.S_path_score[lc] <= 0) {
            block.S_path_score[lc] = 0;
            block.S_direction = 0;
        }
        this.computeOutputBorder(block, 0, col, size, lc, lr);
        block.C = this.max(left_prefix.C, block.S_path_score[lc]);
        if (block.C > this.max_score) {
            this.max_score = block.C;
            this.max_row = 0;
            this.max_col = col;
            this.max_path_type = (byte)2;
        }
        return block;
    }

    @Override
    protected AlignmentBlock createFirstColumnBlock(Factor factor1, Factor factor2, int row) throws IncompatibleScoringSchemeException {
        int lr = factor1.length();
        int lc = 0;
        int size = lr + lc + 1;
        LocalAlignmentBlock block = new LocalAlignmentBlock(factor1, factor2, size);
        LocalAlignmentBlock top_prefix = (LocalAlignmentBlock)this.getTopPrefix(block);
        int score_del = this.scoreDeletion(factor1.getNewChar());
        block.dist_column[0] = 0;
        block.E_path_score[0] = 0;
        block.direction[0] = 0;
        block.E_path_ancestor[0] = block;
        block.E_path_ancestor_index[0] = 0;
        block.S_direction = (byte)3;
        block.S_path_score[0] = top_prefix.S_path_score[0] + score_del;
        if (block.S_path_score[0] <= 0) {
            block.S_path_score[0] = 0;
            block.S_direction = 0;
        }
        for (int i = 1; i < size; ++i) {
            block.dist_column[i] = top_prefix.dist_column[i - 1] + score_del;
            block.direction[i] = 3;
            block.S_path_score[i] = top_prefix.S_path_score[i - 1];
            block.E_path_score[i] = top_prefix.E_path_score[i - 1];
            block.E_path_ancestor[i] = top_prefix.E_path_ancestor[i - 1];
            block.E_path_ancestor_index[i] = top_prefix.E_path_ancestor_index[i - 1];
            if (block.dist_column[i] <= block.E_path_score[i]) continue;
            block.E_path_score[i] = block.dist_column[i];
            block.E_path_ancestor[i] = block;
            block.E_path_ancestor_index[i] = i;
        }
        this.computeOutputBorder(block, row, 0, size, lc, lr);
        block.C = this.max(block.S_path_score[lc], top_prefix.C);
        if (block.C > this.max_score) {
            this.max_score = block.C;
            this.max_row = row;
            this.max_col = 0;
            this.max_path_type = (byte)2;
        }
        return block;
    }

    protected void computeOutputBorder(LocalAlignmentBlock block, int row, int col, int dim, int lc, int lr) {
        int[] input = this.assembleInputBorder(dim, row, col, lr);
        int[][] dist = this.assembleDistMatrix(block, dim, row, col, lc);
        this.out_matrix.setData(dist, input, dim, lc);
        this.smawk.computeColumnMaxima(this.out_matrix, block.source_path);
        for (int i = 0; i < dim; ++i) {
            block.path_type[i] = 0;
            block.output_border[i] = this.out_matrix.valueAt(block.source_path[i], i);
            if (block.S_path_score[i] >= block.output_border[i]) {
                block.output_border[i] = block.S_path_score[i];
                block.path_type[i] = 1;
            }
            if (input[i] + block.E_path_score[i] <= this.max_score) continue;
            this.max_score = input[i] + block.E_path_score[i];
            this.max_row = row;
            this.max_col = col;
            this.max_source_index = i;
            this.max_path_type = (byte)3;
        }
    }

    @Override
    protected PairwiseAlignment buildOptimalAlignment() throws IncompatibleScoringSchemeException {
        StringBuffer gapped_seq1 = new StringBuffer();
        StringBuffer tag_line = new StringBuffer();
        StringBuffer gapped_seq2 = new StringBuffer();
        LocalAlignmentBlock block = (LocalAlignmentBlock)this.block_table[this.max_row][this.max_col];
        if (this.max_path_type == 2) {
            this.traverseS_Path(block, gapped_seq1, tag_line, gapped_seq2);
        } else {
            this.traverseBlockCrossingPath(block, gapped_seq1, tag_line, gapped_seq2);
        }
        return new PairwiseAlignment(gapped_seq1.toString(), tag_line.toString(), gapped_seq2.toString(), this.locateScore());
    }

    protected void traverseBlockCrossingPath(LocalAlignmentBlock block, StringBuffer gapped_seq1, StringBuffer tag_line, StringBuffer gapped_seq2) throws IncompatibleScoringSchemeException {
        int row = this.max_row;
        int col = this.max_col;
        int source = this.max_source_index;
        LocalAlignmentBlock ancestor = block.E_path_ancestor[source];
        int ancestor_source = block.E_path_ancestor_index[source];
        this.traverseBlock(ancestor, ancestor_source, gapped_seq1, tag_line, gapped_seq2);
        while (true) {
            int dest;
            if (row == 0) {
                dest = this.block_table[row][--col].factor2.length();
            } else if (col == 0) {
                --row;
                dest = 0;
            } else if (source < block.factor1.length()) {
                dest = this.block_table[row][--col].factor2.length() + source;
            } else if (source == block.factor1.length()) {
                dest = this.block_table[--row][--col].factor2.length();
            } else {
                --row;
                dest = source - block.factor1.length();
            }
            if (row <= 0 && col <= 0) break;
            block = (LocalAlignmentBlock)this.block_table[row][col];
            if (block.path_type[dest] == 1) {
                ancestor = (LocalAlignmentBlock)block.ancestor[dest];
                this.traverseS_Path(ancestor, gapped_seq1, tag_line, gapped_seq2);
                break;
            }
            source = block.source_path[dest];
            ancestor = (LocalAlignmentBlock)block.ancestor[dest];
            ancestor_source = source;
            if (dest > block.factor2.length()) {
                ancestor_source -= block.factor1.length() - ancestor.factor1.length();
            }
            this.traverseBlock(ancestor, ancestor_source, gapped_seq1, tag_line, gapped_seq2);
        }
    }

    protected void traverseS_Path(LocalAlignmentBlock block, StringBuffer gapped_seq1, StringBuffer tag_line, StringBuffer gapped_seq2) throws IncompatibleScoringSchemeException {
        while (block.S_direction != 0) {
            char char1 = block.factor1.getNewChar();
            char char2 = block.factor2.getNewChar();
            switch (block.S_direction) {
                case 1: {
                    gapped_seq1.insert(0, '-');
                    tag_line.insert(0, ' ');
                    gapped_seq2.insert(0, char2);
                    block = (LocalAlignmentBlock)this.getLeftPrefix(block);
                    break;
                }
                case 2: {
                    gapped_seq1.insert(0, char1);
                    if (char1 == char2) {
                        if (this.useMatchTag()) {
                            tag_line.insert(0, '|');
                        } else {
                            tag_line.insert(0, char1);
                        }
                    } else if (this.scoreSubstitution(char1, char2) > 0) {
                        tag_line.insert(0, '+');
                    } else {
                        tag_line.insert(0, ' ');
                    }
                    gapped_seq2.insert(0, char2);
                    block = (LocalAlignmentBlock)this.getDiagonalPrefix(block);
                    break;
                }
                case 3: {
                    gapped_seq1.insert(0, char1);
                    tag_line.insert(0, ' ');
                    gapped_seq2.insert(0, '-');
                    block = (LocalAlignmentBlock)this.getTopPrefix(block);
                }
            }
        }
    }

    @Override
    protected int locateScore() {
        return this.max_score;
    }
}

