/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.neobio;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import net.maizegenetics.analysis.gbs.neobio.Factor;
import net.maizegenetics.analysis.gbs.neobio.InvalidSequenceException;
import net.maizegenetics.analysis.gbs.neobio.Trie;

public class FactorSequence {
    protected static final char COMMENT_CHAR = '>';
    protected Factor root_factor;
    protected int num_chars;
    protected int num_factors;

    public FactorSequence(Reader reader) throws IOException, InvalidSequenceException {
        int ch;
        BufferedReader input = new BufferedReader(reader);
        Trie new_node = null;
        this.root_factor = new Factor();
        Trie root_node = new Trie(this.root_factor);
        this.num_factors = 1;
        this.num_chars = 0;
        Trie current_node = root_node;
        Factor last_factor = this.root_factor;
        while ((ch = input.read()) != -1) {
            char c = (char)ch;
            if (c == '>') {
                input.readLine();
                continue;
            }
            if (Character.isLetter(c)) {
                ++this.num_chars;
                new_node = current_node.spellDown(c);
                if (new_node != null) {
                    current_node = new_node;
                    continue;
                }
                Factor current_factor = (Factor)current_node.getData();
                Factor new_factor = new Factor(current_factor, this.num_factors, c);
                current_node.add(new_factor, c);
                last_factor.setNext(new_factor);
                last_factor = new_factor;
                current_node = root_node;
                ++this.num_factors;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            throw new InvalidSequenceException("Sequences can contain letters only.");
        }
        if (new_node != null) {
            last_factor.setNext((Factor)new_node.getData());
            ++this.num_factors;
        }
        if (this.num_factors <= 1) {
            throw new InvalidSequenceException("Empty sequence.");
        }
    }

    public Factor getRootFactor() {
        return this.root_factor;
    }

    public int numFactors() {
        return this.num_factors;
    }

    public int numChars() {
        return this.num_chars;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Factor node = this.root_factor.getNext();
        for (int i = 1; i < this.numFactors(); ++i) {
            buf.append(node);
            node = node.getNext();
        }
        return buf.toString();
    }

    public String printFactors() {
        StringBuffer buf = new StringBuffer();
        Factor factor = this.root_factor.getNext();
        for (int i = 1; i < this.numFactors(); ++i) {
            buf.append(factor.getSerialNumber() + "\t<");
            buf.append(factor.getAncestor().getSerialNumber() + " ,\t");
            buf.append(factor.getNewChar() + ">\t");
            buf.append(factor.length() + "\t" + factor + "\n");
            factor = factor.getNext();
        }
        buf.append(this.numFactors() + " factors\n");
        return buf.toString();
    }
}

