/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.neobio;

import net.maizegenetics.analysis.gbs.neobio.Matrix;

public class Smawk {
    protected Matrix matrix;
    protected int numrows;
    protected int[] row;
    protected int[] row_position;
    protected int numcols;
    protected int[] col;

    public synchronized void computeColumnMaxima(Matrix matrix, int[] col_maxima) {
        int i;
        this.matrix = matrix;
        this.numcols = matrix.numColumns();
        this.col = new int[this.numcols];
        for (i = 0; i < this.numcols; ++i) {
            this.col[i] = i;
        }
        this.numrows = matrix.numRows();
        this.row = new int[this.numrows];
        for (i = 0; i < this.numrows; ++i) {
            this.row[i] = i;
        }
        this.row_position = new int[this.numrows];
        this.computeColumnMaxima(col_maxima);
    }

    protected void computeColumnMaxima(int[] col_maxima) {
        int r;
        int original_numrows = this.numrows;
        if (this.numrows > this.numcols) {
            this.reduce();
        }
        if (this.numrows == 1) {
            col_maxima[this.col[0]] = this.row[0];
            if (original_numrows > this.numrows) {
                this.restoreRows(original_numrows);
            }
            return;
        }
        int original_numcols = this.numcols;
        this.deleteOddColumns();
        this.computeColumnMaxima(col_maxima);
        this.restoreOddColumns(original_numcols);
        for (r = 0; r < this.numrows; ++r) {
            this.row_position[this.row[r]] = r;
        }
        for (int c = 1; c < this.numcols; c += 2) {
            int end = c < this.numcols - 1 ? this.row_position[col_maxima[this.col[c + 1]]] : this.numrows - 1;
            int max = this.row_position[col_maxima[this.col[c - 1]]];
            for (r = max + 1; r <= end; ++r) {
                if (this.valueAt(r, c) <= this.valueAt(max, c)) continue;
                max = r;
            }
            col_maxima[this.col[c]] = this.row[max];
        }
        if (original_numrows > this.numrows) {
            this.restoreRows(original_numrows);
        }
    }

    protected final int valueAt(int r, int c) {
        return this.matrix.valueAt(this.row[r], this.col[c]);
    }

    protected void deleteOddColumns() {
        for (int c = 2; c < this.numcols; c += 2) {
            int tmp = this.col[c / 2];
            this.col[c / 2] = this.col[c];
            this.col[c] = tmp;
        }
        this.numcols = (this.numcols - 1) / 2 + 1;
    }

    protected void restoreOddColumns(int original_numcols) {
        for (int c = 2 * ((original_numcols - 1) / 2); c > 0; c -= 2) {
            int tmp = this.col[c / 2];
            this.col[c / 2] = this.col[c];
            this.col[c] = tmp;
        }
        this.numcols = original_numcols;
    }

    protected void reduce() {
        int k = 0;
        int reduced_numrows = this.numrows;
        while (reduced_numrows > this.numcols) {
            if (this.valueAt(k, k) < this.valueAt(k + 1, k)) {
                this.deleteRow(reduced_numrows, k);
                --reduced_numrows;
                --k;
                continue;
            }
            if (k < this.numcols - 1) {
                ++k;
                continue;
            }
            this.deleteRow(reduced_numrows, k + 1);
            --reduced_numrows;
        }
        this.numrows = reduced_numrows;
    }

    protected void deleteRow(int reduced_rows, int k) {
        int r;
        int saved_row = this.row[k];
        for (r = k + 1; r < reduced_rows; ++r) {
            this.row[r - 1] = this.row[r];
        }
        for (r = reduced_rows - 1; r < this.numrows - 1 && this.row[r + 1] < saved_row; ++r) {
            this.row[r] = this.row[r + 1];
        }
        this.row[r] = saved_row;
    }

    protected void restoreRows(int original_numrows) {
        int d = this.numrows;
        for (int r = 0; r < d; ++r) {
            if (this.row[r] <= this.row[d]) continue;
            int s = this.row[d];
            for (int r2 = d; r2 > r; --r2) {
                this.row[r2] = this.row[r2 - 1];
            }
            this.row[r] = s;
            if (++d > original_numrows - 1) break;
        }
        this.numrows = original_numrows;
    }

    public static void naiveComputeColumnMaxima(Matrix matrix, int[] col_maxima) {
        int max_row = 0;
        for (int c = 0; c < matrix.numColumns(); ++c) {
            for (int r = max_row; r < matrix.numRows(); ++r) {
                if (matrix.valueAt(r, c) <= matrix.valueAt(max_row, c)) continue;
                max_row = r;
            }
            col_maxima[c] = max_row;
        }
    }

    public static void naiveComputeRowMaxima(Matrix matrix, int[] row_maxima) {
        int max_col = 0;
        for (int r = 0; r < matrix.numRows(); ++r) {
            for (int c = max_col; c < matrix.numColumns(); ++c) {
                if (matrix.valueAt(r, c) <= matrix.valueAt(r, max_col)) continue;
                max_col = c;
            }
            row_maxima[r] = max_col;
        }
    }

    protected void printMatrix() {
        int c;
        System.out.print("row\\col\t| ");
        for (c = 0; c < this.numcols; ++c) {
            System.out.print(this.col[c] + "\t");
        }
        for (int r = 0; r < this.numrows; ++r) {
            System.out.print(this.row[r] + "\n\t| ");
            for (c = 0; c < this.numcols; ++c) {
                System.out.print(this.matrix.valueAt(r, c) + "\t");
            }
        }
    }

    public static void printMatrix(Matrix matrix) {
        for (int r = 0; r < matrix.numRows(); ++r) {
            for (int c = 0; c < matrix.numColumns(); ++c) {
                System.out.print(matrix.valueAt(r, c) + "\t");
            }
            System.out.print("\n");
        }
    }
}

