/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.neobio;

import java.io.IOException;
import java.io.Reader;
import net.maizegenetics.analysis.gbs.neobio.CharSequence;
import net.maizegenetics.analysis.gbs.neobio.IncompatibleScoringSchemeException;
import net.maizegenetics.analysis.gbs.neobio.InvalidSequenceException;
import net.maizegenetics.analysis.gbs.neobio.PairwiseAlignment;
import net.maizegenetics.analysis.gbs.neobio.PairwiseAlignmentAlgorithm;

public class SmithWaterman
extends PairwiseAlignmentAlgorithm {
    protected CharSequence seq1;
    protected CharSequence seq2;
    protected int[][] matrix;
    protected int max_row;
    protected int max_col;

    @Override
    protected void loadSequencesInternal(Reader input1, Reader input2) throws IOException, InvalidSequenceException {
        this.seq1 = new CharSequence(input1);
        this.seq2 = new CharSequence(input2);
    }

    @Override
    protected void unloadSequencesInternal() {
        this.seq1 = null;
        this.seq2 = null;
        this.matrix = null;
    }

    @Override
    protected PairwiseAlignment computePairwiseAlignment() throws IncompatibleScoringSchemeException {
        this.computeMatrix();
        PairwiseAlignment alignment = this.buildOptimalAlignment();
        this.matrix = null;
        return alignment;
    }

    protected void computeMatrix() throws IncompatibleScoringSchemeException {
        int c;
        int rows = this.seq1.length() + 1;
        int cols = this.seq2.length() + 1;
        this.matrix = new int[rows][cols];
        for (c = 0; c < cols; ++c) {
            this.matrix[0][c] = 0;
        }
        int max_score = 0;
        this.max_col = 0;
        this.max_row = 0;
        for (int r = 1; r < rows; ++r) {
            this.matrix[r][0] = 0;
            for (c = 1; c < cols; ++c) {
                int ins = this.matrix[r][c - 1] + this.scoreInsertion(this.seq2.charAt(c));
                int sub = this.matrix[r - 1][c - 1] + this.scoreSubstitution(this.seq1.charAt(r), this.seq2.charAt(c));
                int del = this.matrix[r - 1][c] + this.scoreDeletion(this.seq1.charAt(r));
                this.matrix[r][c] = this.max(ins, sub, del, 0);
                if (this.matrix[r][c] <= max_score) continue;
                max_score = this.matrix[r][c];
                this.max_row = r;
                this.max_col = c;
            }
        }
    }

    protected PairwiseAlignment buildOptimalAlignment() throws IncompatibleScoringSchemeException {
        int r = this.max_row;
        int c = this.max_col;
        int max_score = this.matrix[r][c];
        StringBuffer gapped_seq1 = new StringBuffer();
        StringBuffer score_tag_line = new StringBuffer();
        StringBuffer gapped_seq2 = new StringBuffer();
        while ((r > 0 || c > 0) && this.matrix[r][c] > 0) {
            int sub;
            if (c > 0 && this.matrix[r][c] == this.matrix[r][c - 1] + this.scoreInsertion(this.seq2.charAt(c))) {
                gapped_seq1.insert(0, '-');
                score_tag_line.insert(0, ' ');
                gapped_seq2.insert(0, this.seq2.charAt(c));
                --c;
                continue;
            }
            if (r > 0 && c > 0 && this.matrix[r][c] == this.matrix[r - 1][c - 1] + (sub = this.scoreSubstitution(this.seq1.charAt(r), this.seq2.charAt(c)))) {
                gapped_seq1.insert(0, this.seq1.charAt(r));
                if (this.seq1.charAt(r) == this.seq2.charAt(c)) {
                    if (this.useMatchTag()) {
                        score_tag_line.insert(0, '|');
                    } else {
                        score_tag_line.insert(0, this.seq1.charAt(r));
                    }
                } else if (sub > 0) {
                    score_tag_line.insert(0, '+');
                } else {
                    score_tag_line.insert(0, ' ');
                }
                gapped_seq2.insert(0, this.seq2.charAt(c));
                --r;
                --c;
                continue;
            }
            gapped_seq1.insert(0, this.seq1.charAt(r));
            score_tag_line.insert(0, ' ');
            gapped_seq2.insert(0, '-');
            --r;
        }
        return new PairwiseAlignment(gapped_seq1.toString(), score_tag_line.toString(), gapped_seq2.toString(), max_score, r, c);
    }

    @Override
    protected int computeScore() throws IncompatibleScoringSchemeException {
        int rows = this.seq1.length() + 1;
        int cols = this.seq2.length() + 1;
        int max_score = 0;
        if (rows <= cols) {
            int r;
            int[] array = new int[rows];
            for (r = 0; r < rows; ++r) {
                array[r] = 0;
            }
            for (int c = 1; c < cols; ++c) {
                int tmp = 0;
                for (r = 1; r < rows; ++r) {
                    int ins = array[r] + this.scoreInsertion(this.seq2.charAt(c));
                    int sub = array[r - 1] + this.scoreSubstitution(this.seq1.charAt(r), this.seq2.charAt(c));
                    int del = tmp + this.scoreDeletion(this.seq1.charAt(r));
                    array[r - 1] = tmp;
                    tmp = this.max(ins, sub, del, 0);
                    if (tmp <= max_score) continue;
                    max_score = tmp;
                }
                array[rows - 1] = tmp;
            }
        } else {
            int c;
            int[] array = new int[cols];
            for (c = 0; c < cols; ++c) {
                array[c] = 0;
            }
            for (int r = 1; r < rows; ++r) {
                int tmp = 0;
                for (c = 1; c < cols; ++c) {
                    int ins = tmp + this.scoreInsertion(this.seq2.charAt(c));
                    int sub = array[c - 1] + this.scoreSubstitution(this.seq1.charAt(r), this.seq2.charAt(c));
                    int del = array[c] + this.scoreDeletion(this.seq1.charAt(r));
                    array[c - 1] = tmp;
                    tmp = this.max(ins, sub, del, 0);
                    if (tmp <= max_score) continue;
                    max_score = tmp;
                }
                array[cols - 1] = tmp;
            }
        }
        return max_score;
    }
}

