/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.pana;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.apache.log4j.Logger;

public class PanAModelTrainingPlugin
extends AbstractPlugin {
    static long timePoint1;
    private ArgsEngine engine = null;
    private Logger logger = Logger.getLogger(PanAModelTrainingPlugin.class);
    String trainingSetFileS = null;
    String wekaPath = null;
    String modelFileS = null;
    String reportDirS = null;
    String predictionFileS = "prediction.txt";
    String accuracyTableFileS = "accuracyTable.txt";

    public PanAModelTrainingPlugin() {
        super(null, false);
    }

    public PanAModelTrainingPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    private void printUsage() {
        this.logger.info((Object)"\n\nUsage is as follows:\n -t  training data set file, including unique reference tag\n -w  path of weka library\n -m  M5 model file\n -r  directory of training report\n");
    }

    @Override
    public DataSet performFunction(DataSet input) {
        this.trainModel();
        this.generateReport();
        return null;
    }

    private void generateReport() {
        int[] predictionCut = new int[]{10000, 20000, 50000, 100000, 200000, 500000, 1000000, 2000000, 5000000, 10000000};
        int[] accuracyCut = new int[]{10000, 20000, 50000, 100000, 200000, 500000, 1000000, 2000000, 5000000, 10000000, 20000000, 50000000};
        double[] logPreCut = new double[predictionCut.length];
        for (int i = 0; i < logPreCut.length; ++i) {
            logPreCut[i] = Math.log10(predictionCut[i]);
        }
        double[] logAccCut = new double[accuracyCut.length];
        for (int i = 0; i < logAccCut.length; ++i) {
            logAccCut[i] = Math.log10(accuracyCut[i]);
        }
        double[] actualValue = null;
        double[] predictionValue = null;
        try {
            int i;
            String temp;
            BufferedReader br = new BufferedReader(new FileReader(this.predictionFileS), 65536);
            br.readLine();
            int cnt = 0;
            while ((temp = br.readLine()) != null) {
                ++cnt;
            }
            actualValue = new double[cnt];
            predictionValue = new double[cnt];
            br = new BufferedReader(new FileReader(this.predictionFileS), 65536);
            br.readLine();
            for (int i2 = 0; i2 < cnt; ++i2) {
                String[] tem = br.readLine().split("\t");
                actualValue[i2] = Double.valueOf(tem[1]);
                predictionValue[i2] = Double.valueOf(tem[2]);
            }
            br.close();
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.accuracyTableFileS), 65536);
            bw.write("PredictionCutoff\tProportionRemain");
            for (i = 0; i < accuracyCut.length; ++i) {
                bw.write("\t<" + String.valueOf(accuracyCut[i] / 1000) + " kb");
            }
            bw.newLine();
            for (i = 0; i < logPreCut.length; ++i) {
                int j;
                double[] ratio = new double[accuracyCut.length];
                cnt = 0;
                for (j = 0; j < actualValue.length; ++j) {
                    if (predictionValue[j] > logPreCut[i]) continue;
                    for (int k = 0; k < logAccCut.length; ++k) {
                        if (!(actualValue[j] < logAccCut[k])) continue;
                        int n = k;
                        ratio[n] = ratio[n] + 1.0;
                    }
                    ++cnt;
                }
                bw.write(String.valueOf(predictionCut[i] / 1000) + "Kb\t" + String.valueOf((double)cnt / (double)actualValue.length));
                for (j = 0; j < logAccCut.length; ++j) {
                    bw.write("\t" + String.valueOf(ratio[j] / (double)cnt));
                }
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Accuracy table is at " + this.accuracyTableFileS);
    }

    private void trainModel() {
        String cmd = "java -Xms500m -Xmx5g -cp " + this.wekaPath.replace("\\", "/") + " weka.classifiers.rules.M5Rules -p 0 -t " + this.trainingSetFileS.replace("\\", "/") + " -d " + this.modelFileS.replace("\\", "/");
        System.out.println(cmd);
        System.out.println("\nStart model training");
        System.out.println("Be patient. It takes a while...\n");
        Runtime rt = Runtime.getRuntime();
        rt.gc();
        ArrayList<Double> obList = new ArrayList<Double>();
        ArrayList<Double> preList = new ArrayList<Double>();
        try {
            String temp;
            Process p = rt.exec(cmd);
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()), 655360);
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.predictionFileS), 65536);
            bw.write("Instance\tAcutal\tPredicted\tError");
            bw.newLine();
            for (int i = 0; i < 5; ++i) {
                System.out.println(br.readLine());
            }
            int cnt = 0;
            while ((temp = br.readLine()) != null) {
                System.out.println(temp);
                if (temp.isEmpty()) continue;
                String[] tem = temp.trim().split("\\s+");
                bw.write(String.valueOf(cnt) + "\t" + tem[1] + "\t" + tem[2] + "\t" + tem[3]);
                obList.add(Double.valueOf(tem[1]));
                preList.add(Double.valueOf(tem[2]));
                bw.newLine();
                ++cnt;
            }
            br.close();
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        double[] ob = new double[obList.size()];
        double[] pre = new double[preList.size()];
        for (int i = 0; i < ob.length; ++i) {
            ob[i] = (Double)obList.get(i);
            pre[i] = (Double)preList.get(i);
        }
        double r = new PearsonsCorrelation().correlation(ob, pre);
        System.out.println("Pearson correlation coefficient (observation Vs prediction):\t" + String.valueOf(r));
        System.out.println("Training model is generated in " + this.modelFileS);
        System.out.println("Ten fold cross validation prediction at " + this.predictionFileS);
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.engine == null) {
            this.engine = new ArgsEngine();
            this.engine.add("-t", "--training-data", true);
            this.engine.add("-w", "--weka-path", true);
            this.engine.add("-m", "--output-model", true);
            this.engine.add("-r", "--report-dir", true);
            this.engine.parse(args);
        }
        if (!this.engine.getBoolean("-t")) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        this.trainingSetFileS = this.engine.getString("-t");
        if (!this.engine.getBoolean("-w")) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        this.wekaPath = this.engine.getString("-w");
        if (!this.engine.getBoolean("-m")) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        this.modelFileS = this.engine.getString("-m");
        if (!this.engine.getBoolean("-r")) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        this.reportDirS = this.engine.getString("-r");
        File reportDir = new File(this.reportDirS);
        reportDir.mkdirs();
        this.predictionFileS = new File(reportDir.getAbsoluteFile(), this.predictionFileS).getAbsolutePath();
        this.accuracyTableFileS = new File(reportDir.getAbsoluteFile(), this.accuracyTableFileS).getAbsolutePath();
    }

    @Override
    public ImageIcon getIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

