/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.pana;

import java.awt.Frame;
import java.io.File;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.TagAgainstAnchor;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import org.apache.log4j.Logger;

public class PanATagGWASMappingPlugin
extends AbstractPlugin {
    static long timePoint1;
    private ArgsEngine engine = null;
    private Logger logger = Logger.getLogger(PanATagGWASMappingPlugin.class);
    int preCalculation = 0;
    String hapMapHDF5 = null;
    String tbtHDF5 = null;
    String blockFileS = null;
    String outDirS = null;
    double pThresh = 1.0E-6;
    int minCount = 20;
    int coreNum = -1;
    int chunkSize = 65536;
    int chunkStartIndex = 0;
    int chunkEndIndex = 1;

    public PanATagGWASMappingPlugin() {
        super(null, false);
    }

    public PanATagGWASMappingPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    private void printUsage() {
        this.logger.info((Object)"\n\nUsage is as follows:\n -pc pre-caculation for chunk number, value = 0/1. Default = 0; when 1, should only be used with -t option together\n -g  input anchor map file, SimpleGenotypeSBit format\n -t  input TBT file, TagsByTaxaByteHDF5TagGroup format\n -b  input TagBlockPosition file, correspongding to tags in TBT. Used to block the marker coming from the tag to be mapped. Default = null\n -o  output directory\n -m  minimum count when tag appear in taxa, default = 20, too low number lacks statistical power\n -c  coreNum, value = max/Integer. Default:max, which means using all cores in a node, 4 threads/core. When the coreNum is set less than or equal to total core number, which means using coreNum cores, each core runs 1 thread\n -s  chunkSize, number of tags in a chunk. This determines the time usage in a node/computer. Default = 65536\n -cs chunkStartIndex, start index of chunk\n -ce chunkEndIndex, end index of chunk. Exclusive\n\n");
    }

    @Override
    public DataSet performFunction(DataSet input) {
        if (this.preCalculation == 1) {
            TagAgainstAnchor.getChunkNum(this.tbtHDF5, this.chunkSize);
        } else {
            String outfileS = new File(this.tbtHDF5).getName().substring(0, new File(this.tbtHDF5).getName().lastIndexOf(".")) + ".gwas.txt";
            outfileS = new File(this.outDirS, outfileS).getAbsolutePath();
            TagAgainstAnchor tagAgainstAnchor = new TagAgainstAnchor(this.hapMapHDF5, this.tbtHDF5, this.blockFileS, outfileS, this.pThresh, this.minCount, this.coreNum, this.chunkSize, this.chunkStartIndex, this.chunkEndIndex);
        }
        return null;
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.engine == null) {
            this.engine = new ArgsEngine();
            this.engine.add("-pc", "--pre-calculation", true);
            this.engine.add("-g", "--anchor-file", true);
            this.engine.add("-t", "--TBT-file", true);
            this.engine.add("-b", "--TagBlock-file", true);
            this.engine.add("-o", "--output-file", true);
            this.engine.add("-m", "--min-tagInTaxa", true);
            this.engine.add("-c", "--core-num", true);
            this.engine.add("-s", "--chunk-size", true);
            this.engine.add("-cs", "--chunkStart-index", true);
            this.engine.add("-ce", "--chunkEnd-index", true);
            this.engine.parse(args);
        }
        if (this.engine.getBoolean("-pc")) {
            this.preCalculation = Integer.valueOf(this.engine.getString("-pc"));
        }
        if (this.engine.getBoolean("-g")) {
            this.hapMapHDF5 = this.engine.getString("-g");
        }
        if (this.engine.getBoolean("-t")) {
            this.tbtHDF5 = this.engine.getString("-t");
        }
        if (this.engine.getBoolean("-b")) {
            this.blockFileS = this.engine.getString("-b");
        }
        if (this.engine.getBoolean("-o")) {
            this.outDirS = this.engine.getString("-o");
        }
        if (this.engine.getBoolean("-m")) {
            this.minCount = Integer.valueOf(this.engine.getString("-m"));
        }
        if (this.engine.getBoolean("-c") && this.engine.getString("-c").substring(0, 1).matches("\\d")) {
            int numOfProcessors = Runtime.getRuntime().availableProcessors();
            this.coreNum = Integer.valueOf(this.engine.getString("-c"));
            if (this.coreNum > numOfProcessors) {
                this.coreNum = numOfProcessors;
            }
            System.out.println("This node has " + numOfProcessors + " processors");
        }
        if (this.engine.getBoolean("-s")) {
            this.chunkSize = Integer.valueOf(this.engine.getString("-s"));
        }
        if (this.engine.getBoolean("-cs")) {
            this.chunkStartIndex = Integer.valueOf(this.engine.getString("-cs"));
        }
        if (this.engine.getBoolean("-ce")) {
            this.chunkEndIndex = Integer.valueOf(this.engine.getString("-ce"));
        }
    }

    @Override
    public ImageIcon getIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

