/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.repgen;

import net.maizegenetics.dna.tag.Tag;

public class AlignmentInfo
implements Comparable<AlignmentInfo> {
    private final Tag tag2;
    private final String tag2chrom;
    private final int tag2pos;
    private final int alignmentPos;
    private final int ref_strand;
    private final String ref_genome;
    private final int myScore;

    public AlignmentInfo(Tag tag2, String chromosome, int position, int alignmentpos, int ref_strand, String ref_genome, int score) {
        this.tag2 = tag2;
        this.tag2chrom = chromosome;
        this.tag2pos = position;
        this.alignmentPos = alignmentpos;
        this.ref_strand = ref_strand;
        this.ref_genome = ref_genome;
        this.myScore = score;
    }

    public Tag tag2() {
        return this.tag2;
    }

    public String tag2chrom() {
        return this.tag2chrom;
    }

    public int tag2pos() {
        return this.tag2pos;
    }

    public int alignmentPos() {
        return this.alignmentPos;
    }

    public int ref_strand() {
        return this.ref_strand;
    }

    public String ref_genome() {
        return this.ref_genome;
    }

    public int score() {
        return this.myScore;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Alignment:");
        sb.append("\tTag2:").append(this.tag2.sequence());
        sb.append("\tChr:").append(this.tag2chrom);
        sb.append("\tPos:").append(this.tag2pos);
        sb.append("\tAlignmentPos:").append(this.alignmentPos);
        sb.append("\tScore:").append(this.myScore);
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public int compareTo(AlignmentInfo other) {
        return this.myScore > other.score() ? 1 : (this.myScore < other.score() ? -1 : 0);
    }
}

