/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.repgen;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.neobio.BasicScoringScheme;
import net.maizegenetics.analysis.gbs.neobio.IncompatibleScoringSchemeException;
import net.maizegenetics.analysis.gbs.neobio.InvalidSequenceException;
import net.maizegenetics.analysis.gbs.neobio.PairwiseAlignment;
import net.maizegenetics.analysis.gbs.neobio.SmithWaterman;
import net.maizegenetics.analysis.gbs.repgen.AlignmentInfo;
import net.maizegenetics.analysis.gbs.repgen.RefTagData;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.GenomeSequence;
import net.maizegenetics.dna.map.GenomeSequenceBuilder;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.tag.RepGenSQLite;
import net.maizegenetics.dna.tag.Tag;
import net.maizegenetics.dna.tag.TagBuilder;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.GeneratePluginCode;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.OpenBitSet;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class RepGenAlignerPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(RepGenAlignerPlugin.class);
    private PluginParameter<String> myDBFile = new PluginParameter.Builder<String>("db", null, String.class).guiName("Input DB").required(true).inFile().description("Input database file with tags and taxa distribution").build();
    private PluginParameter<String> refGenome = new PluginParameter.Builder<String>("ref", null, String.class).guiName("Reference Genome File").required(true).description("Referemce Genome File for aligning against ").build();
    private PluginParameter<Integer> minTagCount = new PluginParameter.Builder<Integer>("minTagCount", 1, Integer.class).guiName("Min Tag Count").description("Minimum count of reads for a tag to be aligned").build();
    private PluginParameter<Integer> minHitCount = new PluginParameter.Builder<Integer>("minHitCount", 4, Integer.class).guiName("Minimum Hit Count").description("Minimum number of hits in a cluster for a reference tag to be created from that location.").build();
    private PluginParameter<Integer> seedLen = new PluginParameter.Builder<Integer>("seedLen", 17, Integer.class).guiName("Seed Kmer Length").description("Length of kmer seed created from DB tags and used as seeds for aligning against the reference genome.").build();
    private PluginParameter<Integer> seedWindow = new PluginParameter.Builder<Integer>("seedWindow", 20, Integer.class).guiName("Window Length for Seed Creation").description("Length of window between positions when creating seed from DB tags.").build();
    private PluginParameter<Integer> kmerLen = new PluginParameter.Builder<Integer>("kmerLen", 150, Integer.class).guiName("Kmer Length").description("Length of kmer from fastq reads stored as the tag sequence in the DB.").build();
    private PluginParameter<Integer> refKmerLen = new PluginParameter.Builder<Integer>("refKmerLen", 300, Integer.class).guiName("Reference Kmer Length").description("Length of kmers created from reference genome to store in the DB. \nThis should be at as long or longer than the kmerLen parameter used for storing input sequence tags.").build();
    private PluginParameter<Integer> match_reward = new PluginParameter.Builder<Integer>("match_reward", 2, Integer.class).guiName("Match Reward Amount").description("Parameter sent to Smith Waterman aligner for use in calculating reward when base pairs match.").build();
    private PluginParameter<Integer> mismatch_penalty = new PluginParameter.Builder<Integer>("mismatch_penalty", -1, Integer.class).guiName("Mismatch Penalty Amount").description("Parameter sent to Smith Waterman aligner for use in calculating penalty when base pairs are mis-matched.").build();
    private PluginParameter<Integer> gap_penalty = new PluginParameter.Builder<Integer>("gap_penalty", -1, Integer.class).guiName("Gap Penalty Amount").description("Parameter sent to Smith Waterman aligner for use in calculating penalty when when a gap is identified.").build();
    static GenomeSequence myRefSequence = null;

    public RepGenAlignerPlugin() {
        super(null, false);
    }

    public RepGenAlignerPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    public RepGenAlignerPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public void postProcessParameters() {
        if (this.myDBFile.isEmpty() || !Files.exists(Paths.get(this.inputDB(), new String[0]), new LinkOption[0])) {
            throw new IllegalArgumentException("RepGenAlignerPlugin: postProcessParameters: Input DB not set or found");
        }
        if (this.refGenome.isEmpty()) {
            throw new IllegalArgumentException("RepGenAlignerPlugin: postProcessParameters: reference genome not set or found");
        }
        myRefSequence = GenomeSequenceBuilder.instance(this.refGenome());
    }

    @Override
    public DataSet processData(DataSet input) {
        long totalTime = System.nanoTime();
        long time = System.nanoTime();
        try {
            System.out.println("RepGenAlignerPlugin:processData begin");
            RepGenSQLite repGenData = new RepGenSQLite(this.inputDB());
            Map<Tag, Integer> tagsWithDepth = repGenData.getTagsWithDepth(this.minTagCount());
            if (tagsWithDepth.isEmpty()) {
                System.out.println("\nNo tags found with minimum depth " + this.minTagCount() + ". Halting Run.\n");
                repGenData.close();
                return null;
            }
            HashMultimap kmerTagMap = HashMultimap.create();
            System.out.println("Calling createKmerSeedsFromDBTags with window size: " + this.seedWindow());
            this.createKmerSeedsFromDBTags(tagsWithDepth.keySet(), (Multimap<String, Tag>)kmerTagMap, this.seedWindow());
            System.out.println("Num distinct kmerSeeds created: " + kmerTagMap.keySet().size() + ", kmerTagMap size is:" + kmerTagMap.size() + ",TotalTime for createKmerSeedsFromDBTags was " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds");
            System.out.println("Size of tagsWithDepth: " + tagsWithDepth.size());
            System.out.println("Size of kmerTagMap keyset: " + kmerTagMap.keySet().size());
            time = System.nanoTime();
            Set<Chromosome> chromsInRef = myRefSequence.chromosomes();
            ConcurrentHashMap chromBitMaps = new ConcurrentHashMap();
            System.out.println("Start making array of chrom bitmaps ");
            chromsInRef.parallelStream().forEach(arg_0 -> this.lambda$processData$0((Multimap)kmerTagMap, chromBitMaps, arg_0));
            System.out.println("Entering loop to find clusters");
            HashMultimap chromMaximaMap = HashMultimap.create();
            HashMultimap refTagPositionMap = HashMultimap.create();
            for (String chrom : chromBitMaps.keySet()) {
                OpenBitSet chromHits = (OpenBitSet)chromBitMaps.get(chrom);
                this.createRefTagsForAlignment(chromHits, chrom, (Multimap<String, Integer>)chromMaximaMap, (Multimap<Tag, Position>)refTagPositionMap);
            }
            String refTagOutFile = "/home/lcj34/repGen_outputFiles/allChroms_refTagsOrigAligner.txt";
            BufferedWriter refwr = Utils.getBufferedWriter(refTagOutFile);
            try {
                for (Map.Entry entry : refTagPositionMap.entries()) {
                    int position = ((Position)entry.getValue()).getPosition();
                    String chromname = ((Position)entry.getValue()).getChromosome().getName();
                    Tag refTag = (Tag)entry.getKey();
                    String refData = chromname + "\t" + position + "\t" + refTag.sequence() + "\n";
                    refwr.write(refData);
                }
                refwr.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            System.out.println("\nNumber of distinct refTags to be loaded into db: " + refTagPositionMap.keySet().size() + " total refTags: " + refTagPositionMap.size());
            repGenData.addMappingApproach("SmithWaterman");
            repGenData.addReferenceGenome(this.refGenome());
            repGenData.putRefTagMapping((Multimap<Tag, Position>)refTagPositionMap, this.refGenome());
            Set<Tag> tagsToAlign = repGenData.getTags();
            ArrayList<Tag> tagList = new ArrayList<Tag>(tagsToAlign);
            Multimap tagAlignInfoMap = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
            Multimap refTagAlignInfoMap = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
            System.out.println("Calling calculateTagTagAlignment for tags without refs");
            this.calculateTagTagAlignment(tagList, (Multimap<Tag, AlignmentInfo>)tagAlignInfoMap);
            System.out.println("Number of tag-tag alignments: " + tagAlignInfoMap.size() + ", store to db.");
            repGenData.putTagTagAlignments((Multimap<Tag, AlignmentInfo>)tagAlignInfoMap);
            System.out.println("Calling calculateTagRefTagALignment for tags WITH ref");
            Set<RefTagData> refTags = repGenData.getRefTags();
            ArrayList<RefTagData> refTagList = new ArrayList<RefTagData>(refTags);
            tagAlignInfoMap.clear();
            this.calculateTagRefTagAlignment(tagList, refTagList, (Multimap<Tag, AlignmentInfo>)tagAlignInfoMap, this.refGenome());
            System.out.println("Number of tag-refTag alignments, includes aligning to ref fwd and reverse strands: " + tagAlignInfoMap.size() + ", store to db.");
            repGenData.putTagRefTagAlignments((Multimap<Tag, AlignmentInfo>)tagAlignInfoMap, this.refGenome());
            System.out.println("Calling calculateRefRefAlignment");
            this.calculateRefRefAlignment(refTagList, (Multimap<Tag, Position>)refTagPositionMap, (Multimap<RefTagData, AlignmentInfo>)refTagAlignInfoMap);
            System.out.println("Number of reftag-reftag alignments: " + refTagAlignInfoMap.size() + ", store to db.");
            repGenData.putRefRefAlignments((Multimap<RefTagData, AlignmentInfo>)refTagAlignInfoMap, this.refGenome());
            repGenData.close();
            myLogger.info((Object)"Finished RepGenAlignerPlugin\n");
        }
        catch (Exception e) {
            myLogger.info((Object)("Catch in prcessing REpGEnALignerPlugin file e=" + e));
            e.printStackTrace();
        }
        System.out.println("Process took " + (double)(System.nanoTime() - totalTime) / 1.0E9 + " seconds.\n");
        return null;
    }

    private short calculateFirstRangeCount(int rangeSize, OpenBitSet obs) {
        short totalhits = 0;
        for (int idx = 0; idx < rangeSize; ++idx) {
            if (!obs.get(idx)) continue;
            totalhits = (short)(totalhits + 1);
        }
        return totalhits;
    }

    private void storeRefTagPositions(int peaknum, List<Integer> positionsInPeak, Multimap<String, Integer> chromMaximaMap, String chrom, long chromSize, Multimap<Tag, Position> refTagPositionMap) {
        Chromosome chromObject;
        byte[] refTagBytes;
        String refString;
        int endpos;
        int size = positionsInPeak.size();
        if (size < this.minHitCount()) {
            System.out.println("storeRefTagPosition: dropping peak number " + peaknum + ", only " + size + " positions in cluster.");
            return;
        }
        int start = positionsInPeak.get(0);
        int end = positionsInPeak.get(size - 1);
        int maxima = start + (end - start) / 2 + this.seedLen() / 2;
        chromMaximaMap.put((Object)chrom, (Object)maxima);
        int lowpos = maxima - this.refKmerLen() / 2;
        int startRefPos = lowpos > 0 ? lowpos : 1;
        int n = endpos = startRefPos == 1 ? this.refKmerLen() : startRefPos + (this.refKmerLen() - 1);
        if ((long)endpos > chromSize - 1L) {
            endpos = (int)(chromSize - 1L);
        }
        if ((refString = NucleotideAlignmentConstants.nucleotideBytetoString(refTagBytes = myRefSequence.chromosomeSequence(chromObject = new Chromosome(chrom), startRefPos, endpos))).contains("N") || refString.contains("null")) {
            System.out.println("StoreRefTagPositions... refString contains N or null: " + refString);
            lowpos = maxima - this.kmerLen() / 2;
            startRefPos = lowpos > 0 ? lowpos : 1;
            endpos = startRefPos == 1 ? this.kmerLen() : startRefPos + (this.kmerLen() - 1);
            refTagBytes = myRefSequence.chromosomeSequence(chromObject, startRefPos, endpos);
            refString = NucleotideAlignmentConstants.nucleotideBytetoString(refTagBytes);
            if (refString.contains("N") || refString.contains("null")) {
                System.out.println(" - after adjusting, refString still contains N, drop this one");
            } else {
                System.out.println(" - new refTag after adjusting, len=" + refString.length() + ", " + refString);
            }
        }
        if (refString == null || refString.length() == 0) {
            System.out.println(" storeRefTagPositions - refString is NULL");
        } else {
            Tag refTag = TagBuilder.instance(refString).reference().build();
            if (refTag != null) {
                GeneralPosition refPos = new GeneralPosition.Builder(chromObject, startRefPos).strand((byte)1).addAnno("mappingapproach", "SmithWaterman").addAnno("forward", "true").build();
                refTagPositionMap.put((Object)refTag, (Object)refPos);
            } else {
                System.out.println("- refTag is NULL for refString: " + refString);
            }
        }
    }

    private void createKmerSeedsFromDBTags(Set<Tag> tagWithDepth, Multimap<String, Tag> kmerTagMap, int window) {
        for (Tag tag : tagWithDepth) {
            String tagSequence = tag.sequence();
            int maxIdx = tagSequence.length() - window;
            int seqIdx = 0;
            while (seqIdx < maxIdx) {
                String kmer = tagSequence.substring(seqIdx, seqIdx + this.seedLen());
                byte[] kmerBytesAsNum = NucleotideAlignmentConstants.convertHaplotypeStringToAlleleByteArray(kmer);
                int badValues = this.checkForN(kmerBytesAsNum);
                if (badValues >= 0) {
                    seqIdx += window;
                    continue;
                }
                kmerTagMap.put((Object)kmer, (Object)tag);
                byte[] kmerRC = NucleotideAlignmentConstants.reverseComplementAlleleByteArray(kmer.getBytes());
                String kmerRCString = new String(kmerRC);
                kmerTagMap.put((Object)kmerRCString, (Object)tag);
                seqIdx += window;
            }
        }
    }

    private void createRefTagsForAlignment(OpenBitSet chromHits, String chrom, Multimap<String, Integer> chromMaximaMap, Multimap<Tag, Position> refTagPositionMap) {
        String peakOutFile = "/home/lcj34/repGen_outputFiles/chrom" + chrom + "_peaklist400.txt";
        BufferedWriter peakwr = Utils.getBufferedWriter(peakOutFile);
        String header = "peakStart,numHits\n";
        try {
            peakwr.write(header);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        long chromSize = chromHits.size();
        HashMultimap movingSumMap = HashMultimap.create();
        System.out.println("Size of OpenBitSet for chrom " + chrom + ": " + chromSize + ", cardiality is: " + chromHits.cardinality());
        int rangeSize = this.refKmerLen();
        int firstRange = rangeSize / 2;
        short firstRangeCount = this.calculateFirstRangeCount(rangeSize, chromHits);
        System.out.println("firstRangeCount: " + firstRangeCount);
        short currentTotal = firstRangeCount;
        int lastRange = (int)chromSize - firstRange;
        short peak_num = 0;
        boolean belowMin = true;
        for (int idx = firstRange + 1; idx < lastRange; ++idx) {
            int posToDrop = idx - rangeSize / 2 - 1;
            int posToAdd = idx + rangeSize / 2 - 1;
            if (chromHits.fastGet(posToDrop)) {
                currentTotal = (short)(currentTotal - 1);
            }
            if (chromHits.fastGet(posToAdd)) {
                currentTotal = (short)(currentTotal + 1);
            }
            if (currentTotal >= this.minHitCount()) {
                if (belowMin) {
                    peak_num = (short)(peak_num + 1);
                    belowMin = false;
                }
                movingSumMap.put((Object)peak_num, (Object)idx);
                continue;
            }
            belowMin = true;
        }
        Set peaks = movingSumMap.keySet();
        System.out.println("Total number of peaks calculated for chrom: " + chrom + ": " + peaks.size());
        ArrayList sumList = new ArrayList(peaks);
        sumList.stream().forEach(arg_0 -> this.lambda$createRefTagsForAlignment$1((Multimap)movingSumMap, peakwr, chromMaximaMap, chrom, chromSize, refTagPositionMap, arg_0));
        try {
            peakwr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void calculateTagTagAlignment(List<Tag> tags, Multimap<Tag, AlignmentInfo> tagAlignInfoMap) {
        long totalTime = System.nanoTime();
        tags.parallelStream().forEach(tag1 -> {
            for (Tag tag2 : tags) {
                if (tag1.equals(tag2)) continue;
                String seq1 = tag1.sequence();
                String seq2 = tag2.sequence();
                StringReader reader1 = new StringReader(seq1);
                StringReader reader2 = new StringReader(seq2);
                SmithWaterman algorithm = new SmithWaterman();
                BasicScoringScheme scoring = new BasicScoringScheme(this.match_reward(), this.mismatch_penalty(), this.gap_penalty());
                algorithm.setScoringScheme(scoring);
                int score = 0;
                try {
                    algorithm.loadSequences(reader1, reader2);
                    score = algorithm.getScore();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                catch (InvalidSequenceException ise) {
                    ise.printStackTrace();
                }
                catch (IncompatibleScoringSchemeException isse) {
                    isse.printStackTrace();
                }
                AlignmentInfo tagAI = new AlignmentInfo(tag2, null, -1, -1, -1, this.refGenome(), score);
                tagAlignInfoMap.put(tag1, (Object)tagAI);
            }
        });
        System.out.println("Number of tags: " + tags.size() + ", TotalTime for calculateTagTagAlignment was " + (double)(System.nanoTime() - totalTime) / 1.0E9 + " seconds");
    }

    private void calculateTagRefTagAlignment(List<Tag> tags, List<RefTagData> refTagDataList, Multimap<Tag, AlignmentInfo> tagAlignInfoMap, String refGenome) {
        long totalTime = System.nanoTime();
        tags.parallelStream().forEach(tag1 -> {
            for (RefTagData rtd : refTagDataList) {
                Tag tag2 = rtd.tag();
                String seq1 = tag1.sequence();
                String seq2 = tag2.sequence();
                StringReader reader1 = new StringReader(seq1);
                StringReader reader2 = new StringReader(seq2);
                SmithWaterman algorithm = new SmithWaterman();
                BasicScoringScheme scoring = new BasicScoringScheme(this.match_reward(), this.mismatch_penalty(), this.gap_penalty());
                algorithm.setScoringScheme(scoring);
                int refAlignStartPos = rtd.position();
                int tagAlignOffset = 0;
                try {
                    AlignmentInfo tagAI;
                    algorithm.loadSequences(reader1, reader2);
                    int score = algorithm.getScore();
                    PairwiseAlignment alignment = algorithm.getPairwiseAlignment();
                    tagAlignOffset = alignment.getRowStart();
                    refAlignStartPos += alignment.getColStart();
                    if (tagAlignOffset > 0) {
                        refAlignStartPos -= tagAlignOffset;
                    }
                    if (refAlignStartPos >= 0) {
                        tagAI = new AlignmentInfo(tag2, rtd.chromosome(), rtd.position(), refAlignStartPos, 1, refGenome, score);
                        tagAlignInfoMap.put(tag1, (Object)tagAI);
                    }
                    reader1 = new StringReader(seq1);
                    seq2 = tag2.toReverseComplement();
                    reader2 = new StringReader(seq2);
                    algorithm.unloadSequences();
                    algorithm.loadSequences(reader1, reader2);
                    score = algorithm.getScore();
                    alignment = algorithm.getPairwiseAlignment();
                    tagAlignOffset = alignment.getRowStart();
                    refAlignStartPos += alignment.getColStart();
                    if (tagAlignOffset > 0) {
                        refAlignStartPos -= tagAlignOffset;
                    }
                    if (refAlignStartPos < 0) continue;
                    tagAI = new AlignmentInfo(tag2, rtd.chromosome(), rtd.position(), refAlignStartPos, 0, this.refGenome(), score);
                    tagAlignInfoMap.put(tag1, (Object)tagAI);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InvalidSequenceException e) {
                    e.printStackTrace();
                }
                catch (IncompatibleScoringSchemeException e) {
                    e.printStackTrace();
                }
            }
        });
        System.out.println("Num tags: " + tags.size() + ", Num refTags: " + refTagDataList.size() + ", TotalTime for calculateTagRefTagAlignment was " + (double)(System.nanoTime() - totalTime) / 1.0E9 + " seconds");
    }

    private void calculateRefRefAlignment(List<RefTagData> refTags, Multimap<Tag, Position> refTagPosMap, Multimap<RefTagData, AlignmentInfo> refTagAlignInfoMap) {
        long totalTime = System.nanoTime();
        refTags.parallelStream().forEach(tag1 -> {
            for (RefTagData tag2 : refTags) {
                if (tag1.equals(tag2)) continue;
                String seq1 = tag1.tag().sequence();
                String seq2 = tag2.tag().sequence();
                StringReader reader1 = new StringReader(seq1);
                StringReader reader2 = new StringReader(seq2);
                SmithWaterman algorithm = new SmithWaterman();
                BasicScoringScheme scoring = new BasicScoringScheme(this.match_reward(), this.mismatch_penalty(), this.gap_penalty());
                algorithm.setScoringScheme(scoring);
                int score = 0;
                try {
                    algorithm.loadSequences(reader1, reader2);
                    score = algorithm.getScore();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                catch (InvalidSequenceException ise) {
                    ise.printStackTrace();
                }
                catch (IncompatibleScoringSchemeException isse) {
                    isse.printStackTrace();
                }
                AlignmentInfo tagAI = new AlignmentInfo(tag2.tag(), tag2.chromosome(), tag2.position(), -1, 1, this.refGenome(), score);
                refTagAlignInfoMap.put(tag1, (Object)tagAI);
            }
        });
        System.out.println("Number of refTags: " + refTags.size() + ", TotalTime for calculateREfRefAlignment was " + (double)(System.nanoTime() - totalTime) / 1.0E9 + " seconds");
    }

    private int checkForN(byte[] kmer) {
        int idx;
        boolean flag = false;
        for (idx = 0; idx < kmer.length; ++idx) {
            if (kmer[idx] <= 3) continue;
            flag = true;
            break;
        }
        if (flag) {
            return idx;
        }
        return -1;
    }

    public static void writeToFile(String chrom, Multimap<String, Integer> chromMaximaMap, int minCount) {
        String outFile = "/Users/lcj34/notes_files/repgen/junit2_out/chrom" + chrom + "_peakMaximaPositions_minCount" + minCount + ".txt";
        BufferedWriter bw = Utils.getBufferedWriter(outFile);
        Collection maximaForChrom = chromMaximaMap.get((Object)chrom);
        ArrayList chromValues = new ArrayList(maximaForChrom);
        Collections.sort(chromValues);
        System.out.println("Total number of maxima/peak positions for chrom " + chrom + " is " + maximaForChrom.size() + ". Writing them to file " + outFile + " .... ");
        try {
            StringBuilder sb = new StringBuilder();
            int count = 0;
            for (int idx = 0; idx < chromValues.size(); ++idx) {
                String hits = Integer.toString((Integer)chromValues.get(idx));
                sb.append(hits);
                sb.append("\n");
                if (++count <= 100000) continue;
                bw.write(sb.toString());
                count = 0;
                sb.setLength(0);
            }
            if (count > 0) {
                bw.write(sb.toString());
            }
            bw.close();
        }
        catch (IOException ioe) {
            System.out.println("LCJ - exception writing file " + outFile);
            ioe.printStackTrace();
        }
    }

    public static void writePeakPositions(String chrom, int peak, List<Integer> peakPositions) {
        String outFile = "/Users/lcj34/notes_files/repgen/junit2_out/chrom" + chrom + "_peak" + peak + "_positions.txt";
        BufferedWriter bw = Utils.getBufferedWriter(outFile);
        System.out.println("Total number of  positions for peak " + peak + " is " + peakPositions.size() + ". Writing them to file " + outFile + " .... ");
        try {
            StringBuilder sb = new StringBuilder();
            int count = 0;
            for (int idx = 0; idx < peakPositions.size(); ++idx) {
                String hits = Integer.toString(peakPositions.get(idx));
                sb.append(hits);
                sb.append("\n");
                if (++count <= 100000) continue;
                bw.write(sb.toString());
                count = 0;
                sb.setLength(0);
            }
            if (count > 0) {
                bw.write(sb.toString());
            }
            bw.close();
        }
        catch (IOException ioe) {
            System.out.println("LCJ - exception writing file " + outFile);
            ioe.printStackTrace();
        }
    }

    public static void writeChrom9Bits(List<Integer> peakPositions) {
        String outFile = "/Users/lcj34/notes_files/repgen/junit_out/chrom9bit_positions.txt";
        BufferedWriter bw = Utils.getBufferedWriter(outFile);
        System.out.println("Total number of  positions for chrom9: " + peakPositions.size());
        try {
            StringBuilder sb = new StringBuilder();
            int count = 0;
            for (int idx = 0; idx < peakPositions.size(); ++idx) {
                String hits = Integer.toString(peakPositions.get(idx));
                sb.append(hits);
                sb.append("\n");
                if (++count <= 100000) continue;
                bw.write(sb.toString());
                count = 0;
                sb.setLength(0);
            }
            if (count > 0) {
                bw.write(sb.toString());
            }
            bw.close();
        }
        catch (IOException ioe) {
            System.out.println("LCJ - exception writing file " + outFile);
            ioe.printStackTrace();
        }
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return null;
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    public static void main(String[] args) {
        GeneratePluginCode.generate(RepGenAlignerPlugin.class);
    }

    public String inputDB() {
        return this.myDBFile.value();
    }

    public RepGenAlignerPlugin inputDB(String value) {
        this.myDBFile = new PluginParameter<String>(this.myDBFile, value);
        return this;
    }

    public String refGenome() {
        return this.refGenome.value();
    }

    public RepGenAlignerPlugin refGenome(String value) {
        this.refGenome = new PluginParameter<String>(this.refGenome, value);
        return this;
    }

    public Integer minTagCount() {
        return this.minTagCount.value();
    }

    public RepGenAlignerPlugin minTagCount(Integer value) {
        this.minTagCount = new PluginParameter<Integer>(this.minTagCount, value);
        return this;
    }

    public Integer minHitCount() {
        return this.minHitCount.value();
    }

    public RepGenAlignerPlugin minHitCount(Integer value) {
        this.minHitCount = new PluginParameter<Integer>(this.minHitCount, value);
        return this;
    }

    public Integer seedLen() {
        return this.seedLen.value();
    }

    public RepGenAlignerPlugin seedLen(Integer value) {
        this.seedLen = new PluginParameter<Integer>(this.seedLen, value);
        return this;
    }

    public Integer seedWindow() {
        return this.seedWindow.value();
    }

    public RepGenAlignerPlugin seedWindow(Integer value) {
        this.seedWindow = new PluginParameter<Integer>(this.seedWindow, value);
        return this;
    }

    public Integer kmerLen() {
        return this.kmerLen.value();
    }

    public RepGenAlignerPlugin kmerLen(Integer value) {
        this.kmerLen = new PluginParameter<Integer>(this.kmerLen, value);
        return this;
    }

    public Integer refKmerLen() {
        return this.refKmerLen.value();
    }

    public RepGenAlignerPlugin refKmerLen(Integer value) {
        this.refKmerLen = new PluginParameter<Integer>(this.refKmerLen, value);
        return this;
    }

    public Integer match_reward() {
        return this.match_reward.value();
    }

    public RepGenAlignerPlugin match_reward(Integer value) {
        this.match_reward = new PluginParameter<Integer>(this.match_reward, value);
        return this;
    }

    public Integer mismatch_penalty() {
        return this.mismatch_penalty.value();
    }

    public RepGenAlignerPlugin mismatch_penalty(Integer value) {
        this.mismatch_penalty = new PluginParameter<Integer>(this.mismatch_penalty, value);
        return this;
    }

    public Integer gap_penalty() {
        return this.gap_penalty.value();
    }

    public RepGenAlignerPlugin gap_penalty(Integer value) {
        this.gap_penalty = new PluginParameter<Integer>(this.gap_penalty, value);
        return this;
    }

    private /* synthetic */ void lambda$createRefTagsForAlignment$1(Multimap movingSumMap, BufferedWriter peakwr, Multimap chromMaximaMap, String chrom, long chromSize, Multimap refTagPositionMap, Short peak) {
        Collection values = movingSumMap.get((Object)peak);
        ArrayList<Integer> positionsInPeak = new ArrayList<Integer>(values);
        Collections.sort(positionsInPeak);
        String peakData = positionsInPeak.get(0) + "," + positionsInPeak.size() + "\n";
        try {
            peakwr.write(peakData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.storeRefTagPositions(peak.shortValue(), positionsInPeak, (Multimap<String, Integer>)chromMaximaMap, chrom, chromSize, (Multimap<Tag, Position>)refTagPositionMap);
    }

    private /* synthetic */ void lambda$processData$0(Multimap kmerTagMap, Map chromBitMaps, Chromosome chrom) {
        int kmersForChrom = 0;
        int chromLength = myRefSequence.chromosomeSize(chrom);
        System.out.println("\nChecking reference chrom " + chrom.getName() + ", size: " + chromLength + " for tag kmer matches.");
        OpenBitSet chromBits = new OpenBitSet(chromLength);
        int chromIdx = 0;
        while (chromIdx < chromLength) {
            int end = Math.min(chromLength, chromIdx + this.seedLen());
            byte[] chromSeedBytes = myRefSequence.chromosomeSequence(chrom, chromIdx + 1, end);
            int badValue = this.checkForN(chromSeedBytes);
            if (badValue >= 0) {
                chromIdx += badValue + 1;
                continue;
            }
            String chromKmerString = NucleotideAlignmentConstants.nucleotideBytetoString(chromSeedBytes);
            if (kmerTagMap.containsKey((Object)chromKmerString)) {
                ++kmersForChrom;
                chromBits.fastSet(chromIdx);
            }
            ++chromIdx;
        }
        chromBitMaps.put(chrom.getName(), chromBits);
        System.out.println("Total tag seeds matching to kmers in chrom " + chrom.getName() + ": " + kmersForChrom + ", total fastBits set via cardinality: " + chromBits.cardinality());
    }
}

