/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.repgen;

import java.awt.Frame;
import java.io.BufferedReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.v2.GBSUtils;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.tag.RepGenSQLite;
import net.maizegenetics.dna.tag.Tag;
import net.maizegenetics.dna.tag.TagBuilder;
import net.maizegenetics.dna.tag.TagDataSQLite;
import net.maizegenetics.dna.tag.TaxaDistBuilder;
import net.maizegenetics.dna.tag.TaxaDistribution;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListIOUtils;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.DirectoryCrawler;
import net.maizegenetics.util.Tuple;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class RepGenLoadSeqToDBPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(RepGenLoadSeqToDBPlugin.class);
    private PluginParameter<String> myInputDir = new PluginParameter.Builder<String>("i", null, String.class).guiName("Input Directory").required(true).inDir().description("Input directory containing FASTQ files in text or gzipped text.\n     NOTE: Directory will be searched recursively and should\n     be written WITHOUT a slash after its name.").build();
    private PluginParameter<String> myKeyFile = new PluginParameter.Builder<String>("k", null, String.class).guiName("Key File").required(true).inFile().description("Key file listing barcodes distinguishing the samples").build();
    private PluginParameter<Integer> myKmerLength = new PluginParameter.Builder<Integer>("kmerLength", 150, Integer.class).guiName("Maximum Kmer Length").description("Specified length for each kmer to process").build();
    private PluginParameter<Integer> myMinKmerLength = new PluginParameter.Builder<Integer>("minKmerL", 120, Integer.class).guiName("Minimum Kmer Length").description("Minimum kmer Length after second cut site is removed").build();
    private PluginParameter<Integer> myMinKmerCount = new PluginParameter.Builder<Integer>("c", 10, Integer.class).guiName("Min Kmer Count").description("Minimum kmer count").build();
    private PluginParameter<Integer> minTaxa = new PluginParameter.Builder<Integer>("minTaxa", 2, Integer.class).guiName("Min Taxa Represented").description("Minimum numer of taxa where kmer is found").build();
    private PluginParameter<String> myOutputDB = new PluginParameter.Builder<String>("db", null, String.class).guiName("Output Database File").required(true).outFile().description("Output Database File").build();
    private PluginParameter<Integer> myMinQualScore = new PluginParameter.Builder<Integer>("mnQS", 0, Integer.class).guiName("Minimum quality score").required(false).description("Minimum quality score within the barcode and read length to be accepted").build();
    private PluginParameter<Integer> myMaxKmerNumber = new PluginParameter.Builder<Integer>("mxKmerNum", 50000000, Integer.class).guiName("Maximum Kmer Number").required(false).description("Maximum number of kmers").build();
    private PluginParameter<Integer> myBatchSize = new PluginParameter.Builder<Integer>("batchSize", 100, Integer.class).guiName("Batch size of fastq files").required(false).description("Number of flow cells being processed simultaneously").build();
    LongAdder roughTagCnt = new LongAdder();
    private TagDistributionMap tagCntMap;
    private TagCountQualityScoreMap tagCntQSMap;
    private boolean taglenException;
    protected static int readEndCutSiteRemnantLength;
    protected static int qualityScoreBase;
    String[] likelyReadEndStrings;

    public RepGenLoadSeqToDBPlugin() {
        super(null, false);
    }

    public RepGenLoadSeqToDBPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    private long[] calcTagMapStats(TagDistributionMap tagCntMap) {
        long totalDepth = 0L;
        long memory = 0L;
        int cnt = 0;
        for (Map.Entry entry : tagCntMap.entrySet()) {
            memory += (long)((TaxaDistribution)entry.getValue()).memorySize();
            memory += 25L;
            totalDepth += (long)((TaxaDistribution)entry.getValue()).totalDepth();
            ++cnt;
        }
        int currentSize = tagCntMap.size();
        long[] stats = new long[]{currentSize, memory += (long)(tagCntMap.size() * 2 * 16), totalDepth, totalDepth / (long)cnt};
        System.out.printf("Map Tags:%,d  Memory:%,d  TotalDepth:%,d  AvgDepthPerTag:%d%n", stats[0], stats[1], stats[2], stats[3]);
        return stats;
    }

    @Override
    public void postProcessParameters() {
    }

    @Override
    public DataSet processData(DataSet input) {
        int batchSize = this.myBatchSize.value();
        float loadFactor = 0.95f;
        this.tagCntMap = new TagDistributionMap(this.myMaxKmerNumber.value(), loadFactor, 128, this.minKmerCount());
        this.tagCntQSMap = new TagCountQualityScoreMap(this.myMaxKmerNumber.value(), loadFactor, 128, this.minKmerCount());
        try {
            TaxaList masterTaxaList = TaxaListIOUtils.readTaxaAnnotationFile(this.keyFile(), "FullSampleName", new HashMap<String, String>(), true);
            Map<String, Taxon> fileTaxaMap = TaxaListIOUtils.getUniqueMapOfTaxonByAnnotation(masterTaxaList, "FileName").orElseThrow(() -> new IllegalArgumentException("Error: Same file points more than one taxon in the KeyFile"));
            List<Path> directoryFiles = DirectoryCrawler.listPaths("glob:*{.fq,fq.gz,fastq,fastq.txt,fastq.gz,fastq.txt.gz,_sequence.txt,_sequence.txt.gz}", Paths.get(this.myInputDir.value(), new String[0]).toAbsolutePath());
            if (directoryFiles.isEmpty()) {
                myLogger.warn((Object)"No files matching:glob:*{.fq,fq.gz,fastq,fastq.txt,fastq.gz,fastq.txt.gz,_sequence.txt,_sequence.txt.gz}");
                return null;
            }
            List inputSeqFiles = directoryFiles.stream().peek(path -> System.out.println(path.getFileName().toString())).filter(path -> fileTaxaMap.containsKey(path.getFileName().toString())).collect(Collectors.toList());
            if (inputSeqFiles.size() == 0) {
                System.out.println("RepGenLoadSeqToDB:processData - found NO files represented in key file.");
                System.out.println("Please verify your file names are formatted correctly and that your key file contains the required headers.");
                return null;
            }
            System.out.println("Found " + inputSeqFiles.size() + " files to process");
            int batchNum = inputSeqFiles.size() / batchSize;
            if (inputSeqFiles.size() % batchSize != 0) {
                ++batchNum;
            }
            RepGenSQLite tdw = null;
            if (Files.exists(Paths.get(this.myOutputDB.value(), new String[0]), new LinkOption[0])) {
                try {
                    Files.delete(Paths.get(this.myOutputDB.value(), new String[0]));
                }
                catch (Exception exc) {
                    System.out.println("Error when trying to delete database file: " + this.myOutputDB.value());
                    System.out.println("File delete error: " + exc.getMessage());
                    return null;
                }
            }
            if (tdw == null) {
                tdw = new RepGenSQLite(this.myOutputDB.value());
            }
            this.taglenException = false;
            for (int i = 0; i < inputSeqFiles.size(); i += batchSize) {
                int end = i + batchSize;
                if (end > inputSeqFiles.size()) {
                    end = inputSeqFiles.size();
                }
                ArrayList<Object> sub = new ArrayList<Object>();
                for (int j = i; j < end; ++j) {
                    sub.add(inputSeqFiles.get(j));
                }
                System.out.println("\nStart processing batch " + String.valueOf(i / batchSize + 1));
                sub.forEach((Consumer<Object>)((Consumer<Path>)inputSeqFile -> {
                    try {
                        int taxaIndex = masterTaxaList.indexOf((Taxon)fileTaxaMap.get(inputSeqFile.getFileName().toString()));
                        this.processFastQ((Path)inputSeqFile, taxaIndex, masterTaxaList, this.tagCntMap, this.kmerLength(), this.minimumQualityScore());
                    }
                    catch (StringIndexOutOfBoundsException oobe) {
                        oobe.printStackTrace();
                        myLogger.error((Object)oobe.getMessage());
                        this.setTagLenException();
                        return;
                    }
                }));
                if (this.taglenException) {
                    ((TagDataSQLite)((Object)tdw)).close();
                    return null;
                }
                System.out.println("\nKmers are added from batch " + String.valueOf(i / batchSize + 1) + ". Total batch number: " + batchNum);
                int currentSize = this.tagCntMap.size();
                System.out.println("Current number: " + String.valueOf(currentSize) + ". Max kmer number: " + String.valueOf(this.myMaxKmerNumber.value()));
                System.out.println(String.valueOf((float)currentSize / (float)this.myMaxKmerNumber.value().intValue()) + " of max tag number");
                if (currentSize > 0) {
                    this.calcTagMapStats(this.tagCntMap);
                    System.out.println();
                    System.out.println("BEFORE removeTagsWihtoutReplication, tagCntMap.size= " + ((ConcurrentHashMap.CollectionView)((Object)this.tagCntMap.keySet())).size() + ", tagCntQSMap.size= " + ((ConcurrentHashMap.CollectionView)((Object)this.tagCntQSMap.keySet())).size());
                    RepGenLoadSeqToDBPlugin.removeTagsWithoutReplication(this.tagCntMap, this.tagCntQSMap, 2, 4);
                    if (this.tagCntMap.size() == 0) {
                        System.out.println("WARNING:  After removing tags without replication, there are NO  tags left in the database");
                    } else {
                        this.calcTagMapStats(this.tagCntMap);
                        System.out.println();
                        System.out.println("After removeTagsWithoutReplication: Kmer number is reduced to " + this.tagCntMap.size() + "\n");
                    }
                    this.roughTagCnt.reset();
                    this.roughTagCnt.add(this.tagCntMap.size());
                } else {
                    System.out.println("WARNING: Current tagcntmap size is 0 after processing batch " + String.valueOf(i / batchSize + 1));
                }
                System.out.println("Total memory: " + String.valueOf((double)(Runtime.getRuntime().totalMemory() / 1024L / 1024L / 1024L)) + " Gb");
                System.out.println("Free memory: " + String.valueOf((double)(Runtime.getRuntime().freeMemory() / 1024L / 1024L / 1024L)) + " Gb");
                System.out.println("Max memory: " + String.valueOf((double)(Runtime.getRuntime().maxMemory() / 1024L / 1024L / 1024L)) + " Gb");
                System.out.println("\n");
            }
            System.out.println("\nAll the batch are processed");
            RepGenLoadSeqToDBPlugin.removeTagsWithoutReplication(this.tagCntMap, this.tagCntQSMap, this.minTaxa(), this.minKmerCount());
            System.out.printf("Filter by kmerCnt:%d taxaCount:%d results in MapSize:%d\n", this.minKmerCount(), this.minTaxa(), this.tagCntMap.size());
            if (((ConcurrentHashMap.CollectionView)((Object)this.tagCntMap.keySet())).size() != ((ConcurrentHashMap.CollectionView)((Object)this.tagCntQSMap.keySet())).size()) {
                System.out.println("Mismatch between size of tagCntMap " + ((ConcurrentHashMap.CollectionView)((Object)this.tagCntMap.keySet())).size() + ", and tagCntQSMap " + ((ConcurrentHashMap.CollectionView)((Object)this.tagCntQSMap.keySet())).size());
                System.out.println("quitting - nothing added to DB!");
                tdw.close();
                return null;
            }
            System.out.println("\ntagCntMap and tagCntQSMap have same size: " + ((ConcurrentHashMap.CollectionView)((Object)this.tagCntMap.keySet())).size());
            Map<Tag, Tuple<Integer, String>> tagInstanceAverageQS = RepGenLoadSeqToDBPlugin.calculateTagAveQS(this.tagCntQSMap, qualityScoreBase);
            System.out.println("Before add to DB: sizeof tagInstanceAverageQS.keySet = " + tagInstanceAverageQS.keySet().size());
            tdw.putTaxaList(masterTaxaList);
            tdw.putAllTag(this.tagCntMap.keySet(), tagInstanceAverageQS);
            tdw.putTaxaDistribution(this.tagCntMap);
            tdw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new DataSet(new Datum("TagMap", this.tagCntMap, ""), (Plugin)this);
    }

    private void processFastQ(Path fastqFile, int taxaIndex, TaxaList masterTaxaList, TagDistributionMap masterTagTaxaMap, int preferredTagLength, int minQual) throws StringIndexOutOfBoundsException {
        int allReads = 0;
        int goodBarcodedReads = 0;
        int lowQualityReads = 0;
        int tooShortReads = 0;
        int maxTaxaNumber = masterTaxaList.size();
        int checkSize = 10000000;
        myLogger.info((Object)("processing file " + fastqFile.toString()));
        try {
            String[] seqAndQual;
            qualityScoreBase = GBSUtils.determineQualityScoreBase(fastqFile);
            BufferedReader br = Utils.getBufferedReader(fastqFile.toString(), 0x400000);
            long time = System.nanoTime();
            while ((seqAndQual = GBSUtils.readFastQBlock(br, allReads)) != null) {
                int tagEnd;
                ++allReads;
                int n = tagEnd = seqAndQual[0].length() < preferredTagLength ? seqAndQual[0].length() : preferredTagLength;
                if (minQual > 0 && BaseEncoder.getFirstLowQualityPos(seqAndQual[1], minQual, qualityScoreBase) < tagEnd) {
                    ++lowQualityReads;
                    continue;
                }
                if (seqAndQual[0].length() < this.minimumKmerLength()) {
                    ++tooShortReads;
                    continue;
                }
                Tag tag = TagBuilder.instance(seqAndQual[0].substring(0, tagEnd)).build();
                if (tag == null) continue;
                ++goodBarcodedReads;
                TaxaDistribution taxaDistribution = (TaxaDistribution)masterTagTaxaMap.get(tag);
                if (taxaDistribution == null) {
                    masterTagTaxaMap.put(tag, TaxaDistBuilder.create(maxTaxaNumber, taxaIndex));
                    this.roughTagCnt.increment();
                } else {
                    taxaDistribution.increment(taxaIndex);
                }
                String tagQS = seqAndQual[1].substring(0, tagEnd);
                List<String> tagScores = (List<String>)this.tagCntQSMap.get(tag);
                if (tagScores == null) {
                    tagScores = Collections.synchronizedList(new ArrayList());
                    tagScores.add(tagQS);
                    this.tagCntQSMap.put(tag, tagScores);
                } else {
                    tagScores.add(tagQS);
                }
                if (allReads % checkSize != 0) continue;
                myLogger.info((Object)("Total Reads:" + allReads + " Reads with barcode and cut site overhang:" + goodBarcodedReads + " rate:" + (System.nanoTime() - time) / (long)allReads + " ns/read. Current tag count:" + this.roughTagCnt));
            }
            myLogger.info((Object)("Summary for " + fastqFile.toString() + "\nTotal number of reads in lane=" + allReads + "\nTotal number of good barcoded reads=" + goodBarcodedReads + "\nTotal number of low quality reads=" + lowQualityReads + "\nTotal number of too short reads=" + tooShortReads + "\nTiming process (sorting, collapsing, and writing TagCount to file).\nProcess took " + (double)(System.nanoTime() - time) / 1000000.0 + " milliseconds."));
            System.out.println("tagCntMap size: " + masterTagTaxaMap.size());
            br.close();
        }
        catch (StringIndexOutOfBoundsException oobe) {
            throw oobe;
        }
        catch (Exception e) {
            myLogger.error((Object)("Good Barcodes Read: " + goodBarcodedReads));
            e.printStackTrace();
        }
    }

    private static void removeTagsWithoutReplication(TagDistributionMap masterTagTaxaMap, TagCountQualityScoreMap tagCntQSMap, int minTaxa, int minDepth) {
        int currentSize = masterTagTaxaMap.size();
        System.out.println("Starting removeTagsWithoutReplication. Current tag number: " + currentSize);
        LongAdder tagsRemoved = new LongAdder();
        masterTagTaxaMap.entrySet().parallelStream().forEach(t -> {
            TaxaDistribution td = (TaxaDistribution)t.getValue();
            if (td.totalDepth() < minDepth) {
                masterTagTaxaMap.remove(t.getKey());
                tagCntQSMap.remove(t.getKey());
                tagsRemoved.increment();
            } else if (IntStream.of(td.depths()).filter(depth -> depth > 1).count() < (long)minTaxa) {
                masterTagTaxaMap.remove(t.getKey());
                tagCntQSMap.remove(t.getKey());
                tagsRemoved.increment();
            }
        });
        System.out.println("Finished removeTagsWithoutReplication.  tagsRemoved = " + tagsRemoved + ". Current tag number: " + String.valueOf(currentSize - tagsRemoved.intValue()));
    }

    public void setTagLenException() {
        this.taglenException = true;
    }

    public static Map<Tag, Tuple<Integer, String>> calculateTagAveQS(TagCountQualityScoreMap tagCntQSMap, int qualityScoreBase) {
        ConcurrentHashMap<Tag, Tuple<Integer, String>> tagInstanceAverageQS = new ConcurrentHashMap<Tag, Tuple<Integer, String>>();
        tagCntQSMap.entrySet().parallelStream().forEach(entry -> {
            Tag tag = (Tag)entry.getKey();
            List scores = (List)entry.getValue();
            int numInstances = scores.size();
            int scoreLen = ((String)scores.get(0)).length();
            int[] scoreArray = new int[scoreLen];
            for (int idx = 0; idx < numInstances; ++idx) {
                String currentScore = (String)scores.get(idx);
                for (int jdx = 0; jdx < scoreLen; ++jdx) {
                    int n = jdx;
                    scoreArray[n] = scoreArray[n] + (currentScore.charAt(jdx) - qualityScoreBase);
                }
            }
            StringBuilder sb = new StringBuilder();
            for (int jdx = 0; jdx < scoreLen; ++jdx) {
                int n = jdx;
                scoreArray[n] = scoreArray[n] / numInstances;
                char ch = (char)(scoreArray[jdx] + qualityScoreBase);
                sb.append(ch);
            }
            Tuple<Integer, String> instanceScore = new Tuple<Integer, String>(numInstances, sb.toString());
            tagInstanceAverageQS.put(tag, instanceScore);
        });
        return tagInstanceAverageQS;
    }

    public String inputDirectory() {
        return this.myInputDir.value();
    }

    public RepGenLoadSeqToDBPlugin inputDirectory(String value) {
        this.myInputDir = new PluginParameter<String>(this.myInputDir, value);
        return this;
    }

    public String keyFile() {
        return this.myKeyFile.value();
    }

    public RepGenLoadSeqToDBPlugin keyFile(String value) {
        this.myKeyFile = new PluginParameter<String>(this.myKeyFile, value);
        return this;
    }

    public Integer kmerLength() {
        return this.myKmerLength.value();
    }

    public RepGenLoadSeqToDBPlugin kmerLength(Integer value) {
        this.myKmerLength = new PluginParameter<Integer>(this.myKmerLength, value);
        return this;
    }

    public Integer minimumKmerLength() {
        return this.myMinKmerLength.value();
    }

    public RepGenLoadSeqToDBPlugin minimumKmerLength(Integer value) {
        this.myMinKmerLength = new PluginParameter<Integer>(this.myMinKmerLength, value);
        return this;
    }

    public Integer minKmerCount() {
        return this.myMinKmerCount.value();
    }

    public RepGenLoadSeqToDBPlugin minKmerCount(Integer value) {
        this.myMinKmerCount = new PluginParameter<Integer>(this.myMinKmerCount, value);
        return this;
    }

    public Integer minTaxa() {
        return this.minTaxa.value();
    }

    public RepGenLoadSeqToDBPlugin minTaxa(Integer value) {
        this.minTaxa = new PluginParameter<Integer>(this.minTaxa, value);
        return this;
    }

    public String outputDatabaseFile() {
        return this.myOutputDB.value();
    }

    public RepGenLoadSeqToDBPlugin outputDatabaseFile(String value) {
        this.myOutputDB = new PluginParameter<String>(this.myOutputDB, value);
        return this;
    }

    public Integer minimumQualityScore() {
        return this.myMinQualScore.value();
    }

    public RepGenLoadSeqToDBPlugin minimumQualityScore(Integer value) {
        this.myMinQualScore = new PluginParameter<Integer>(this.myMinQualScore, value);
        return this;
    }

    public RepGenLoadSeqToDBPlugin maximumKmerNumber(Integer value) {
        this.myMaxKmerNumber = new PluginParameter<Integer>(this.myMaxKmerNumber, value);
        return this;
    }

    public RepGenLoadSeqToDBPlugin batchSize(Integer value) {
        this.myBatchSize = new PluginParameter<Integer>(this.myBatchSize, value);
        return this;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Discovery Tags By Taxa";
    }

    @Override
    public String getToolTipText() {
        return "Discovery Tags By Taxa";
    }

    public static class TagCountQualityScoreMap
    extends ConcurrentHashMap<Tag, List<String>> {
        private int tagCount;

        TagCountQualityScoreMap(int maxTagNumber, float loadFactor, int concurrencyLevel, int minCount) {
            super(maxTagNumber * 2, loadFactor, concurrencyLevel);
        }

        public synchronized void removeTagByCount(int minCnt) {
            this.entrySet().parallelStream().filter(e -> ((List)e.getValue()).size() < minCnt).forEach((? super T e) -> {
                List cfr_ignored_0 = (List)this.remove(e.getKey());
            });
        }
    }

    static class TagDistributionMap
    extends ConcurrentHashMap<Tag, TaxaDistribution> {
        private final int maxTagNum;
        private int minDepthToRetainInMap = 2;
        private final int minCount;

        TagDistributionMap(int maxTagNumber, float loadFactor, int concurrencyLevel, int minCount) {
            super(maxTagNumber * 2, loadFactor, concurrencyLevel);
            this.maxTagNum = maxTagNumber;
            this.minCount = minCount;
        }

        @Override
        public TaxaDistribution put(Tag key, TaxaDistribution value) {
            return super.put(key, value);
        }

        public synchronized void removeTagByCount(int minCnt) {
            this.entrySet().parallelStream().filter(e -> ((TaxaDistribution)e.getValue()).totalDepth() < minCnt).forEach((? super T e) -> {
                TaxaDistribution cfr_ignored_0 = (TaxaDistribution)this.remove(e.getKey());
            });
        }

        public long estimateMapMemorySize() {
            long size = 0L;
            int cnt = 0;
            for (Map.Entry entry : this.entrySet()) {
                size += 25L;
                size += 16L;
                size += (long)((TaxaDistribution)entry.getValue()).memorySize();
                if (++cnt <= 10000) continue;
                break;
            }
            long estSize = (long)(this.size() / cnt) * size;
            return estSize;
        }

        public long[] depthDistribution() {
            long[] base2bins = new long[34];
            int cnt = 0;
            for (Map.Entry entry : this.entrySet()) {
                int n = 31 - Integer.numberOfLeadingZeros(((TaxaDistribution)entry.getValue()).totalDepth());
                base2bins[n] = base2bins[n] + 1L;
                ++cnt;
            }
            return base2bins;
        }
    }
}

