/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.repgen;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.neobio.BasicScoringScheme;
import net.maizegenetics.analysis.gbs.neobio.IncompatibleScoringSchemeException;
import net.maizegenetics.analysis.gbs.neobio.InvalidSequenceException;
import net.maizegenetics.analysis.gbs.neobio.PairwiseAlignment;
import net.maizegenetics.analysis.gbs.neobio.SmithWaterman;
import net.maizegenetics.analysis.gbs.repgen.AlignmentInfo;
import net.maizegenetics.analysis.gbs.repgen.RefTagData;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.GenomeSequence;
import net.maizegenetics.dna.map.GenomeSequenceBuilder;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.tag.RepGenSQLite;
import net.maizegenetics.dna.tag.Tag;
import net.maizegenetics.dna.tag.TagBuilder;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.GeneratePluginCode;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.Tuple;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class RepGenPhase2AlignerPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(RepGenPhase2AlignerPlugin.class);
    private PluginParameter<String> myDBFile = new PluginParameter.Builder<String>("db", null, String.class).guiName("Input DB").required(true).inFile().description("Input database file with tags and taxa distribution").build();
    private PluginParameter<String> refGenome = new PluginParameter.Builder<String>("ref", null, String.class).guiName("Reference Genome File").required(true).description("Referemce Genome File for aligning against ").build();
    private PluginParameter<Integer> minTagCount = new PluginParameter.Builder<Integer>("minTagCount", 1, Integer.class).guiName("Min Tag Count").description("Minimum count of reads for a tag to be aligned").build();
    private PluginParameter<Integer> seedLen = new PluginParameter.Builder<Integer>("seedLen", 31, Integer.class).guiName("Seed Kmer Length").description("Length of kmer seed created from DB tags and used as seeds for aligning against the reference genome.").build();
    private PluginParameter<Integer> seedWindow = new PluginParameter.Builder<Integer>("seedWindow", 1, Integer.class).guiName("Window Length for Seed Creation").description("Length of window between positions when creating seed from DB tags.").build();
    private PluginParameter<Integer> kmerLen = new PluginParameter.Builder<Integer>("kmerLen", 150, Integer.class).guiName("Kmer Length").description("Length of kmer from fastq reads stored as the tag sequence in the DB.").build();
    private PluginParameter<Integer> refKmerLen = new PluginParameter.Builder<Integer>("refKmerLen", 300, Integer.class).guiName("Reference Kmer Length").description("Length of kmers created from reference genome to store in the DB. \nThis should be at as long or longer than the kmerLen parameter used for storing input sequence tags.").build();
    private PluginParameter<Integer> match_reward = new PluginParameter.Builder<Integer>("match_reward", 2, Integer.class).guiName("Match Reward Amount").description("Parameter sent to Smith Waterman aligner for use in calculating reward when base pairs match.").build();
    private PluginParameter<Integer> mismatch_penalty = new PluginParameter.Builder<Integer>("mismatch_penalty", -1, Integer.class).guiName("Mismatch Penalty Amount").description("Parameter sent to Smith Waterman aligner for use in calculating penalty when base pairs are mis-matched.").build();
    private PluginParameter<Integer> gap_penalty = new PluginParameter.Builder<Integer>("gap_penalty", -1, Integer.class).guiName("Gap Penalty Amount").description("Parameter sent to Smith Waterman aligner for use in calculating penalty when when a gap is identified.").build();
    private PluginParameter<String> primers = new PluginParameter.Builder<String>("primers", null, String.class).guiName("Primers").required(true).inFile().description("Tab delimited file that contains a list of forward,reverse primer pairs.  \nThe values in each column are the forward primer sequence and the reverse primer sequence.").build();
    static GenomeSequence myRefSequence = null;
    static int refAlignLen = 1000;
    static int bestScoreBad = 0;

    public RepGenPhase2AlignerPlugin() {
        super(null, false);
    }

    public RepGenPhase2AlignerPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    public RepGenPhase2AlignerPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public void postProcessParameters() {
        if (this.myDBFile.isEmpty() || !Files.exists(Paths.get(this.inputDB(), new String[0]), new LinkOption[0])) {
            throw new IllegalArgumentException("RepGenPhase2AlignerPlugin: postProcessParameters: Input DB not set or found");
        }
        if (this.primers.isEmpty() || !Files.exists(Paths.get(this.inputDB(), new String[0]), new LinkOption[0])) {
            throw new IllegalArgumentException("RepGenPhase2AlignerPlugin: postProcessParameters: Primer file not set or found");
        }
        if (this.refGenome.isEmpty()) {
            throw new IllegalArgumentException("RepGenPhase2AlignerPlugin: postProcessParameters: reference genome not set or found");
        }
        myRefSequence = GenomeSequenceBuilder.instance(this.refGenome());
    }

    @Override
    public DataSet processData(DataSet input) {
        long totalTime = System.nanoTime();
        long time = System.nanoTime();
        try {
            System.out.println("RepGenPhase2AlignerPlugin:processData begin");
            RepGenSQLite repGenData = new RepGenSQLite(this.inputDB());
            Map<Tag, Integer> tagsWithDepth = repGenData.getTagsWithDepth(this.minTagCount());
            if (tagsWithDepth.isEmpty()) {
                System.out.println("\nNo tags found with minimum depth " + this.minTagCount() + ". Halting Run.\n");
                repGenData.close();
                return null;
            }
            HashMultimap kmerTagMap = HashMultimap.create();
            System.out.println("Calling createKmerSeedsFromDBTags with window size: " + this.seedWindow());
            this.createKmerSeedsFromDBTags(tagsWithDepth.keySet(), (Multimap<String, Tag>)kmerTagMap, this.seedWindow());
            System.out.println("Num distinct kmerSeeds created: " + kmerTagMap.keySet().size() + ", kmerTagMap size is:" + kmerTagMap.size() + ",TotalTime for createKmerSeedsFromDBTags was " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds");
            System.out.println("Size of tagsWithDepth: " + tagsWithDepth.size());
            System.out.println("Size of kmerTagMap keyset: " + kmerTagMap.keySet().size());
            time = System.nanoTime();
            Set<Chromosome> chromsInRef = myRefSequence.chromosomes();
            List<Tuple<String, String>> primerList = this.createPrimerList();
            if (primerList == null || primerList.isEmpty()) {
                repGenData.close();
                System.out.println("Failed to process entries from primers file " + this.primers() + ".\nPlease ensure file exists and a header line with 3 tab-delimited columns for chrom,forward,reverse\n");
                return null;
            }
            Multimap refTagPositionMap = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
            chromsInRef.parallelStream().forEach(arg_0 -> this.lambda$processData$0((Multimap)kmerTagMap, primerList, refTagPositionMap, arg_0));
            String refTagOutFile = "/home/lcj34/repGen_outputFiles/allChroms_refTagsFromPrimers.txt";
            BufferedWriter refwr = Utils.getBufferedWriter(refTagOutFile);
            try {
                for (Map.Entry entry : refTagPositionMap.entries()) {
                    int position = ((Position)entry.getValue()).getPosition();
                    String chromname = ((Position)entry.getValue()).getChromosome().getName();
                    Tag refTag = (Tag)entry.getKey();
                    String refData = chromname + "\t" + position + "\t" + refTag.sequence() + "\n";
                    refwr.write(refData);
                }
                refwr.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            System.out.println("Finished with refs from primers, total time:" + (double)(System.nanoTime() - time) / 1.0E9 + " seconds.\n");
            time = System.nanoTime();
            System.out.println("\nNumber of distinct refTags to be loaded into db: " + refTagPositionMap.keySet().size() + " total refTags: " + refTagPositionMap.size());
            repGenData.addMappingApproach("SmithWaterman");
            repGenData.addReferenceGenome(this.refGenome());
            repGenData.putRefTagMapping((Multimap<Tag, Position>)refTagPositionMap, this.refGenome());
            repGenData.close();
            myLogger.info((Object)"Finished RepGenPhase2AlignerPlugin\n");
        }
        catch (Exception e) {
            myLogger.info((Object)("Catch in prcessing RepGenPhase2AlignerPlugin file e=" + e));
            e.printStackTrace();
        }
        System.out.println("Process took " + (double)(System.nanoTime() - totalTime) / 1.0E9 + " seconds.\n");
        return null;
    }

    private List<Tuple<String, String>> createPrimerList() {
        ArrayList<Tuple<String, String>> pmap = new ArrayList<Tuple<String, String>>();
        BufferedReader br = Utils.getBufferedReader(this.primers());
        try {
            String line = br.readLine();
            while ((line = br.readLine()) != null) {
                String[] primerTokens = line.split("\t");
                if (primerTokens.length != 2) {
                    System.out.println("Bad file format for primers.  Should be 2 tab delimited columns for forward, reverse");
                    return null;
                }
                Tuple<String, String> primers = new Tuple<String, String>(primerTokens[0], primerTokens[1]);
                pmap.add(primers);
            }
        }
        catch (IOException ioe) {
            System.out.println("createChromPrimerMap failed processing file: " + this.primers());
            ioe.printStackTrace();
            return null;
        }
        return pmap;
    }

    private void createKmerSeedsFromDBTags(Set<Tag> tagWithDepth, Multimap<String, Tag> kmerTagMap, int window) {
        for (Tag tag : tagWithDepth) {
            String tagSequence = tag.sequence();
            int maxIdx = window > this.seedLen() ? tagSequence.length() - window : tagSequence.length() - this.seedLen();
            int seqIdx = 0;
            while (seqIdx < maxIdx) {
                String kmer = tagSequence.substring(seqIdx, seqIdx + this.seedLen());
                byte[] kmerBytesAsNum = NucleotideAlignmentConstants.convertHaplotypeStringToAlleleByteArray(kmer);
                int badValues = this.checkForN(kmerBytesAsNum);
                if (badValues >= 0) {
                    seqIdx += badValues + 1;
                    continue;
                }
                kmerTagMap.put((Object)kmer, (Object)tag);
                byte[] kmerRC = NucleotideAlignmentConstants.reverseComplementAlleleByteArray(kmer.getBytes());
                String kmerRCString = new String(kmerRC);
                kmerTagMap.put((Object)kmerRCString, (Object)tag);
                seqIdx += window;
            }
        }
    }

    private int createRefTagsForAlignment(Chromosome chrom, String refString, int refOffset, List<Tuple<String, String>> primers, Multimap<Tag, Position> refTagPositionMap) {
        int nextChromIdx = -1;
        for (Tuple<String, String> primer : primers) {
            String forward = (String)primer.x;
            String reverse = (String)primer.y;
            String forwardRC = BaseEncoder.getReverseComplement(forward);
            String reverseRC = BaseEncoder.getReverseComplement(reverse);
            int perfectScore = forward.length() * 2;
            int oneMisMatch = (forward.length() - 1) * 2 - 1;
            int twoMisMatch = (forward.length() - 2) * 2 - 2;
            int threeMisMatch = (forward.length() - 3) * 2 - 3;
            Tuple<Integer, Integer> forwardPrimer = null;
            Tuple<Integer, Integer> reversePrimer = null;
            Tuple<Integer, Integer> forwardRCPrimer = null;
            Tuple<Integer, Integer> reverseRCPrimer = null;
            BestScore bestPrimer = BestScore.none;
            int bestScore = -1;
            HashMap<String, PairwiseAlignment> pAlign = new HashMap<String, PairwiseAlignment>();
            forwardPrimer = this.computePrimerSW(forward, refString, 2, -1, -1, pAlign);
            if (forwardPrimer != null && (Integer)forwardPrimer.x >= threeMisMatch) {
                bestPrimer = BestScore.forward;
                bestScore = (Integer)forwardPrimer.x;
                reverseRCPrimer = this.computePrimerSW(reverseRC, refString, 2, -1, -1, pAlign);
                if (reverseRCPrimer != null && (Integer)reverseRCPrimer.x >= threeMisMatch) {
                    if ((Integer)reverseRCPrimer.x > bestScore) {
                        bestScore = (Integer)reverseRCPrimer.x;
                        bestPrimer = BestScore.reverseRC;
                    }
                } else {
                    reverseRCPrimer = null;
                    bestScore = -1;
                }
            } else {
                forwardPrimer = null;
            }
            if ((reversePrimer = this.computePrimerSW(reverse, refString, 2, -1, -1, pAlign)) != null && (Integer)reversePrimer.x >= threeMisMatch) {
                int tempBest = bestScore;
                if ((Integer)reversePrimer.x > tempBest) {
                    tempBest = (Integer)reversePrimer.x;
                    bestPrimer = BestScore.reverse;
                }
                if ((forwardRCPrimer = this.computePrimerSW(forwardRC, refString, 2, -1, -1, pAlign)) != null && (Integer)forwardRCPrimer.x >= threeMisMatch) {
                    if ((Integer)forwardRCPrimer.x > tempBest) {
                        tempBest = (Integer)forwardRCPrimer.x;
                        bestPrimer = BestScore.forwardRC;
                    }
                    if (tempBest > bestScore) {
                        bestScore = tempBest;
                    }
                } else {
                    forwardRCPrimer = null;
                }
            } else {
                reversePrimer = null;
            }
            if (bestScore < 0) continue;
            int refBegin = -1;
            switch (bestPrimer) {
                case forward: 
                case reverseRC: {
                    if ((Integer)forwardPrimer.y < (Integer)reverseRCPrimer.y) {
                        refBegin = (Integer)forwardPrimer.y;
                        nextChromIdx = (Integer)reverseRCPrimer.y + reverseRC.length();
                        break;
                    }
                    refBegin = (Integer)reverseRCPrimer.y;
                    nextChromIdx = (Integer)forwardPrimer.y + forward.length();
                    break;
                }
                case reverse: 
                case forwardRC: {
                    if ((Integer)reversePrimer.y < (Integer)forwardRCPrimer.y) {
                        refBegin = (Integer)reversePrimer.y;
                        nextChromIdx = (Integer)forwardRCPrimer.y + forwardRC.length();
                        break;
                    }
                    refBegin = (Integer)forwardRCPrimer.y;
                    nextChromIdx = (Integer)reversePrimer.y + reverseRC.length();
                    break;
                }
                default: {
                    System.out.println("ERROR: best Primer is not one of the 4 !! We should have ditched earlier!");
                    return -2;
                }
            }
            int refStartIdx = refOffset + refBegin;
            int refEndIdx = Math.min(refStartIdx + this.refKmerLen(), myRefSequence.chromosomeSize(chrom));
            byte[] refTagBytes = myRefSequence.chromosomeSequence(chrom, refStartIdx, refEndIdx);
            String refTagString = NucleotideAlignmentConstants.nucleotideBytetoString(refTagBytes);
            if (refTagString == null || refTagString.length() == 0 || refTagString.contains("N") || refTagString.contains("null")) {
                System.out.println(" storeRefTagPositions - refString is NULL or contains N or null or is length 0");
                continue;
            }
            Tag refTag = TagBuilder.instance(refTagString).reference().build();
            if (refTag != null) {
                GeneralPosition refPos = new GeneralPosition.Builder(chrom, refStartIdx).strand((byte)1).addAnno("mappingapproach", "SmithWaterman").addAnno("forward", "true").build();
                refTagPositionMap.put((Object)refTag, (Object)refPos);
                continue;
            }
            System.out.println("- refTag is NULL for refString: " + refString);
        }
        return nextChromIdx;
    }

    private void calculateTagTagAlignment(List<Tag> tags, Multimap<Tag, AlignmentInfo> tagAlignInfoMap) {
        long totalTime = System.nanoTime();
        tags.parallelStream().forEach(tag1 -> {
            for (Tag tag2 : tags) {
                if (tag1.equals(tag2)) continue;
                String seq1 = tag1.sequence();
                String seq2 = tag2.sequence();
                StringReader reader1 = new StringReader(seq1);
                StringReader reader2 = new StringReader(seq2);
                SmithWaterman algorithm = new SmithWaterman();
                BasicScoringScheme scoring = new BasicScoringScheme(this.match_reward(), this.mismatch_penalty(), this.gap_penalty());
                algorithm.setScoringScheme(scoring);
                int score = 0;
                try {
                    algorithm.loadSequences(reader1, reader2);
                    score = algorithm.getScore();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                catch (InvalidSequenceException ise) {
                    ise.printStackTrace();
                }
                catch (IncompatibleScoringSchemeException isse) {
                    isse.printStackTrace();
                }
                AlignmentInfo tagAI = new AlignmentInfo(tag2, null, -1, -1, -1, this.refGenome(), score);
                tagAlignInfoMap.put(tag1, (Object)tagAI);
            }
        });
        System.out.println("Number of tags: " + tags.size() + ", TotalTime for calculateTagTagAlignment was " + (double)(System.nanoTime() - totalTime) / 1.0E9 + " seconds");
    }

    private void calculateTagRefTagAlignment(List<Tag> tags, List<RefTagData> refTagDataList, Multimap<Tag, AlignmentInfo> tagAlignInfoMap, String refGenome) {
        long totalTime = System.nanoTime();
        tags.parallelStream().forEach(tag1 -> {
            for (RefTagData rtd : refTagDataList) {
                Tag tag2 = rtd.tag();
                String seq1 = tag1.sequence();
                String seq2 = tag2.sequence();
                StringReader reader1 = new StringReader(seq1);
                StringReader reader2 = new StringReader(seq2);
                SmithWaterman algorithm = new SmithWaterman();
                BasicScoringScheme scoring = new BasicScoringScheme(this.match_reward(), this.mismatch_penalty(), this.gap_penalty());
                algorithm.setScoringScheme(scoring);
                int refAlignStartPos = rtd.position();
                int tagAlignOffset = 0;
                try {
                    AlignmentInfo tagAI;
                    algorithm.loadSequences(reader1, reader2);
                    PairwiseAlignment alignment = algorithm.getPairwiseAlignment();
                    int score = algorithm.getScore();
                    tagAlignOffset = alignment.getRowStart();
                    refAlignStartPos += alignment.getColStart();
                    if (tagAlignOffset > 0) {
                        refAlignStartPos -= tagAlignOffset;
                    }
                    if (refAlignStartPos >= 0) {
                        tagAI = new AlignmentInfo(tag2, rtd.chromosome(), rtd.position(), refAlignStartPos, 1, refGenome, score);
                        tagAlignInfoMap.put(tag1, (Object)tagAI);
                    }
                    reader1 = new StringReader(seq1);
                    seq2 = tag2.toReverseComplement();
                    reader2 = new StringReader(seq2);
                    algorithm.unloadSequences();
                    algorithm.loadSequences(reader1, reader2);
                    score = algorithm.getScore();
                    alignment = algorithm.getPairwiseAlignment();
                    tagAlignOffset = alignment.getRowStart();
                    refAlignStartPos += alignment.getColStart();
                    if (tagAlignOffset > 0) {
                        refAlignStartPos -= tagAlignOffset;
                    }
                    if (refAlignStartPos < 0) continue;
                    tagAI = new AlignmentInfo(tag2, rtd.chromosome(), rtd.position(), refAlignStartPos, 0, this.refGenome(), score);
                    tagAlignInfoMap.put(tag1, (Object)tagAI);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InvalidSequenceException e) {
                    e.printStackTrace();
                }
                catch (IncompatibleScoringSchemeException e) {
                    e.printStackTrace();
                }
            }
        });
        System.out.println("Num tags: " + tags.size() + ", Num refTags: " + refTagDataList.size() + ", TotalTime for calculateTagRefTagAlignment was " + (double)(System.nanoTime() - totalTime) / 1.0E9 + " seconds");
    }

    private void calculateRefRefAlignment(List<RefTagData> refTags, Multimap<Tag, Position> refTagPosMap, Multimap<RefTagData, AlignmentInfo> refTagAlignInfoMap) {
        long totalTime = System.nanoTime();
        refTags.parallelStream().forEach(tag1 -> {
            for (RefTagData tag2 : refTags) {
                if (tag1.equals(tag2)) continue;
                String seq1 = tag1.tag().sequence();
                String seq2 = tag2.tag().sequence();
                StringReader reader1 = new StringReader(seq1);
                StringReader reader2 = new StringReader(seq2);
                SmithWaterman algorithm = new SmithWaterman();
                BasicScoringScheme scoring = new BasicScoringScheme(this.match_reward(), this.mismatch_penalty(), this.gap_penalty());
                algorithm.setScoringScheme(scoring);
                int score = 0;
                try {
                    algorithm.loadSequences(reader1, reader2);
                    score = algorithm.getScore();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                catch (InvalidSequenceException ise) {
                    ise.printStackTrace();
                }
                catch (IncompatibleScoringSchemeException isse) {
                    isse.printStackTrace();
                }
                AlignmentInfo tagAI = new AlignmentInfo(tag2.tag(), tag2.chromosome(), tag2.position(), -1, 1, this.refGenome(), score);
                refTagAlignInfoMap.put(tag1, (Object)tagAI);
            }
        });
        System.out.println("Number of refTags: " + refTags.size() + ", TotalTime for calculateREfRefAlignment was " + (double)(System.nanoTime() - totalTime) / 1.0E9 + " seconds");
    }

    private int checkForN(byte[] kmer) {
        int idx;
        boolean flag = false;
        for (idx = 0; idx < kmer.length; ++idx) {
            if (kmer[idx] <= 3) continue;
            flag = true;
            break;
        }
        if (flag) {
            return idx;
        }
        return -1;
    }

    private Tuple<Integer, Integer> computePrimerSW(String primerSeq, String refSeq, int match, int mismatch, int gap, Map<String, PairwiseAlignment> pAlignment) {
        StringReader reader1 = new StringReader(primerSeq);
        StringReader reader2 = new StringReader(refSeq);
        SmithWaterman algorithm = new SmithWaterman();
        BasicScoringScheme scoring = new BasicScoringScheme(match, mismatch, gap);
        algorithm.setScoringScheme(scoring);
        int primerOffset = 0;
        int refAlignStartPos = 0;
        try {
            algorithm.loadSequences(reader1, reader2);
            PairwiseAlignment alignment = algorithm.getPairwiseAlignment();
            int score = algorithm.getScore();
            pAlignment.put(primerSeq, alignment);
            primerOffset = alignment.getRowStart();
            refAlignStartPos += alignment.getColStart();
            if (primerOffset > 0) {
                refAlignStartPos -= primerOffset;
            }
            return new Tuple<Integer, Integer>(score, refAlignStartPos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidSequenceException e) {
            e.printStackTrace();
        }
        catch (IncompatibleScoringSchemeException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void writeToFile(String chrom, Multimap<String, Integer> chromMaximaMap, int minCount) {
        String outFile = "/Users/lcj34/notes_files/repgen/junit_out/chrom" + chrom + "_peakMaximaPositions_minCount" + minCount + ".txt";
        BufferedWriter bw = Utils.getBufferedWriter(outFile);
        Collection maximaForChrom = chromMaximaMap.get((Object)chrom);
        ArrayList chromValues = new ArrayList(maximaForChrom);
        Collections.sort(chromValues);
        System.out.println("Total number of maxima/peak positions for chrom " + chrom + " is " + maximaForChrom.size() + ". Writing them to file " + outFile + " .... ");
        try {
            StringBuilder sb = new StringBuilder();
            int count = 0;
            for (int idx = 0; idx < chromValues.size(); ++idx) {
                String hits = Integer.toString((Integer)chromValues.get(idx));
                sb.append(hits);
                sb.append("\n");
                if (++count <= 100000) continue;
                bw.write(sb.toString());
                count = 0;
                sb.setLength(0);
            }
            if (count > 0) {
                bw.write(sb.toString());
            }
            bw.close();
        }
        catch (IOException ioe) {
            System.out.println("LCJ - exception writing file " + outFile);
            ioe.printStackTrace();
        }
    }

    public static void writePeakPositions(String chrom, int peak, List<Integer> peakPositions) {
        String outFile = "/Users/lcj34/notes_files/repgen/junit_out/chrom" + chrom + "_peak" + peak + "_positions.txt";
        BufferedWriter bw = Utils.getBufferedWriter(outFile);
        System.out.println("Total number of  positions for peak " + peak + " is " + peakPositions.size() + ". Writing them to file " + outFile + " .... ");
        try {
            StringBuilder sb = new StringBuilder();
            int count = 0;
            for (int idx = 0; idx < peakPositions.size(); ++idx) {
                String hits = Integer.toString(peakPositions.get(idx));
                sb.append(hits);
                sb.append("\n");
                if (++count <= 100000) continue;
                bw.write(sb.toString());
                count = 0;
                sb.setLength(0);
            }
            if (count > 0) {
                bw.write(sb.toString());
            }
            bw.close();
        }
        catch (IOException ioe) {
            System.out.println("LCJ - exception writing file " + outFile);
            ioe.printStackTrace();
        }
    }

    public static void writeChrom9Bits(List<Integer> peakPositions) {
        String outFile = "/Users/lcj34/notes_files/repgen/junit_out/chrom9bit_positions.txt";
        BufferedWriter bw = Utils.getBufferedWriter(outFile);
        System.out.println("Total number of  positions for chrom9: " + peakPositions.size());
        try {
            StringBuilder sb = new StringBuilder();
            int count = 0;
            for (int idx = 0; idx < peakPositions.size(); ++idx) {
                String hits = Integer.toString(peakPositions.get(idx));
                sb.append(hits);
                sb.append("\n");
                if (++count <= 100000) continue;
                bw.write(sb.toString());
                count = 0;
                sb.setLength(0);
            }
            if (count > 0) {
                bw.write(sb.toString());
            }
            bw.close();
        }
        catch (IOException ioe) {
            System.out.println("LCJ - exception writing file " + outFile);
            ioe.printStackTrace();
        }
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return null;
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    public static void main(String[] args) {
        GeneratePluginCode.generate(RepGenPhase2AlignerPlugin.class);
    }

    public String inputDB() {
        return this.myDBFile.value();
    }

    public RepGenPhase2AlignerPlugin inputDB(String value) {
        this.myDBFile = new PluginParameter<String>(this.myDBFile, value);
        return this;
    }

    public String refGenome() {
        return this.refGenome.value();
    }

    public RepGenPhase2AlignerPlugin refGenome(String value) {
        this.refGenome = new PluginParameter<String>(this.refGenome, value);
        return this;
    }

    public Integer minTagCount() {
        return this.minTagCount.value();
    }

    public RepGenPhase2AlignerPlugin minTagCount(Integer value) {
        this.minTagCount = new PluginParameter<Integer>(this.minTagCount, value);
        return this;
    }

    public Integer seedLen() {
        return this.seedLen.value();
    }

    public RepGenPhase2AlignerPlugin seedLen(Integer value) {
        this.seedLen = new PluginParameter<Integer>(this.seedLen, value);
        return this;
    }

    public Integer seedWindow() {
        return this.seedWindow.value();
    }

    public RepGenPhase2AlignerPlugin seedWindow(Integer value) {
        this.seedWindow = new PluginParameter<Integer>(this.seedWindow, value);
        return this;
    }

    public Integer kmerLen() {
        return this.kmerLen.value();
    }

    public RepGenPhase2AlignerPlugin kmerLen(Integer value) {
        this.kmerLen = new PluginParameter<Integer>(this.kmerLen, value);
        return this;
    }

    public Integer refKmerLen() {
        return this.refKmerLen.value();
    }

    public RepGenPhase2AlignerPlugin refKmerLen(Integer value) {
        this.refKmerLen = new PluginParameter<Integer>(this.refKmerLen, value);
        return this;
    }

    public Integer match_reward() {
        return this.match_reward.value();
    }

    public RepGenPhase2AlignerPlugin match_reward(Integer value) {
        this.match_reward = new PluginParameter<Integer>(this.match_reward, value);
        return this;
    }

    public Integer mismatch_penalty() {
        return this.mismatch_penalty.value();
    }

    public RepGenPhase2AlignerPlugin mismatch_penalty(Integer value) {
        this.mismatch_penalty = new PluginParameter<Integer>(this.mismatch_penalty, value);
        return this;
    }

    public Integer gap_penalty() {
        return this.gap_penalty.value();
    }

    public RepGenPhase2AlignerPlugin gap_penalty(Integer value) {
        this.gap_penalty = new PluginParameter<Integer>(this.gap_penalty, value);
        return this;
    }

    public String primers() {
        return this.primers.value();
    }

    public RepGenPhase2AlignerPlugin primers(String value) {
        this.primers = new PluginParameter<String>(this.primers, value);
        return this;
    }

    private /* synthetic */ void lambda$processData$0(Multimap kmerTagMap, List primerList, Multimap refTagPositionMap, Chromosome chrom) {
        int kmersForChrom = 0;
        int chromLength = myRefSequence.chromosomeSize(chrom);
        System.out.println("\nChecking reference chrom " + chrom.getName() + ", size: " + chromLength + " for tag kmer matches.");
        int refTagsCreated = 0;
        int noRefTagCreated = 0;
        int chromIdx = 0;
        while (chromIdx < chromLength) {
            int end = Math.min(chromLength, chromIdx + this.seedLen());
            byte[] chromSeedBytes = myRefSequence.chromosomeSequence(chrom, chromIdx + 1, end);
            int badValue = this.checkForN(chromSeedBytes);
            if (badValue >= 0) {
                chromIdx += badValue + 1;
                continue;
            }
            String chromKmerString = NucleotideAlignmentConstants.nucleotideBytetoString(chromSeedBytes);
            if (kmerTagMap.containsKey((Object)chromKmerString)) {
                int last;
                ++kmersForChrom;
                int refHalfLen = refAlignLen / 2;
                int first = chromIdx < refHalfLen ? 0 : chromIdx;
                byte[] refBytes = myRefSequence.chromosomeSequence(chrom, first + 1, last = Math.min(chromLength, chromIdx + refHalfLen));
                String refString = NucleotideAlignmentConstants.nucleotideBytetoString(refBytes);
                if (refString == null) {
                    System.out.println("repGenPhase2ALigner:procesData - NULL returned for refString - continue");
                    continue;
                }
                int nextChromIdx = this.createRefTagsForAlignment(chrom, refString, first + 1, primerList, (Multimap<Tag, Position>)refTagPositionMap);
                if (nextChromIdx > 0) {
                    chromIdx += nextChromIdx;
                    ++refTagsCreated;
                    continue;
                }
                ++chromIdx;
                ++noRefTagCreated;
                continue;
            }
            ++chromIdx;
        }
        System.out.println("Total tag seeds matching to kmers in chrom " + chrom.getName() + ": " + kmersForChrom + ",total refTagsCreated " + refTagsCreated + ", no ref tag created " + noRefTagCreated);
    }

    public static enum BestScore {
        none(0),
        forward(1),
        reverse(2),
        forwardRC(3),
        reverseRC(4);

        private int primer;

        private BestScore(int value) {
            this.primer = value;
        }
    }
}

