/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.maizegenetics.analysis.gbs.Barcode;

public class BarcodeTrie {
    private TrieNode root = new TrieNode();
    private Map<String, Barcode> barcodeInformation = new HashMap<String, Barcode>();

    public void addBarcode(Barcode barcode) {
        String[] barcodeWOverhang;
        for (String word : barcodeWOverhang = barcode.getBarWOverHang()) {
            this.root.addWord(word.toUpperCase());
            String bcode = word;
            this.barcodeInformation.put(bcode, barcode);
        }
    }

    public void addBarcodeNoOverhang(Barcode barcode) {
        String barcodeAlone = barcode.getBarcodeString();
        this.root.addWord(barcodeAlone.toUpperCase());
        String bcode = barcodeAlone;
        this.barcodeInformation.put(bcode, barcode);
    }

    public void addAllBarcodes(Collection<Barcode> barcodes) {
        for (Barcode b : barcodes) {
            this.addBarcode(b);
        }
    }

    public void addAllBarcodesNoOverhang(Collection<Barcode> barcodes) {
        for (Barcode b : barcodes) {
            this.addBarcodeNoOverhang(b);
        }
    }

    public boolean contains(String s) {
        TrieNode currentNode = this.root;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!currentNode.containsKey(c)) {
                return false;
            }
            currentNode = currentNode.getNode(c);
        }
        return true;
    }

    public List getWords(String prefix) {
        TrieNode lastNode = this.root;
        for (int i = 0; i < prefix.length(); ++i) {
            if ((lastNode = lastNode.getNode(prefix.charAt(i))) != null) continue;
            return new ArrayList();
        }
        return lastNode.getWords();
    }

    public Barcode longestPrefix(String input) {
        String result;
        block3: {
            result = "";
            if (input == null) {
                System.out.println("stop");
            }
            int length = input.length();
            TrieNode crawl = this.root;
            int prevMatch = 0;
            for (int level = 0; level < length - 1; ++level) {
                char ch = input.charAt(level);
                if (!(ch >= 'A' && ch <= 'T' || (ch = Character.toUpperCase(ch)) >= 'A' && ch <= 'T')) {
                    return null;
                }
                TrieNode child = crawl.getNode(ch);
                if (!crawl.containsKey(ch)) break;
                result = result + ch;
                crawl = child;
                if (!crawl.isWord) continue;
                prevMatch = level + 1;
            }
            if (crawl.isWord) break block3;
            result = result.substring(0, prevMatch);
        }
        return this.barcodeInformation.get(result);
    }

    public static void main(String[] args) {
    }

    class TrieNode {
        public TrieNode parent;
        public TrieNode[] children = new TrieNode[26];
        public boolean isLeaf = true;
        public boolean isWord = false;
        public char character;

        public TrieNode() {
        }

        public TrieNode(char character) {
            this();
            this.character = character;
        }

        protected void addWord(String word) {
            this.isLeaf = false;
            int charPos = word.charAt(0) - 65;
            if (this.children[charPos] == null) {
                this.children[charPos] = new TrieNode(word.charAt(0));
                this.children[charPos].parent = this;
            }
            if (word.length() > 1) {
                this.children[charPos].addWord(word.substring(1));
            } else {
                this.children[charPos].isWord = true;
            }
        }

        protected TrieNode getNode(char c) {
            return this.children[c - 65];
        }

        public boolean containsKey(char c) {
            ArrayList<Character> followers = new ArrayList<Character>();
            for (TrieNode x : this.children) {
                if (x == null) continue;
                char y = x.character;
                followers.add(Character.valueOf(y));
            }
            return followers.contains(Character.valueOf(c));
        }

        protected List getWords() {
            ArrayList<String> list = new ArrayList<String>();
            if (this.isWord) {
                list.add(this.toString());
            }
            if (!this.isLeaf) {
                for (int i = 0; i < this.children.length; ++i) {
                    if (this.children[i] == null) continue;
                    list.addAll(this.children[i].getWords());
                }
            }
            return list;
        }

        public String toString() {
            if (this.parent == null) {
                return "";
            }
            return this.parent.toString() + new String(new char[]{this.character});
        }
    }
}

