/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.v2;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Set;
import org.apache.log4j.Logger;
import org.ini4j.Ini;
import org.ini4j.Profile;

public class EnzymeList {
    private static final Logger myLogger = Logger.getLogger(EnzymeList.class);
    public static final EnzymeList defaultCache = new EnzymeList();
    private LinkedHashMap<String, Enzyme> map;

    public EnzymeList() {
        String parentPath = EnzymeList.getJarPath(Ini.class).getPath();
        File iniFile = new File(parentPath + "/enzymes.ini");
        if (!this.loadFromFile(iniFile)) {
            this.loadDefaults();
        }
    }

    public EnzymeList(File iniFile) {
        if (!this.loadFromFile(iniFile)) {
            this.loadDefaults();
        }
    }

    private synchronized boolean loadFromFile(File iniFile) {
        if (this.map == null) {
            this.map = new LinkedHashMap();
        }
        try {
            Ini ini = new Ini(iniFile);
            if (!iniFile.exists()) {
                return false;
            }
            ini.load();
            Set keySet = ini.keySet();
            String empty = null;
            for (String key : keySet) {
                String readLenString;
                int readEndCutSiteRemnantLength;
                String likelyReadEnd;
                String initialCutSiteRemnant;
                Profile.Section section = (Profile.Section)ini.get((Object)key);
                String name = section.get((Object)"name", empty);
                if (name == null | (initialCutSiteRemnant = section.get((Object)"initialCutSiteRemnant", empty)) == null | (likelyReadEnd = section.get((Object)"likelyReadEnd", empty)) == null | (readEndCutSiteRemnantLength = Integer.parseInt(readLenString = section.get((Object)"readEndCutSiteRemnantLength", "-1"))) < 0) {
                    myLogger.warn((Object)("WARNING! Cannot load Enzyme section" + key));
                    continue;
                }
                this.map.put(key.trim().toUpperCase(), new Enzyme(name, initialCutSiteRemnant.split(","), likelyReadEnd.split(","), readEndCutSiteRemnantLength));
            }
        }
        catch (Exception ex) {
            myLogger.warn((Object)("ERROR! Cannot load Enzyme List -- " + iniFile.getPath()));
            return false;
        }
        return true;
    }

    private void loadDefaults() {
        if (this.map == null) {
            this.map = new LinkedHashMap();
        }
        this.map.put("APEKI", new Enzyme("ApeKI", new String[]{"CAGC", "CTGC"}, new String[]{"GCAGC", "GCTGC", "GCAGAGAT", "GCTGAGAT"}, 4));
        this.map.put("PSTI", new Enzyme("PstI", new String[]{"TGCAG"}, new String[]{"CTGCAG", "CTGCAAGAT"}, 5));
        this.map.put("ECOT22I", new Enzyme("EcoT22I", new String[]{"TGCAT"}, new String[]{"ATGCAT", "ATGCAAGAT"}, 5));
        this.map.put("PASI", new Enzyme("PasI", new String[]{"CAGGG", "CTGGG"}, new String[]{"CCCAGGG", "CCCTGGG", "CCCTGAGAT", "CCCAGAGAT"}, 5));
        this.map.put("HPAII", new Enzyme("HpaII", new String[]{"CGG"}, new String[]{"CCGG", "CCGAGATCGG"}, 3));
        this.map.put("MSPI", new Enzyme("MspI", new String[]{"CGG"}, new String[]{"CCGG", "CCGAGATCGG"}, 3));
        this.map.put("PSTI-APEKI", new Enzyme("PstI-ApeKI", new String[]{"TGCAG"}, new String[]{"GCAGC", "GCTGC", "CTGCAG", "GCAGAGAT", "GCTGAGAT"}, 4));
        this.map.put("PSTI-BFAI", new Enzyme("PstI-BfaI", new String[]{"TGCAG"}, new String[]{"CTGCAG", "CTAG", "CTAAGATC"}, 3));
        this.map.put("PSTI-ECOT22I", new Enzyme("PstI-EcoT22I", new String[]{"TGCAG", "TGCAT"}, new String[]{"ATGCAT", "CTGCAG", "CTGCAAGAT", "ATGCAAGAT"}, 5));
        this.map.put("PSTI-MSPI", new Enzyme("PstI-MspI", new String[]{"TGCAG"}, new String[]{"CCGG", "CTGCAG", "CCGAGATC"}, 3));
        this.map.put("PSTI-MSPI-GDF-CUSTOM", new Enzyme("PstI-MspI-GDFcustom", new String[]{"TGCAG"}, new String[]{"CCGG", "CTGCAG", "CCGCTCAGG"}, 3));
        this.map.put("PSTI-TAQI", new Enzyme("PstI-TaqI", new String[]{"TGCAG"}, new String[]{"TCGA", "CTGCAG", "TCGAGATC"}, 3));
        this.map.put("NSII-MSPI", new Enzyme("NsiI-MspI", new String[]{"TGCAT"}, new String[]{"CCGG", "ATGCAT", "CCGAGATC"}, 3));
        this.map.put("PAER7I-HHAI", new Enzyme("PaeR7I-HhaI", new String[]{"TCGAG"}, new String[]{"GCGC", "CTCGAG", "GCGAGATC"}, 3));
        this.map.put("SBFI-MSPI", new Enzyme("SbfI-MspI", new String[]{"TGCAGG"}, new String[]{"CCGG", "CCTGCAGG", "CCGAGATC"}, 3));
        this.map.put("SBFI-HPAII", new Enzyme("SbfI-HpaII", new String[]{"TGCAGG"}, new String[]{"CCGG", "CCTGCAGG", "CCGAGATC"}, 3));
        this.map.put("SBFI-BFAI", new Enzyme("SbfI-BfaI", new String[]{"TGCAGG"}, new String[]{"CTAG", "CCTGCAGG", "CTAAGATC"}, 3));
        this.map.put("SPHI-ECORI", new Enzyme("SphI-EcoRI", new String[]{"CATGC"}, new String[]{"GCATGC", "GAATTC", "GAATTAGATC"}, 5));
        this.map.put("ASISI-MSPI", new Enzyme("AsiSI-MspI", new String[]{"ATCGC"}, new String[]{"CCGG", "GCGATCGC", "CCGAGATC"}, 3));
        this.map.put("BSSHII-MSPI", new Enzyme("BssHII-MspI", new String[]{"CGCGC"}, new String[]{"CCGG", "GCGCGC", "CCGAGATC"}, 3));
        this.map.put("FSEI-MSPI", new Enzyme("FseI-MspI", new String[]{"CCGGCC"}, new String[]{"CCGG", "GGCCGGCC", "CCGAGATC"}, 3));
        this.map.put("SALI-MSPI", new Enzyme("SalI-MspI", new String[]{"TCGAC"}, new String[]{"CCGG", "GTCGAC", "CCGAGATC"}, 3));
        this.map.put("ECORI-MSPI", new Enzyme("EcoRI-MspI", new String[]{"AATTC"}, new String[]{"CCGG", "GAATTC", "CCGAGATC"}, 3));
        this.map.put("HINDIII-MSPI", new Enzyme("HindIII-MspI", new String[]{"AGCTT"}, new String[]{"CCGG", "AAGCTT", "CCGAGATC"}, 3));
        this.map.put("HINDIII-NLAIII", new Enzyme("HindIII-NlaIII", new String[]{"AGCTT"}, new String[]{"CATG", "AAGCTT", "CATGAGATC"}, 4));
        this.map.put("SEXAI-SAU3AI", new Enzyme("SexAI-Sau3AI", new String[]{"CCAGGT", "CCTGGT"}, new String[]{"GATC", "ACCAGGT", "ACCTGGT", "GATCAGATC"}, 4));
        this.map.put("BAMHI-MLUCI", new Enzyme("BamHI-MluCI", new String[]{"GATCC"}, new String[]{"AATT", "GGATCC", "AATTAGATC"}, 4));
        this.map.put("PSTI-MLUCI", new Enzyme("PstI-MluCI", new String[]{"TGCAG"}, new String[]{"AATT", "CTGCAG", "AATTAGATC"}, 4));
        this.map.put("PSTI-MSEI", new Enzyme("PstI-MseI", new String[]{"TGCAG"}, new String[]{"TTAA", "CTGCAG", "TTAAGATC"}, 3));
        this.map.put("AVAII-MSEI", new Enzyme("AvaII-MseI", new String[]{"GACC", "GTCC"}, new String[]{"TTAA", "GGACC", "GGTCC", "TTAAGATC"}, 3));
        this.map.put("ECORI-MSEI", new Enzyme("EcoRI-MseI", new String[]{"AATTC"}, new String[]{"TTAA", "GAATTC", "TTAAGATC"}, 3));
        this.map.put("ECORI-AVAII", new Enzyme("EcoRI-AvaII", new String[]{"AATTC"}, new String[]{"GGACC", "GGTCC", "GAATTC", "GGACAGATC", "GGTCAGATC"}, 4));
        this.map.put("ECORI-HINFI", new Enzyme("EcoRI-HinfI", new String[]{"AATTC"}, new String[]{"GAATC", "GACTC", "GAGTC", "GATTC", "GAATTC", "GAATAGATC", "GACTAGATC", "GAGTAGATC", "GATTAGATC"}, 4));
        this.map.put("BBVCI-MSPI", new Enzyme("BbvCI-MspI", new String[]{"TCAGC"}, new String[]{"CCGG", "CCTCAGC", "CCGAGATC"}, 3));
        this.map.put("MSPI-APEKI", new Enzyme("MspI-ApeKI", new String[]{"CGG", "CAGC", "CTGC"}, new String[]{"CCGG", "GCAGC", "GCTGC", "CCGAGATCGG", "GCAGAGAT", "GCTGAGAT"}, 3));
        this.map.put("APOI", new Enzyme("ApoI", new String[]{"AATTC", "AATTT"}, new String[]{"AAATTC", "AAATTT", "GAATTC", "GAATTT", "AAATTAGAT", "GAATTAGAT"}, 5));
        this.map.put("BAMHI", new Enzyme("BamHI", new String[]{"GATCC"}, new String[]{"GGATCC", "GGATCAGAT"}, 5));
        this.map.put("MSEI", new Enzyme("MseI", new String[]{"TAA"}, new String[]{"TTAA", "TTAAGAT"}, 3));
        this.map.put("SAU3AI", new Enzyme("Sau3AI", new String[]{"GATC"}, new String[]{"GATC", "GATCAGAT"}, 4));
        this.map.put("NDEI", new Enzyme("NdeI", new String[]{"TATG"}, new String[]{"CATATG", "CATAAGAT"}, 4));
        this.map.put("HINP1I", new Enzyme("HinP1I", new String[]{"CGC"}, new String[]{"GCGC", "GCGAGAT"}, 3));
        this.map.put("SBFI", new Enzyme("SbfI", new String[]{"TGCAGG"}, new String[]{"CCTGCAGG", "CCTGCAAGAT"}, 6));
        this.map.put("HINDIII", new Enzyme("HindIII", new String[]{"AGCTT"}, new String[]{"AAGCTT", "AAGCTAGAT"}, 5));
        this.map.put("ECORI", new Enzyme("EcoRI", new String[]{"AATTC"}, new String[]{"GAATTC", "GAATTAGAT"}, 5));
        this.map.put("CVI1I", new Enzyme("CviQI", new String[]{"TAC"}, new String[]{"GTAC", "GTAAGATCGG"}, 3));
        this.map.put("CSP6I", new Enzyme("Csp6I", new String[]{"TAC"}, new String[]{"GTAC", "GTAAGATCGG"}, 3));
        this.map.put("NLAIII", new Enzyme("NlaIII", new String[]{"CATG"}, new String[]{"CATG", "CATGAGAT"}, 4));
        this.map.put("SPHI", new Enzyme("SphI", new String[]{"CATGC"}, new String[]{"GCATGC", "GCATGAGAT"}, 5));
        this.map.put("NSPI", new Enzyme("NspI", new String[]{"CATGC", "CATGT"}, new String[]{"ACATGT", "GCATGC", "ACATGAGAT", "GCATGAGAT"}, 5));
        this.map.put("KPNI", new Enzyme("KpnI", new String[]{"GTACC"}, new String[]{"GGTACC", "GGTACAGAT"}, 5));
        this.map.put("STYI", new Enzyme("StyI", new String[]{"CAAGG", "CATGG", "CTAGG", "CTTGG"}, new String[]{"CCAAGG", "CCATGG", "CCTAGG", "CCTTGG", "CCAAGAGAT", "CCATGAGAT", "CCTAGAGAT", "CCTTGAGAT"}, 5));
        this.map.put("STYI-MSEI", new Enzyme("StyI-MseI", new String[]{"CAAGG", "CATGG", "CTAGG", "CTTGG"}, new String[]{"TTAA", "CCAAGG", "CCATGG", "CCTAGG", "CCTTGG", "TTAAGAT"}, 3));
        this.map.put("FSEI", new Enzyme("FseI", new String[]{"CCGGCC"}, new String[]{"GGCCGGCC", "AGATCGGAAG"}, 0));
        this.map.put("NgoMIV", new Enzyme("NgoMIV", new String[]{"CCGGC"}, new String[]{"GCCGGC", "AGATCGGAAG"}, 0));
        this.map.put("MSLI", new Enzyme("MslI", new String[]{""}, new String[]{"AGATCGGA"}, 0));
        this.map.put("ASEI", new Enzyme("AseI", new String[]{"TAAT"}, new String[]{"ATTAAT", "ATTAAGAT"}, 4));
        this.map.put("AVAII", new Enzyme("AvaII", new String[]{"GACC", "GTCC"}, new String[]{"GGACC", "GGTCC", "GGACAGAT", "GGTCAGAT"}, 4));
        this.map.put("KPNI-MSPI", new Enzyme("KpnI-MspI", new String[]{"GTACC"}, new String[]{"CCGG", "GGTACC", "CCGAGATC"}, 3));
        this.map.put("RBSTA", new Enzyme("RBSTA", new String[]{"TA"}, new String[]{"TTAA", "GTAC", "CTAG", "TTAAGAT", "GTAAGAT", "CTAAGAT"}, 3));
        this.map.put("RBSCG", new Enzyme("RBSCG", new String[]{"CG"}, new String[]{"CCGC", "TCGA", "GCGC", "CCGG", "ACGT", "CCGAGAT", "TCGAGAT", "GCGAGAT", "ACGAGAT"}, 3));
        this.map.put("IGNORE", new Enzyme("unspecified", new String[]{""}, new String[]{"AGATCGGA"}, 0));
    }

    static File getJarPath(Class clazz) {
        try {
            File nf;
            URL location = clazz.getProtectionDomain().getCodeSource().getLocation();
            File f = new File(location.toURI().getPath());
            if (!f.exists() && (nf = new File(location.getPath())).exists()) {
                f = nf;
            }
            if (f.getName().toLowerCase().endsWith(".jar")) {
                return f.getParentFile();
            }
            return f;
        }
        catch (URISyntaxException ex) {
            return new File(clazz.getProtectionDomain().getCodeSource().getLocation().getPath());
        }
    }

    public synchronized Enzyme getEnzyme(String key) {
        if (this.map == null) {
            this.loadDefaults();
        }
        return this.map.get(key.trim().toUpperCase());
    }

    static void add(Ini ini, Enzyme enzyme, String key) {
        int i;
        key = key == null ? enzyme.name.trim().toUpperCase() : key.trim().toUpperCase();
        Profile.Section section = ini.containsKey((Object)key) ? (Profile.Section)ini.get((Object)key) : ini.add(key);
        section.put((Object)"name", (Object)enzyme.name);
        StringBuilder builder = new StringBuilder(enzyme.initialCutSiteRemnant[0]);
        for (i = 1; i < enzyme.initialCutSiteRemnant.length; ++i) {
            builder.append(",");
            builder.append(enzyme.initialCutSiteRemnant[i]);
        }
        section.put((Object)"initialCutSiteRemnant", (Object)builder.toString());
        builder = new StringBuilder(enzyme.likelyReadEnd[0]);
        for (i = 1; i < enzyme.likelyReadEnd.length; ++i) {
            builder.append(",");
            builder.append(enzyme.likelyReadEnd[i]);
        }
        section.put((Object)"likelyReadEnd", (Object)builder.toString());
        section.put("readEndCutSiteRemnantLength", (Object)enzyme.readEndCutSiteRemnantLength);
    }

    public void printEnzymes(PrintStream print) throws IOException {
        Ini ini = new Ini();
        ini.getConfig().setLineSeparator("\n");
        if (this.map == null) {
            this.loadDefaults();
        }
        for (String key : this.map.keySet()) {
            Enzyme enzyme = this.map.get(key);
            EnzymeList.add(ini, enzyme, key);
        }
        ini.store((OutputStream)print);
    }

    public static void main(String[] args) throws IOException {
        defaultCache.printEnzymes(System.out);
    }

    public static class Enzyme {
        public final String name;
        public final String[] initialCutSiteRemnant;
        public final String[] likelyReadEnd;
        public final int readEndCutSiteRemnantLength;

        private Enzyme(String name, String[] initialCutSiteRemnant, String[] likelyReadEnd, int readEndCutSiteRemnantLength) {
            this.name = name;
            this.initialCutSiteRemnant = initialCutSiteRemnant;
            this.likelyReadEnd = likelyReadEnd;
            this.readEndCutSiteRemnantLength = readEndCutSiteRemnantLength;
        }

        public String enzyme() {
            return this.name;
        }

        public String[] initialCutSiteRemnant() {
            return this.initialCutSiteRemnant;
        }

        public String[] likelyReadEnd() {
            return this.likelyReadEnd;
        }

        public int readEndCutSiteRemnantLength() {
            return this.readEndCutSiteRemnantLength;
        }
    }
}

