/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.v2;

import java.awt.Frame;
import java.io.BufferedReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.IntStream;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.Barcode;
import net.maizegenetics.analysis.gbs.v2.BarcodeTrie;
import net.maizegenetics.analysis.gbs.v2.EnzymeList;
import net.maizegenetics.analysis.gbs.v2.GBSUtils;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.tag.Tag;
import net.maizegenetics.dna.tag.TagBuilder;
import net.maizegenetics.dna.tag.TagDataSQLite;
import net.maizegenetics.dna.tag.TaxaDistBuilder;
import net.maizegenetics.dna.tag.TaxaDistribution;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListIOUtils;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.DirectoryCrawler;
import net.maizegenetics.util.Utils;
import org.ahocorasick.trie.Trie;
import org.apache.log4j.Logger;

public class GBSSeqToTagDBPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(GBSSeqToTagDBPlugin.class);
    private PluginParameter<String> myInputDir = new PluginParameter.Builder<String>("i", null, String.class).guiName("Input Directory").required(true).inDir().description("Input directory containing FASTQ files in text or gzipped text.\n     NOTE: Directory will be searched recursively and should\n     be written WITHOUT a slash after its name.").build();
    private PluginParameter<String> myKeyFile = new PluginParameter.Builder<String>("k", null, String.class).guiName("Key File").required(true).inFile().description("Key file listing barcodes distinguishing the samples").build();
    private PluginParameter<String> myEnzyme = new PluginParameter.Builder<String>("e", null, String.class).guiName("Enzyme").required(true).description("Enzyme used to create the GBS library, if it differs from the one listed in the key file").build();
    private PluginParameter<Integer> myKmerLength = new PluginParameter.Builder<Integer>("kmerLength", 64, Integer.class).guiName("Maximum Kmer Length").description("Specified length for each kmer to process").build();
    private PluginParameter<Integer> myMinKmerLength = new PluginParameter.Builder<Integer>("minKmerL", 20, Integer.class).guiName("Minimum Kmer Length").description("Minimum kmer Length after second cut site is removed").build();
    private PluginParameter<Integer> myMinKmerCount = new PluginParameter.Builder<Integer>("c", 10, Integer.class).guiName("Min Kmer Count").description("Minimum kmer count").build();
    private PluginParameter<String> myOutputDB = new PluginParameter.Builder<String>("db", null, String.class).guiName("Output Database File").required(true).outFile().description("Output Database File").build();
    private PluginParameter<Integer> myMinQualScore = new PluginParameter.Builder<Integer>("mnQS", 0, Integer.class).guiName("Minimum quality score").required(false).description("Minimum quality score within the barcode and read length to be accepted").build();
    private PluginParameter<Integer> myMaxKmerNumber = new PluginParameter.Builder<Integer>("mxKmerNum", 50000000, Integer.class).guiName("Maximum Kmer Number").required(false).description("Maximum number of kmers").build();
    private PluginParameter<Integer> myBatchSize = new PluginParameter.Builder<Integer>("batchSize", 8, Integer.class).guiName("Batch size of fastq files").required(false).description("Number of flow cells being processed simultaneously").build();
    private PluginParameter<Boolean> myDeleteOldData = new PluginParameter.Builder<Boolean>("deleteOldData", true, Boolean.class).guiName("Delete Old Data").description("Delete existing SNP quality data from db tables").build();
    LongAdder roughTagCnt = new LongAdder();
    private TagDistributionMap tagCntMap;
    private boolean taglenException;
    protected static int readEndCutSiteRemnantLength;
    private Trie ahoCorasickTrie;
    String[] likelyReadEndStrings;

    public GBSSeqToTagDBPlugin() {
        super(null, false);
    }

    public GBSSeqToTagDBPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    private List<Path> sortFastqBySize(List<Path> fs) {
        ArrayList sizeList = new ArrayList();
        HashMap sizePathMap = new HashMap();
        fs.parallelStream().forEach(f -> {
            try {
                long s = Files.size(f);
                sizeList.add(s);
                sizePathMap.putIfAbsent(s, f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        Collections.sort(sizeList, Collections.reverseOrder());
        ArrayList<Path> np = new ArrayList<Path>();
        try {
            for (int i = 0; i < sizeList.size(); ++i) {
                np.add((Path)sizePathMap.get(sizeList.get(i)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return np;
    }

    private long[] calcTagMapStats(TagDistributionMap tagCntMap) {
        long totalDepth = 0L;
        long memory = 0L;
        int cnt = 0;
        for (Map.Entry entry : tagCntMap.entrySet()) {
            memory += (long)((TaxaDistribution)entry.getValue()).memorySize();
            memory += 25L;
            totalDepth += (long)((TaxaDistribution)entry.getValue()).totalDepth();
            ++cnt;
        }
        int currentSize = tagCntMap.size();
        long[] stats = new long[]{currentSize, memory += (long)(tagCntMap.size() * 2 * 16), totalDepth, totalDepth / (long)cnt};
        System.out.printf("Map Tags:%,d  Memory:%,d  TotalDepth:%,d  AvgDepthPerTag:%d%n", stats[0], stats[1], stats[2], stats[3]);
        return stats;
    }

    @Override
    public void postProcessParameters() {
        if (!this.myEnzyme.isEmpty()) {
            EnzymeList.Enzyme enzyme = EnzymeList.defaultCache.getEnzyme(this.enzyme());
            this.likelyReadEndStrings = enzyme.likelyReadEnd;
            readEndCutSiteRemnantLength = enzyme.readEndCutSiteRemnantLength;
        }
    }

    @Override
    public DataSet processData(DataSet input) {
        int batchSize = this.myBatchSize.value();
        float loadFactor = 0.95f;
        this.tagCntMap = new TagDistributionMap(this.myMaxKmerNumber.value(), loadFactor, 128, this.minKmerCount());
        try {
            Path keyPath = Paths.get(this.keyFile(), new String[0]).toAbsolutePath();
            List<Path> directoryFiles = DirectoryCrawler.listPaths("glob:*{.fq,fq.gz,fastq,fastq.txt,fastq.gz,fastq.txt.gz,_sequence.txt,_sequence.txt.gz}", Paths.get(this.myInputDir.value(), new String[0]).toAbsolutePath());
            if (directoryFiles.isEmpty()) {
                myLogger.warn((Object)"No files matching:glob:*{.fq,fq.gz,fastq,fastq.txt,fastq.gz,fastq.txt.gz,_sequence.txt,_sequence.txt.gz}");
                return null;
            }
            List<Path> inputSeqFiles = GBSUtils.culledFiles(directoryFiles, keyPath);
            if (inputSeqFiles.size() == 0) {
                System.out.println("GBSSeqToTagDBPlugin:processData - found NO files represented in key file.");
                System.out.println("Please verify your file names are formatted correctly and that your key file contains the required headers.");
                return null;
            }
            System.out.println("Found " + inputSeqFiles.size() + " files to process");
            int batchNum = inputSeqFiles.size() / batchSize;
            if (inputSeqFiles.size() % batchSize != 0) {
                ++batchNum;
            }
            TaxaList masterTaxaList = TaxaListIOUtils.readTaxaAnnotationFile(this.keyFile(), "FullSampleName", new HashMap<String, String>(), true);
            TagDataSQLite tdw = null;
            if (Files.exists(Paths.get(this.myOutputDB.value(), new String[0]), new LinkOption[0])) {
                if (this.deleteOldData().booleanValue()) {
                    try {
                        Files.delete(Paths.get(this.myOutputDB.value(), new String[0]));
                    }
                    catch (Exception exc) {
                        System.out.println("Error when trying to delete database file: " + this.myOutputDB.value());
                        System.out.println("File delete error: " + exc.getMessage());
                        return null;
                    }
                } else {
                    tdw = new TagDataSQLite(this.myOutputDB.value());
                    TaxaList oldTaxaList = tdw.getTaxaList();
                    boolean sameMasterTaxaList = true;
                    Taxon badTaxon = null;
                    for (Taxon taxa : masterTaxaList) {
                        if (oldTaxaList.contains(taxa)) continue;
                        sameMasterTaxaList = false;
                        badTaxon = taxa;
                        break;
                    }
                    if (!sameMasterTaxaList) {
                        myLogger.error((Object)("Taxa list in keyfile contains taxa not in db:  " + badTaxon + ".\nEither delete existing DB, use a new DB output file, or use keyfile with entries matching existing taxa list.\n"));
                        tdw.close();
                        return null;
                    }
                    Map<Tag, TaxaDistribution> existingTDM = tdw.getAllTagsTaxaMap();
                    this.tagCntMap.putAll(existingTDM);
                    tdw.clearTagTaxaDistributionData();
                }
            }
            if (tdw == null) {
                tdw = new TagDataSQLite(this.myOutputDB.value());
            }
            this.taglenException = false;
            for (int i = 0; i < inputSeqFiles.size(); i += batchSize) {
                int end = i + batchSize;
                if (end > inputSeqFiles.size()) {
                    end = inputSeqFiles.size();
                }
                ArrayList<Path> sub = new ArrayList<Path>();
                for (int j = i; j < end; ++j) {
                    sub.add(inputSeqFiles.get(j));
                }
                System.out.println("\nStart processing batch " + String.valueOf(i / batchSize + 1));
                sub.parallelStream().forEach(inputSeqFile -> {
                    try {
                        this.processFastQFile(masterTaxaList, keyPath, (Path)inputSeqFile, this.enzyme(), this.minimumQualityScore(), this.tagCntMap, this.kmerLength());
                    }
                    catch (StringIndexOutOfBoundsException oobe) {
                        oobe.printStackTrace();
                        myLogger.error((Object)oobe.getMessage());
                        this.setTagLenException();
                        return;
                    }
                });
                if (this.taglenException) {
                    return null;
                }
                System.out.println("\nKmers are added from batch " + String.valueOf(i / batchSize + 1) + ". Total batch number: " + batchNum);
                int currentSize = this.tagCntMap.size();
                System.out.println("Current number: " + String.valueOf(currentSize) + ". Max kmer number: " + String.valueOf(this.myMaxKmerNumber.value()));
                System.out.println(String.valueOf((float)currentSize / (float)this.myMaxKmerNumber.value().intValue()) + " of max tag number");
                if (currentSize > 0) {
                    this.calcTagMapStats(this.tagCntMap);
                    System.out.println();
                    GBSSeqToTagDBPlugin.removeTagsWithoutReplication(this.tagCntMap);
                    if (this.tagCntMap.size() == 0) {
                        System.out.println("WARNING:  After removing tags without replication, there are NO  tags left in the database");
                    } else {
                        this.calcTagMapStats(this.tagCntMap);
                        System.out.println();
                        System.out.println("Kmer number is reduced to " + this.tagCntMap.size() + "\n");
                    }
                    this.roughTagCnt.reset();
                    this.roughTagCnt.add(this.tagCntMap.size());
                } else {
                    System.out.println("WARNING: Current tagcntmap size is 0 after processing batch " + String.valueOf(i / batchSize + 1));
                    System.out.println("  This could happen if your total number of good barcoded reads is 0, or if there are no kmers that contain the min specified count");
                    System.out.println("  If your good barcoded reads are 0, your reads may contain something other than ACGT or your minimum tag length may not be met.");
                    System.out.println("  Adjust your minimum kmer count paramter,  adjust your minimum tag length, and/or inspect your fastQ files.");
                }
                System.out.println("Total memory: " + String.valueOf((double)(Runtime.getRuntime().totalMemory() / 1024L / 1024L / 1024L)) + " Gb");
                System.out.println("Free memory: " + String.valueOf((double)(Runtime.getRuntime().freeMemory() / 1024L / 1024L / 1024L)) + " Gb");
                System.out.println("Max memory: " + String.valueOf((double)(Runtime.getRuntime().maxMemory() / 1024L / 1024L / 1024L)) + " Gb");
                System.out.println("\n");
            }
            System.out.println("\nAll the batch are processed");
            this.tagCntMap.removeTagByCount(this.myMinKmerCount.value());
            System.out.println("By removing kmers with minCount of " + this.myMinKmerCount.value() + "Kmer number is reduced to " + this.tagCntMap.size() + "\n");
            tdw.putTaxaList(masterTaxaList);
            tdw.putAllTag(this.tagCntMap.keySet());
            tdw.putTaxaDistribution(this.tagCntMap);
            tdw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new DataSet(new Datum("TagMap", this.tagCntMap, ""), (Plugin)this);
    }

    private void processFastQFile(TaxaList masterTaxaList, Path keyPath, Path fastQPath, String enzymeName, int minQuality, TagDistributionMap masterTagTaxaMap, int preferredTagLength) throws StringIndexOutOfBoundsException {
        ArrayList<Taxon> tl = GBSUtils.getLaneAnnotatedTaxaList(keyPath, fastQPath);
        if (tl.size() == 0) {
            return;
        }
        BarcodeTrie barcodeTrie = GBSUtils.initializeBarcodeTrie(tl, masterTaxaList, EnzymeList.defaultCache.getEnzyme(enzymeName));
        this.processFastQ(fastQPath, barcodeTrie, masterTaxaList, masterTagTaxaMap, preferredTagLength, minQuality);
    }

    private void processFastQ(Path fastqFile, BarcodeTrie barcodeTrie, TaxaList masterTaxaList, TagDistributionMap masterTagTaxaMap, int preferredTagLength, int minQual) throws StringIndexOutOfBoundsException {
        int allReads = 0;
        int goodBarcodedReads = 0;
        int lowQualityReads = 0;
        int maxTaxaNumber = masterTaxaList.size();
        int checkSize = 10000000;
        myLogger.info((Object)("processing file " + fastqFile.toString()));
        try {
            String[] seqAndQual;
            int qualityScoreBase = GBSUtils.determineQualityScoreBase(fastqFile);
            BufferedReader br = Utils.getBufferedReader(fastqFile.toString(), 0x400000);
            long time = System.nanoTime();
            while ((seqAndQual = GBSUtils.readFastQBlock(br, allReads)) != null) {
                ++allReads;
                Barcode barcode = barcodeTrie.longestPrefix(seqAndQual[0]);
                if (barcode == null) continue;
                if (minQual > 0 && BaseEncoder.getFirstLowQualityPos(seqAndQual[1], minQual, qualityScoreBase) < barcode.getBarLength() + preferredTagLength) {
                    ++lowQualityReads;
                    continue;
                }
                int barcodeLen = barcode.getBarLength();
                if (seqAndQual[0].length() - barcodeLen < preferredTagLength) {
                    String errMsg = "\n\nERROR processing " + fastqFile.toString() + "\nReading entry number " + allReads + " fails the length test.\nSequence length " + seqAndQual[0].length() + " minus barcode length " + barcodeLen + " is less than kmerLength " + preferredTagLength + ".\nRe-run your files with either a shorter kmerLength value or a higher minimum quality score.\n";
                    throw new StringIndexOutOfBoundsException(errMsg);
                }
                Tag tag = this.removeSecondCutSiteIndexOf(seqAndQual[0].substring(barcodeLen), preferredTagLength);
                if (tag == null) continue;
                ++goodBarcodedReads;
                TaxaDistribution taxaDistribution = (TaxaDistribution)masterTagTaxaMap.get(tag);
                if (taxaDistribution == null) {
                    masterTagTaxaMap.put(tag, TaxaDistBuilder.create(maxTaxaNumber, barcode.getTaxaIndex()));
                    this.roughTagCnt.increment();
                } else {
                    taxaDistribution.increment(barcode.getTaxaIndex());
                }
                if (allReads % checkSize != 0) continue;
                myLogger.info((Object)("Total Reads:" + allReads + " Reads with barcode and cut site overhang:" + goodBarcodedReads + " rate:" + (System.nanoTime() - time) / (long)allReads + " ns/read. Current tag count:" + this.roughTagCnt));
            }
            myLogger.info((Object)("Summary for " + fastqFile.toString() + "\nTotal number of reads in lane=" + allReads + "\nTotal number of good barcoded reads=" + goodBarcodedReads + "\nTotal number of low quality reads=" + lowQualityReads + "\nTiming process (sorting, collapsing, and writing TagCount to file).\nProcess took " + (double)(System.nanoTime() - time) / 1000000.0 + " milliseconds."));
            System.out.println("tagCntMap size: " + masterTagTaxaMap.size());
            br.close();
        }
        catch (StringIndexOutOfBoundsException oobe) {
            throw oobe;
        }
        catch (Exception e) {
            myLogger.error((Object)("Good Barcodes Read: " + goodBarcodedReads));
            e.printStackTrace();
        }
    }

    private Tag removeSecondCutSiteIndexOf(String seq, int preferredLength) {
        Tag tag = null;
        if (this.enzyme().equalsIgnoreCase("ApeKI") && (seq.startsWith("CAGCTGC") || seq.startsWith("CTGCAGC"))) {
            seq = seq.substring(3, seq.length());
        }
        int indexOfReadEnd = -1;
        String shortSeq = seq.substring(20);
        for (String readEnd : this.likelyReadEndStrings) {
            int indx = shortSeq.indexOf(readEnd);
            if (indx <= 0 || indexOfReadEnd >= 0 && indx >= indexOfReadEnd) continue;
            indexOfReadEnd = indx;
        }
        int tagLen = indexOfReadEnd + 20 + readEndCutSiteRemnantLength;
        if (indexOfReadEnd > 0 && tagLen < preferredLength) {
            if (tagLen < this.minimumKmerLength()) {
                return null;
            }
        } else {
            byte seqEnd = (byte)Math.min(seq.length(), preferredLength);
            return TagBuilder.instance(seq.substring(0, seqEnd)).build();
        }
        tag = TagBuilder.instance(seq.substring(0, tagLen)).build();
        return tag;
    }

    private void removeSecondCutSitesFromMap(EnzymeList.Enzyme enzyme) {
        System.out.println("GBSSeqToTagDBPlugin.removeSecondCutSitesFromMap started Initial Size:" + this.tagCntMap.size());
        String[] likelyReadEnd = enzyme.likelyReadEnd;
        long time = System.nanoTime();
        HashMap<Tag, TaxaDistribution> shortTags = new HashMap<Tag, TaxaDistribution>(this.tagCntMap.size() / 5);
        int belowMinSize = 0;
        int shortExisting = 0;
        for (Tag origTag : this.tagCntMap.keySet()) {
            int minCutSite = Integer.MAX_VALUE;
            String origTagSequence = origTag.sequence();
            for (String potentialCutSite : likelyReadEnd) {
                int p = origTagSequence.indexOf(potentialCutSite, 1);
                if (p <= 0) continue;
                minCutSite = Math.min(minCutSite, p);
            }
            if (minCutSite == Integer.MAX_VALUE || minCutSite <= 1) continue;
            if (minCutSite < this.minimumKmerLength()) {
                this.tagCntMap.remove(origTag);
                ++belowMinSize;
                continue;
            }
            TaxaDistribution currentTaxaDist = (TaxaDistribution)this.tagCntMap.remove(origTag);
            Tag t = TagBuilder.instance(origTagSequence.substring(0, minCutSite + enzyme.readEndCutSiteRemnantLength())).build();
            TaxaDistribution existingTD = (TaxaDistribution)shortTags.get(t);
            if (existingTD != null) {
                if (currentTaxaDist == null || existingTD == null) {
                    System.out.println("We have a problem");
                }
                currentTaxaDist = TaxaDistBuilder.combine(currentTaxaDist, existingTD);
                ++shortExisting;
            }
            shortTags.put(t, currentTaxaDist);
        }
        System.out.println("After removal tagCntMap.size() = " + this.tagCntMap.size());
        System.out.println("After removal shortTags.size() = " + shortTags.size());
        System.out.println("belowMinSize = " + belowMinSize);
        System.out.println("shortExisting = " + shortExisting);
        System.out.println("removeSecondCutSite: Process took " + (double)(System.nanoTime() - time) / 1000000.0 + " milliseconds.");
        this.tagCntMap.putAll(shortTags);
        System.out.println("After combining again tagCntMap.size() = " + this.tagCntMap.size());
    }

    private static void removeTagsWithoutReplication(TagDistributionMap masterTagTaxaMap) {
        int currentSize = masterTagTaxaMap.size();
        int minTaxa = 2;
        System.out.println("Starting removeTagsWithoutReplication. Current tag number: " + currentSize);
        LongAdder tagsRemoved = new LongAdder();
        masterTagTaxaMap.entrySet().parallelStream().forEach(t -> {
            TaxaDistribution td = (TaxaDistribution)t.getValue();
            if (td.totalDepth() < 2 * minTaxa) {
                masterTagTaxaMap.remove(t.getKey());
                tagsRemoved.increment();
            } else if (IntStream.of(td.depths()).filter(depth -> depth > 1).count() < (long)minTaxa) {
                masterTagTaxaMap.remove(t.getKey());
                tagsRemoved.increment();
            }
        });
        System.out.println("Finished removeTagsWithoutReplication.  tagsRemoved = " + tagsRemoved + ". Current tag number: " + String.valueOf(currentSize - tagsRemoved.intValue()));
    }

    public void setTagLenException() {
        this.taglenException = true;
    }

    public String inputDirectory() {
        return this.myInputDir.value();
    }

    public GBSSeqToTagDBPlugin inputDirectory(String value) {
        this.myInputDir = new PluginParameter<String>(this.myInputDir, value);
        return this;
    }

    public String keyFile() {
        return this.myKeyFile.value();
    }

    public GBSSeqToTagDBPlugin keyFile(String value) {
        this.myKeyFile = new PluginParameter<String>(this.myKeyFile, value);
        return this;
    }

    public String enzyme() {
        return this.myEnzyme.value();
    }

    public GBSSeqToTagDBPlugin enzyme(String value) {
        this.myEnzyme = new PluginParameter<String>(this.myEnzyme, value);
        return this;
    }

    public Integer kmerLength() {
        return this.myKmerLength.value();
    }

    public GBSSeqToTagDBPlugin kmerLength(Integer value) {
        this.myKmerLength = new PluginParameter<Integer>(this.myKmerLength, value);
        return this;
    }

    public Integer minimumKmerLength() {
        return this.myMinKmerLength.value();
    }

    public GBSSeqToTagDBPlugin minimumKmerLength(Integer value) {
        this.myMinKmerLength = new PluginParameter<Integer>(this.myMinKmerLength, value);
        return this;
    }

    public Integer minKmerCount() {
        return this.myMinKmerCount.value();
    }

    public GBSSeqToTagDBPlugin minKmerCount(Integer value) {
        this.myMinKmerCount = new PluginParameter<Integer>(this.myMinKmerCount, value);
        return this;
    }

    public String outputDatabaseFile() {
        return this.myOutputDB.value();
    }

    public GBSSeqToTagDBPlugin outputDatabaseFile(String value) {
        this.myOutputDB = new PluginParameter<String>(this.myOutputDB, value);
        return this;
    }

    public Integer minimumQualityScore() {
        return this.myMinQualScore.value();
    }

    public GBSSeqToTagDBPlugin minimumQualityScore(Integer value) {
        this.myMinQualScore = new PluginParameter<Integer>(this.myMinQualScore, value);
        return this;
    }

    public GBSSeqToTagDBPlugin maximumKmerNumber(Integer value) {
        this.myMaxKmerNumber = new PluginParameter<Integer>(this.myMaxKmerNumber, value);
        return this;
    }

    public GBSSeqToTagDBPlugin batchSize(Integer value) {
        this.myBatchSize = new PluginParameter<Integer>(this.myBatchSize, value);
        return this;
    }

    public Boolean deleteOldData() {
        return this.myDeleteOldData.value();
    }

    public GBSSeqToTagDBPlugin deleteOldData(Boolean value) {
        this.myDeleteOldData = new PluginParameter<Boolean>(this.myDeleteOldData, value);
        return this;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Sequence to Tag/Taxa DB";
    }

    @Override
    public String getToolTipText() {
        return "Input GBS Sequence to Tag/Taxa tables in DB";
    }

    static class TagDistributionMap
    extends ConcurrentHashMap<Tag, TaxaDistribution> {
        private final int maxTagNum;
        private int minDepthToRetainInMap = 2;
        private final int minCount;

        TagDistributionMap(int maxTagNumber, float loadFactor, int concurrencyLevel, int minCount) {
            super(maxTagNumber * 2, loadFactor, concurrencyLevel);
            this.maxTagNum = maxTagNumber;
            this.minCount = minCount;
        }

        @Override
        public TaxaDistribution put(Tag key, TaxaDistribution value) {
            return super.put(key, value);
        }

        public synchronized void removeTagByCount(int minCnt) {
            this.entrySet().parallelStream().filter(e -> ((TaxaDistribution)e.getValue()).totalDepth() < minCnt).forEach((? super T e) -> {
                TaxaDistribution cfr_ignored_0 = (TaxaDistribution)this.remove(e.getKey());
            });
        }

        public long estimateMapMemorySize() {
            long size = 0L;
            int cnt = 0;
            for (Map.Entry entry : this.entrySet()) {
                size += 25L;
                size += 16L;
                size += (long)((TaxaDistribution)entry.getValue()).memorySize();
                if (++cnt <= 10000) continue;
                break;
            }
            long estSize = (long)(this.size() / cnt) * size;
            return estSize;
        }

        public long[] depthDistribution() {
            long[] base2bins = new long[34];
            int cnt = 0;
            for (Map.Entry entry : this.entrySet()) {
                int n = 31 - Integer.numberOfLeadingZeros(((TaxaDistribution)entry.getValue()).totalDepth());
                base2bins[n] = base2bins[n] + 1L;
                ++cnt;
            }
            return base2bins;
        }
    }
}

