/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.v2;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.v2.GetTagSequenceFromDBPlugin;
import net.maizegenetics.dna.tag.Tag;
import net.maizegenetics.dna.tag.TagBuilder;
import net.maizegenetics.dna.tag.TagDataSQLite;
import net.maizegenetics.dna.tag.TaxaDistribution;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.GeneratePluginCode;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.TaxaList;
import org.apache.log4j.Logger;

public class GetTagTaxaDistFromDBPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(GetTagSequenceFromDBPlugin.class);
    private PluginParameter<String> myDBFile = new PluginParameter.Builder<String>("db", null, String.class).guiName("Input DB").required(true).inFile().description("Input database file with tags").build();
    private PluginParameter<String> myOutputFile = new PluginParameter.Builder<String>("o", null, String.class).guiName("Output File").required(true).outFile().description("Output txt file that can be imported to Excel").build();
    private PluginParameter<String> myTagFile = new PluginParameter.Builder<String>("tagFile", null, String.class).guiName("Tag File").required(false).inFile().description("Input file with list of tags to process.  Any number of tab-delimited columns, but must have 1 called Tags.").build();

    public GetTagTaxaDistFromDBPlugin() {
        super(null, false);
    }

    public GetTagTaxaDistFromDBPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    public GetTagTaxaDistFromDBPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        TagDataSQLite tdw = new TagDataSQLite(this.inputDB());
        try {
            BufferedWriter fileWriter = new BufferedWriter(new FileWriter(this.outputFile()));
            StringBuilder strB = new StringBuilder();
            TaxaList taxaList = tdw.getTaxaList();
            strB.append("Tag");
            taxaList.stream().forEach(item -> {
                strB.append("\t");
                strB.append(item.getName());
            });
            strB.append("\n");
            fileWriter.write(strB.toString());
            strB.setLength(0);
            Set<Object> myTags = new HashSet();
            if (this.tagFile() != null) {
                BufferedReader tagFileReader = new BufferedReader(new FileReader(new File(this.tagFile())));
                String[] headers1 = tagFileReader.readLine().split("\t");
                ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(headers1));
                arrayList.replaceAll(String::toUpperCase);
                int tagColumn = arrayList.indexOf("TAGS");
                if (tagColumn == -1) {
                    tagFileReader.close();
                    throw new IllegalArgumentException("Missing Tags column in tag file: " + this.tagFile());
                }
                String line = null;
                while ((line = tagFileReader.readLine()) != null) {
                    String tagSeq = line.split("\t")[tagColumn];
                    Tag tag = TagBuilder.instance(tagSeq).build();
                    myTags.add(tag);
                }
                tagFileReader.close();
            } else {
                myTags = tdw.getTags();
            }
            int tagcount = 0;
            System.out.println("GetTagTaxaDist: number of tags to process: " + myTags.size());
            for (Tag tag : myTags) {
                ++tagcount;
                TaxaDistribution tagTD = tdw.getTaxaDistribution(tag);
                if (tagTD == null) {
                    System.out.println("GetTagTaxaDist: got null tagTD at tagcount " + tagcount);
                    return null;
                }
                int[] depths = tagTD.depths();
                strB.append(tag.sequence());
                for (int idx = 0; idx < depths.length; ++idx) {
                    strB.append("\t");
                    strB.append(depths[idx]);
                }
                strB.append("\n");
                fileWriter.write(strB.toString());
                strB.setLength(0);
            }
            fileWriter.close();
            tdw.close();
            myLogger.info((Object)"TagsTaxaDistToTabDelim: Finished writing TaxaDistribution \n");
        }
        catch (Exception exc) {
            myLogger.error((Object)("GetTagTaxaDistFromDBPlugin: caught error " + exc));
            exc.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) {
        GeneratePluginCode.generate(GetTagTaxaDistFromDBPlugin.class);
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "GetTagTaxaDistFromDB";
    }

    @Override
    public String getToolTipText() {
        return "From a given database, data on taxa distribution of tags is compiled and printed.";
    }

    public String inputDB() {
        return this.myDBFile.value();
    }

    public GetTagTaxaDistFromDBPlugin inputDB(String value) {
        this.myDBFile = new PluginParameter<String>(this.myDBFile, value);
        return this;
    }

    public String outputFile() {
        return this.myOutputFile.value();
    }

    public GetTagTaxaDistFromDBPlugin outputFile(String value) {
        this.myOutputFile = new PluginParameter<String>(this.myOutputFile, value);
        return this;
    }

    public String tagFile() {
        return this.myTagFile.value();
    }

    public GetTagTaxaDistFromDBPlugin tagFile(String value) {
        this.myTagFile = new PluginParameter<String>(this.myTagFile, value);
        return this;
    }
}

