/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.v2;

import com.google.common.collect.Multimap;
import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.v2.UpdateSNPPositionQualityPlugin;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.snp.Allele;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.tag.Tag;
import net.maizegenetics.dna.tag.TagDataSQLite;
import net.maizegenetics.dna.tag.TagDataWriter;
import net.maizegenetics.dna.tag.TaxaDistribution;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.TaxaList;
import org.apache.log4j.Logger;

public class SNPCutPosTagVerificationPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(UpdateSNPPositionQualityPlugin.class);
    private PluginParameter<String> myDBFile = new PluginParameter.Builder<String>("db", null, String.class).guiName("Input DB").required(true).inFile().description("Input database file with SNP positions stored").build();
    private PluginParameter<String> myChrom = new PluginParameter.Builder<String>("chr", null, String.class).guiName("Chromosome").required(true).description("Chromsome containing the positions").build();
    private PluginParameter<Integer> myPosition = new PluginParameter.Builder<Integer>("pos", null, Integer.class).guiName("Cut or SNP Position").required(true).description("A cut or SNP position number").build();
    private PluginParameter<Byte> myStrand = new PluginParameter.Builder<Byte>("strand", null, Byte.class).guiName("Strand").required(true).description("The strand - 0 for reverse, 1 for forward").build();
    private PluginParameter<String> myPositionType = new PluginParameter.Builder<String>("type", null, String.class).guiName("Type of Position").required(true).description("Type of Position - either snp or cut - for which the TaxaDistribution will be presented").build();
    private PluginParameter<String> myOutputFile = new PluginParameter.Builder<String>("outFile", null, String.class).guiName("Output file").required(true).outFile().description("File name to which tab-delimited output will be written").build();
    private TagDataWriter tdw = null;

    public SNPCutPosTagVerificationPlugin() {
        super(null, false);
    }

    public SNPCutPosTagVerificationPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    public SNPCutPosTagVerificationPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        this.tdw = new TagDataSQLite(this.inputDB());
        Map<Tag, TaxaDistribution> cutPositionMap = null;
        Multimap<Allele, Map<Tag, TaxaDistribution>> snpPositionMap = null;
        Map<Tag, Position> tagCutPosMap = null;
        try {
            Chromosome myChr = new Chromosome(this.chrom());
            GeneralPosition pos = new GeneralPosition.Builder(myChr, this.cutOrSnpPosition()).strand(this.strand()).build();
            TaxaList taxaList = this.tdw.getTaxaList();
            if (this.positionType().equals("cut")) {
                cutPositionMap = this.tdw.getTagsTaxaMap(pos);
                this.writeCutPositionTagTaxonFile(taxaList, cutPositionMap);
            } else if (this.positionType().equals("snp")) {
                try {
                    snpPositionMap = this.tdw.getAllelesTagTaxaDistForSNP(pos);
                }
                catch (Exception exc) {
                    System.out.println("\nError attempting to grab SNP position data for chrom " + this.chrom() + ", pos " + this.cutOrSnpPosition());
                    System.out.println("Please verify the position is stored as a SNP position in the input database.");
                    System.out.println("Use a database manager tool to check your db, or run the SNPQualityProfilerPlugin to check for SNP positions.\n");
                    return null;
                }
                HashSet<Tag> fullTagList = new HashSet<Tag>();
                snpPositionMap.entries().forEach(entry -> {
                    Set tags = ((Map)entry.getValue()).keySet();
                    fullTagList.addAll(tags);
                });
                tagCutPosMap = this.tdw.getTagCutPosition(fullTagList);
                this.writeSNPPositionTagTaxonFile(taxaList, snpPositionMap, tagCutPosMap);
            } else {
                myLogger.error((Object)"Position type must be specified as either snp or cut\n");
                return null;
            }
            ((TagDataSQLite)this.tdw).close();
            myLogger.info((Object)("SNPCutPosTagVerificationPlugin: Finished writing TaxaDistribution to file for position " + this.positionType() + ".\n"));
        }
        catch (Exception exc) {
            myLogger.error((Object)("SNPCutPosTagVerificationPlugin: caught error " + exc));
            exc.printStackTrace();
        }
        return null;
    }

    private void writeCutPositionTagTaxonFile(TaxaList taxaList, Map<Tag, TaxaDistribution> cutPositionMap) throws Exception {
        BufferedWriter fileWriter = null;
        StringBuilder strB = new StringBuilder();
        if (this.outputFile() != null) {
            strB.append("Chr\tPos\tTag");
            taxaList.stream().forEach(item -> {
                strB.append("\t");
                strB.append(item.getName());
            });
            strB.append("\n");
            cutPositionMap.entrySet().stream().forEach(entry -> {
                strB.append(this.chrom());
                strB.append("\t");
                strB.append(this.cutOrSnpPosition());
                strB.append("\t");
                Tag curTag = (Tag)entry.getKey();
                strB.append(curTag.sequence());
                TaxaDistribution tagTD = (TaxaDistribution)entry.getValue();
                int[] depths = tagTD.depths();
                for (int idx = 0; idx < depths.length; ++idx) {
                    strB.append("\t");
                    strB.append(depths[idx]);
                }
                strB.append("\n");
            });
            try {
                fileWriter = new BufferedWriter(new FileWriter(this.outputFile()));
                fileWriter.write(strB.toString());
            }
            catch (IOException e) {
                myLogger.error((Object)"Caught Exception in writeCutPositionTagTaxonFile");
                System.out.println(e);
            }
            fileWriter.close();
        } else {
            myLogger.warn((Object)"Outputfile is null - nothing happening here");
        }
    }

    private void writeSNPPositionTagTaxonFile(TaxaList taxaList, Multimap<Allele, Map<Tag, TaxaDistribution>> snpPositionMap, Map<Tag, Position> tagPosMap) throws Exception {
        BufferedWriter fileWriter = null;
        StringBuilder strB = new StringBuilder();
        if (this.outputFile() != null) {
            strB.append("Chr\tSNPPos\tAllele\tTag\tForwardStrand\tTagAsForwardStrand\tCutPos:SNPOffset");
            taxaList.stream().forEach(item -> {
                strB.append("\t");
                strB.append(item.getName());
            });
            strB.append("\n");
            snpPositionMap.entries().stream().forEach(entry -> {
                Allele curAllele = (Allele)entry.getKey();
                strB.append(this.chrom());
                strB.append("\t");
                strB.append(this.cutOrSnpPosition());
                strB.append("\t");
                strB.append(NucleotideAlignmentConstants.getHaplotypeNucleotide(curAllele.allele()));
                strB.append("\t");
                Map curTagTaxa = (Map)entry.getValue();
                for (Map.Entry tagTaxaMap : curTagTaxa.entrySet()) {
                    Tag curTag = (Tag)tagTaxaMap.getKey();
                    Position cutPos = (Position)tagPosMap.get(curTag);
                    TaxaDistribution tagTD = (TaxaDistribution)tagTaxaMap.getValue();
                    strB.append(curTag.sequence());
                    strB.append("\t");
                    boolean isForward = cutPos.getAnnotation().getTextAnnotation("forward")[0].equals("true");
                    strB.append(cutPos.getAnnotation().getTextAnnotation("forward")[0]);
                    strB.append("\t");
                    if (isForward) {
                        strB.append(curTag.sequence());
                    } else {
                        strB.append(curTag.toReverseComplement());
                    }
                    strB.append("\t");
                    strB.append(cutPos.getPosition());
                    strB.append(":");
                    int offSetVal = cutPos.getPosition() - this.cutOrSnpPosition();
                    System.out.println("LCJ: writeSNPPosition: cutPos: " + cutPos.getPosition() + ", cutOrSNPPosition: " + this.cutOrSnpPosition() + " offsetVal: " + offSetVal + " strand:" + isForward);
                    strB.append(offSetVal);
                    int[] depths = tagTD.depths();
                    for (int idx = 0; idx < depths.length; ++idx) {
                        strB.append("\t");
                        strB.append(depths[idx]);
                    }
                    strB.append("\n");
                }
            });
            try {
                fileWriter = new BufferedWriter(new FileWriter(this.outputFile()));
                fileWriter.write(strB.toString());
            }
            catch (IOException e) {
                myLogger.error((Object)"Caught exception in writeSNPPositionTagTaxonFile");
                System.out.println(e);
            }
            fileWriter.close();
        } else {
            myLogger.warn((Object)"Outputfile is null - nothing happening here");
        }
    }

    @Override
    public String getToolTipText() {
        return "Debug tool: Verify which Tags in which taxon map to the specified cut position.  Verify which tags have a SNP at the specified position.";
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "SNP/Cut Position Verification";
    }

    public String runPlugin(DataSet input) {
        return (String)this.performFunction(input).getData(0).getData();
    }

    public String inputDB() {
        return this.myDBFile.value();
    }

    public SNPCutPosTagVerificationPlugin inputDB(String value) {
        this.myDBFile = new PluginParameter<String>(this.myDBFile, value);
        return this;
    }

    public String chrom() {
        return this.myChrom.value();
    }

    public SNPCutPosTagVerificationPlugin chrom(String value) {
        this.myChrom = new PluginParameter<String>(this.myChrom, value);
        return this;
    }

    public Integer cutOrSnpPosition() {
        return this.myPosition.value();
    }

    public SNPCutPosTagVerificationPlugin cutOrSnpPosition(Integer value) {
        this.myPosition = new PluginParameter<Integer>(this.myPosition, value);
        return this;
    }

    public Byte strand() {
        return this.myStrand.value();
    }

    public SNPCutPosTagVerificationPlugin strand(Byte value) {
        this.myStrand = new PluginParameter<Byte>(this.myStrand, value);
        return this;
    }

    public String positionType() {
        return this.myPositionType.value();
    }

    public SNPCutPosTagVerificationPlugin positionType(String value) {
        this.myPositionType = new PluginParameter<String>(this.myPositionType, value);
        return this;
    }

    public String outputFile() {
        return this.myOutputFile.value();
    }

    public SNPCutPosTagVerificationPlugin outputFile(String value) {
        this.myOutputFile = new PluginParameter<String>(this.myOutputFile, value);
        return this;
    }
}

