/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.v2;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.snp.Allele;
import net.maizegenetics.dna.tag.TagData;
import net.maizegenetics.dna.tag.TagDataSQLite;
import net.maizegenetics.dna.tag.TaxaDistribution;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListIOUtils;
import net.maizegenetics.taxa.Taxon;
import org.apache.log4j.Logger;

public class SNPQualityProfilerPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(SNPQualityProfilerPlugin.class);
    private PluginParameter<String> myTaxaFile = new PluginParameter.Builder<String>("taxa", null, String.class).guiName("Taxa List File").inFile().description("Name of taxa list input file in taxa list format").build();
    private PluginParameter<String> myDBFile = new PluginParameter.Builder<String>("db", null, String.class).guiName("GBS DB File").required(true).outFile().description("Name of output file (e.g. GBSv2.db)").build();
    private PluginParameter<String> myTaxaListName = new PluginParameter.Builder<String>("tname", null, String.class).guiName("Name for taxa set in DB").description("Name of taxa set for database").build();
    private PluginParameter<String> statFileName = new PluginParameter.Builder<String>("statFile", null, String.class).guiName("Name for Stat File Output").description("Name of Stat File for Output").build();
    private PluginParameter<Boolean> myDeleteOldData = new PluginParameter.Builder<Boolean>("deleteOldData", true, Boolean.class).guiName("Delete Old Data").description("Delete existing SNP quality data from db tables").build();
    private TagDataSQLite tagDataWriter;

    public SNPQualityProfilerPlugin() {
        super(null, false);
    }

    public SNPQualityProfilerPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        StringBuilder strBuild;
        TaxaList subTaxa;
        this.tagDataWriter = new TagDataSQLite(this.dBFile());
        TaxaList taxaList = this.tagDataWriter.getTaxaList();
        if (this.myTaxaFile.isEmpty()) {
            subTaxa = taxaList;
            if (this.myTaxaListName.isEmpty()) {
                this.taxaListName("ALL");
            }
        } else {
            subTaxa = TaxaListIOUtils.readTaxaAnnotationFile(this.taxaFile(), "<NAME>");
            if (this.myTaxaListName.isEmpty()) {
                this.taxaListName(this.taxaFile());
            }
        }
        if (this.deleteOldData().booleanValue()) {
            myLogger.info((Object)"deleteOldData is TRUE: Clearing existing snpQuality data");
            this.tagDataWriter.clearSNPQualityData();
        }
        subTaxa.stream().filter(t -> taxaList.indexOf((Taxon)t) < 0).forEach(t -> System.err.println("Missing taxon from master:" + t));
        int[] subsetIndices = subTaxa.stream().mapToInt(taxaList::indexOf).filter(i -> i > -1).sorted().toArray();
        System.out.println("sublist");
        System.out.println(Arrays.toString(subsetIndices));
        int totalRecords = 2000;
        long startTimeNew = System.currentTimeMillis();
        Comparator<int[]> arrayCompare = Comparator.comparing(depths -> -Arrays.stream(depths).sum());
        Stream<Map.Entry<Allele, TaxaDistribution>> streamOfAlleles = this.tagDataWriter.getAllAllelesTaxaDistForSNPEntries();
        LongAdder adder = new LongAdder();
        Iterator streamIterator = streamOfAlleles.iterator();
        if (!streamIterator.hasNext()) {
            System.out.println("\nERROR: No SNP entries found in the SNP Position table.  \nPlease run DiscoverySNPCallerPluginV2 to call SNPs before running this plugin.\n");
            return null;
        }
        ImmutableMultimap.Builder aggMapBuilder = ImmutableMultimap.builder();
        Map.Entry currentMap = (Map.Entry)streamIterator.next();
        Position currentPosition = ((Allele)currentMap.getKey()).position();
        aggMapBuilder.put(currentMap);
        BufferedWriter fileWriter = null;
        if (this.statFileName.value() != null) {
            try {
                fileWriter = new BufferedWriter(new FileWriter(this.statFileName.value()));
                fileWriter.write("Chromosome\tPositionID\tavgDepth\tminorDepthProp\tminor2DepthProp\tgapDepthProp\tpropCovered\tpropCovered2\ttaxaCntWithMinorAlleleGE2\tgenotypeCnt\tminorAlleleFreqGE2\thetFreq_DGE2\tinbredF_DGE2");
                fileWriter.write("\n");
            }
            catch (IOException e) {
                System.out.println(e);
                return null;
            }
        }
        System.out.print("Processing Positions between 0 and 10,000.");
        while (streamIterator.hasNext()) {
            currentMap = (Map.Entry)streamIterator.next();
            if (currentPosition.equals(((Allele)currentMap.getKey()).position())) {
                aggMapBuilder.put(currentMap);
                continue;
            }
            ImmutableMultimap aTDMMap = aggMapBuilder.build();
            Map<Allele, int[]> subDepths = this.convertToSubsetMap((Multimap<Allele, TaxaDistribution>)aTDMMap, subsetIndices);
            List depthsInOrder = subDepths.values().stream().sorted(arrayCompare).collect(Collectors.toList());
            HashMap<String, Double> qualMap = new HashMap<String, Double>();
            int[] alleleDepths = depthsInOrder.stream().mapToInt(depths -> Arrays.stream(depths).sum()).toArray();
            double totalDepth = Arrays.stream(alleleDepths).sum();
            strBuild = new StringBuilder();
            qualMap.put("avgDepth", totalDepth / (double)subsetIndices.length);
            if (totalDepth > 0.0) {
                qualMap.put("minorDepthProp", alleleDepths.length > 1 ? (double)alleleDepths[1] / totalDepth : 0.0);
                qualMap.put("minor2DepthProp", alleleDepths.length > 2 ? (double)alleleDepths[2] / totalDepth : 0.0);
                int gapDepth = subDepths.entrySet().stream().filter(ent -> ((Allele)ent.getKey()).allele() == 5).mapToInt(ent -> Arrays.stream((int[])ent.getValue()).sum()).sum();
                Arrays.stream(subDepths.getOrDefault((byte)5, new int[0])).sum();
                qualMap.put("gapDepthProp", (double)gapDepth / totalDepth);
                int[] coverage = new int[subsetIndices.length];
                for (int[] depths2 : depthsInOrder) {
                    for (int i2 = 0; i2 < depths2.length; ++i2) {
                        int n = i2;
                        coverage[n] = coverage[n] + depths2[i2];
                    }
                }
                qualMap.put("propCovered", (double)Arrays.stream(coverage).filter(d -> d > 0).count() / (double)coverage.length);
                qualMap.put("propCovered2", (double)Arrays.stream(coverage).filter(d -> d > 1).count() / (double)coverage.length);
                qualMap.put("taxaCntWithMinorAlleleGE2", alleleDepths.length > 1 ? (double)Arrays.stream((int[])depthsInOrder.get(1)).filter(d -> d > 1).count() : 0.0);
                if (depthsInOrder.size() >= 2) {
                    GenotypeStats genotypeCnt = this.callGenotypes((int[])depthsInOrder.get(0), (int[])depthsInOrder.get(1));
                    qualMap.put("genotypeCnt", Double.valueOf(genotypeCnt.totalCnt));
                    qualMap.put("minorAlleleFreqGE2", Double.isNaN(genotypeCnt.minorFreq) ? 0.0 : genotypeCnt.minorFreq);
                    qualMap.put("hetFreq_DGE2", Double.valueOf(genotypeCnt.hetCnt));
                    qualMap.put("inbredF_DGE2", genotypeCnt.f);
                }
                HashMap<Position, Map<String, Double>> resultMap = new HashMap<Position, Map<String, Double>>();
                resultMap.put(currentPosition, qualMap);
                try {
                    this.tagDataWriter.putSNPQualityProfile(resultMap, this.myTaxaListName.value(), adder.intValue());
                }
                catch (Exception sqlE) {
                    System.out.println("Error processing request.  Quality data may already exist for taxa name " + this.taxaListName() + "\n " + sqlE.getMessage());
                    try {
                        this.tagDataWriter.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    return null;
                }
                adder.increment();
                if (adder.intValue() % 2000 == 0) {
                    System.out.print(".");
                }
                if (adder.intValue() % 10000 == 0) {
                    System.out.println("DONE. Time: " + ((double)System.currentTimeMillis() - (double)startTimeNew) / 1000.0);
                    System.out.print("Processing Positions between " + adder.intValue() + " and " + (adder.intValue() + 10000) + ".");
                }
                strBuild.append(currentPosition.getChromosome().toString());
                strBuild.append("\t");
                strBuild.append(currentPosition.getPosition());
                strBuild.append("\t");
                strBuild.append(qualMap.get("avgDepth"));
                strBuild.append("\t");
                strBuild.append(qualMap.get("minorDepthProp"));
                strBuild.append("\t");
                strBuild.append(qualMap.get("minor2DepthProp"));
                strBuild.append("\t");
                strBuild.append(qualMap.get("gapDepthProp"));
                strBuild.append("\t");
                strBuild.append(qualMap.get("propCovered"));
                strBuild.append("\t");
                strBuild.append(qualMap.get("propCovered2"));
                strBuild.append("\t");
                strBuild.append(qualMap.get("taxaCntWithMinorAlleleGE2"));
                if (depthsInOrder.size() >= 2) {
                    strBuild.append("\t");
                    strBuild.append(qualMap.get("genotypeCnt"));
                    strBuild.append("\t");
                    strBuild.append(qualMap.get("minorAlleleFreqGE2"));
                    strBuild.append("\t");
                    strBuild.append(qualMap.get("hetFreq_DGE2"));
                    strBuild.append("\t");
                    strBuild.append(qualMap.get("inbredF_DGE2"));
                }
                strBuild.append("\n");
            }
            if (this.statFileName.value() != null) {
                try {
                    fileWriter.write(strBuild.toString());
                }
                catch (IOException e) {
                    System.out.println(e);
                }
            }
            currentPosition = ((Allele)currentMap.getKey()).position();
            aggMapBuilder = ImmutableMultimap.builder();
            aggMapBuilder.put(currentMap);
        }
        System.out.println("DONE");
        long totalTimeNew = System.currentTimeMillis() - startTimeNew;
        ImmutableMultimap aTDMMap = aggMapBuilder.build();
        Map<Allele, int[]> subDepths = this.convertToSubsetMap((Multimap<Allele, TaxaDistribution>)aTDMMap, subsetIndices);
        List depthsInOrder = subDepths.values().stream().sorted(arrayCompare).collect(Collectors.toList());
        HashMap<String, Double> qualMap = new HashMap<String, Double>();
        int[] alleleDepths = depthsInOrder.stream().mapToInt(depths -> Arrays.stream(depths).sum()).toArray();
        strBuild = new StringBuilder();
        double totalDepth = Arrays.stream(alleleDepths).sum();
        qualMap.put("avgDepth", totalDepth / (double)subsetIndices.length);
        if (totalDepth > 0.0) {
            qualMap.put("minorDepthProp", alleleDepths.length > 1 ? (double)alleleDepths[1] / totalDepth : 0.0);
            qualMap.put("minor2DepthProp", alleleDepths.length > 2 ? (double)alleleDepths[2] / totalDepth : 0.0);
            int gapDepth = subDepths.entrySet().stream().filter(ent -> ((Allele)ent.getKey()).allele() == 5).mapToInt(ent -> Arrays.stream((int[])ent.getValue()).sum()).sum();
            Arrays.stream(subDepths.getOrDefault((byte)5, new int[0])).sum();
            qualMap.put("gapDepthProp", (double)gapDepth / totalDepth);
            int[] coverage = new int[subsetIndices.length];
            for (int[] depths3 : depthsInOrder) {
                for (int i3 = 0; i3 < depths3.length; ++i3) {
                    int n = i3;
                    coverage[n] = coverage[n] + depths3[i3];
                }
            }
            qualMap.put("propCovered", (double)Arrays.stream(coverage).filter(d -> d > 0).count() / (double)coverage.length);
            qualMap.put("propCovered2", (double)Arrays.stream(coverage).filter(d -> d > 1).count() / (double)coverage.length);
            qualMap.put("taxaCntWithMinorAlleleGE2", alleleDepths.length > 1 ? (double)Arrays.stream((int[])depthsInOrder.get(1)).filter(d -> d > 1).count() : 0.0);
            if (depthsInOrder.size() >= 2) {
                GenotypeStats genotypeCnt = this.callGenotypes((int[])depthsInOrder.get(0), (int[])depthsInOrder.get(1));
                qualMap.put("genotypeCnt", Double.valueOf(genotypeCnt.totalCnt));
                qualMap.put("minorAlleleFreqGE2", Double.isNaN(genotypeCnt.minorFreq) ? 0.0 : genotypeCnt.minorFreq);
                qualMap.put("hetFreq_DGE2", Double.valueOf(genotypeCnt.hetCnt));
                qualMap.put("inbredF_DGE2", genotypeCnt.f);
            }
            adder.increment();
            HashMap<Position, Map<String, Double>> resultMap = new HashMap<Position, Map<String, Double>>();
            resultMap.put(currentPosition, qualMap);
            try {
                this.tagDataWriter.putSNPQualityProfile(resultMap, this.myTaxaListName.value(), -1);
            }
            catch (Exception sqlE) {
                System.out.println("Error processing request.  Quality data may already exist for taxa name " + this.taxaListName() + "\n " + sqlE.getMessage());
                sqlE.printStackTrace();
                try {
                    this.tagDataWriter.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return null;
            }
            strBuild.append(((Allele)currentMap.getKey()).position().getChromosome().toString());
            strBuild.append("\t");
            strBuild.append(((Allele)currentMap.getKey()).position().getPosition());
            strBuild.append("\t");
            strBuild.append(qualMap.get("avgDepth"));
            strBuild.append("\t");
            strBuild.append(qualMap.get("minorDepthProp"));
            strBuild.append("\t");
            strBuild.append(qualMap.get("minor2DepthProp"));
            strBuild.append("\t");
            strBuild.append(qualMap.get("gapDepthProp"));
            strBuild.append("\t");
            strBuild.append(qualMap.get("propCovered"));
            strBuild.append("\t");
            strBuild.append(qualMap.get("propCovered2"));
            strBuild.append("\t");
            strBuild.append(qualMap.get("taxaCntWithMinorAlleleGE2"));
            if (depthsInOrder.size() >= 2) {
                strBuild.append("\t");
                strBuild.append(qualMap.get("genotypeCnt"));
                strBuild.append("\t");
                strBuild.append(qualMap.get("minorAlleleFreqGE2"));
                strBuild.append("\t");
                strBuild.append(qualMap.get("hetFreq_DGE2"));
                strBuild.append("\t");
                strBuild.append(qualMap.get("inbredF_DGE2"));
            }
            strBuild.append("\n");
            if (this.statFileName.value() != null) {
                try {
                    fileWriter.write(strBuild.toString());
                }
                catch (IOException e) {
                    System.out.println(e);
                }
            }
        }
        System.out.println("Total Time: " + (double)totalTimeNew / 1000.0 + " seconds.\nProcessed " + adder.intValue() + " positions.");
        if (this.statFileName.value() != null) {
            try {
                fileWriter.close();
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
        try {
            this.tagDataWriter.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private GenotypeStats callGenotypes(int[] majorAlleleDepth, int[] minorAlleleDepth) {
        int[] genotypes = new int[3];
        for (int i = 0; i < majorAlleleDepth.length; ++i) {
            if (majorAlleleDepth[i] + minorAlleleDepth[i] < 2) continue;
            int genotype = majorAlleleDepth[i] > 0 ? 1 : 0;
            int n = (genotype += minorAlleleDepth[i] > 0 ? 2 : 0) - 1;
            genotypes[n] = genotypes[n] + 1;
        }
        return new GenotypeStats(genotypes[0], genotypes[2], genotypes[1]);
    }

    private Map<Allele, int[]> convertToSubsetMap(Multimap<Allele, TaxaDistribution> aTDMMap, int[] subsetIndices) {
        HashMap<Allele, int[]> result = new HashMap<Allele, int[]>();
        for (Allele allele : aTDMMap.keySet()) {
            int[] subDepths = new int[subsetIndices.length];
            for (TaxaDistribution taxaDistribution : aTDMMap.get((Object)allele)) {
                int[] depths = taxaDistribution.depths();
                for (int i = 0; i < subDepths.length; ++i) {
                    int n = i;
                    subDepths[n] = subDepths[n] + depths[subsetIndices[i]];
                }
            }
            result.put(allele, subDepths);
        }
        return result;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "SNP Quality Profiler";
    }

    @Override
    public String getToolTipText() {
        return "SNP Quality Profiler";
    }

    public TagData runPlugin(DataSet input) {
        return (TagData)this.performFunction(input).getData(0).getData();
    }

    public String taxaFile() {
        return this.myTaxaFile.value();
    }

    public SNPQualityProfilerPlugin taxaFile(String value) {
        this.myTaxaFile = new PluginParameter<String>(this.myTaxaFile, value);
        return this;
    }

    public String dBFile() {
        return this.myDBFile.value();
    }

    public SNPQualityProfilerPlugin dBFile(String value) {
        this.myDBFile = new PluginParameter<String>(this.myDBFile, value);
        return this;
    }

    public String statFile() {
        return this.statFileName.value();
    }

    public SNPQualityProfilerPlugin statFile(String value) {
        this.statFileName = new PluginParameter<String>(this.statFileName, value);
        return this;
    }

    public String taxaListName() {
        return this.myTaxaListName.value();
    }

    public SNPQualityProfilerPlugin taxaListName(String value) {
        this.myTaxaListName = new PluginParameter<String>(this.myTaxaListName, value);
        return this;
    }

    public Boolean deleteOldData() {
        return this.myDeleteOldData.value();
    }

    public SNPQualityProfilerPlugin deleteOldData(Boolean value) {
        this.myDeleteOldData = new PluginParameter<Boolean>(this.myDeleteOldData, value);
        return this;
    }

    private class GenotypeStats {
        double majorFreq;
        double minorFreq;
        int homoMajorCnt;
        int hetCnt;
        int homoMinorCnt;
        int totalCnt;
        double f;

        private GenotypeStats(int homoMajorCnt, int hetCnt, int homoMinorCnt) {
            this.homoMajorCnt = homoMajorCnt;
            this.hetCnt = hetCnt;
            this.homoMinorCnt = homoMinorCnt;
            this.totalCnt = homoMajorCnt + hetCnt + homoMinorCnt;
            this.majorFreq = ((double)homoMajorCnt + (double)hetCnt * 0.5) / (double)this.totalCnt;
            this.minorFreq = 1.0 - this.majorFreq;
            double expHets = 2.0 * this.minorFreq * this.majorFreq;
            double propHets = (double)hetCnt / (double)this.totalCnt;
            this.f = 1.0 - propHets / expHets;
        }
    }
}

